/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.step.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.JacksonCSVSplitter;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.datamovement.WriteEvent;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.ext.util.DefaultDocumentPermissionsParser;
import com.marklogic.client.ext.util.DocumentPermissionsParser;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.dataservices.JobService;
import com.marklogic.hub.error.DataHubConfigurationException;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.step.RunStepResponse;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.step.StepItemCompleteListener;
import com.marklogic.hub.step.StepItemFailureListener;
import com.marklogic.hub.step.StepRunner;
import com.marklogic.hub.step.StepStatusListener;
import com.marklogic.hub.step.impl.FileCollector;
import com.marklogic.hub.step.impl.IngestionStepDefinitionImpl;
import com.marklogic.hub.step.impl.StepMetrics;
import com.marklogic.hub.step.impl.StepRunnerUtil;
import com.marklogic.hub.util.DiskQueue;
import com.marklogic.hub.util.json.JSONObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteStepRunner
implements StepRunner {
    private static final int MAX_ERROR_MESSAGES = 10;
    private Flow flow;
    private int batchSize;
    private int threadCount;
    private String destinationDatabase;
    private int previousPercentComplete;
    protected long csvFilesProcessed;
    private String currentCsvFile;
    private Map<String, Object> combinedOptions;
    private boolean stopOnFailure = false;
    private String jobId;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String step = "1";
    private static final String DATE_TIME_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private List<StepItemCompleteListener> stepItemCompleteListeners = new ArrayList<StepItemCompleteListener>();
    private List<StepItemFailureListener> stepItemFailureListeners = new ArrayList<StepItemFailureListener>();
    private List<StepStatusListener> stepStatusListeners = new ArrayList<StepStatusListener>();
    private HubClient hubClient;
    private HubProject hubProject;
    private Thread runningThread = null;
    private DataMovementManager dataMovementManager = null;
    private WriteBatcher writeBatcher = null;
    protected String inputFilePath = null;
    protected String outputCollections;
    protected String outputPermissions;
    protected String outputFormat;
    protected String inputFileType;
    protected String outputURIReplacement;
    protected String outputURIPrefix;
    protected String separator = ",";
    protected AtomicBoolean isStopped = new AtomicBoolean(false);
    private IngestionStepDefinitionImpl stepDef;
    private Map<String, Object> stepConfig = new HashMap<String, Object>();
    private DocumentPermissionsParser documentPermissionsParser = new DefaultDocumentPermissionsParser();

    public WriteStepRunner(HubClient hubClient, HubProject hubProject) {
        this.hubClient = hubClient;
        this.hubProject = hubProject;
    }

    @Override
    public StepRunner withFlow(Flow flow) {
        this.flow = flow;
        return this;
    }

    @Override
    public StepRunner withStep(String step) {
        this.step = step;
        return this;
    }

    @Override
    public StepRunner withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public StepRunner withStepDefinition(StepDefinition stepDefinition) {
        this.stepDef = (IngestionStepDefinitionImpl)stepDefinition;
        return this;
    }

    @Override
    public StepRunner withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public StepRunner withThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public StepRunner withDestinationDatabase(String destinationDatabase) {
        this.destinationDatabase = destinationDatabase;
        return this;
    }

    @Override
    public StepRunner withStopOnFailure(boolean stopOnFailure) {
        this.stopOnFailure = stopOnFailure;
        return this;
    }

    @Override
    public StepRunner withRuntimeOptions(Map<String, Object> runtimeOptions) {
        if (this.flow == null) {
            throw new DataHubConfigurationException("Flow has to be set before setting options");
        }
        this.combinedOptions = StepRunnerUtil.makeCombinedOptions(this.flow, this.stepDef, this.step, runtimeOptions);
        return this;
    }

    @Override
    public StepRunner withStepConfig(Map<String, Object> stepConfig) {
        this.stepConfig = stepConfig;
        return this;
    }

    @Override
    public StepRunner onItemComplete(StepItemCompleteListener listener) {
        this.stepItemCompleteListeners.add(listener);
        return this;
    }

    @Override
    public StepRunner onItemFailed(StepItemFailureListener listener) {
        this.stepItemFailureListeners.add(listener);
        return this;
    }

    @Override
    public StepRunner onStatusChanged(StepStatusListener listener) {
        this.stepStatusListeners.add(listener);
        return this;
    }

    @Override
    public void awaitCompletion() {
        try {
            this.awaitCompletion(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException | TimeoutException exception) {
            // empty catch block
        }
    }

    @Override
    public void awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.runningThread != null) {
            this.runningThread.join(unit.convert(timeout, unit));
            if (this.runningThread.getState() != Thread.State.TERMINATED) {
                if (this.dataMovementManager != null && this.writeBatcher != null) {
                    this.dataMovementManager.stopJob((Batcher)this.writeBatcher);
                }
                this.runningThread.interrupt();
                throw new TimeoutException("Timeout occurred after " + timeout + " " + unit.toString());
            }
        }
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    private boolean jobOutputIsEnabled() {
        if (this.combinedOptions != null && this.combinedOptions.containsKey("disableJobOutput")) {
            return !Boolean.parseBoolean(this.combinedOptions.get("disableJobOutput").toString());
        }
        return true;
    }

    @Override
    public RunStepResponse run() {
        Collection<String> uris;
        if (this.combinedOptions == null) {
            this.combinedOptions = new HashMap<String, Object>();
        }
        this.runningThread = null;
        RunStepResponse runStepResponse = StepRunnerUtil.createStepResponse(this.flow, this.step, this.jobId);
        this.loadStepRunnerParameters();
        if ("csv".equalsIgnoreCase(this.inputFileType)) {
            this.combinedOptions.put("inputFileType", "csv");
        }
        this.combinedOptions.put("flow", this.flow.getName());
        if (this.jobOutputIsEnabled()) {
            JobService.on(this.hubClient.getJobsClient()).startStep(this.jobId, this.step, this.flow.getName(), new ObjectMapper().valueToTree(this.combinedOptions));
        }
        try {
            uris = this.runFileCollector();
        }
        catch (Exception e) {
            runStepResponse.setCounts(0L, 0L, 0L, 0L, 0L).withStatus("failed step " + this.step);
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            runStepResponse.withStepOutput(errors.toString());
            if (this.jobOutputIsEnabled()) {
                JsonNode jobDoc = JobService.on(this.hubClient.getJobsClient()).finishStep(this.jobId, this.step, "failed step " + this.step, (JsonNode)runStepResponse.toObjectNode());
                try {
                    return StepRunnerUtil.getResponse(jobDoc, this.step);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return runStepResponse;
        }
        return this.runIngester(runStepResponse, uris);
    }

    @Override
    public RunStepResponse run(Collection<String> uris) {
        this.runningThread = null;
        RunStepResponse runStepResponse = StepRunnerUtil.createStepResponse(this.flow, this.step, this.jobId);
        if (this.jobOutputIsEnabled()) {
            JobService.on(this.hubClient.getJobsClient()).startStep(this.jobId, this.step, this.flow.getName(), new ObjectMapper().valueToTree(this.combinedOptions));
        }
        return this.runIngester(runStepResponse, uris);
    }

    @Override
    public void stop() {
        this.isStopped.set(true);
        if (this.writeBatcher != null) {
            this.dataMovementManager.stopJob((Batcher)this.writeBatcher);
        }
    }

    protected void loadStepRunnerParameters() {
        JsonNode comboOptions = null;
        try {
            comboOptions = JSONObject.readInput(JSONObject.writeValueAsString(this.combinedOptions));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject obj = new JSONObject(comboOptions);
        if (obj.getArrayString("collections", false) != null) {
            this.outputCollections = StringUtils.join(obj.getArrayString("collections", false), (String)",");
        }
        if (obj.getString("permissions") != null) {
            this.outputPermissions = obj.getString("permissions");
        }
        if (obj.getString("targetDatabase") != null) {
            this.withDestinationDatabase(obj.getString("targetDatabase"));
        }
        if (obj.getString("outputFormat") != null) {
            this.outputFormat = obj.getString("outputFormat");
        }
        ObjectMapper mapper = new ObjectMapper();
        HashMap fileLocations = new HashMap();
        if (this.stepDef.getFileLocations() != null) {
            Map stepDefFileLocation = (Map)mapper.convertValue((Object)this.stepDef.getFileLocations(), Map.class);
            fileLocations.putAll(stepDefFileLocation);
        }
        if (this.flow.getStep(this.step).getFileLocations() != null) {
            Map stepFileLocation = (Map)mapper.convertValue((Object)this.flow.getStep(this.step).getFileLocations(), Map.class);
            fileLocations.putAll(stepFileLocation);
        }
        if (this.stepConfig.get("batchSize") != null) {
            this.batchSize = Integer.parseInt(this.stepConfig.get("batchSize").toString());
        }
        if (this.stepConfig.get("threadCount") != null) {
            this.threadCount = Integer.parseInt(this.stepConfig.get("threadCount").toString());
        }
        if (this.stepConfig.get("fileLocations") != null) {
            fileLocations.putAll((Map)this.stepConfig.get("fileLocations"));
        }
        if (!fileLocations.isEmpty()) {
            this.inputFilePath = (String)fileLocations.get("inputFilePath");
            this.inputFileType = (String)fileLocations.get("inputFileType");
            this.outputURIReplacement = (String)fileLocations.get("outputURIReplacement");
            this.outputURIPrefix = (String)fileLocations.get("outputURIPrefix");
            if (this.inputFileType.equalsIgnoreCase("csv") && fileLocations.get("separator") != null) {
                this.separator = (String)fileLocations.get("separator");
                if (!"\t".equals(this.separator)) {
                    this.separator = this.separator.trim();
                }
            }
        }
        if (this.separator != null && this.separator.equalsIgnoreCase("\\t")) {
            this.separator = "\t";
        }
        if (this.stepConfig.get("stopOnFailure") != null) {
            this.withStopOnFailure(Boolean.parseBoolean(this.stepConfig.get("stopOnFailure").toString()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.outputURIReplacement)) {
            if (this.outputURIPrefix != null) {
                throw new RuntimeException("'outputURIPrefix' and 'outputURIReplacement' cannot be set simultaneously");
            }
        } else if (this.outputURIPrefix == null) {
            this.outputURIPrefix = "";
        }
        if (this.inputFilePath == null || this.inputFileType == null) {
            throw new RuntimeException("File path and type cannot be empty");
        }
    }

    protected Path determineInputFilePath(String inputFilePath) {
        Path dirPath = Paths.get(inputFilePath, new String[0]);
        if (dirPath.isAbsolute()) {
            return dirPath;
        }
        if (this.hubProject != null) {
            String projectDirString = this.hubProject.getProjectDirString();
            return new File(projectDirString, dirPath.toString()).toPath().toAbsolutePath();
        }
        Path inputPath = new File(dirPath.toString()).toPath().toAbsolutePath();
        this.logger.info("No HubProject available to resolve relative inputFilePath; will ingest from: " + inputPath);
        return inputPath;
    }

    private Collection<String> runFileCollector() {
        this.stepStatusListeners.forEach(listener -> listener.onStatusChange(this.jobId, 0, "running step " + this.step, 0L, 0L, "fetching files"));
        DiskQueue<String> uris = !this.isStopped.get() ? new FileCollector(this.inputFileType).run(this.determineInputFilePath(this.inputFilePath)) : null;
        return uris;
    }

    private RunStepResponse runIngester(RunStepResponse runStepResponse, Collection<String> uris) {
        StepMetrics stepMetrics = new StepMetrics();
        this.stepStatusListeners.forEach(listener -> listener.onStatusChange(runStepResponse.getJobId(), 0, "running step " + this.step, 0L, 0L, "starting step execution"));
        if (uris == null || uris.size() == 0) {
            JsonNode jobDoc = null;
            String stepStatus = this.isStopped.get() ? "canceled step " + this.step : "completed step " + this.step;
            this.stepStatusListeners.forEach(listener -> listener.onStatusChange(runStepResponse.getJobId(), 100, stepStatus, 0L, 0L, stepStatus.contains("completed step ") ? "provided file path returned 0 items" : "job was stopped"));
            runStepResponse.setCounts(0L, 0L, 0L, 0L, 0L);
            runStepResponse.withStatus(stepStatus);
            if (this.jobOutputIsEnabled()) {
                jobDoc = JobService.on(this.hubClient.getJobsClient()).finishStep(this.jobId, this.step, stepStatus, (JsonNode)runStepResponse.toObjectNode());
                try {
                    return StepRunnerUtil.getResponse(jobDoc, this.step);
                }
                catch (Exception ex2) {
                    return runStepResponse;
                }
            }
            return runStepResponse;
        }
        Vector errorMessages = new Vector();
        this.dataMovementManager = this.destinationDatabase.equals(this.hubClient.getDbName(DatabaseKind.FINAL)) ? this.hubClient.getFinalClient().newDataMovementManager() : this.hubClient.getStagingClient(this.destinationDatabase).newDataMovementManager();
        HashMap<String, JobTicket> ticketWrapper = new HashMap<String, JobTicket>();
        double uriSize = uris.size();
        ServerTransform serverTransform = new ServerTransform("mlRunIngest");
        serverTransform.addParameter("job-id", this.jobId);
        serverTransform.addParameter("step", this.step);
        serverTransform.addParameter("flow-name", this.flow.getName());
        String optionString = this.jsonToString(this.combinedOptions);
        serverTransform.addParameter("options", optionString);
        this.writeBatcher = this.dataMovementManager.newWriteBatcher().withBatchSize(this.batchSize).withThreadCount(this.threadCount).withJobId(runStepResponse.getJobId()).withTransform(serverTransform).onBatchSuccess(batch -> {
            stepMetrics.getSuccessfulEvents().addAndGet(((WriteEvent[])batch.getItems()).length - 1);
            stepMetrics.getSuccessfulBatches().addAndGet(1L);
            this.logger.debug(String.format("Current SuccessfulEvents: %d - FailedEvents: %d", stepMetrics.getSuccessfulEventsCount(), stepMetrics.getFailedEventsCount()));
            this.runStatusListener(uriSize, stepMetrics);
            if (this.stepItemCompleteListeners.size() > 0) {
                Arrays.stream(batch.getItems()).forEach(e -> this.stepItemCompleteListeners.forEach(listener -> listener.processCompletion(runStepResponse.getJobId(), e.getTargetUri())));
            }
        }).onBatchFailure((batch, ex) -> {
            JobTicket jobTicket;
            stepMetrics.getFailedEvents().addAndGet(((WriteEvent[])batch.getItems()).length - 1);
            stepMetrics.getFailedBatches().addAndGet(1L);
            this.runStatusListener(uriSize, stepMetrics);
            if (errorMessages.size() < 10) {
                errorMessages.add(ex.getLocalizedMessage());
            }
            if (this.stepItemFailureListeners.size() > 0) {
                Arrays.stream(batch.getItems()).forEach(e -> this.stepItemFailureListeners.forEach(listener -> listener.processFailure(runStepResponse.getJobId(), e.getTargetUri())));
            }
            if (this.stopOnFailure && (jobTicket = (JobTicket)ticketWrapper.get("jobTicket")) != null) {
                this.dataMovementManager.stopJob(jobTicket);
            }
        });
        DocumentMetadataHandle metadataHandle = new DocumentMetadataHandle();
        if (StringUtils.isNotEmpty((CharSequence)this.outputPermissions)) {
            this.documentPermissionsParser.parsePermissions(this.outputPermissions, metadataHandle.getPermissions());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.outputCollections)) {
            metadataHandle.withCollections(this.outputCollections.split(","));
        }
        if (this.flow.getName().equals("default-ingestion")) {
            metadataHandle.withCollections(new String[]{"default-ingestion"});
        }
        DocumentMetadataHandle.DocumentMetadataValues metadataValues = metadataHandle.getMetadataValues();
        metadataValues.add("datahubCreatedByJob", this.jobId);
        metadataValues.add("datahubCreatedInFlow", this.flow.getName());
        metadataValues.add("datahubRanBySteps", this.flow.getStep(this.step).getName());
        metadataValues.add("datahubCreatedByStep", this.flow.getStep(this.step).getName());
        metadataValues.add("datahubCreatedOn", new SimpleDateFormat(DATE_TIME_FORMAT_PATTERN).format(new Date()));
        metadataValues.add("datahubCreatedBy", this.hubClient.getUsername());
        this.writeBatcher.withDefaultMetadata(metadataHandle);
        Format format = null;
        switch (this.inputFileType.toLowerCase()) {
            case "xml": {
                format = Format.XML;
                break;
            }
            case "json": {
                format = Format.JSON;
                break;
            }
            case "csv": {
                format = Format.JSON;
                break;
            }
            case "text": {
                format = Format.TEXT;
                break;
            }
            default: {
                format = Format.BINARY;
            }
        }
        Format fileFormat = format;
        Spliterator<String> itr = Spliterators.spliteratorUnknownSize(uris.iterator(), 0);
        if (!this.isStopped.get()) {
            JobTicket jobTicket = this.dataMovementManager.startJob(this.writeBatcher);
            ticketWrapper.put("jobTicket", jobTicket);
            StreamSupport.stream(itr, true).forEach(uri -> {
                try {
                    File file = new File((String)uri);
                    this.addToBatcher(file, fileFormat);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        this.runningThread = new Thread(() -> {
            try {
                this.writeBatcher.flushAndWait();
            }
            catch (IllegalStateException e) {
                this.logger.error("WriteBatcher has been stopped");
            }
            String stepStatus = stepMetrics.getFailedEventsCount() > 0L && this.stopOnFailure ? "stop on error in step " + this.step : (this.isStopped.get() ? "canceled step " + this.step : (stepMetrics.getFailedEventsCount() > 0L && stepMetrics.getSuccessfulEventsCount() > 0L ? "completed with errors step " + this.step : (stepMetrics.getFailedEventsCount() == 0L && stepMetrics.getSuccessfulEventsCount() > 0L ? "completed step " + this.step : "failed step " + this.step)));
            this.stepStatusListeners.forEach(listener -> listener.onStatusChange(runStepResponse.getJobId(), 100, stepStatus, stepMetrics.getSuccessfulEventsCount(), stepMetrics.getFailedEventsCount(), "Ingestion completed"));
            this.dataMovementManager.stopJob((Batcher)this.writeBatcher);
            runStepResponse.setCounts(stepMetrics.getSuccessfulEventsCount() + stepMetrics.getFailedEventsCount(), stepMetrics.getSuccessfulEventsCount(), stepMetrics.getFailedEventsCount(), stepMetrics.getSuccessfulBatchesCount(), stepMetrics.getFailedBatchesCount());
            runStepResponse.withStatus(stepStatus);
            if (errorMessages.size() > 0) {
                runStepResponse.withStepOutput(errorMessages);
            }
            if (this.jobOutputIsEnabled()) {
                JsonNode jobDoc = null;
                try {
                    jobDoc = JobService.on(this.hubClient.getJobsClient()).finishStep(this.jobId, this.step, stepStatus, (JsonNode)runStepResponse.toObjectNode());
                }
                catch (Exception e) {
                    this.logger.error("Unable to update job document, cause: " + e.getMessage());
                }
                if (jobDoc != null) {
                    try {
                        RunStepResponse tempResp = StepRunnerUtil.getResponse(jobDoc, this.step);
                        runStepResponse.setStepStartTime(tempResp.getStepStartTime());
                        runStepResponse.setStepEndTime(tempResp.getStepEndTime());
                    }
                    catch (Exception ex) {
                        this.logger.error("Unable to update step response, cause: " + ex.getMessage());
                    }
                }
            }
        });
        this.runningThread.start();
        return runStepResponse;
    }

    private void processCsv(JacksonHandle jacksonHandle, File file) {
        ObjectMapper mapper = jacksonHandle.getMapper();
        JsonNode originalContent = jacksonHandle.get();
        ObjectNode node = mapper.createObjectNode();
        if (this.outputFormat != null && this.outputFormat.equalsIgnoreCase("xml")) {
            node.putObject("content").set("root", originalContent);
        } else {
            node.set("content", originalContent);
        }
        node.put("file", file.getAbsolutePath());
        jacksonHandle.set((JsonNode)node);
        try {
            this.writeBatcher.add(this.generateUriForCsv(file.getParent(), SystemUtils.OS_NAME.toLowerCase()), (AbstractWriteHandle)jacksonHandle);
        }
        catch (IllegalStateException e) {
            this.logger.error("WriteBatcher has been stopped");
        }
        if (!file.getAbsolutePath().equalsIgnoreCase(this.currentCsvFile)) {
            this.currentCsvFile = file.getAbsolutePath();
            ++this.csvFilesProcessed;
        }
    }

    protected String generateUriForCsv(String parentPath, String os) {
        String uri;
        if (this.outputURIPrefix != null) {
            try {
                uri = this.generateAndEncodeURI(this.outputURIPrefix).replace("%", "%%");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        uri = parentPath;
        if (os.contains("windows")) {
            uri = "/" + FilenameUtils.separatorsToUnix((String)StringUtils.replaceOnce((String)uri, (String)":", (String)""));
        }
        try {
            uri = this.generateAndEncodeURI(this.outputURIReplace(uri)).replace("%", "%%");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        uri = uri + "/";
        return String.format(uri + "%s." + ("xml".equalsIgnoreCase(this.outputFormat) ? "xml" : "json"), UUID.randomUUID());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addToBatcher(File file, Format fileFormat) throws IOException {
        FileInputStream docStream = new FileInputStream(file);
        if (this.inputFileType.equalsIgnoreCase("csv") || this.inputFileType.equalsIgnoreCase("tsv") || this.inputFileType.equalsIgnoreCase("psv")) {
            CsvSchema schema = CsvSchema.emptySchema().withHeader().withColumnSeparator(this.separator.charAt(0));
            JacksonCSVSplitter splitter = new JacksonCSVSplitter().withCsvSchema(schema);
            try {
                if (this.writeBatcher.isStopped()) return;
                Stream contentStream = splitter.split((InputStream)docStream);
                contentStream.forEach(jacksonHandle -> this.processCsv((JacksonHandle)jacksonHandle, file));
                return;
            }
            catch (Exception e) {
                IOUtils.closeQuietly((InputStream)docStream);
                throw new RuntimeException(e);
            }
        }
        InputStreamHandle handle = new InputStreamHandle((InputStream)docStream);
        try {
            handle.setFormat(fileFormat);
            if (this.writeBatcher.isStopped()) return;
            try {
                String uri;
                if (this.outputURIPrefix != null) {
                    uri = this.getPrefixedEncodedURI(file.getName());
                } else {
                    uri = file.getAbsolutePath();
                    if (SystemUtils.OS_NAME.toLowerCase().contains("windows")) {
                        uri = "/" + FilenameUtils.separatorsToUnix((String)StringUtils.replaceOnce((String)uri, (String)":", (String)""));
                    }
                    uri = this.generateAndEncodeURI(this.outputURIReplace(uri));
                }
                this.writeBatcher.add(uri, (AbstractWriteHandle)handle);
                return;
            }
            catch (IllegalStateException e) {
                this.logger.error("WriteBatcher has been stopped");
            }
            return;
        }
        catch (URISyntaxException e) {
            IOUtils.closeQuietly((Closeable)handle);
            throw new RuntimeException(e);
        }
    }

    protected String getPrefixedEncodedURI(String filename) throws URISyntaxException {
        return this.generateAndEncodeURI(this.outputURIPrefix + filename);
    }

    private String generateAndEncodeURI(String path) throws URISyntaxException {
        URI uri = new URI(null, null, null, 0, path, null, null);
        return uri.toString();
    }

    private String outputURIReplace(String uri) {
        if (StringUtils.isNotEmpty((CharSequence)this.outputURIReplacement)) {
            String replacement;
            int i;
            String[] replace = this.outputURIReplacement.split(",");
            if (replace.length % 2 != 0) {
                throw new IllegalArgumentException("Invalid argument for URI replacement: " + this.outputURIReplacement);
            }
            for (i = 0; i < replace.length - 1; ++i) {
                if ((replacement = replace[++i].trim()).startsWith("'") && replacement.endsWith("'")) continue;
                throw new IllegalArgumentException("Invalid argument for URI replacement: " + this.outputURIReplacement);
            }
            for (i = 0; i < replace.length - 1; i += 2) {
                replacement = replace[i + 1].trim();
                replacement = replacement.substring(1, replacement.length() - 1);
                uri = uri.replaceAll(replace[i], replacement);
            }
        }
        return uri;
    }

    protected void runStatusListener(double uriSize, StepMetrics stepMetrics) {
        double batchCount = Math.ceil(uriSize / (double)this.batchSize);
        long totalRunBatches = stepMetrics.getSuccessfulBatchesCount() + stepMetrics.getFailedBatchesCount();
        if ("csv".equalsIgnoreCase(this.inputFileType)) {
            int percentComplete = (int)((double)this.csvFilesProcessed / uriSize * 100.0);
            if (percentComplete != this.previousPercentComplete && percentComplete % 2 == 0) {
                this.previousPercentComplete = percentComplete;
                this.stepStatusListeners.forEach(listener -> listener.onStatusChange(this.jobId, percentComplete, "running step " + this.step, stepMetrics.getSuccessfulEventsCount(), stepMetrics.getFailedEventsCount(), "Ingesting"));
            }
        } else {
            int percentComplete = (int)((double)totalRunBatches / batchCount * 100.0);
            if (percentComplete != this.previousPercentComplete && percentComplete % 5 == 0) {
                this.previousPercentComplete = percentComplete;
                this.stepStatusListeners.forEach(listener -> listener.onStatusChange(this.jobId, percentComplete, "running step " + this.step, stepMetrics.getSuccessfulEventsCount(), stepMetrics.getFailedEventsCount(), "Ingesting"));
            }
        }
    }

    private String jsonToString(Map map) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString(objectMapper.convertValue((Object)map, JsonNode.class));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

