/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.step;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.marklogic.hub.error.DataHubConfigurationException;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.step.impl.Step;
import com.marklogic.hub.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RunStepResponse {
    private String jobId;
    private String flowName;
    private String stepName;
    private String stepDefinitionName;
    private String stepDefinitionType;
    private String targetEntityType;
    private String targetDatabase;
    public List<String> stepOutput;
    private Map<String, JsonNode> fullOutput;
    private String status;
    private long totalEvents = 0L;
    private long successfulEvents = 0L;
    private long failedEvents = 0L;
    private long successfulBatches = 0L;
    private long failedBatches = 0L;
    private boolean success = false;
    private String stepStartTime;
    private String stepEndTime;
    private Flow flow;

    public void setStepStartTime(String stepStartTime) {
        this.stepStartTime = stepStartTime;
    }

    public void setStepEndTime(String stepEndTime) {
        this.stepEndTime = stepEndTime;
    }

    public ObjectNode toObjectNode() {
        try {
            String json = JSONObject.writeValueAsString(this);
            return (ObjectNode)new ObjectMapper().readTree(json);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to convert RunStepResponse into JSON node; cause: " + ex.getMessage());
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public RunStepResponse withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public static RunStepResponse withFlow(Flow flow) {
        RunStepResponse runStepResponse = new RunStepResponse();
        runStepResponse.flowName = flow.getName();
        runStepResponse.flow = flow;
        return runStepResponse;
    }

    public RunStepResponse withStep(String stepNum) {
        if (this.flow == null) {
            throw new DataHubConfigurationException("Flow has to be set before setting step");
        }
        Step step = this.flow.getStep(stepNum);
        this.stepName = step.getName();
        this.stepDefinitionName = step.getStepDefinitionName();
        this.stepDefinitionType = step.getStepDefinitionType() != null ? step.getStepDefinitionType().toString() : null;
        TextNode targetEntityTextNode = (TextNode)step.getOptions().getOrDefault("targetEntityType", step.getOptions().get("targetEntity"));
        if (targetEntityTextNode != null) {
            this.targetEntityType = targetEntityTextNode.asText();
        }
        Optional.of(step.getOptions()).map(optionMap -> (TextNode)optionMap.get("targetDatabase")).ifPresent(node -> {
            this.targetDatabase = node.asText();
        });
        return this;
    }

    public RunStepResponse withStepOutput(List<String> stepOutput) {
        this.stepOutput = stepOutput;
        return this;
    }

    public RunStepResponse withFullOutput(Map<String, JsonNode> fullOutput) {
        this.fullOutput = fullOutput;
        return this;
    }

    public RunStepResponse withStepOutput(String jobOutput) {
        if (this.stepOutput == null) {
            this.stepOutput = new ArrayList<String>();
        }
        this.stepOutput.add(jobOutput);
        return this;
    }

    public RunStepResponse withStatus(String status) {
        if (status.contains("completed step ")) {
            this.success = true;
        }
        this.status = status;
        return this;
    }

    public RunStepResponse withSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public RunStepResponse setCounts(long totalEvents, long successfulEvents, long failedEvents, long successfulBatches, long failedBatches) {
        this.totalEvents = totalEvents;
        this.successfulEvents = successfulEvents;
        this.failedEvents = failedEvents;
        this.successfulBatches = successfulBatches;
        this.failedBatches = failedBatches;
        return this;
    }

    @JsonIgnore
    public String getJobId() {
        return this.jobId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Map<String, JsonNode> getFullOutput() {
        return this.fullOutput;
    }

    public String getStatus() {
        return this.status;
    }

    public List<String> getStepOutput() {
        return this.stepOutput;
    }

    public long getSuccessfulEvents() {
        return this.successfulEvents;
    }

    public long getFailedEvents() {
        return this.failedEvents;
    }

    public long getTotalEvents() {
        return this.totalEvents;
    }

    public long getSuccessfulBatches() {
        return this.successfulBatches;
    }

    public long getFailedBatches() {
        return this.failedBatches;
    }

    public String getStepName() {
        return this.stepName;
    }

    public String getStepDefinitionType() {
        return this.stepDefinitionType;
    }

    public String getStepDefinitionName() {
        return this.stepDefinitionName;
    }

    public String getStepStartTime() {
        return this.stepStartTime;
    }

    public String getStepEndTime() {
        return this.stepEndTime;
    }

    public String getTargetEntityType() {
        return this.targetEntityType;
    }

    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    public void setTargetDatabase(String targetDatabase) {
        this.targetDatabase = targetDatabase;
    }

    public String toString() {
        return String.format("[flowName: %s, stepName: %s, stepDefinitionName: %s, stepDefinitionType: %s, targetEntityType: %s, targetDatabase: %s, success: %s, status: %s, totalEvents: %d, successfulEvents: %d, failedEvents: %d, successfulBatches: %d, failedBatches: %d, stepStartTime: %s , stepEndTime: %s]", this.flowName, this.stepName, this.stepDefinitionName, this.stepDefinitionType, this.targetEntityType, this.targetDatabase, this.success, this.status, this.totalEvents, this.successfulEvents, this.failedEvents, this.successfulBatches, this.failedBatches, this.stepStartTime, this.stepEndTime);
    }
}

