/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.mapping;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.hub.entity.DefinitionType;
import com.marklogic.hub.entity.HubEntity;
import com.marklogic.hub.entity.InfoType;
import com.marklogic.hub.entity.PropertyType;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.mapping.Mapping;
import java.util.HashMap;
import java.util.Map;

@JsonPropertyOrder(value={"lang", "name", "description", "version", "targetEntityType", "sourceContext", "sourceURI", "properties"})
public class MappingImpl
implements Mapping {
    private String name;
    private String sourceContext;
    private String targetEntityType;
    private String description;
    private String lang;
    private int version;
    private String sourceURI;
    private Map<String, String> namespaces;
    private HashMap<String, ObjectNode> properties;

    public MappingImpl(String name) {
        this.name = name;
        this.lang = "zxx";
        this.version = 1;
        this.description = "Default description";
        this.sourceContext = "/";
        this.sourceURI = "";
        this.properties = new HashMap();
        this.namespaces = new HashMap<String, String>();
        this.targetEntityType = "http://example.org/modelName-version/entityType";
    }

    public MappingImpl(String name, HubEntity entity) {
        this(name);
        InfoType info;
        if (entity != null && (info = entity.getInfo()) != null) {
            String prefix = info.getBaseUri() != null ? info.getBaseUri() : "";
            this.targetEntityType = prefix + info.getTitle() + "-" + info.getVersion() + "/" + info.getTitle();
            DefinitionType definition = entity.getDefinitions().getDefinitions().get(info.getTitle());
            if (definition != null) {
                this.properties.clear();
                for (PropertyType property : definition.getProperties()) {
                    String propertyName = property.getName();
                    this.properties.put(propertyName, this.createProperty("sourcedFrom", propertyName));
                }
            }
        }
    }

    @Override
    public Mapping deserialize(JsonNode json) {
        HashMap jsonProperties;
        ObjectMapper mapper = new ObjectMapper();
        try {
            jsonProperties = (HashMap)mapper.treeToValue((TreeNode)json.get("properties"), HashMap.class);
        }
        catch (JsonProcessingException e) {
            throw new DataHubProjectException("Could not parse mapper properties");
        }
        if (json.has("namespaces") && !json.get("namespaces").isNull()) {
            HashMap jsonNamespaces;
            try {
                jsonNamespaces = (HashMap)mapper.treeToValue((TreeNode)json.get("namespaces"), HashMap.class);
            }
            catch (JsonProcessingException e) {
                throw new DataHubProjectException("Could not parse mapper namespaces");
            }
            this.setNamespaces(jsonNamespaces);
        }
        if (json.has("version")) {
            this.setVersion(json.get("version").asInt());
        }
        if (json.has("name")) {
            this.setName(json.get("name").asText());
        }
        if (json.has("sourceContext")) {
            this.setSourceContext(json.get("sourceContext").asText());
        }
        if (json.has("description")) {
            this.setDescription(json.get("description").asText());
        }
        if (json.has("targetEntityType")) {
            this.setTargetEntityType(json.get("targetEntityType").asText());
        }
        if (json.has("language")) {
            this.setLang(json.get("language").asText());
        }
        if (json.has("lang")) {
            this.setLang(json.get("lang").asText());
        }
        if (json.has("sourceURI")) {
            this.setSourceURI(json.get("sourceURI").asText());
        }
        if (json.has("properties")) {
            this.setProperties(jsonProperties);
        }
        return this;
    }

    @Override
    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    private ObjectNode createProperty(String name, String value) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put(name, value);
        return node;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public HashMap<String, ObjectNode> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(HashMap<String, ObjectNode> properties) {
        this.properties = properties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSourceContext() {
        return this.sourceContext;
    }

    @Override
    public void setSourceContext(String sourceContext) {
        this.sourceContext = sourceContext;
    }

    @Override
    public String getTargetEntityType() {
        return this.targetEntityType;
    }

    @Override
    public void setTargetEntityType(String targetEntityType) {
        this.targetEntityType = targetEntityType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getSourceURI() {
        return this.sourceURI;
    }

    @Override
    public void setSourceURI(String sourceURI) {
        this.sourceURI = sourceURI;
    }

    @Override
    @JsonIgnore
    @Deprecated
    public String getLanguage() {
        return this.lang;
    }

    @Override
    @Deprecated
    public void setLanguage(String language) {
        this.lang = language;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Override
    public String serialize() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new DataHubProjectException("Unable to serialize mapping object.");
        }
    }

    @Override
    public void incrementVersion() {
        this.setVersion(this.getVersion() + 1);
    }
}

