/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.legacy.impl;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.legacy.LegacyFlowManager;
import com.marklogic.hub.legacy.collector.impl.LegacyCollectorImpl;
import com.marklogic.hub.legacy.flow.CodeFormat;
import com.marklogic.hub.legacy.flow.DataFormat;
import com.marklogic.hub.legacy.flow.FlowType;
import com.marklogic.hub.legacy.flow.LegacyFlow;
import com.marklogic.hub.legacy.flow.LegacyFlowBuilder;
import com.marklogic.hub.legacy.flow.LegacyFlowRunner;
import com.marklogic.hub.legacy.flow.impl.LegacyFlowRunnerImpl;
import com.marklogic.hub.legacy.impl.FlowResource;
import com.marklogic.hub.legacy.impl.MainPluginImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LegacyFlowManagerImpl
extends LoggingObject
implements LegacyFlowManager {
    @Autowired
    private HubConfig hubConfig;

    public LegacyFlowManagerImpl() {
    }

    public LegacyFlowManagerImpl(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    @Override
    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    @Override
    public List<LegacyFlow> getLocalFlows() {
        ArrayList<LegacyFlow> flows = new ArrayList<LegacyFlow>();
        Path entitiesDir = this.hubConfig.getHubProject().getLegacyHubEntitiesDir();
        File[] entities = entitiesDir.toFile().listFiles(pathname -> pathname.isDirectory());
        if (entities != null) {
            for (File entity : entities) {
                String entityName = entity.getName();
                flows.addAll(this.getLocalFlowsForEntity(entityName));
            }
        }
        return flows;
    }

    @Override
    public List<LegacyFlow> getLocalFlowsForEntity(String entityName) {
        return this.getLocalFlowsForEntity(entityName, null);
    }

    @Override
    public List<LegacyFlow> getLocalFlowsForEntity(String entityName, FlowType flowType) {
        File[] harmonizeFlows;
        LegacyFlow flow;
        File[] inputFlows;
        ArrayList<LegacyFlow> flows = new ArrayList<LegacyFlow>();
        Path entitiesDir = this.hubConfig.getHubProject().getLegacyHubEntitiesDir();
        Path entityDir = entitiesDir.resolve(entityName);
        Path inputDir = entityDir.resolve("input");
        Path harmonizeDir = entityDir.resolve("harmonize");
        boolean getInputFlows = false;
        boolean getHarmonizeFlows = false;
        if (flowType == null) {
            getHarmonizeFlows = true;
            getInputFlows = true;
        } else if (flowType.equals((Object)FlowType.INPUT)) {
            getInputFlows = true;
        } else if (flowType.equals((Object)FlowType.HARMONIZE)) {
            getHarmonizeFlows = true;
        }
        if (getInputFlows && (inputFlows = inputDir.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.getName().equals("REST"))) != null) {
            for (File inputFlow : inputFlows) {
                flow = this.getLocalFlow(entityName, inputFlow.toPath(), FlowType.INPUT);
                if (flow == null) continue;
                flows.add(flow);
            }
        }
        if (getHarmonizeFlows && (harmonizeFlows = harmonizeDir.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.getName().equals("REST"))) != null) {
            for (File harmonizeFlow : harmonizeFlows) {
                flow = this.getLocalFlow(entityName, harmonizeFlow.toPath(), FlowType.HARMONIZE);
                if (flow == null) continue;
                flows.add(flow);
            }
        }
        return flows;
    }

    @Override
    public LegacyFlow getFlowFromProperties(Path propertiesFile) {
        String quotedSeparator = Pattern.quote(File.separator);
        String floweRegex = ".+plugins" + quotedSeparator + "entities" + quotedSeparator + "(.+)" + quotedSeparator + "(input|harmonize)" + quotedSeparator + "(.+)" + quotedSeparator + ".+";
        FlowType flowType = propertiesFile.toString().replaceAll(floweRegex, "$2").equals("input") ? FlowType.INPUT : FlowType.HARMONIZE;
        String entityName = propertiesFile.toString().replaceAll(floweRegex, "$1");
        Path propertiesDir = propertiesFile.getParent();
        return propertiesDir == null ? null : this.getLocalFlow(entityName, propertiesDir, flowType);
    }

    private LegacyFlow getLocalFlow(String entityName, Path flowDir, FlowType flowType) {
        Path flowPath = flowDir.getFileName();
        if (flowPath == null) {
            return null;
        }
        String flowName = flowPath.toString();
        File propertiesFile = flowDir.resolve(flowName + ".properties").toFile();
        if (propertiesFile.exists()) {
            Properties properties = new Properties();
            try (FileInputStream fis = new FileInputStream(propertiesFile);){
                properties.load(fis);
            }
            catch (FileNotFoundException e) {
                this.logger.warn("Unable to locate properties file for legacy flow: " + flowName, (Throwable)e);
                return null;
            }
            catch (IOException e) {
                this.logger.warn("Unable to load properties file for legacy flow: " + flowName, (Throwable)e);
                return null;
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                properties.put(entry.getKey(), entry.getValue().toString().trim());
            }
            LegacyFlowBuilder flowBuilder = LegacyFlowBuilder.newFlow().withEntityName(entityName).withName(flowName).withType(flowType).withCodeFormat(CodeFormat.getCodeFormat((String)properties.get("codeFormat"))).withDataFormat(DataFormat.getDataFormat((String)properties.get("dataFormat"))).withMain(new MainPluginImpl((String)properties.get("mainModule"), CodeFormat.getCodeFormat((String)properties.get("mainCodeFormat"))));
            if (flowType.equals((Object)FlowType.HARMONIZE)) {
                flowBuilder.withCollector(new LegacyCollectorImpl((String)properties.get("collectorModule"), CodeFormat.getCodeFormat((String)properties.get("collectorCodeFormat"))));
            }
            return flowBuilder.build();
        }
        return null;
    }

    @Override
    public List<LegacyFlow> getFlows(String entityName) {
        return new FlowResource(this.hubConfig.newStagingClient()).getFlows(entityName);
    }

    @Override
    public LegacyFlow getFlow(String entityName, String flowName) {
        return this.getFlow(entityName, flowName, null);
    }

    @Override
    public LegacyFlow getFlow(String entityName, String flowName, FlowType flowType) {
        return new FlowResource(this.hubConfig.newStagingClient()).getFlow(entityName, flowName, flowType);
    }

    @Override
    public LegacyFlowRunner newFlowRunner() {
        return new LegacyFlowRunnerImpl(this.hubConfig);
    }
}

