/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.legacy.flow;

import com.marklogic.hub.legacy.MainPlugin;
import com.marklogic.hub.legacy.collector.LegacyCollector;
import com.marklogic.hub.legacy.collector.impl.LegacyCollectorImpl;
import com.marklogic.hub.legacy.flow.CodeFormat;
import com.marklogic.hub.legacy.flow.DataFormat;
import com.marklogic.hub.legacy.flow.FlowType;
import com.marklogic.hub.legacy.flow.LegacyFlow;
import com.marklogic.hub.legacy.flow.impl.LegacyFlowImpl;
import com.marklogic.hub.legacy.impl.MainPluginImpl;

public class LegacyFlowBuilder {
    LegacyFlow flow = new LegacyFlowImpl();

    private LegacyFlowBuilder() {
    }

    public static LegacyFlowBuilder newFlow() {
        return new LegacyFlowBuilder();
    }

    public LegacyFlowBuilder withName(String flowName) {
        this.flow.setName(flowName);
        return this;
    }

    public LegacyFlowBuilder withEntityName(String entityName) {
        this.flow.setEntityName(entityName);
        return this;
    }

    public LegacyFlowBuilder withType(FlowType type) {
        this.flow.setType(type);
        return this;
    }

    public LegacyFlowBuilder withDataFormat(DataFormat dataFormat) {
        this.flow.setDataFormat(dataFormat);
        return this;
    }

    public LegacyFlowBuilder withCodeFormat(CodeFormat codeFormat) {
        this.flow.setCodeFormat(codeFormat);
        return this;
    }

    public LegacyFlowBuilder withCollector(LegacyCollector legacyCollector) {
        this.flow.setCollector(legacyCollector);
        return this;
    }

    public LegacyFlowBuilder withMain(MainPlugin main) {
        this.flow.setMain(main);
        return this;
    }

    public LegacyFlowBuilder withMapping(String mappingName) {
        this.flow.setMappingName(mappingName);
        return this;
    }

    public LegacyFlow build() {
        if (this.flow.getCollector() == null && this.flow.getType().equals((Object)FlowType.HARMONIZE)) {
            String collectorModule = "collector." + this.flow.getCodeFormat().toString();
            this.flow.setCollector(new LegacyCollectorImpl(collectorModule, this.flow.getCodeFormat()));
        }
        if (this.flow.getMain() == null) {
            String mainModule = "main." + this.flow.getCodeFormat().toString();
            this.flow.setMain(new MainPluginImpl(mainModule, this.flow.getCodeFormat()));
        }
        return this.flow;
    }
}

