/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.MarkLogicVersion;
import com.marklogic.hub.impl.HubVersionManager;
import com.marklogic.hub.impl.LegacyHubVersionManager;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Versions
extends LoggingObject {
    @Autowired
    private HubConfig hubConfig;
    private HubClient hubClient;

    public Versions() {
    }

    public Versions(HubClient hubClient) {
        this.hubClient = hubClient;
    }

    public Versions(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public String getInstalledVersion() {
        return this.getInstalledVersion(false);
    }

    public String getInstalledVersion(boolean fallbackToLocalProject) {
        try {
            DatabaseClient stagingClient = this.hubClient != null ? this.hubClient.getStagingClient() : this.hubConfig.newStagingClient();
            return this.getVersionFromRestEndpoint(stagingClient);
        }
        catch (Exception ex) {
            if (fallbackToLocalProject) {
                this.logger.warn("Unable to determine installed version, likely because DH is not yet installed: " + ex.getMessage());
                this.logger.warn("Will try to determine version from local project");
                return this.getLocalProjectVersion();
            }
            throw ex;
        }
    }

    private String getVersionFromRestEndpoint(DatabaseClient stagingClient) {
        try {
            return new HubVersionManager(stagingClient).getHubVersion();
        }
        catch (FailedRequestException fre) {
            String serverMessage = fre.getServerMessage();
            if (serverMessage != null && serverMessage.contains("Extension mlHubversion")) {
                this.logger.warn("Could not find mlHubversion REST endpoint; will try ml:hubversion REST endpoint to determine installed DHF version");
                return this.getVersionFromViaLegacyRestExtension(stagingClient);
            }
            throw fre;
        }
    }

    protected String getVersionFromViaLegacyRestExtension(DatabaseClient stagingClient) {
        return new LegacyHubVersionManager(stagingClient).getHubVersion();
    }

    public String getLocalProjectVersion() {
        String version;
        String string = version = this.hubConfig != null ? this.determineVersionFromLocalProject(this.hubConfig.getHubProject()) : null;
        if (version == null) {
            version = "2.0.0";
            this.logger.warn("Unable to determine version from local project, will fallback to earliest known version: " + version);
        } else {
            this.logger.info("Local project version: " + version);
        }
        return version;
    }

    protected String determineVersionFromLocalProject(HubProject hubProject) {
        File roleFile;
        File rolesDir;
        File securityDir = hubProject.getHubSecurityDir().toFile();
        if (securityDir.exists() && (rolesDir = new File(securityDir, "roles")).exists() && (roleFile = new File(rolesDir, "data-hub-admin.json")).exists()) {
            try {
                JsonNode role = new ObjectMapper().readTree(roleFile);
                String description = role.get("description").asText();
                int pos = description.indexOf(": Permits");
                if (pos > -1) {
                    return description.substring(0, pos);
                }
            }
            catch (Exception ex) {
                this.logger.warn("Unexpected error when trying to read local project version from data-hub-admin.json; cause: " + ex.getMessage());
            }
        }
        return null;
    }

    public String getMarkLogicVersionString() {
        DatabaseClient client = this.hubClient != null ? this.hubClient.getStagingClient() : this.hubConfig.getAppConfig().newAppServicesDatabaseClient(null);
        try {
            return (String)client.newServerEval().xquery("xdmp:version()").evalAs(String.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to get version of MarkLogic; cause: " + ex.getMessage(), ex);
        }
    }

    public MarkLogicVersion getMarkLogicVersion() {
        return new MarkLogicVersion(this.getMarkLogicVersionString());
    }

    public static int compare(String v1, String v2) {
        if (v1 == null || v2 == null) {
            return 1;
        }
        String[] v1Parts = v1.split("\\.");
        String[] v2Parts = v2.split("\\.");
        int length = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < length; ++i) {
            int v2Part;
            int v1Part = i < v1Parts.length ? Integer.parseInt(v1Parts[i]) : 0;
            int n = v2Part = i < v2Parts.length ? Integer.parseInt(v2Parts[i]) : 0;
            if (v1Part < v2Part) {
                return -1;
            }
            if (v1Part <= v2Part) continue;
            return 1;
        }
        return 0;
    }
}

