/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.extensions.ResourceServices;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.util.RequestParameters;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.dataservices.StepService;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.impl.Scaffolding;
import com.marklogic.hub.impl.StepDefinitionManagerImpl;
import com.marklogic.hub.impl.Versions;
import com.marklogic.hub.legacy.flow.CodeFormat;
import com.marklogic.hub.legacy.flow.DataFormat;
import com.marklogic.hub.legacy.flow.FlowType;
import com.marklogic.hub.legacy.flow.LegacyFlow;
import com.marklogic.hub.legacy.flow.LegacyFlowBuilder;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.util.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ScaffoldingImpl
extends LoggingObject
implements Scaffolding {
    @Autowired
    HubConfig hubConfig;
    Versions versions;

    public ScaffoldingImpl() {
    }

    public ScaffoldingImpl(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    public static String getAbsolutePath(String first, String ... more) {
        StringBuilder absolutePath = new StringBuilder(first);
        for (String path : more) {
            absolutePath.append(File.separator);
            absolutePath.append(path);
        }
        return absolutePath.toString();
    }

    public StepDefinition createStepDefinition(String name, String type, String format) {
        StepDefinitionManagerImpl stepDefinitionManager = new StepDefinitionManagerImpl(this.hubConfig);
        StepDefinition stepDef = StepDefinition.create(name, StepDefinition.StepDefinitionType.getStepDefinitionType(type));
        if (stepDefinitionManager.getStepDefinition(name, stepDef.getType()) != null) {
            throw new IllegalArgumentException(this.format("A step definition already exists with the name '%s' and type '%s'", new Object[]{name, type}));
        }
        stepDef.setModulePath(String.format("/custom-modules/%s/%s/main.sjs", type.toLowerCase(), name));
        stepDefinitionManager.saveStepDefinition(stepDef);
        this.createCustomModule(name, type, format);
        return stepDef;
    }

    public Pair<File, String> createStepFile(String stepName, String stepType, String stepDefName, String entityType) {
        JsonNode step;
        StepDefinitionManagerImpl stepDefinitionManager = new StepDefinitionManagerImpl(this.hubConfig);
        StepDefinition.StepDefinitionType stepDefType = StepDefinition.StepDefinitionType.getStepDefinitionType(stepType);
        Assert.notNull((Object)((Object)stepDefType), (String)("Unrecognized step type: " + stepType));
        StepDefinition stepDefinition = null;
        StringBuilder messageBuilder = new StringBuilder();
        File stepFile = this.hubConfig.getHubProject().getStepFile(stepDefType, stepName);
        if (stepFile.exists()) {
            throw new IllegalArgumentException("Cannot create step; a step file already exists at: " + stepFile.getAbsolutePath() + ". Please choose a different name for your step.");
        }
        stepFile.getParentFile().mkdirs();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode stepPayLoad = objectMapper.createObjectNode();
        stepPayLoad.put("name", stepName);
        stepPayLoad.put("description", "");
        stepPayLoad.put("stepDefinitionType", stepType);
        if (stepDefName != null) {
            stepPayLoad.put("stepDefinitionName", stepDefName);
        } else if (StepDefinition.StepDefinitionType.CUSTOM.equals((Object)stepDefType)) {
            stepDefName = stepName;
            stepPayLoad.put("stepDefinitionName", stepDefName);
        }
        if ("ingestion".equalsIgnoreCase(stepType)) {
            stepPayLoad.put("sourceFormat", "json");
            stepPayLoad.put("targetFormat", "json");
        } else {
            stepPayLoad.put("selectedSource", "query");
            if ("custom".equalsIgnoreCase(stepType) || "mapping".equalsIgnoreCase(stepType)) {
                stepPayLoad.put("sourceQuery", "cts.collectionQuery('changeme')");
                if (entityType != null) {
                    stepPayLoad.put("entityType", entityType);
                }
                if ("mapping".equalsIgnoreCase(stepType)) {
                    stepPayLoad.put("attachSourceDocument", false);
                }
            }
        }
        if (stepDefName != null && stepDefinitionManager.getStepDefinition(stepDefName, StepDefinition.StepDefinitionType.getStepDefinitionType(stepType)) == null) {
            try {
                stepDefinition = StepDefinition.create(stepDefName, StepDefinition.StepDefinitionType.getStepDefinitionType(stepType));
                stepDefinition.setModulePath("/custom-modules/" + stepType.toLowerCase() + "/" + stepDefName + "/main.sjs");
                stepDefinitionManager.saveStepDefinition(stepDefinition);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to write step definition to database; cause: " + e.getMessage(), e);
            }
            this.createCustomModule(stepDefName, stepType);
            messageBuilder.append(String.format("Created step definition '%s' of type '%s'.\n", stepName, stepType));
            messageBuilder.append("The module file for the step definition is available at /custom-modules/" + stepType.toLowerCase() + "/" + stepDefName + "/main.sjs. \n");
            messageBuilder.append("It is recommended to run './gradlew -i mlWatch' so that as you modify the module, it will be automatically loaded into your application's modules database.\n");
        }
        DatabaseClient stagingClient = this.hubConfig.newHubClient().getStagingClient();
        try {
            StepService stepService = StepService.on(stagingClient);
            step = stepService.saveStep(stepType, (JsonNode)stepPayLoad, false, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write step to database; cause: " + e.getMessage(), e);
        }
        messageBuilder.append("Created step '" + stepName + "' of type '" + stepType + "' with default properties. The step has been deployed to staging and final databases.");
        try {
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(stepFile, (Object)step);
            return Pair.of((Object)stepFile, (Object)messageBuilder.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write step to file: " + stepFile.getAbsolutePath() + "; cause: " + e.getMessage(), e);
        }
    }

    @Override
    public Path getLegacyFlowDir(String entityName, String flowName, FlowType flowType) {
        Path entityDir = this.hubConfig.getHubProject().getEntityDir(entityName);
        Path typeDir = entityDir.resolve(flowType.toString());
        Path flowDir = typeDir.resolve(flowName);
        return flowDir;
    }

    @Override
    public void createEntity(String entityName) {
        Path entityDir = this.hubConfig.getHubProject().getHubEntitiesDir();
        File entityFile = entityDir.resolve(entityName + ".entity.json").toFile();
        if (entityFile.exists()) {
            throw new DataHubProjectException("Entity with that name already exists.");
        }
        File entityDirFile = entityDir.toFile();
        if (!entityDirFile.exists()) {
            entityDirFile.mkdirs();
        }
        String fileContents = this.getFileContent("scaffolding/Entity.json", entityName);
        this.writeToFile(fileContents, entityFile);
    }

    @Override
    public void createLegacyMappingDir(String mappingName) {
        Path mappingDir = this.hubConfig.getHubProject().getLegacyMappingDir(mappingName);
        mappingDir.toFile().mkdirs();
    }

    @Override
    public void createMappingDir(String mappingName) {
        Path mappingDir = this.hubConfig.getHubProject().getMappingDir(mappingName);
        mappingDir.toFile().mkdirs();
    }

    @Override
    public void createCustomModule(String stepName, String stepType) {
        this.createCustomModule(stepName, stepType, "sjs");
    }

    @Override
    public void createCustomModule(String stepName, String stepType, String format) {
        Path customModuleDir = this.hubConfig.getHubProject().getCustomModuleDir(stepName, stepType.toLowerCase());
        customModuleDir.toFile().mkdirs();
        if (customModuleDir.toFile().exists()) {
            String moduleScaffoldingSrcFile;
            String libScaffoldingSrcFile = null;
            if ("sjs".equalsIgnoreCase(format)) {
                moduleScaffoldingSrcFile = "scaffolding/custom-module/sjs/main-" + stepType.toLowerCase() + ".sjs";
            } else if ("xqy".equalsIgnoreCase(format)) {
                moduleScaffoldingSrcFile = "scaffolding/custom-module/xqy/main-" + stepType.toLowerCase() + ".sjs";
                libScaffoldingSrcFile = "scaffolding/custom-module/xqy/lib-" + stepType.toLowerCase() + ".xqy";
            } else {
                throw new RuntimeException("Invalid code format. The allowed formats are 'xqy' or 'sjs'");
            }
            File moduleFile = customModuleDir.resolve("main.sjs").toFile();
            InputStream inputStream = ScaffoldingImpl.class.getClassLoader().getResourceAsStream(moduleScaffoldingSrcFile);
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(this.format("Writing module to: %s", new Object[]{moduleFile.getAbsolutePath()}));
                }
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)moduleFile);
                File libFile = customModuleDir.resolve("lib.xqy").toFile();
                if (libScaffoldingSrcFile != null) {
                    InputStream libInputStream = ScaffoldingImpl.class.getClassLoader().getResourceAsStream(libScaffoldingSrcFile);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(this.format("Writing module to: %s", new Object[]{libFile.getAbsolutePath()}));
                    }
                    FileUtils.copyInputStreamToFile((InputStream)libInputStream, (File)libFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public File createDefaultFlow(String flowName) {
        Path flowsDir = this.hubConfig.getHubProject().getFlowsDir();
        flowsDir.toFile().mkdirs();
        File flowFile = flowsDir.resolve(flowName + ".flow.json").toFile();
        if (flowsDir.toFile().exists()) {
            HashMap<String, String> customTokens = new HashMap<String, String>();
            customTokens.put("%%mlStagingDbName%%", this.hubConfig.getDbName(DatabaseKind.STAGING));
            customTokens.put("%%mlFinalDbName%%", this.hubConfig.getDbName(DatabaseKind.FINAL));
            customTokens.put("%%mlFlowName%%", flowName);
            try {
                String fileContents = this.buildFlowFromDefaultFlow(customTokens);
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(flowFile), StandardCharsets.UTF_8);){
                    writer.write(fileContents);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return flowFile;
    }

    protected String buildFlowFromDefaultFlow(Map<String, String> customTokens) throws IOException {
        String flowSrcFile = "scaffolding/defaultFlow.flow.json";
        String fileContents = null;
        try (InputStream inputStream = ScaffoldingImpl.class.getClassLoader().getResourceAsStream(flowSrcFile);){
            assert (inputStream != null);
            fileContents = IOUtils.toString((InputStream)inputStream);
            for (Map.Entry<String, String> entry : customTokens.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                fileContents = fileContents.replace(entry.getKey(), value);
            }
        }
        return fileContents;
    }

    @Override
    public void createLegacyFlow(String entityName, String flowName, FlowType flowType, CodeFormat codeFormat, DataFormat dataFormat) {
        this.createLegacyFlow(entityName, flowName, flowType, codeFormat, dataFormat, true);
    }

    @Override
    public void createLegacyFlow(String entityName, String flowName, FlowType flowType, CodeFormat codeFormat, DataFormat dataFormat, boolean useEsModel) {
        this.createLegacyFlow(entityName, flowName, flowType, codeFormat, dataFormat, useEsModel, null);
    }

    @Override
    public void createLegacyFlow(String entityName, String flowName, FlowType flowType, CodeFormat codeFormat, DataFormat dataFormat, boolean useEsModel, String mappingNameWithVersion) {
        try {
            Path flowDir = this.getLegacyFlowDir(entityName, flowName, flowType);
            flowDir.toFile().mkdirs();
            if (useEsModel) {
                ContentPlugin cp = new ContentPlugin(this.hubConfig.newStagingClient());
                String content = cp.getContents(entityName, codeFormat, flowType, mappingNameWithVersion);
                this.writeBuffer(content, flowDir.resolve("content." + (Object)((Object)codeFormat)));
            } else {
                this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/content." + (Object)((Object)codeFormat), flowDir.resolve("content." + (Object)((Object)codeFormat)));
            }
            if (flowType.equals((Object)FlowType.HARMONIZE)) {
                this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/collector." + (Object)((Object)codeFormat), flowDir.resolve("collector." + (Object)((Object)codeFormat)));
                this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/writer." + (Object)((Object)codeFormat), flowDir.resolve("writer." + (Object)((Object)codeFormat)));
            }
            this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/headers." + (Object)((Object)codeFormat), flowDir.resolve("headers." + (Object)((Object)codeFormat)));
            this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/triples." + (Object)((Object)codeFormat), flowDir.resolve("triples." + (Object)((Object)codeFormat)));
            this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/main." + (Object)((Object)codeFormat), flowDir.resolve("main." + (Object)((Object)codeFormat)));
            LegacyFlow flow = LegacyFlowBuilder.newFlow().withEntityName(entityName).withName(flowName).withType(flowType).withCodeFormat(codeFormat).withDataFormat(dataFormat).withMapping(mappingNameWithVersion).build();
            try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(flowDir.resolve(flowName + ".properties").toFile()), StandardCharsets.UTF_8);){
                flow.toProperties().store(fw, "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateLegacyEntity(String entityName) {
        Path oldEntityDir = this.hubConfig.getHubProject().getEntityDir(entityName);
        Path newEntityDir = this.hubConfig.getHubProject().getHubEntitiesDir();
        String entityFileName = entityName + "entity.json";
        try {
            Files.move(oldEntityDir.resolve(entityFileName), newEntityDir.resolve(entityFileName), new CopyOption[0]);
        }
        catch (IOException e) {
            this.logger.warn("Unable to move legacy entity '" + entityName + "'", (Throwable)e);
        }
    }

    private void writeFile(String srcFile, Path dstFile) {
        this.logger.info("writing: " + srcFile + " => " + dstFile.toString());
        if (!dstFile.toFile().exists()) {
            InputStream inputStream = Scaffolding.class.getClassLoader().getResourceAsStream(srcFile);
            FileUtil.copy(inputStream, dstFile.toFile());
        }
    }

    private void writeBuffer(String buffer, Path dstFile) {
        this.logger.info("writing: " + dstFile.toString());
        if (!dstFile.toFile().exists()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.getBytes(StandardCharsets.UTF_8));
            FileUtil.copy(inputStream, dstFile.toFile());
        }
    }

    private void writeToFile(String fileContent, File dstFile) {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dstFile), StandardCharsets.UTF_8));){
            bw.write(fileContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFileContent(String srcFile, String placeholder) {
        StringBuilder output = new StringBuilder();
        InputStream inputStream = null;
        BufferedReader rdr = null;
        try {
            inputStream = Scaffolding.class.getClassLoader().getResourceAsStream(srcFile);
            rdr = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String bufferedLine = null;
            while ((bufferedLine = rdr.readLine()) != null) {
                if (bufferedLine.contains("placeholder")) {
                    bufferedLine = bufferedLine.replace("placeholder", placeholder);
                }
                output.append(bufferedLine);
                output.append("\n");
            }
            inputStream.close();
            rdr.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toString();
    }

    public static class ContentPlugin
    extends ResourceManager {
        private static final String NAME = "mlScaffoldContent";
        private RequestParameters params = new RequestParameters();

        public ContentPlugin(DatabaseClient client) {
            client.init(NAME, (ResourceManager)this);
        }

        public String getContents(String entityName, CodeFormat codeFormat, FlowType flowType, String mappingName) {
            ResourceServices.ServiceResultIterator resultItr;
            this.params.add("entity", entityName);
            this.params.add("codeFormat", codeFormat.toString());
            this.params.add("flowType", flowType.toString());
            if (mappingName != null) {
                this.params.add("mapping", mappingName);
            }
            if ((resultItr = this.getServices().get(this.params, new String[0])) == null || !resultItr.hasNext()) {
                throw new RuntimeException("Unable to get Content Plugin scaffold");
            }
            ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
            return ((StringHandle)res.getContent((AbstractReadHandle)new StringHandle())).get().replaceAll("\n", "\r\n");
        }
    }
}

