/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.hubcentral;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.dataservices.ArtifactService;
import com.marklogic.hub.impl.HubConfigImpl;
import com.marklogic.hub.impl.HubProjectImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.util.FileCopyUtils;

public class HubCentralManager
extends LoggingObject {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHubCentralFilesAsZip(HubClient hubClient, OutputStream outputStream) {
        ArrayNode artifacts = (ArrayNode)ArtifactService.on(hubClient.getStagingClient()).getArtifactsWithProjectPaths();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        ObjectWriter prettyWriter = this.buildPrettyWriter();
        try {
            artifacts.forEach(artifact -> {
                ZipEntry entry = new ZipEntry(artifact.get("path").asText());
                try {
                    zipOutputStream.putNextEntry(entry);
                    if (artifact.has("xml")) {
                        byte[] bytes = artifact.get("xml").asText().getBytes(StandardCharsets.UTF_8);
                        zipOutputStream.write(bytes, 0, bytes.length);
                    } else {
                        byte[] bytes = prettyWriter.writeValueAsString((Object)artifact.get("json")).getBytes(StandardCharsets.UTF_8);
                        zipOutputStream.write(bytes, 0, bytes.length);
                    }
                    zipOutputStream.closeEntry();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to download configuration files as a zip, cause: " + ex.getMessage(), ex);
                }
            });
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
        }
    }

    public void writeProjectFilesAsZip(HubClient hubClient, OutputStream outputStream) {
        HubProjectImpl hubProject = new HubProjectImpl();
        Path projectPath = null;
        try {
            projectPath = Files.createTempDirectory("", new FileAttribute[0]);
            hubProject.createProject(projectPath.toFile().getAbsolutePath());
            HubConfigImpl hubConfig = new HubConfigImpl(hubProject);
            Properties dbProperties = hubConfig.getHubPropertiesFromDb(hubClient.getStagingClient());
            hubConfig.applyProperties(dbProperties);
            hubConfig.initHubProject();
            this.writeHubCentralFilesToProject(hubProject, hubClient);
            this.writeDhsGradlePropertiesFile(hubProject);
            hubProject.exportProject(outputStream, Stream.of("gradle-local.properties", "gradle-dhs.properties").collect(Collectors.toList()));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to download project files as a zip, cause: " + ex.getMessage(), ex);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
            if (projectPath != null) {
                FileUtils.deleteQuietly((File)projectPath.toFile());
            }
        }
    }

    public void deployHubCentralConfig(HubClient hubClient, JsonNode config, String docUri) {
        JacksonHandle handle = new JacksonHandle().with(config);
        DocumentMetadataHandle documentMetadataHandle = new DocumentMetadataHandle().withPermission("data-hub-common", new DocumentMetadataHandle.Capability[]{DocumentMetadataHandle.Capability.READ}).withPermission("hub-central-entity-model-reader", new DocumentMetadataHandle.Capability[]{DocumentMetadataHandle.Capability.UPDATE}).withCollections(new String[]{"http://marklogic.com/hub-central/ui-config"});
        hubClient.getFinalClient().newJSONDocumentManager().write(docUri, (DocumentMetadataWriteHandle)documentMetadataHandle, (AbstractWriteHandle)handle);
        hubClient.getStagingClient().newJSONDocumentManager().write(docUri, (DocumentMetadataWriteHandle)documentMetadataHandle, (AbstractWriteHandle)handle);
    }

    public void deleteHubCentralConfig(HubClient hubClient) {
        hubClient.getFinalClient().newJSONDocumentManager().delete("/config/hubCentral.json");
        hubClient.getStagingClient().newJSONDocumentManager().delete("/config/hubCentral.json");
    }

    private void writeDhsGradlePropertiesFile(HubProjectImpl hubProject) {
        try (FileOutputStream outputStream = new FileOutputStream(hubProject.getProjectDir().resolve("gradle-dhs.properties").toFile());){
            Properties properties = new Properties();
            properties.setProperty("mlHost", "");
            properties.setProperty("mlUsername", "");
            properties.setProperty("mlPassword", "");
            properties.setProperty("hubDhs", "true");
            properties.store(outputStream, null);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write gradle-dhs.properties, cause: " + ex.getMessage(), ex);
        }
    }

    private void writeHubCentralFilesToProject(HubProject hubProject, HubClient hubClient) {
        ArrayNode artifacts = (ArrayNode)ArtifactService.on(hubClient.getStagingClient()).getArtifactsWithProjectPaths();
        File projectDir = hubProject.getProjectDir().toFile();
        ObjectWriter prettyWriter = this.buildPrettyWriter();
        artifacts.forEach(artifact -> {
            String path = artifact.get("path").asText();
            try {
                byte[] bytes = artifact.has("xml") ? artifact.get("xml").asText().getBytes(StandardCharsets.UTF_8) : prettyWriter.writeValueAsString((Object)artifact.get("json")).getBytes(StandardCharsets.UTF_8);
                File outputFile = new File(projectDir, path);
                File parentDirectory = outputFile.getParentFile();
                if (parentDirectory == null || !parentDirectory.mkdirs() && !parentDirectory.exists()) {
                    throw new RuntimeException("Unable to create parent directory at '" + parentDirectory.getAbsolutePath() + "' for zip file.");
                }
                try (FileOutputStream fileOut = new FileOutputStream(outputFile);){
                    FileCopyUtils.copy((byte[])bytes, (OutputStream)fileOut);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to download project files as a zip, cause: " + ex.getMessage(), ex);
            }
        });
    }

    public void applyHubCentralZipToProject(HubProject hubProject, File zipFile) {
        if (zipFile == null || !zipFile.exists()) {
            throw new RuntimeException("Unable to apply zip file to project, file does not exist: " + zipFile);
        }
        this.deleteUserArtifacts(hubProject);
        this.deleteEntityBasedArtifacts(hubProject);
        hubProject.init(new HashMap<String, String>());
        this.extractZipToProject(hubProject, zipFile);
    }

    protected void deleteUserArtifacts(HubProject hubProject) {
        Stream.of(hubProject.getFlowsDir(), hubProject.getHubEntitiesDir(), hubProject.getHubCentralConfigPath()).forEach(path -> this.deleteDirectory(path.toFile()));
        File stepsDir = hubProject.getStepsPath().toFile();
        if (stepsDir.exists() && stepsDir.isDirectory()) {
            this.deleteDirectory(new File(stepsDir, "ingestion"));
            this.deleteDirectory(new File(stepsDir, "mapping"));
        }
    }

    private void deleteDirectory(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            try {
                this.logger.info("Deleting directory: " + dir);
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to delete directory: " + dir + "; cause: " + ex.getMessage(), ex);
            }
        }
    }

    protected void deleteEntityBasedArtifacts(HubProject hubProject) {
        File entityConfigDir;
        File userConfigDir = hubProject.getUserConfigDir().toFile();
        if (userConfigDir.exists()) {
            File file;
            File qrDir;
            File[] files;
            ConfigDir configDir = new ConfigDir(userConfigDir);
            File ppDir = configDir.getProtectedPathsDir();
            if (ppDir.exists() && (files = ppDir.listFiles((dir, name) -> name.contains("pii-protected-paths.json"))) != null) {
                for (File file2 : files) {
                    this.logger.info("Deleting entity-based protected path file: " + file2.getAbsolutePath());
                    if (file2.delete()) continue;
                    this.logger.warn("Unable to delete entity-based protected path file: " + file2.getAbsolutePath());
                }
            }
            if ((qrDir = configDir.getQueryRolesetsDir()).exists() && (file = new File(qrDir, "pii-reader.json")).exists()) {
                this.logger.info("Deleting entity-based PII query roleset file: " + file.getAbsolutePath());
                file.delete();
            }
        }
        if ((entityConfigDir = hubProject.getEntityConfigDir().toFile()).exists()) {
            this.logger.info("Deleting entity-config directory: " + entityConfigDir.getAbsolutePath());
            try {
                FileUtils.deleteDirectory((File)entityConfigDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to delete entity-config directory at: " + entityConfigDir.getAbsolutePath() + "; cause: " + e.getMessage(), e);
            }
        }
    }

    protected void extractZipToProject(HubProject hubProject, File zipFile) {
        File projectDir = hubProject.getProjectDir().toFile();
        this.logger.info("Extracting zip file into project directory: " + projectDir.getAbsolutePath());
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                int entrySize = (int)entry.getSize();
                byte[] buffer = new byte[entrySize];
                File outputFile = new File(projectDir, entry.getName());
                outputFile.getParentFile().mkdirs();
                InputStream inputStream = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream fileOut = new FileOutputStream(outputFile);
                    Throwable throwable2 = null;
                    try {
                        if (inputStream.read(buffer, 0, entrySize) <= 0) continue;
                        this.logger.info("Writing file: " + outputFile);
                        FileCopyUtils.copy((byte[])buffer, (OutputStream)fileOut);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fileOut == null) continue;
                        if (throwable2 != null) {
                            try {
                                fileOut.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        fileOut.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error extracting project zip file.", ex);
        }
    }

    protected ObjectWriter buildPrettyWriter() {
        ObjectMapper prettyMapper = new ObjectMapper();
        prettyMapper.enable(SerializationFeature.INDENT_OUTPUT);
        return prettyMapper.writer((PrettyPrinter)new CustomPrettyPrinter());
    }

    class CustomPrettyPrinter
    extends DefaultPrettyPrinter {
        CustomPrettyPrinter() {
        }

        public DefaultPrettyPrinter withSeparators(Separators separators) {
            this._separators = separators;
            this._objectFieldValueSeparatorWithSpaces = ": ";
            return this;
        }

        public DefaultPrettyPrinter createInstance() {
            CustomPrettyPrinter printer = new CustomPrettyPrinter();
            printer.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
            return printer;
        }
    }
}

