/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.util;

import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.client.ext.helper.LoggingObject;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.core.io.Resource;

public class ModuleWatchingConsumer
extends LoggingObject
implements Consumer<Set<Resource>> {
    private CommandContext commandContext;
    private Command generateFunctionMetadataCommand;

    public ModuleWatchingConsumer(CommandContext commandContext, Command generateFunctionMetadataCommand) {
        this.commandContext = commandContext;
        this.generateFunctionMetadataCommand = generateFunctionMetadataCommand;
    }

    @Override
    public void accept(Set<Resource> resources) {
        if (this.shouldFunctionMetadataBeGenerated(resources)) {
            if (this.generateFunctionMetadataCommand == null || this.commandContext == null) {
                this.logger.warn("Unable to generate function metadata for modules containing mapping functions; no command or command context found");
            } else {
                try {
                    this.logger.info("Generating function metadata for modules containing mapping functions");
                    this.generateFunctionMetadataCommand.execute(this.commandContext);
                }
                catch (Exception ex) {
                    this.logger.error("Unable to generate function metadata, cause: " + ex.getMessage());
                }
            }
        }
    }

    protected boolean shouldFunctionMetadataBeGenerated(Set<Resource> resources) {
        if (resources != null && !resources.isEmpty()) {
            for (Resource r : resources) {
                try {
                    if (!r.getFile().getAbsolutePath().contains("mapping-functions")) continue;
                    return true;
                }
                catch (Exception ex) {
                    this.logger.warn("Unable to read resource: " + r + "; cause: " + ex.getMessage());
                }
            }
        }
        return false;
    }
}

