/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.file.CacheBusterDocumentFileProcessor;
import com.marklogic.client.ext.file.CollectionsDocumentFileProcessor;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.file.DocumentFileReader;
import com.marklogic.client.ext.file.JarDocumentFileReader;
import com.marklogic.client.ext.file.PermissionsDocumentFileProcessor;
import com.marklogic.client.ext.file.TokenReplacerDocumentFileProcessor;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.ModulesLoader;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import com.marklogic.client.ext.modulesloader.impl.AssetFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesFinder;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.client.ext.modulesloader.impl.PropertiesModuleManager;
import com.marklogic.client.ext.modulesloader.impl.SearchOptionsFinder;
import com.marklogic.client.ext.tokenreplacer.DefaultTokenReplacer;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.dataservices.SystemService;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoadHubModulesCommand
extends AbstractCommand {
    private static final String CUSTOM_REWRITER_URI = "/data-hub/5/rest-api/staging-rewriter.xml";
    @Autowired
    private HubConfig hubConfig;
    private Throwable caughtException;

    public LoadHubModulesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.LOAD_MODULES - 1);
    }

    public LoadHubModulesCommand(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandContext context) {
        DatabaseClient modulesClient = this.hubConfig.newModulesDbClient();
        ModulesLoader modulesLoader = this.newModulesLoader(context, modulesClient);
        boolean switchToDefaultRewriter = this.needToSwitchToDefaultRewriter();
        if (switchToDefaultRewriter) {
            this.switchSingleAppserverToDefaultRewriter();
        }
        try {
            if (this.caughtException == null) {
                this.logger.info("Loading DHF modules");
                modulesLoader.loadModules("classpath*:/ml-modules", (ModulesFinder)new DefaultModulesFinder(), modulesClient);
                this.createCustomRewriters();
                this.logger.info("Loading REST search options for staging server");
                modulesLoader.loadModules("classpath*:/ml-modules-staging", (ModulesFinder)new SearchOptionsFinder(), this.hubConfig.newStagingClient());
            }
        }
        finally {
            if (switchToDefaultRewriter) {
                this.switchSingleAppServerToCustomRewriter();
            }
        }
        if (this.caughtException == null) {
            this.loadJobsSearchOptions(modulesLoader);
        }
        if (this.caughtException != null) {
            throw new RuntimeException(this.caughtException);
        }
    }

    protected boolean needToSwitchToDefaultRewriter() {
        Integer stagingPort = this.hubConfig.getPort(DatabaseKind.STAGING);
        if (stagingPort != null && stagingPort.equals(this.hubConfig.getPort(DatabaseKind.FINAL))) {
            boolean exists;
            this.logger.info("Staging and final app servers use the same port, so checking to see if custom rewriter exists");
            DatabaseClient client = this.hubConfig.newAppServicesModulesClient();
            boolean bl = exists = client.newDocumentManager().exists(CUSTOM_REWRITER_URI) != null;
            if (!exists) {
                this.logger.info("Custom rewriter does not exist, so will switch app server to use the default rewriter so modules can be loaded");
                return true;
            }
            this.logger.info("Custom rewriter exists, so will not switch app server to use the default rewriter");
        }
        return false;
    }

    private void switchSingleAppserverToDefaultRewriter() {
        String uri = "/MarkLogic/rest-api/rewriter.xml";
        this.logger.info("Switching single appserver to use default rewriter: /MarkLogic/rest-api/rewriter.xml");
        this.updateStagingRewriter("/MarkLogic/rest-api/rewriter.xml");
    }

    private void switchSingleAppServerToCustomRewriter() {
        this.logger.info("Switching single appserver to use custom rewriter: /data-hub/5/rest-api/staging-rewriter.xml");
        this.updateStagingRewriter(CUSTOM_REWRITER_URI);
    }

    private void updateStagingRewriter(String rewriterUrl) {
        try {
            new ServerManager(this.hubConfig.getManageClient()).save(new ObjectMapper().createObjectNode().put("server-name", this.hubConfig.getHttpName(DatabaseKind.STAGING)).put("url-rewriter", rewriterUrl).toString());
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to update url-rewriter property on staging app server; please ensure you are using a user with privilege to do this, such as a user with the manage-admin or admin role; error: " + ex.getMessage(), ex);
        }
    }

    private void loadJobsSearchOptions(ModulesLoader modulesLoader) {
        this.logger.info("Loading REST search options for jobs server");
        DatabaseClient jobsClient = this.hubConfig.newJobDbClient();
        modulesLoader.loadModules("classpath*:/ml-modules-traces", (ModulesFinder)new SearchOptionsFinder(), jobsClient);
        if (this.caughtException == null) {
            modulesLoader.loadModules("classpath*:/ml-modules-jobs", (ModulesFinder)new SearchOptionsFinder(), jobsClient);
        }
    }

    private ModulesLoader newModulesLoader(CommandContext context, DatabaseClient client) {
        PropertiesModuleManager modulesManager = new PropertiesModuleManager(this.hubConfig.getAppConfig().getModuleTimestampsPath());
        AssetFileLoader assetFileLoader = new AssetFileLoader(client, (ModulesManager)modulesManager);
        this.prepareAssetFileLoader(assetFileLoader, context);
        DefaultModulesLoader modulesLoader = new DefaultModulesLoader(assetFileLoader);
        modulesLoader.setModulesManager((ModulesManager)modulesManager);
        modulesLoader.addFailureListener((throwable, dbClient) -> {
            if (this.caughtException == null) {
                this.caughtException = throwable;
            }
        });
        return modulesLoader;
    }

    protected void createCustomRewriters() {
        this.logger.info("Creating custom rewriters for staging and job app servers");
        SystemService.on(this.hubConfig.newFinalClient(null)).createCustomRewriters();
    }

    protected void prepareAssetFileLoader(AssetFileLoader loader, CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        Integer batchSize = appConfig.getModulesLoaderBatchSize();
        if (batchSize != null) {
            loader.setBatchSize(batchSize);
        } else {
            loader.setBatchSize(Integer.valueOf(1));
        }
        JarDocumentFileReader jarDocumentFileReader = new JarDocumentFileReader();
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new CacheBusterDocumentFileProcessor());
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new TokenReplacerDocumentFileProcessor(this.buildModuleTokenReplacer(appConfig)));
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new CollectionsDocumentFileProcessor(new String[]{"hub-core-module"}));
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new PermissionsDocumentFileProcessor(appConfig.getModulePermissions()));
        loader.setDocumentFileReader((DocumentFileReader)jarDocumentFileReader);
    }

    private TokenReplacer buildModuleTokenReplacer(AppConfig appConfig) {
        DefaultTokenReplacer r = new DefaultTokenReplacer();
        Map customTokens = appConfig.getCustomTokens();
        if (customTokens != null && !customTokens.isEmpty()) {
            r.addPropertiesSource(() -> {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)customTokens);
                return p;
            });
        }
        return r;
    }

    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }
}

