/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.JSONDocumentManager;
import com.marklogic.client.ext.util.DefaultDocumentPermissionsParser;
import com.marklogic.client.ext.util.DocumentPermissionsParser;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.hub.HubConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class LoadHubArtifactsCommand
extends AbstractCommand {
    public static final int SORT_ORDER = SortOrderConstants.DEPLOY_TRIGGERS + 10;
    @Autowired
    private HubConfig hubConfig;
    private DocumentPermissionsParser documentPermissionsParser = new DefaultDocumentPermissionsParser();

    public LoadHubArtifactsCommand() {
        this.setExecuteSortOrder(SORT_ORDER);
    }

    public LoadHubArtifactsCommand(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    public void execute(CommandContext context) {
        JSONDocumentManager finalDocMgr = this.hubConfig.newFinalClient().newJSONDocumentManager();
        JSONDocumentManager stagingDocMgr = this.hubConfig.newStagingClient().newJSONDocumentManager();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(((Object)((Object)this)).getClass().getClassLoader());
        HashMap<String, DocumentWriteOperationImpl> writeOps = new HashMap<String, DocumentWriteOperationImpl>();
        try {
            String uri;
            DocumentMetadataHandle meta;
            StringHandle handle;
            InputStream inputStream;
            File file;
            for (Resource r : resolver.getResources("classpath*:/hub-internal-artifacts/flows/**/*.flow.json")) {
                file = new File("hub-internal-artifacts/flows/" + r.getFilename());
                inputStream = r.getInputStream();
                handle = new StringHandle(IOUtils.toString((InputStream)inputStream));
                inputStream.close();
                meta = this.buildMetadata(this.hubConfig.getFlowPermissions(), "http://marklogic.com/data-hub/flow");
                uri = "/flows/" + file.getName();
                writeOps.put(uri, new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, (DocumentMetadataWriteHandle)meta, (AbstractWriteHandle)handle));
            }
            for (Resource r : resolver.getResources("classpath*:/hub-internal-artifacts/step-definitions/**/*.step.json")) {
                file = new File("hub-internal-artifacts/step-definitions/" + r.getURL().getPath().substring(r.getURL().getPath().indexOf("hub-internal-artifacts/step-definitions/")));
                inputStream = r.getInputStream();
                handle = new StringHandle(IOUtils.toString((InputStream)inputStream));
                inputStream.close();
                meta = this.buildMetadata(this.hubConfig.getStepDefinitionPermissions(), "http://marklogic.com/data-hub/step-definition");
                uri = "/step-definitions/" + file.getParentFile().getParentFile().getName() + "/" + file.getParentFile().getName() + "/" + file.getName();
                writeOps.put(uri, new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, (DocumentMetadataWriteHandle)meta, (AbstractWriteHandle)handle));
            }
            DocumentWriteSet stagingWriteSet = stagingDocMgr.newWriteSet();
            DocumentWriteSet finalWriteSet = finalDocMgr.newWriteSet();
            for (Map.Entry writeEntry : writeOps.entrySet()) {
                DocumentWriteOperation op = (DocumentWriteOperation)writeEntry.getValue();
                stagingWriteSet.add((Object)op);
                finalWriteSet.add((Object)op);
            }
            stagingDocMgr.write(stagingWriteSet);
            finalDocMgr.write(finalWriteSet);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to access hub artifacts: " + e.getMessage(), e);
        }
    }

    protected DocumentMetadataHandle buildMetadata(String permissions, String collection) {
        DocumentMetadataHandle meta = new DocumentMetadataHandle();
        meta.getCollections().add((Object)collection);
        meta.getCollections().add((Object)"hub-core-artifact");
        this.documentPermissionsParser.parsePermissions(permissions, meta.getPermissions());
        return meta;
    }

    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }
}

