/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.client.DatabaseClient;
import java.util.Optional;

class EntityServicesManager
extends com.marklogic.client.ext.es.EntityServicesManager {
    protected DatabaseClient client;
    private static final String ENTITY_FILE_EXTENSION = ".entity.json";

    public EntityServicesManager(DatabaseClient client) {
        super(client);
        this.client = client;
    }

    protected String generateCode(String modelUri, String functionName) {
        if ("extraction-template-generate".equals(functionName)) {
            String xquery = "import module namespace es = \"http://marklogic.com/entity-services\" at \"/MarkLogic/entity-services/entity-services.xqy\"; \nimport module namespace hent = \"http://marklogic.com/data-hub/hub-entities\" at \"/data-hub/5/impl/hub-entities.xqy\";\ndeclare variable $entity-title external; \nhent:dump-tde(json:to-array(es:model-validate(hent:get-model($entity-title))))";
            return this.client.newServerEval().xquery(xquery).addVariable("entity-title", EntityServicesManager.extractEntityNameFromURI(modelUri).get()).eval().next().getString();
        }
        return super.generateCode(modelUri, functionName);
    }

    public static Optional<String> extractEntityNameFromURI(String filename) {
        int index;
        if (filename == null || filename.trim().isEmpty()) {
            return Optional.of(null);
        }
        int pathIndex = filename.lastIndexOf("/");
        if (pathIndex >= 0) {
            filename = filename.substring(pathIndex + 1);
        }
        if ((index = filename.indexOf(ENTITY_FILE_EXTENSION)) < 0) {
            return Optional.of(null);
        }
        return Optional.of(filename.substring(0, index));
    }
}

