/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.rest.util.Fragment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;
import org.springframework.http.ResponseEntity;

public class DeployDatabaseFieldCommand
extends AbstractResourceCommand {
    private static final Namespace MANAGE_NS = Namespace.getNamespace((String)"http://marklogic.com/manage");

    public DeployDatabaseFieldCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_OTHER_DATABASES + 1);
    }

    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, configDir -> new File(configDir.getBaseDir(), "database-fields"));
    }

    protected ResourceManager getResourceManager(CommandContext commandContext) {
        return new HubDatabaseManager(commandContext.getManageClient());
    }

    protected String adjustPayloadBeforeSavingResource(CommandContext context, File f, String payload) {
        payload = super.adjustPayloadBeforeSavingResource(context, f, payload);
        return this.addExistingFieldsAndRangeFieldIndexes(payload, (ResourceManager)new DatabaseManager(context.getManageClient()));
    }

    public void undo(CommandContext context) {
        this.logger.info("No action required on undeploy, as the command for deleting databases on undeploy will also delete the fields and indexes created by this command.");
    }

    protected String addExistingFieldsAndRangeFieldIndexes(String payload, ResourceManager dbManager) {
        Fragment newProps = new Fragment(payload, new Namespace[0]);
        Fragment existingProps = dbManager.getPropertiesAsXml(newProps.getElementValue("/node()/m:database-name"), new String[0]);
        this.addExistingFields(newProps, existingProps);
        this.addExistingRangeFieldIndexes(newProps, existingProps);
        this.addExistingRangePathIndexes(newProps, existingProps);
        this.addExistingPathNamespaces(newProps, existingProps);
        return newProps.getPrettyXml();
    }

    protected void addExistingFields(Fragment newProps, Fragment existingProps) {
        Element newFields = newProps.getInternalDoc().getRootElement().getChild("fields", MANAGE_NS);
        if (newFields != null) {
            ArrayList newFieldNames = new ArrayList();
            newProps.getElements("/m:database-properties/m:fields/m:field").forEach(field -> {
                String name = field.getChildText("field-name", MANAGE_NS);
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    newFieldNames.add(name);
                }
            });
            for (Element field2 : existingProps.getElements("/m:database-properties/m:fields/m:field")) {
                String name = field2.getChildText("field-name", MANAGE_NS);
                if (!StringUtils.isNotBlank((CharSequence)name) || newFieldNames.contains(name)) continue;
                newFields.addContent((Content)field2.detach());
            }
        }
    }

    protected void addExistingRangeFieldIndexes(Fragment newProps, Fragment existingProps) {
        Element newRangeFieldIndexes = newProps.getInternalDoc().getRootElement().getChild("range-field-indexes", MANAGE_NS);
        if (newRangeFieldIndexes != null) {
            ArrayList newIndexFieldNames = new ArrayList();
            newProps.getElements("/m:database-properties/m:range-field-indexes/m:range-field-index").forEach(index -> {
                String name = index.getChildText("field-name", MANAGE_NS);
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    newIndexFieldNames.add(name);
                }
            });
            for (Element index2 : existingProps.getElements("/m:database-properties/m:range-field-indexes/m:range-field-index")) {
                String name = index2.getChildText("field-name", MANAGE_NS);
                if (!StringUtils.isNotBlank((CharSequence)name) || newIndexFieldNames.contains(name)) continue;
                newRangeFieldIndexes.addContent((Content)index2.detach());
            }
        }
    }

    protected void addExistingRangePathIndexes(Fragment newProps, Fragment existingProps) {
        Element newRangePathIndexes = newProps.getInternalDoc().getRootElement().getChild("range-path-indexes", MANAGE_NS);
        if (newRangePathIndexes != null) {
            ArrayList newIndexPathExpressions = new ArrayList();
            newProps.getElements("/m:database-properties/m:range-path-indexes/m:range-path-index").forEach(index -> {
                String pathExpression = index.getChildText("path-expression", MANAGE_NS);
                if (StringUtils.isNotBlank((CharSequence)pathExpression)) {
                    newIndexPathExpressions.add(pathExpression);
                }
            });
            for (Element index2 : existingProps.getElements("/m:database-properties/m:range-path-indexes/m:range-path-index")) {
                String pathExpression = index2.getChildText("path-expression", MANAGE_NS);
                if (!StringUtils.isNotBlank((CharSequence)pathExpression) || newIndexPathExpressions.contains(pathExpression)) continue;
                newRangePathIndexes.addContent((Content)index2.detach());
            }
        }
    }

    protected void addExistingPathNamespaces(Fragment newProps, Fragment existingProps) {
        Element newNamespaces = newProps.getInternalDoc().getRootElement().getChild("path-namespaces", MANAGE_NS);
        if (newNamespaces != null) {
            ArrayList newNamespacePrefixes = new ArrayList();
            newProps.getElements("/m:database-properties/m:path-namespaces/m:path-namespace").forEach(namespace -> newNamespacePrefixes.add(namespace.getChildText("prefix", MANAGE_NS)));
            for (Element namespace2 : existingProps.getElements("/m:database-properties/m:path-namespaces/m:path-namespace")) {
                String prefix = namespace2.getChildText("prefix", MANAGE_NS);
                if (newNamespacePrefixes.contains(prefix)) continue;
                newNamespaces.addContent((Content)namespace2.detach());
            }
        }
    }

    public static class HubDatabaseManager
    extends DatabaseManager {
        public HubDatabaseManager(ManageClient manageClient) {
            super(manageClient);
        }

        protected String getResourceName() {
            return "database";
        }

        protected ResponseEntity<String> putPayload(ManageClient client, String path, String payload) {
            if (!this.payloadParser.isJsonPayload(payload)) {
                payload = this.removeDatabaseNameFromXmlPayload(payload);
            }
            return super.putPayload(client, path, payload);
        }

        protected String removeDatabaseNameFromXmlPayload(String payload) {
            Fragment frag = new Fragment(payload, new Namespace[0]);
            List elements = frag.getElements("/node()/m:database-name");
            if (elements != null) {
                elements.forEach(el -> el.detach());
            }
            return new XMLOutputter().outputString(frag.getInternalDoc());
        }
    }
}

