/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.HubConfig;

public class CheckSecurityConfiguration
extends LoggingObject
implements Command {
    private HubConfig hubConfig;
    private static final String dataHubDeveloperRole = "data-hub-developer";
    private static final String dataHubOperatorRole = "data-hub-operator";

    public CheckSecurityConfiguration(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public void execute(CommandContext context) {
        if (dataHubDeveloperRole.equals(this.hubConfig.getFlowDeveloperRoleName())) {
            throw new RuntimeException("mlFlowDeveloperRole setting conflicts with core 'data-hub-developer' role. \nChange mlFlowDeveloperRole to a different value or consider removing src/main/hub-internal-config/security/roles/flow-developer-role.json in favor of using data-hub-developer.");
        }
        if (dataHubOperatorRole.equals(this.hubConfig.getFlowOperatorRoleName())) {
            throw new RuntimeException("mlFlowOperatorRole setting conflicts with core 'data-hub-operator' role. \nChange mlFlowDeveloperRole to a different value or consider removing src/main/hub-internal-config/security/roles/flow-operator-role.json in favor of using data-hub-operator.");
        }
    }

    public Integer getExecuteSortOrder() {
        return SortOrderConstants.DEPLOY_ROLES - 1;
    }
}

