/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.io.Reader;
import java.util.stream.Stream;

public interface EntitySearchService {
    public static EntitySearchService on(DatabaseClient db) {
        return EntitySearchService.on(db, null);
    }

    public static EntitySearchService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class EntitySearchServiceImpl
        implements EntitySearchService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_getMinAndMaxPropertyValues;
            private BaseProxy.DBFunctionRequest req_getSavedQuery;
            private BaseProxy.DBFunctionRequest req_deleteSavedQuery;
            private BaseProxy.DBFunctionRequest req_saveSavedQuery;
            private BaseProxy.DBFunctionRequest req_getSavedQueries;
            private BaseProxy.DBFunctionRequest req_exportSearchAsCSV;
            private BaseProxy.DBFunctionRequest req_getSemanticConceptInfo;
            private BaseProxy.DBFunctionRequest req_getModelRelationships;
            private BaseProxy.DBFunctionRequest req_getRecord;
            private BaseProxy.DBFunctionRequest req_getMatchingPropertyValues;

            EntitySearchServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/5/data-services/entitySearch/", servDecl);
                this.req_getMinAndMaxPropertyValues = this.baseProxy.request("getMinAndMaxPropertyValues.sjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_getSavedQuery = this.baseProxy.request("getSavedQuery.sjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_deleteSavedQuery = this.baseProxy.request("deleteSavedQuery.sjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_saveSavedQuery = this.baseProxy.request("saveSavedQuery.sjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_getSavedQueries = this.baseProxy.request("getSavedQueries.sjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_exportSearchAsCSV = this.baseProxy.request("exportSearchAsCSV.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_getSemanticConceptInfo = this.baseProxy.request("getSemanticConceptInfo.sjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_getModelRelationships = this.baseProxy.request("getModelRelationships.sjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_getRecord = this.baseProxy.request("getRecord.sjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_getMatchingPropertyValues = this.baseProxy.request("getMatchingPropertyValues.sjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
            }

            @Override
            public JsonNode getMinAndMaxPropertyValues(JsonNode facetRangeSearchQuery) {
                return this.getMinAndMaxPropertyValues(this.req_getMinAndMaxPropertyValues.on(this.dbClient), facetRangeSearchQuery);
            }

            private JsonNode getMinAndMaxPropertyValues(BaseProxy.DBFunctionRequest request, JsonNode facetRangeSearchQuery) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"facetRangeSearchQuery", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)facetRangeSearchQuery))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getSavedQuery(String id) {
                return this.getSavedQuery(this.req_getSavedQuery.on(this.dbClient), id);
            }

            private JsonNode getSavedQuery(BaseProxy.DBFunctionRequest request, String id) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"id", (boolean)false, (String)BaseProxy.StringType.fromString((String)id))}).responseSingle(false, Format.JSON));
            }

            @Override
            public void deleteSavedQuery(String id) {
                this.deleteSavedQuery(this.req_deleteSavedQuery.on(this.dbClient), id);
            }

            private void deleteSavedQuery(BaseProxy.DBFunctionRequest request, String id) {
                request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"id", (boolean)false, (String)BaseProxy.StringType.fromString((String)id))}).responseNone();
            }

            @Override
            public JsonNode saveSavedQuery(JsonNode saveQuery) {
                return this.saveSavedQuery(this.req_saveSavedQuery.on(this.dbClient), saveQuery);
            }

            private JsonNode saveSavedQuery(BaseProxy.DBFunctionRequest request, JsonNode saveQuery) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"saveQuery", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)saveQuery))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getSavedQueries() {
                return this.getSavedQueries(this.req_getSavedQueries.on(this.dbClient));
            }

            private JsonNode getSavedQueries(BaseProxy.DBFunctionRequest request) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.responseSingle(false, Format.JSON));
            }

            @Override
            public Reader exportSearchAsCSV(String structuredQuery, String searchText, String queryOptions, String schemaName, String viewName, Long limit, ArrayNode sortOrder, Stream<String> columns) {
                return this.exportSearchAsCSV(this.req_exportSearchAsCSV.on(this.dbClient), structuredQuery, searchText, queryOptions, schemaName, viewName, limit, sortOrder, columns);
            }

            private Reader exportSearchAsCSV(BaseProxy.DBFunctionRequest request, String structuredQuery, String searchText, String queryOptions, String schemaName, String viewName, Long limit, ArrayNode sortOrder, Stream<String> columns) {
                return BaseProxy.TextDocumentType.toReader((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"structuredQuery", (boolean)false, (String)BaseProxy.StringType.fromString((String)structuredQuery)), BaseProxy.atomicParam((String)"searchText", (boolean)true, (String)BaseProxy.StringType.fromString((String)searchText)), BaseProxy.atomicParam((String)"queryOptions", (boolean)false, (String)BaseProxy.StringType.fromString((String)queryOptions)), BaseProxy.atomicParam((String)"schemaName", (boolean)false, (String)BaseProxy.StringType.fromString((String)schemaName)), BaseProxy.atomicParam((String)"viewName", (boolean)false, (String)BaseProxy.StringType.fromString((String)viewName)), BaseProxy.atomicParam((String)"limit", (boolean)true, (String)BaseProxy.LongType.fromLong((Long)limit)), BaseProxy.documentParam((String)"sortOrder", (boolean)false, (BufferableContentHandle)BaseProxy.ArrayType.fromArrayNode((ArrayNode)sortOrder)), BaseProxy.atomicParam((String)"columns", (boolean)false, (Stream)BaseProxy.StringType.fromString(columns))}).responseSingle(false, Format.TEXT));
            }

            @Override
            public JsonNode getSemanticConceptInfo(String semanticConceptIRI) {
                return this.getSemanticConceptInfo(this.req_getSemanticConceptInfo.on(this.dbClient), semanticConceptIRI);
            }

            private JsonNode getSemanticConceptInfo(BaseProxy.DBFunctionRequest request, String semanticConceptIRI) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"semanticConceptIRI", (boolean)false, (String)BaseProxy.StringType.fromString((String)semanticConceptIRI))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getModelRelationships() {
                return this.getModelRelationships(this.req_getModelRelationships.on(this.dbClient));
            }

            private JsonNode getModelRelationships(BaseProxy.DBFunctionRequest request) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getRecord(String docUri) {
                return this.getRecord(this.req_getRecord.on(this.dbClient), docUri);
            }

            private JsonNode getRecord(BaseProxy.DBFunctionRequest request, String docUri) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"docUri", (boolean)false, (String)BaseProxy.StringType.fromString((String)docUri))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getMatchingPropertyValues(JsonNode facetValuesSearchQuery) {
                return this.getMatchingPropertyValues(this.req_getMatchingPropertyValues.on(this.dbClient), facetValuesSearchQuery);
            }

            private JsonNode getMatchingPropertyValues(BaseProxy.DBFunctionRequest request, JsonNode facetValuesSearchQuery) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"facetValuesSearchQuery", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)facetValuesSearchQuery))}).responseSingle(false, Format.JSON));
            }
        }
        return new EntitySearchServiceImpl(db, serviceDeclaration);
    }

    public JsonNode getMinAndMaxPropertyValues(JsonNode var1);

    public JsonNode getSavedQuery(String var1);

    public void deleteSavedQuery(String var1);

    public JsonNode saveSavedQuery(JsonNode var1);

    public JsonNode getSavedQueries();

    public Reader exportSearchAsCSV(String var1, String var2, String var3, String var4, String var5, Long var6, ArrayNode var7, Stream<String> var8);

    public JsonNode getSemanticConceptInfo(String var1);

    public JsonNode getModelRelationships();

    public JsonNode getRecord(String var1);

    public JsonNode getMatchingPropertyValues(JsonNode var1);
}

