/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.helper.FilenameUtil;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.io.Format;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class CacheBusterDocumentFileProcessor
extends LoggingObject
implements DocumentFileProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        Resource resource;
        if (documentFile.getFormat() == Format.BINARY) {
            return documentFile;
        }
        String text = documentFile.getModifiedContent();
        if (text == null && (resource = documentFile.getResource()) != null) {
            InputStream inputStream = null;
            try {
                inputStream = resource.getInputStream();
                text = new String(FileCopyUtils.copyToByteArray((InputStream)inputStream), StandardCharsets.UTF_8);
            }
            catch (IOException ie) {
                this.logger.warn("Unable to replace tokens in file: " + documentFile.getUri() + "; cause: " + ie.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        if (text != null) {
            resource = documentFile.getResource();
            String comment = "";
            if (FilenameUtil.isJavascriptFile((String)resource.getFilename())) {
                comment = "// cache buster: " + UUID.randomUUID().toString() + "\n";
            } else if (FilenameUtil.isXqueryFile((String)resource.getFilename())) {
                comment = "(: cache buster: " + UUID.randomUUID().toString() + " :)\n";
            }
            text = comment + text;
            documentFile.setModifiedContent(text);
        }
        return documentFile;
    }
}

