/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Base64;

public interface VectorUtil {
    public static String base64Encode(float ... vector) {
        int dimensions = vector.length;
        ByteBuffer buffer = ByteBuffer.allocate(8 + 4 * dimensions);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(0);
        buffer.putInt(dimensions);
        for (float v : vector) {
            buffer.putFloat(v);
        }
        return Base64.getEncoder().encodeToString(buffer.array());
    }

    public static float[] base64Decode(String encodedVector) {
        ByteBuffer buffer = ByteBuffer.wrap(Base64.getDecoder().decode(encodedVector));
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int version = buffer.getInt();
        if (version != 0) {
            throw new IllegalArgumentException("Unsupported vector version: " + version);
        }
        int dimensions = buffer.getInt();
        float[] vector = new float[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            vector[i] = buffer.getFloat();
        }
        return vector;
    }
}

