/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.row;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.expression.PlanBuilder;
import com.marklogic.client.row.RowManager;
import com.marklogic.client.row.RowRecord;
import com.marklogic.client.row.RowSet;
import java.io.IOException;
import java.util.function.Function;

public class RowTemplate {
    private final DatabaseClient databaseClient;

    public RowTemplate(DatabaseClient client) {
        this.databaseClient = client;
    }

    public <T> T query(Function<PlanBuilder, PlanBuilder.Plan> planFunction, Function<RowSet<RowRecord>, T> rowSetConsumer) {
        RowManager rowManager = this.databaseClient.newRowManager();
        PlanBuilder.Plan plan = planFunction.apply(rowManager.newPlanBuilder());
        return this.resultRows(rowManager, plan, rowSetConsumer);
    }

    public void update(Function<PlanBuilder, PlanBuilder.Plan> planFunction) {
        this.update(planFunction, null);
    }

    public <T> T update(Function<PlanBuilder, PlanBuilder.Plan> planFunction, Function<RowSet<RowRecord>, T> rowSetConsumer) {
        RowManager rowManager = this.databaseClient.newRowManager().withUpdate(true);
        PlanBuilder.Plan plan = planFunction.apply(rowManager.newPlanBuilder());
        if (rowSetConsumer == null) {
            rowManager.execute(plan);
            return null;
        }
        return this.resultRows(rowManager, plan, rowSetConsumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T resultRows(RowManager rowManager, PlanBuilder.Plan plan, Function<RowSet<RowRecord>, T> rowSetConsumer) {
        try (RowSet<RowRecord> rows = rowManager.resultRows(plan);){
            RowSet<RowRecord> rowSet = rowSetConsumer.apply(rows);
            return (T)rowSet;
        }
        catch (IOException ex) {
            throw new MarkLogicIOException(String.format("Unable to close row set; cause: %s", ex.getMessage()), ex);
        }
    }
}

