/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.impl.XmlFactories;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.StreamingContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class InputSourceHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
StreamingContentHandle<InputSource, InputStream>,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(InputSourceHandle.class);
    private EntityResolver resolver;
    private ErrorHandler errorHandler;
    private Schema defaultWriteSchema;
    private SAXParserFactory factory;
    private InputSource content;
    private InputStream underlyingStream;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{InputSource.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return InputSource.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                InputSourceHandle handle = this.isHandled(type) ? new InputSourceHandle() : null;
                return handle;
            }
        };
    }

    public InputSourceHandle() {
        super.setFormat(Format.XML);
        this.setResendable(false);
    }

    public InputSourceHandle(InputSource content) {
        this();
        this.set(content);
    }

    public EntityResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public InputSource get() {
        return this.content;
    }

    @Override
    public void set(InputSource content) {
        this.content = content;
    }

    public InputSourceHandle with(InputSource content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<InputSource> getContentClass() {
        return InputSource.class;
    }

    @Override
    public InputSourceHandle newHandle() {
        return new InputSourceHandle().withMimetype(this.getMimetype());
    }

    public InputSourceHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new InputSourceHandle[length];
    }

    public InputSource[] newArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new InputSource[length];
    }

    public void process(ContentHandler handler) {
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Processing input source with SAX content handler");
            }
            XMLReader reader = this.makeReader(false);
            reader.setContentHandler(handler);
            reader.parse(this.content);
        }
        catch (SAXException e) {
            logger.error("Failed to process input source with SAX content handler", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (IOException e) {
            logger.error("Failed to process input source with SAX content handler", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("InputSourceHandle supports the XML format only");
        }
    }

    public InputSourceHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            byte[] b = buffer.toByteArray();
            this.fromBuffer(b);
            return b;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public InputSource toContent(InputStream serialization) {
        return serialization == null ? null : new InputSource(new InputStreamReader(serialization, StandardCharsets.UTF_8));
    }

    @Override
    public InputSource bytesToContent(byte[] buffer) {
        return buffer == null || buffer.length == 0 ? null : this.toContent(new ByteArrayInputStream(buffer));
    }

    @Override
    public byte[] contentToBytes(InputSource content) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.sendContent(content).write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException("Could not convert InputSource to byte[] array", e);
        }
    }

    public String toString() {
        byte[] buffer = this.toBuffer();
        return buffer == null ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    public SAXParserFactory getFactory() throws SAXException, ParserConfigurationException {
        if (this.factory == null) {
            this.factory = this.makeSAXParserFactory();
        }
        return this.factory;
    }

    public void setFactory(SAXParserFactory factory) {
        this.factory = factory;
    }

    protected SAXParserFactory makeSAXParserFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtds", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        factory.setXIncludeAware(false);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        return factory;
    }

    public Schema getDefaultWriteSchema() {
        return this.defaultWriteSchema;
    }

    public void setDefaultWriteSchema(Schema schema) {
        this.defaultWriteSchema = schema;
    }

    protected XMLReader makeReader(boolean isForWrite) {
        try {
            boolean useDefaultSchema;
            SAXParserFactory factory = this.getFactory();
            if (factory == null) {
                throw new MarkLogicInternalException("Failed to make SAX parser factory");
            }
            boolean bl = useDefaultSchema = isForWrite && this.defaultWriteSchema != null && factory.getSchema() == null;
            if (useDefaultSchema) {
                factory.setSchema(this.defaultWriteSchema);
            }
            XMLReader reader = factory.newSAXParser().getXMLReader();
            try {
                reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtds", false);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
            try {
                reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
            try {
                reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
            if (useDefaultSchema) {
                factory.setSchema(null);
            }
            if (this.resolver != null) {
                reader.setEntityResolver(this.resolver);
            }
            if (this.errorHandler != null) {
                reader.setErrorHandler(this.errorHandler);
            }
            return reader;
        }
        catch (SAXException e) {
            logger.error("Failed to process input source with SAX content handler", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Failed to process input source with SAX content handler", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            this.content = null;
            return;
        }
        this.underlyingStream = content;
        this.content = new InputSource(new InputStreamReader(content, StandardCharsets.UTF_8));
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No input source to write");
        }
        return this;
    }

    protected OutputStreamSender sendContent(InputSource content) {
        return content == null ? null : new OutputStreamSenderImpl(this.makeTransformerFactory(), this.makeReader(true), content);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        try {
            this.makeTransformerFactory().newTransformer().transform(new SAXSource(this.makeReader(true), this.content), new StreamResult(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
        }
        catch (TransformerException e) {
            logger.error("Failed to transform input source into result", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
    }

    private TransformerFactory makeTransformerFactory() {
        return XmlFactories.makeNewTransformerFactory();
    }

    @Override
    public void close() {
        if (this.underlyingStream != null) {
            try {
                this.underlyingStream.close();
            }
            catch (IOException e) {
                logger.error("Failed to close underlying InputStream", (Throwable)e);
                throw new MarkLogicIOException(e);
            }
        }
    }

    private static class OutputStreamSenderImpl
    implements OutputStreamSender {
        private final TransformerFactory transformerFactory;
        private final XMLReader xmlReader;
        private final InputSource content;

        private OutputStreamSenderImpl(TransformerFactory transformerFactory, XMLReader xmlReader, InputSource content) {
            this.transformerFactory = transformerFactory;
            this.xmlReader = xmlReader;
            this.content = content;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            try {
                this.transformerFactory.newTransformer().transform(new SAXSource(this.xmlReader, this.content), new StreamResult(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
            }
            catch (TransformerException e) {
                logger.error("Failed to transform input source into result", (Throwable)e);
                throw new MarkLogicIOException(e);
            }
        }
    }

    public static class DraconianErrorHandler
    implements ErrorHandler {
        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }
    }
}

