/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl.okhttp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.ProgressDataCloudException;
import com.marklogic.client.impl.okhttp.AuthenticationConfigurer;
import com.marklogic.client.impl.okhttp.OkHttpUtil;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProgressDataCloudAuthenticationConfigurer
implements AuthenticationConfigurer<DatabaseClientFactory.ProgressDataCloudAuthContext> {
    private final String host;

    ProgressDataCloudAuthenticationConfigurer(String host) {
        this.host = host;
    }

    @Override
    public void configureAuthentication(OkHttpClient.Builder clientBuilder, DatabaseClientFactory.ProgressDataCloudAuthContext securityContext) {
        String apiKey = securityContext.getApiKey();
        if (apiKey == null || apiKey.trim().length() < 1) {
            throw new IllegalArgumentException("No API key provided");
        }
        DefaultTokenGenerator tokenGenerator = new DefaultTokenGenerator(this.host, securityContext);
        clientBuilder.addInterceptor((Interceptor)new TokenAuthenticationInterceptor(tokenGenerator));
    }

    static class TokenAuthenticationInterceptor
    implements Interceptor {
        private static final Logger logger = LoggerFactory.getLogger(TokenAuthenticationInterceptor.class);
        private final TokenGenerator tokenGenerator;
        private String token;

        public TokenAuthenticationInterceptor(TokenGenerator tokenGenerator) {
            this.tokenGenerator = tokenGenerator;
            this.token = tokenGenerator.generateToken();
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request.Builder builder = chain.request().newBuilder();
            this.addTokenToRequest(builder);
            Response response = chain.proceed(builder.build());
            if (response.code() == 401) {
                logger.info("Received 401; will generate new token if necessary and retry request");
                response.close();
                String currentToken = this.token;
                this.generateNewTokenIfNecessary(currentToken);
                builder = chain.request().newBuilder();
                this.addTokenToRequest(builder);
                response = chain.proceed(builder.build());
            }
            return response;
        }

        private synchronized void generateNewTokenIfNecessary(String currentToken) {
            if (currentToken.equals(this.token)) {
                logger.info("Generating new token based on receiving 401");
                this.token = this.tokenGenerator.generateToken();
            } else if (logger.isDebugEnabled()) {
                logger.debug("This instance's token has already been updated, presumably by another thread");
            }
        }

        private synchronized Request.Builder addTokenToRequest(Request.Builder builder) {
            return builder.header("Authorization", String.format("Bearer %s", this.token));
        }
    }

    static class DefaultTokenGenerator
    implements TokenGenerator {
        private static final Logger logger = LoggerFactory.getLogger(DefaultTokenGenerator.class);
        private final String host;
        private final DatabaseClientFactory.ProgressDataCloudAuthContext securityContext;

        public DefaultTokenGenerator(String host, DatabaseClientFactory.ProgressDataCloudAuthContext securityContext) {
            this.host = host;
            this.securityContext = securityContext;
        }

        @Override
        public String generateToken() {
            Response tokenResponse = this.callTokenEndpoint();
            String token = this.getAccessTokenFromResponse(tokenResponse);
            if (logger.isInfoEnabled()) {
                logger.info("Successfully obtained authentication token");
            }
            return token;
        }

        private Response callTokenEndpoint() {
            HttpUrl tokenUrl = this.buildTokenUrl();
            OkHttpClient.Builder clientBuilder = OkHttpUtil.newClientBuilder();
            OkHttpUtil.configureSocketFactory(clientBuilder, this.securityContext.getSSLContext(), this.securityContext.getTrustManager());
            OkHttpUtil.configureHostnameVerifier(clientBuilder, this.securityContext.getSSLHostnameVerifier());
            if (logger.isInfoEnabled()) {
                logger.info("Calling token endpoint at: " + tokenUrl);
            }
            Call call = clientBuilder.build().newCall(new Request.Builder().url(tokenUrl).post((RequestBody)this.newFormBody()).build());
            try {
                return call.execute();
            }
            catch (IOException e) {
                throw new ProgressDataCloudException(String.format("Unable to call token endpoint at %s; cause: %s", tokenUrl, e.getMessage(), e));
            }
        }

        protected HttpUrl buildTokenUrl() {
            HttpUrl.Builder builder = new HttpUrl.Builder().scheme("https").host(this.host).port(443).build().resolve(this.securityContext.getTokenEndpoint()).newBuilder();
            Integer duration = this.securityContext.getTokenDuration();
            return duration != null ? builder.addQueryParameter("duration", duration.toString()).build() : builder.build();
        }

        protected FormBody newFormBody() {
            return new FormBody.Builder().add("grant_type", this.securityContext.getGrantType()).add("key", this.securityContext.getApiKey()).build();
        }

        private String getAccessTokenFromResponse(Response response) {
            JsonNode payload;
            String responseBody = null;
            try {
                responseBody = response.body().string();
                payload = new ObjectMapper().readTree(responseBody);
            }
            catch (IOException ex) {
                throw new ProgressDataCloudException("Unable to get access token; response: " + responseBody, ex);
            }
            if (!payload.has("access_token")) {
                throw new ProgressDataCloudException("Unable to get access token; unexpected JSON response: " + payload);
            }
            return payload.get("access_token").asText();
        }
    }

    public static interface TokenGenerator {
        public String generateToken();
    }
}

