/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import java.lang.ref.SoftReference;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlFactories {
    private static final Logger logger = LoggerFactory.getLogger(XmlFactories.class);
    private static final CachedInstancePerThreadSupplier<XMLOutputFactory> cachedOutputFactory = new CachedInstancePerThreadSupplier<XMLOutputFactory>(new Supplier<XMLOutputFactory>(){

        @Override
        public XMLOutputFactory get() {
            return XmlFactories.makeNewOutputFactory();
        }
    });

    private XmlFactories() {
    }

    public static XMLOutputFactory makeNewOutputFactory() {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        return factory;
    }

    public static XMLInputFactory makeNewInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        return factory;
    }

    public static TransformerFactory makeNewTransformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            logger.warn("Unable to set {} on TransformerFactory; cause: {}", (Object)"http://javax.xml.XMLConstants/feature/secure-processing", (Object)e.getMessage());
        }
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to set {} on TransformerFactory; cause: {}", (Object)"http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)e.getMessage());
        }
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to set {} on TransformerFactory; cause: {}", (Object)"http://javax.xml.XMLConstants/property/accessExternalStylesheet", (Object)e.getMessage());
        }
        return factory;
    }

    public static XMLOutputFactory getOutputFactory() {
        return cachedOutputFactory.get();
    }

    private static class CachedInstancePerThreadSupplier<T>
    implements Supplier<T> {
        private final ThreadLocal<SoftReference<T>> cachedInstances = new ThreadLocal();
        private final Supplier<T> delegate;

        CachedInstancePerThreadSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
            if (null == delegate) {
                throw new IllegalArgumentException("Delegate must not be null");
            }
        }

        @Override
        public T get() {
            Object cachedInstance;
            SoftReference<T> cachedInstanceReference = this.cachedInstances.get();
            Object t = cachedInstance = null != cachedInstanceReference ? (Object)cachedInstanceReference.get() : null;
            if (null == cachedInstance) {
                cachedInstance = this.delegate.get();
                if (null == cachedInstance) {
                    throw new IllegalStateException("Must not return null from " + this.delegate.getClass().getName() + "::get() (" + this.delegate + ")");
                }
                this.cachedInstances.set(new SoftReference<Object>(cachedInstance));
            }
            return cachedInstance;
        }
    }

    static interface Supplier<T> {
        public T get();
    }
}

