/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.XmlFactories;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public final class Utilities {
    private static DatatypeFactory datatypeFactory;
    private static final int BUFFER_SIZE = 8192;

    public static List<XMLEvent> importFromHandle(AbstractWriteHandle writeHandle) {
        if (writeHandle == null) {
            return null;
        }
        HandleImplementation baseHandle = HandleAccessor.checkHandle(writeHandle, "import");
        return Utilities.objectToEvents(baseHandle.sendContent());
    }

    public static List<XMLEvent> objectToEvents(Object content) {
        if (content == null) {
            return null;
        }
        if (content instanceof byte[]) {
            return Utilities.bytesToEvents((byte[])content);
        }
        if (content instanceof File) {
            return Utilities.fileToEvents((File)content);
        }
        if (content instanceof InputStream) {
            return Utilities.inputStreamToEvents((InputStream)content);
        }
        if (content instanceof Reader) {
            return Utilities.readerToEvents((Reader)content);
        }
        if (content instanceof String) {
            return Utilities.stringToEvents((String)content);
        }
        if (content instanceof OutputStreamSender) {
            return Utilities.outputSenderToEvents((OutputStreamSender)content);
        }
        throw new IllegalArgumentException("Unrecognized class for import: " + content.getClass().getName());
    }

    public static List<XMLEvent> bytesToEvents(byte[] bytes) {
        return Utilities.readerToEvents(Utilities.readBytes(bytes));
    }

    public static List<XMLEvent> fileToEvents(File file) {
        return Utilities.readerToEvents(Utilities.readFile(file));
    }

    public static List<XMLEvent> inputStreamToEvents(InputStream stream) {
        return Utilities.readerToEvents(Utilities.readInputStream(stream));
    }

    public static List<XMLEvent> outputSenderToEvents(OutputStreamSender sender) {
        return Utilities.readerToEvents(Utilities.readOutputSender(sender));
    }

    public static List<XMLEvent> readerToEvents(Reader reader) {
        return Utilities.readerToEvents(Utilities.readReader(reader));
    }

    public static List<XMLEvent> stringToEvents(String string) {
        return Utilities.readerToEvents(Utilities.readString(string));
    }

    static XMLEventReader readBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return Utilities.readInputStream(new ByteArrayInputStream(bytes));
    }

    static XMLEventReader readFile(File file) {
        try {
            if (file == null) {
                return null;
            }
            return Utilities.readInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new MarkLogicIOException(e);
        }
    }

    static XMLEventReader readInputStream(InputStream stream) {
        try {
            if (stream == null) {
                return null;
            }
            return Utilities.makeInputFactory().createXMLEventReader(stream);
        }
        catch (XMLStreamException e) {
            throw new MarkLogicIOException(e);
        }
    }

    static XMLEventReader readOutputSender(OutputStreamSender sender) {
        try {
            if (sender == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            sender.write(baos);
            return Utilities.readBytes(baos.toByteArray());
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    static XMLEventReader readReader(Reader reader) {
        try {
            if (reader == null) {
                return null;
            }
            return Utilities.makeInputFactory().createXMLEventReader(reader);
        }
        catch (XMLStreamException e) {
            throw new MarkLogicIOException(e);
        }
    }

    static XMLEventReader readString(String string) {
        if (string == null) {
            return null;
        }
        return Utilities.readReader(new StringReader(string));
    }

    static XMLInputFactory makeInputFactory() {
        XMLInputFactory factory = XmlFactories.makeNewInputFactory();
        factory.setProperty("javax.xml.stream.isNamespaceAware", true);
        factory.setProperty("javax.xml.stream.isValidating", false);
        return factory;
    }

    public static List<XMLEvent> readerToEvents(XMLEventReader reader) {
        try {
            if (reader == null) {
                return null;
            }
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            block5: while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 7: 
                    case 8: {
                        continue block5;
                    }
                }
                events.add(event);
            }
            if (events.isEmpty()) {
                return null;
            }
            return events;
        }
        catch (XMLStreamException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public static <T extends AbstractReadHandle> T exportToHandle(List<XMLEvent> events, T handle) {
        if (handle == null) {
            return null;
        }
        HandleImplementation baseHandle = HandleAccessor.checkHandle(handle, "export");
        baseHandle.receiveContent(Utilities.eventsToObject(events, baseHandle.receiveAs()));
        return handle;
    }

    public static Object eventsToObject(List<XMLEvent> events, Class<?> as) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        if (byte[].class.isAssignableFrom(as)) {
            return Utilities.eventsToBytes(events);
        }
        if (File.class.isAssignableFrom(as)) {
            return Utilities.eventsToFile(events, ".xml");
        }
        if (InputStream.class.isAssignableFrom(as)) {
            return Utilities.eventsToInputStream(events);
        }
        if (Reader.class.isAssignableFrom(as)) {
            return Utilities.eventsToReader(events);
        }
        if (String.class.isAssignableFrom(as)) {
            return Utilities.eventsToString(events);
        }
        throw new IllegalArgumentException("Unrecognized class for export: " + as.getName());
    }

    public static byte[] eventsToBytes(List<XMLEvent> events) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!Utilities.writeEvents(events, baos)) {
            return null;
        }
        return baos.toByteArray();
    }

    public static File eventsToFile(List<XMLEvent> events, String extension) {
        try {
            File tempFile = File.createTempFile("tmp", extension);
            if (!Utilities.writeEvents(events, new FileOutputStream(tempFile))) {
                if (tempFile.exists()) {
                    tempFile.delete();
                }
                return null;
            }
            return tempFile;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public static InputStream eventsToInputStream(List<XMLEvent> events) {
        byte[] bytes = Utilities.eventsToBytes(events);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public static Reader eventsToReader(List<XMLEvent> events) {
        String string = Utilities.eventsToString(events);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public static String eventsToString(List<XMLEvent> events) {
        byte[] bytes = Utilities.eventsToBytes(events);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static boolean writeEvents(List<XMLEvent> events, OutputStream out) {
        if (events == null || events.isEmpty()) {
            return false;
        }
        try {
            XMLOutputFactory factory = XmlFactories.getOutputFactory();
            XMLEventWriter eventWriter = factory.createXMLEventWriter(out, "UTF-8");
            for (XMLEvent event : events) {
                eventWriter.add(event);
            }
            eventWriter.flush();
            eventWriter.close();
            return true;
        }
        catch (XMLStreamException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public static String eventTextToString(List<XMLEvent> events) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (XMLEvent event : events) {
            if (!event.isCharacters()) continue;
            buf.append(event.asCharacters().getData());
        }
        return buf.toString();
    }

    public static void setHandleContent(ContentHandle handle, Object content) {
        if (handle == null) {
            return;
        }
        handle.set(content);
    }

    public static void setHandleStructuredFormat(ContentHandle handle, Format format) {
        if (handle == null || format == null) {
            return;
        }
        if (BaseHandle.class.isAssignableFrom(handle.getClass())) {
            Utilities.setHandleStructuredFormat((BaseHandle)((Object)handle), format);
        }
    }

    private static void setHandleStructuredFormat(BaseHandle handle, Format format) {
        if (format != Format.JSON && format != Format.XML) {
            throw new IllegalArgumentException("Received " + format.name() + " format instead of JSON or XML");
        }
        handle.setFormat(format);
    }

    public static DatatypeFactory getDatatypeFactory() {
        if (datatypeFactory == null) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new MarkLogicInternalException(e);
            }
        }
        return datatypeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream in, OutputStream outStream) throws IOException {
        if (in == null || outStream == null) {
            return;
        }
        try {
            int byteCount;
            byte[] byteArray = new byte[16384];
            while ((byteCount = in.read(byteArray)) != -1) {
                outStream.write(byteArray, 0, byteCount);
            }
            outStream.flush();
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Reader in, Writer out) throws IOException {
        if (in == null || out == null) {
            return;
        }
        try {
            int charCount;
            char[] charArray = new char[16384];
            while ((charCount = in.read(charArray)) != -1) {
                out.write(charArray, 0, charCount);
            }
            out.flush();
        }
        finally {
            in.close();
        }
    }

    public static void write(Reader in, OutputStream out) throws IOException {
        Utilities.write(in, new OutputStreamWriter(out));
    }

    static String escapeMultipartParamAssignment(CharsetEncoder asciiEncoder, String value) {
        String assignment;
        if (value == null) {
            return null;
        }
        if (asciiEncoder.canEncode(value)) {
            assignment = "=\"" + value.replace("\"", "\\\"").replace("\\", "\\\\") + "\"";
        } else {
            try {
                assignment = "*=UTF-8''" + URLEncoder.encode(value, "UTF-8");
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Uri cannot be encoded as UFT-8: " + value, ex);
            }
        }
        asciiEncoder.reset();
        return assignment;
    }

    public static double parseDouble(String value) {
        return Utilities.parseDouble(value, -1.0);
    }

    public static double parseDouble(String value, double defaultValue) {
        return value == null || value.isEmpty() ? defaultValue : Double.parseDouble(value);
    }

    public static int parseInt(String value) {
        return Utilities.parseInt(value, -1);
    }

    public static int parseInt(String value, int defaultValue) {
        return value == null || value.isEmpty() ? defaultValue : Integer.parseInt(value);
    }

    public static long parseLong(String value) {
        return Utilities.parseLong(value, -1L);
    }

    public static long parseLong(String value, long defaultValue) {
        return value == null || value.isEmpty() ? defaultValue : Long.parseLong(value);
    }

    public static void setHandleToString(AbstractReadHandle handle, String content) {
        if (!(handle instanceof BaseHandle)) {
            throw new IllegalArgumentException("cannot export with handle that doesn't extend base");
        }
        BaseHandle baseHandle = (BaseHandle)((Object)handle);
        Class as = baseHandle.receiveAs();
        if (InputStream.class.isAssignableFrom(as)) {
            baseHandle.receiveContent(new ByteArrayInputStream(content.getBytes()));
        } else if (Reader.class.isAssignableFrom(as)) {
            baseHandle.receiveContent(new StringReader(content));
        } else if (byte[].class.isAssignableFrom(as)) {
            baseHandle.receiveContent(content.getBytes());
        } else if (String.class.isAssignableFrom(as)) {
            baseHandle.receiveContent(content);
        } else {
            throw new IllegalArgumentException("cannot export with handle that doesn't accept content as byte[], input stream, reader, or string");
        }
    }
}

