/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.OutputStreamTee;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.util.RequestLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

class StreamingOutputImpl
extends RequestBody {
    private OutputStreamSender handle;
    private RequestLogger logger;
    private MediaType contentType;

    StreamingOutputImpl(OutputStreamSender handle, RequestLogger logger, MediaType contentType) {
        this.handle = handle;
        this.logger = logger;
        this.contentType = contentType;
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        OutputStream out = sink.outputStream();
        if (this.logger != null) {
            PrintStream tee = this.logger.getPrintStream();
            long max = this.logger.getContentMax();
            if (tee != null && max > 0L) {
                this.handle.write(new OutputStreamTee(out, tee, max));
                return;
            }
        }
        this.handle.write(out);
    }
}

