/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.MarkLogicBindingException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.Transaction;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.expression.PlanBuilder;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.BaseTypeImpl;
import com.marklogic.client.impl.ContentParam;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.impl.PlanBuilderBaseImpl;
import com.marklogic.client.impl.PlanBuilderSubImpl;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.RowsParamsBuilder;
import com.marklogic.client.impl.XsValueImpl;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.XMLStreamReaderHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.row.RawPlan;
import com.marklogic.client.row.RawPlanDefinition;
import com.marklogic.client.row.RawQueryDSLPlan;
import com.marklogic.client.row.RawSPARQLSelectPlan;
import com.marklogic.client.row.RawSQLPlan;
import com.marklogic.client.row.RowManager;
import com.marklogic.client.row.RowRecord;
import com.marklogic.client.row.RowSet;
import com.marklogic.client.type.PlanExprCol;
import com.marklogic.client.type.PlanParamBindingVal;
import com.marklogic.client.type.PlanParamExpr;
import com.marklogic.client.type.XsAnyAtomicTypeVal;
import com.marklogic.client.util.RequestParameters;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RowManagerImpl
extends AbstractLoggingManager
implements RowManager {
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;
    private RowManager.RowSetPart datatypeStyle = null;
    private RowManager.RowStructure rowStructureStyle = null;
    private Integer optimize;
    private String traceLabel;
    private boolean update;

    public RowManagerImpl(RESTServices services) {
        this.services = services;
    }

    DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    @Override
    public PlanBuilder newPlanBuilder() {
        PlanBuilderSubImpl planBuilder = new PlanBuilderSubImpl();
        planBuilder.setHandleRegistry(this.handleRegistry);
        return planBuilder;
    }

    @Override
    public RowManager.RowSetPart getDatatypeStyle() {
        if (this.datatypeStyle == null) {
            return RowManager.RowSetPart.ROWS;
        }
        return this.datatypeStyle;
    }

    @Override
    public void setDatatypeStyle(RowManager.RowSetPart style) {
        this.datatypeStyle = style;
    }

    @Override
    public RowManager.RowStructure getRowStructureStyle() {
        if (this.rowStructureStyle == null) {
            return RowManager.RowStructure.OBJECT;
        }
        return this.rowStructureStyle;
    }

    @Override
    public void setRowStructureStyle(RowManager.RowStructure style) {
        this.rowStructureStyle = style;
    }

    @Override
    public String getTraceLabel() {
        return this.traceLabel;
    }

    @Override
    public void setTraceLabel(String label) {
        this.traceLabel = label;
    }

    @Override
    public Integer getOptimize() {
        return this.optimize;
    }

    @Override
    public void setOptimize(Integer value) {
        this.optimize = value;
    }

    @Override
    public RowManager withUpdate(boolean update) {
        this.update = update;
        return this;
    }

    @Override
    public RawPlanDefinition newRawPlanDefinition(JSONWriteHandle handle) {
        return new RawPlanDefinitionImpl(handle);
    }

    @Override
    public RawQueryDSLPlan newRawQueryDSLPlan(TextWriteHandle handle) {
        return new RawQueryDSLPlanImpl(handle);
    }

    @Override
    public RawSQLPlanImpl newRawSQLPlan(TextWriteHandle handle) {
        return new RawSQLPlanImpl(handle);
    }

    @Override
    public RawSPARQLSelectPlanImpl newRawSPARQLSelectPlan(TextWriteHandle handle) {
        return new RawSPARQLSelectPlanImpl(handle);
    }

    private RowsParamsBuilder newRowsParamsBuilder(PlanBuilderBaseImpl.RequestPlan plan) {
        return new RowsParamsBuilder(plan).withOptimize(this.optimize).withTraceLabel(this.traceLabel);
    }

    @Override
    public <T> T resultDocAs(PlanBuilder.Plan plan, Class<T> as) {
        return this.resultDocAs(plan, as, null);
    }

    @Override
    public <T> T resultDocAs(PlanBuilder.Plan plan, Class<T> as, Transaction transaction) {
        ContentHandle<T> handle = this.handleFor(as);
        if (this.resultDoc(plan, (StructureReadHandle)((Object)handle), transaction) == null) {
            return null;
        }
        return handle.get();
    }

    @Override
    public <T extends StructureReadHandle> T resultDoc(PlanBuilder.Plan plan, T resultsHandle) {
        return this.resultDoc(plan, resultsHandle, null);
    }

    @Override
    public <T extends StructureReadHandle> T resultDoc(PlanBuilder.Plan plan, T resultsHandle, Transaction transaction) {
        if (resultsHandle == null) {
            throw new IllegalArgumentException("Must specify a handle to read the row result document");
        }
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        AbstractWriteHandle astHandle = requestPlan.getHandle();
        RequestParameters params = this.newRowsParamsBuilder(requestPlan).withColumnTypes(this.getDatatypeStyle()).withOutput(this.getRowStructureStyle()).getRequestParameters();
        return this.services.postResource(this.requestLogger, this.determinePath(), transaction, params, astHandle, resultsHandle);
    }

    private String determinePath() {
        return this.update ? "rows/update" : "rows";
    }

    @Override
    public RowSet<RowRecord> resultRows(PlanBuilder.Plan plan) {
        return this.resultRows(plan, (StructureReadHandle)null);
    }

    @Override
    public RowSet<RowRecord> resultRows(PlanBuilder.Plan plan, Transaction transaction) {
        RowManager.RowSetPart datatypeStyle = this.getDatatypeStyle();
        RowManager.RowStructure rowStructureStyle = this.getRowStructureStyle();
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        RequestParameters params = this.newRowsParamsBuilder(requestPlan).withRowFormat("json").withNodeColumns("reference").withColumnTypes(datatypeStyle).withOutput(rowStructureStyle).getRequestParameters();
        RESTServices.RESTServiceResultIterator iter = this.submitPlan(requestPlan, params, transaction);
        RowSetRecord rowset = new RowSetRecord("json", datatypeStyle, rowStructureStyle, iter, this.handleRegistry);
        rowset.init();
        return rowset;
    }

    @Override
    public void execute(PlanBuilder.Plan plan) {
        this.execute(plan, null);
    }

    @Override
    public void execute(PlanBuilder.Plan plan, Transaction transaction) {
        RequestParameters params;
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        RESTServices.RESTServiceResultIterator iter = this.submitPlan(requestPlan, params = this.newRowsParamsBuilder(requestPlan).getRequestParameters(), transaction);
        if (iter != null) {
            iter.close();
        }
    }

    @Override
    public <T extends StructureReadHandle> RowSet<T> resultRows(PlanBuilder.Plan plan, T rowHandle) {
        return this.resultRows(plan, rowHandle, null);
    }

    @Override
    public <T extends StructureReadHandle> RowSet<T> resultRows(PlanBuilder.Plan plan, T rowHandle, Transaction transaction) {
        RowManager.RowSetPart datatypeStyle = this.getDatatypeStyle();
        RowManager.RowStructure rowStructureStyle = this.getRowStructureStyle();
        String rowFormat = this.getRowFormat(rowHandle);
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        RowsParamsBuilder rowsParamsBuilder = this.newRowsParamsBuilder(requestPlan).withRowFormat(rowFormat).withNodeColumns("inline").withColumnTypes(datatypeStyle).withOutput(rowStructureStyle);
        if (rowHandle instanceof BaseHandle) {
            rowsParamsBuilder.withTimestamp(((BaseHandle)((Object)rowHandle)).getPointInTimeQueryTimestamp());
        }
        RequestParameters params = rowsParamsBuilder.getRequestParameters();
        RESTServices.RESTServiceResultIterator iter = this.submitPlan(requestPlan, params, transaction);
        RowSetHandle<T> rowset = new RowSetHandle<T>(rowFormat, datatypeStyle, rowStructureStyle, iter, rowHandle);
        rowset.init();
        return rowset;
    }

    @Override
    public <T> RowSet<T> resultRowsAs(PlanBuilder.Plan plan, Class<T> as) {
        return this.resultRowsAs(plan, as, null);
    }

    @Override
    public <T> RowSet<T> resultRowsAs(PlanBuilder.Plan plan, Class<T> as, Transaction transaction) {
        ContentHandle<T> rowHandle = this.handleFor(as);
        String rowFormat = this.getRowFormat(rowHandle);
        RowManager.RowSetPart datatypeStyle = this.getDatatypeStyle();
        RowManager.RowStructure rowStructureStyle = this.getRowStructureStyle();
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        RequestParameters params = this.newRowsParamsBuilder(requestPlan).withRowFormat(rowFormat).withNodeColumns("inline").withColumnTypes(datatypeStyle).withOutput(rowStructureStyle).getRequestParameters();
        RESTServices.RESTServiceResultIterator iter = this.submitPlan(requestPlan, params, transaction);
        RowSetObject<T> rowset = new RowSetObject<T>(rowFormat, datatypeStyle, rowStructureStyle, iter, rowHandle);
        rowset.init();
        return rowset;
    }

    @Override
    public <T extends StructureReadHandle> T explain(PlanBuilder.Plan plan, T resultsHandle) {
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        AbstractWriteHandle astHandle = requestPlan.getHandle();
        if (resultsHandle == null) {
            throw new IllegalArgumentException("Must specify a handle to read the explanation for the plan");
        }
        RequestParameters params = new RequestParameters();
        params.add("output", "explain");
        return this.services.postResource(this.requestLogger, this.determinePath(), null, params, astHandle, resultsHandle);
    }

    @Override
    public <T> T explainAs(PlanBuilder.Plan plan, Class<T> as) {
        ContentHandle<T> handle = this.handleFor(as);
        if (this.explain(plan, (StructureReadHandle)((Object)handle)) == null) {
            return null;
        }
        return handle.get();
    }

    @Override
    public <T extends XMLReadHandle> T generateView(PlanBuilder.PreparePlan plan, String schema, String view, T resultsHandle) {
        if (resultsHandle == null) {
            throw new IllegalArgumentException("Must specify a handle to generate a view for the plan");
        }
        if (schema == null || schema.length() == 0) {
            throw new IllegalArgumentException("Must specify a schema name to generate a view for the plan");
        }
        if (view == null || view.length() == 0) {
            throw new IllegalArgumentException("Must specify a view name to generate a view for the plan");
        }
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        AbstractWriteHandle astHandle = requestPlan.getHandle();
        RequestParameters params = new RequestParameters();
        params.add("output", "generateView");
        params.add("schemaName", "schema");
        params.add("viewName", "view");
        return this.services.postResource(this.requestLogger, "rows", null, params, astHandle, resultsHandle);
    }

    @Override
    public <T> T generateViewAs(PlanBuilder.PreparePlan plan, String schema, String view, Class<T> as) {
        ContentHandle<T> handle = this.handleFor(as);
        if (this.generateView(plan, schema, view, (XMLReadHandle)((Object)handle)) == null) {
            return null;
        }
        return handle.get();
    }

    @Override
    public <T extends JSONReadHandle> T columnInfo(PlanBuilder.Plan plan, T resultsHandle) {
        if (resultsHandle == null) {
            throw new IllegalArgumentException("Must specify a handle to generate a view for the plan");
        }
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        AbstractWriteHandle astHandle = requestPlan.getHandle();
        RequestParameters params = new RequestParameters();
        params.add("output", "columnInfo");
        return this.services.postResource(this.requestLogger, "rows", null, params, astHandle, resultsHandle);
    }

    @Override
    public <T> T columnInfoAs(PlanBuilder.Plan plan, Class<T> as) {
        ContentHandle<T> handle = this.handleFor(as);
        if (!(handle instanceof JSONReadHandle)) {
            throw new IllegalArgumentException("The handle is not an instance of JSONReadHandle.");
        }
        if (this.columnInfo(plan, (JSONReadHandle)((Object)handle)) == null) {
            return null;
        }
        return handle.get();
    }

    @Override
    public <T extends JSONReadHandle> T graphql(JSONWriteHandle query, T resultsHandle) {
        if (resultsHandle == null) {
            throw new IllegalArgumentException("Must specify a handle for the results of the GraphQL query");
        }
        RequestParameters params = new RequestParameters();
        HandleAccessor.checkHandle(query, "write").setMimetype("application/graphql");
        return this.services.postResource(this.requestLogger, "rows/graphql", null, params, query, resultsHandle);
    }

    @Override
    public <T> T graphqlAs(JSONWriteHandle query, Class<T> as) {
        ContentHandle<T> handle = this.handleFor(as);
        if (!(handle instanceof JSONReadHandle)) {
            throw new IllegalArgumentException("The handle is not an instance of JSONReadHandle.");
        }
        if (this.graphql(query, (JSONReadHandle)((Object)handle)) == null) {
            return null;
        }
        return handle.get();
    }

    private <T extends AbstractReadHandle> String getRowFormat(T rowHandle) {
        if (rowHandle == null) {
            throw new IllegalArgumentException("Must specify a handle to iterate over the rows");
        }
        if (!(rowHandle instanceof BaseHandle)) {
            throw new IllegalArgumentException("Cannot iterate rows with invalid handle having class " + rowHandle.getClass().getName());
        }
        BaseHandle baseHandle = (BaseHandle)((Object)rowHandle);
        Format handleFormat = baseHandle.getFormat();
        switch (handleFormat) {
            case JSON: 
            case UNKNOWN: {
                return "json";
            }
            case XML: {
                return "xml";
            }
        }
        throw new IllegalArgumentException("Must use JSON or XML format to iterate rows instead of " + handleFormat.name());
    }

    private RESTServices.RESTServiceResultIterator submitPlan(PlanBuilderBaseImpl.RequestPlan requestPlan, RequestParameters params, Transaction transaction) {
        AbstractWriteHandle astHandle = requestPlan.getHandle();
        List<ContentParam> contentParams = requestPlan.getContentParams();
        String path = this.determinePath();
        try {
            if (contentParams != null && !contentParams.isEmpty()) {
                contentParams.add(new ContentParam(new PlanBuilderBaseImpl.PlanParamBase("query"), astHandle, null));
                return this.services.postMultipartForm(this.requestLogger, path, transaction, params, contentParams);
            }
            return this.services.postIteratedResource(this.requestLogger, path, transaction, params, astHandle);
        }
        catch (FailedRequestException ex) {
            String message = ex.getMessage();
            if (message != null && message.contains("RESTAPI-UPDATEFROMQUERY")) {
                String betterMessage = "The Optic plan is attempting an update but was sent to the wrong REST API endpoint. You must invoke `withUpdate(true)` on the instance of com.marklogic.client.row.RowManager that you are using to submit the plan";
                throw new FailedRequestException(betterMessage, ex.getFailedRequest());
            }
            throw ex;
        }
    }

    private PlanBuilderBaseImpl.RequestPlan checkPlan(PlanBuilder.Plan plan) {
        if (plan == null) {
            throw new IllegalArgumentException("Must specify a plan to produce row results");
        }
        if (!(plan instanceof PlanBuilderBaseImpl.RequestPlan)) {
            throw new IllegalArgumentException("Cannot produce rows with invalid plan having class " + plan.getClass().getName());
        }
        return (PlanBuilderBaseImpl.RequestPlan)((Object)plan);
    }

    <T> ContentHandle<T> handleFor(Class<T> as) {
        if (as == null) {
            throw new IllegalArgumentException("Must specify a class for content with a registered handle");
        }
        ContentHandle<T> handle = this.handleRegistry.makeHandle(as);
        if (!(handle instanceof StructureReadHandle)) {
            if (handle == null) {
                throw new IllegalArgumentException("Class \"" + as.getName() + "\" has no registered handle");
            }
            throw new IllegalArgumentException("Class \"" + as.getName() + "\" uses handle " + handle.getClass().getName() + " which is not a StructureReadHandle");
        }
        return handle;
    }

    static class RawPlanDefinitionImpl
    extends RawPlanImpl<JSONWriteHandle>
    implements RawPlanDefinition {
        RawPlanDefinitionImpl(JSONWriteHandle handle) {
            super(handle, null);
        }

        private RawPlanDefinitionImpl(JSONWriteHandle handle, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params, List<ContentParam> contentParams) {
            super(handle, params, contentParams, null);
        }

        RawPlanDefinitionImpl parameterize(JSONWriteHandle handle, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params, List<ContentParam> contentParams) {
            return new RawPlanDefinitionImpl(handle, params, contentParams);
        }

        @Override
        void configHandle(BaseHandle handle) {
            handle.setFormat(Format.JSON);
            handle.setMimetype("application/json");
        }

        @Override
        public RawPlanDefinition withHandle(JSONWriteHandle handle) {
            this.setHandle(handle);
            return this;
        }
    }

    static class RawQueryDSLPlanImpl
    extends RawPlanImpl<TextWriteHandle>
    implements RawQueryDSLPlan {
        RawQueryDSLPlanImpl(TextWriteHandle handle) {
            super(handle, null);
        }

        RawQueryDSLPlanImpl(TextWriteHandle handle, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params, List<ContentParam> contentParams) {
            super(handle, params, contentParams, null);
        }

        RawQueryDSLPlanImpl parameterize(TextWriteHandle handle, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params, List<ContentParam> contentParams) {
            return new RawQueryDSLPlanImpl(handle, params, contentParams);
        }

        @Override
        void configHandle(BaseHandle handle) {
            handle.setFormat(Format.TEXT);
            handle.setMimetype("application/vnd.marklogic.querydsl+javascript");
        }

        @Override
        public RawQueryDSLPlan withHandle(TextWriteHandle handle) {
            this.setHandle(handle);
            return this;
        }
    }

    static class RawSPARQLSelectPlanImpl
    extends RawPlanImpl<TextWriteHandle>
    implements RawSPARQLSelectPlan {
        RawSPARQLSelectPlanImpl(TextWriteHandle handle) {
            super(handle, null);
        }

        RawSPARQLSelectPlanImpl(TextWriteHandle handle, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params, List<ContentParam> contentParams) {
            super(handle, params, contentParams, null);
        }

        RawSPARQLSelectPlanImpl parameterize(TextWriteHandle handle, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params, List<ContentParam> contentParams) {
            return new RawSPARQLSelectPlanImpl(handle, params, contentParams);
        }

        @Override
        void configHandle(BaseHandle handle) {
            handle.setFormat(Format.TEXT);
            handle.setMimetype("application/sparql-query");
        }

        @Override
        public RawSPARQLSelectPlan withHandle(TextWriteHandle handle) {
            this.setHandle(handle);
            return this;
        }
    }

    static class RawSQLPlanImpl
    extends RawPlanImpl<TextWriteHandle>
    implements RawSQLPlan {
        RawSQLPlanImpl(TextWriteHandle handle) {
            super(handle, null);
        }

        RawSQLPlanImpl(TextWriteHandle handle, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params, List<ContentParam> contentParams) {
            super(handle, params, contentParams, null);
        }

        RawSQLPlanImpl parameterize(TextWriteHandle handle, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params, List<ContentParam> contentParams) {
            return new RawSQLPlanImpl(handle, params, contentParams);
        }

        @Override
        void configHandle(BaseHandle handle) {
            handle.setFormat(Format.TEXT);
            handle.setMimetype("application/sql");
        }

        @Override
        public RawSQLPlan withHandle(TextWriteHandle handle) {
            this.setHandle(handle);
            return this;
        }
    }

    static abstract class RawPlanImpl<W extends AbstractWriteHandle>
    implements RawPlan,
    PlanBuilderBaseImpl.RequestPlan {
        private Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params = null;
        private List<ContentParam> contentParams;
        private W handle;

        private RawPlanImpl(W handle) {
            this.setHandle(handle);
        }

        private RawPlanImpl(W handle, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params, List<ContentParam> contentParams) {
            this(handle);
            this.params = params;
            this.contentParams = contentParams;
        }

        abstract RawPlanImpl<W> parameterize(W var1, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> var2, List<ContentParam> var3);

        abstract void configHandle(BaseHandle var1);

        public W getHandle() {
            return this.handle;
        }

        public void setHandle(W handle) {
            if (handle == null) {
                throw new IllegalArgumentException("Must specify handle for reading raw plan");
            }
            if (!(handle instanceof BaseHandle)) {
                throw new IllegalArgumentException("Cannot provide raw plan with invalid handle having class " + handle.getClass().getName());
            }
            this.configHandle((BaseHandle)handle);
            this.handle = handle;
        }

        @Override
        public Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> getParams() {
            return this.params;
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, boolean literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, boolean literal) {
            return this.bindParam(param, new XsValueImpl.BooleanValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, byte literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, byte literal) {
            return this.bindParam(param, new XsValueImpl.ByteValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, double literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, double literal) {
            return this.bindParam(param, new XsValueImpl.DoubleValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, float literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, float literal) {
            return this.bindParam(param, new XsValueImpl.FloatValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, int literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, int literal) {
            return this.bindParam(param, new XsValueImpl.IntValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, long literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, long literal) {
            return this.bindParam(param, new XsValueImpl.LongValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, short literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, short literal) {
            return this.bindParam(param, new XsValueImpl.ShortValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, String literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, String literal) {
            return this.bindParam(param, new XsValueImpl.StringValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, PlanParamBindingVal literal) {
            if (!(param instanceof PlanBuilderBaseImpl.PlanParamBase)) {
                throw new IllegalArgumentException("cannot set parameter that doesn't extend base");
            }
            if (!(literal instanceof XsValueImpl.AnyAtomicTypeValImpl)) {
                throw new IllegalArgumentException("cannot set value with unknown implementation");
            }
            HashMap<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> nextParams = new HashMap<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder>();
            if (this.params != null) {
                nextParams.putAll(this.params);
            }
            nextParams.put((PlanBuilderBaseImpl.PlanParamBase)param, (XsValueImpl.AnyAtomicTypeValImpl)((Object)literal));
            return this.parameterize(this.getHandle(), nextParams, this.contentParams);
        }

        @Override
        public PlanBuilder.Plan bindParam(String param, DocumentWriteSet writeSet) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(param), writeSet);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, DocumentWriteSet writeSet) {
            if (!(param instanceof PlanBuilderBaseImpl.PlanParamBase)) {
                throw new IllegalArgumentException("param must be an instance of PlanParamBase");
            }
            ArrayList<ContentParam> nextContentParams = new ArrayList<ContentParam>();
            if (this.contentParams != null) {
                nextContentParams.addAll(this.contentParams);
            }
            nextContentParams.add(ContentParam.fromDocumentWriteSet((PlanBuilderBaseImpl.PlanParamBase)param, writeSet));
            return this.parameterize(this.getHandle(), this.params, nextContentParams);
        }

        @Override
        public PlanBuilder.Plan bindParam(String param, AbstractWriteHandle content) {
            return this.bindParam(new PlanBuilderBaseImpl.PlanParamBase(param), content, null);
        }

        @Override
        public PlanBuilder.Plan bindParam(String param, AbstractWriteHandle content, Map<String, Map<String, AbstractWriteHandle>> columnAttachments) {
            return this.bindParam(new PlanBuilderBaseImpl.PlanParamBase(param), content, columnAttachments);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, AbstractWriteHandle content, Map<String, Map<String, AbstractWriteHandle>> columnAttachments) {
            if (!(param instanceof PlanBuilderBaseImpl.PlanParamBase)) {
                throw new IllegalArgumentException("param must be an instance of PlanParamBase");
            }
            PlanBuilderBaseImpl.PlanParamBase baseParam = (PlanBuilderBaseImpl.PlanParamBase)param;
            ArrayList<ContentParam> nextContentParams = new ArrayList<ContentParam>();
            if (this.contentParams != null) {
                nextContentParams.addAll(this.contentParams);
            }
            nextContentParams.add(new ContentParam(baseParam, content, columnAttachments));
            return this.parameterize(this.getHandle(), this.params, nextContentParams);
        }

        @Override
        public List<ContentParam> getContentParams() {
            return this.contentParams;
        }

        /* synthetic */ RawPlanImpl(AbstractWriteHandle x0, 1 x1) {
            this(x0);
        }

        /* synthetic */ RawPlanImpl(AbstractWriteHandle x0, Map x1, List x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    static class RowRecordImpl
    implements RowRecord {
        private static final Map<Class<? extends XsAnyAtomicTypeVal>, Function<String, ? extends XsAnyAtomicTypeVal>> factories = new HashMap<Class<? extends XsAnyAtomicTypeVal>, Function<String, ? extends XsAnyAtomicTypeVal>>();
        private static final Map<Class<? extends XsAnyAtomicTypeVal>, Constructor<?>> constructors = new HashMap();
        private Map<String, RowRecord.ColumnKind> kinds = null;
        private Map<String, String> datatypes = null;
        private Map<String, Object> row = null;
        private Map<String, Object> aliasedRow = null;
        private RowSetRecord set = null;

        RowRecordImpl(RowSetRecord set) {
            this.set = set;
        }

        void init(Map<String, RowRecord.ColumnKind> kinds, Map<String, String> datatypes, Map<String, Object> row) {
            this.kinds = kinds;
            this.datatypes = datatypes;
            this.row = row;
        }

        @Override
        public RowRecord.ColumnKind getKind(PlanExprCol col) {
            return this.getKind(this.getNameForColumn(col));
        }

        @Override
        public RowRecord.ColumnKind getKind(String columnName) {
            if (columnName == null) {
                throw new IllegalArgumentException("cannot get column kind with null name");
            }
            RowRecord.ColumnKind kind = this.kinds.get(columnName);
            if (kind != null) {
                return kind;
            }
            if (this.kinds.containsKey(columnName)) {
                return RowRecord.ColumnKind.NULL;
            }
            if (this.set.hasAlias(this.kinds, columnName)) {
                return this.kinds.get(columnName);
            }
            throw new IllegalArgumentException("no kind for column: " + columnName);
        }

        @Override
        public String getDatatype(PlanExprCol col) {
            return this.getDatatype(this.getNameForColumn(col));
        }

        @Override
        public String getDatatype(String columnName) {
            if (columnName == null) {
                throw new IllegalArgumentException("cannot get column datatype with null name");
            }
            String datatype = this.datatypes.get(columnName);
            if (datatype != null) {
                return datatype;
            }
            if (this.datatypes.containsKey(columnName)) {
                return null;
            }
            if (this.set.hasAlias(this.datatypes, columnName)) {
                return this.datatypes.get(columnName);
            }
            throw new IllegalArgumentException("no datatype for column: " + columnName);
        }

        @Override
        public boolean containsKey(Object key) {
            if (this.aliasedRow == null) {
                boolean isContained = this.row.containsKey(key);
                if (isContained) {
                    return isContained;
                }
                this.aliasedRow = new HashMap<String, Object>(this.row);
            }
            return this.set.hasAlias(this.aliasedRow, key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.row.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.row.entrySet();
        }

        @Override
        public Object get(Object key) {
            if (key == null) {
                throw new IllegalArgumentException("cannot get column value with null name");
            }
            Map<String, Object> valueRow = this.aliasedRow == null ? this.row : this.aliasedRow;
            Object value = valueRow.get(key);
            if (value != null) {
                return value;
            }
            if (valueRow.containsKey(key)) {
                return null;
            }
            if (this.aliasedRow == null) {
                this.aliasedRow = new HashMap<String, Object>(this.row);
            }
            if (this.set.hasAlias(this.aliasedRow, key)) {
                return this.aliasedRow.get(key);
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.row.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.row.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.row.values();
        }

        @Override
        public int size() {
            return this.row.size();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException("cannot modify row record");
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("cannot modify row record");
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            throw new UnsupportedOperationException("cannot modify row record");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("cannot modify row record");
        }

        @Override
        public boolean getBoolean(PlanExprCol col) {
            return this.getBoolean(this.getNameForColumn(col));
        }

        @Override
        public boolean getBoolean(String columnName) {
            return this.asBoolean(columnName, this.get(columnName));
        }

        @Override
        public byte getByte(PlanExprCol col) {
            return this.getByte(this.getNameForColumn(col));
        }

        @Override
        public byte getByte(String columnName) {
            return this.asByte(columnName, this.get(columnName));
        }

        @Override
        public double getDouble(PlanExprCol col) {
            return this.getDouble(this.getNameForColumn(col));
        }

        @Override
        public double getDouble(String columnName) {
            return this.asDouble(columnName, this.get(columnName));
        }

        @Override
        public float getFloat(PlanExprCol col) {
            return this.getFloat(this.getNameForColumn(col));
        }

        @Override
        public float getFloat(String columnName) {
            return this.asFloat(columnName, this.get(columnName));
        }

        @Override
        public int getInt(PlanExprCol col) {
            return this.getInt(this.getNameForColumn(col));
        }

        @Override
        public int getInt(String columnName) {
            return this.asInt(columnName, this.get(columnName));
        }

        @Override
        public long getLong(PlanExprCol col) {
            return this.getLong(this.getNameForColumn(col));
        }

        @Override
        public long getLong(String columnName) {
            return this.asLong(columnName, this.get(columnName));
        }

        @Override
        public short getShort(PlanExprCol col) {
            return this.getShort(this.getNameForColumn(col));
        }

        @Override
        public short getShort(String columnName) {
            return this.asShort(columnName, this.get(columnName));
        }

        @Override
        public String getString(PlanExprCol col) {
            return this.getString(this.getNameForColumn(col));
        }

        @Override
        public String getString(String columnName) {
            return this.asString(columnName, this.get(columnName));
        }

        private boolean asBoolean(String columnName, Object value) {
            return this.asPrimitiveValueNode(columnName, value).asBoolean();
        }

        private byte asByte(String columnName, Object value) {
            return (byte)this.asPrimitiveValueNode(columnName, value).asInt();
        }

        private double asDouble(String columnName, Object value) {
            return this.asPrimitiveValueNode(columnName, value).asDouble();
        }

        private float asFloat(String columnName, Object value) {
            return (float)this.asPrimitiveValueNode(columnName, value).asDouble();
        }

        private int asInt(String columnName, Object value) {
            return this.asPrimitiveValueNode(columnName, value).asInt();
        }

        private long asLong(String columnName, Object value) {
            return this.asPrimitiveValueNode(columnName, value).asLong();
        }

        private short asShort(String columnName, Object value) {
            return (short)this.asPrimitiveValueNode(columnName, value).asInt();
        }

        private String asString(String columnName, Object value) {
            RESTServices.RESTServiceResult result;
            Format format;
            if (value == null) {
                return null;
            }
            if (value instanceof JsonNode) {
                JsonNode node = (JsonNode)value;
                if (node.isNull()) {
                    return null;
                }
                if (node.isValueNode()) {
                    return node.asText();
                }
                if (node.isContainerNode()) {
                    return node.toPrettyString();
                }
            } else if (value instanceof RESTServices.RESTServiceResult && (format = (result = (RESTServices.RESTServiceResult)value).getFormat()) != null && format != Format.BINARY) {
                return result.getContent(new StringHandle()).get();
            }
            throw new IllegalStateException("column " + columnName + " cannot convert to string");
        }

        private JsonNode asPrimitiveValueNode(String columnName, Object value) {
            JsonNode node = this.asAtomicValueNode(columnName, value);
            if (node == null) {
                throw new IllegalStateException("column " + columnName + " has null instead of primitive value");
            }
            return node;
        }

        private JsonNode asAtomicValueNode(String columnName, Object value) {
            JsonNode node = this.asJsonNode(columnName, value);
            if (node != null && !node.isValueNode()) {
                throw new IllegalStateException("column " + columnName + " does not have an atomic value");
            }
            return node;
        }

        private JsonNode asJsonNode(String columnName, Object value) {
            JsonNode node;
            if (value == null) {
                return null;
            }
            if (value instanceof JsonNode) {
                node = (JsonNode)value;
            } else if (value instanceof RESTServices.RESTServiceResult && this.getContentFormat(columnName) == Format.JSON) {
                node = ((RESTServices.RESTServiceResult)value).getContent(new JacksonHandle()).get();
            } else {
                throw new IllegalStateException("column " + columnName + " does not have a value");
            }
            return node.isNull() ? null : node;
        }

        private RESTServices.RESTServiceResult getServiceResult(String columnName) {
            Object val = this.get(columnName);
            if (val instanceof RESTServices.RESTServiceResult) {
                return (RESTServices.RESTServiceResult)val;
            }
            return null;
        }

        @Override
        public <T extends XsAnyAtomicTypeVal> T getValueAs(PlanExprCol col, Class<T> as) {
            return this.getValueAs(this.getNameForColumn(col), as);
        }

        @Override
        public <T extends XsAnyAtomicTypeVal> T getValueAs(String columnName, Class<T> as) {
            if (as == null) {
                throw new IllegalArgumentException("cannot construct " + columnName + " value with null class");
            }
            try {
                JsonNode node = this.asAtomicValueNode(columnName, this.get(columnName));
                if (node == null) {
                    return null;
                }
                String valueStr = node.asText();
                Function<String, XsAnyAtomicTypeVal> factory = this.getFactory(as);
                if (factory != null) {
                    return (T)((XsAnyAtomicTypeVal)as.cast(factory.apply(valueStr)));
                }
                Constructor<Object> constructor = constructors.get(as);
                if (constructor == null) {
                    constructor = as.getConstructor(String.class);
                    constructors.put(as, constructor);
                }
                return (T)((XsAnyAtomicTypeVal)constructor.newInstance(valueStr));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("cannot construct " + columnName + " value as class: " + as.getName());
            }
            catch (InstantiationException e) {
                throw new MarkLogicBindingException("could not construct value as class: " + as.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new MarkLogicBindingException("could not construct value as class: " + as.getName(), e);
            }
            catch (IllegalArgumentException e) {
                throw new MarkLogicBindingException("could not construct value as class: " + as.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new MarkLogicBindingException("could not construct value as class: " + as.getName(), e);
            }
        }

        <T extends XsAnyAtomicTypeVal> Function<String, ? extends XsAnyAtomicTypeVal> getFactory(Class<T> as) {
            Function<String, ? extends XsAnyAtomicTypeVal> factory = factories.get(as);
            if (factory != null) {
                return factory;
            }
            if (as.isAssignableFrom(XsValueImpl.DecimalValImpl.class)) {
                factory = XsValueImpl.DecimalValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.IntegerValImpl.class)) {
                factory = XsValueImpl.IntegerValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.LongValImpl.class)) {
                factory = XsValueImpl.LongValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.IntValImpl.class)) {
                factory = XsValueImpl.IntValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.ShortValImpl.class)) {
                factory = XsValueImpl.ShortValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.ByteValImpl.class)) {
                factory = XsValueImpl.ByteValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.UnsignedLongValImpl.class)) {
                factory = XsValueImpl.UnsignedLongValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.UnsignedIntValImpl.class)) {
                factory = XsValueImpl.UnsignedIntValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.UnsignedShortValImpl.class)) {
                factory = XsValueImpl.UnsignedShortValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.UnsignedByteValImpl.class)) {
                factory = XsValueImpl.UnsignedByteValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.DoubleValImpl.class)) {
                factory = XsValueImpl.DoubleValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.FloatValImpl.class)) {
                factory = XsValueImpl.FloatValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.DateTimeValImpl.class)) {
                factory = XsValueImpl.DateTimeValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.DateValImpl.class)) {
                factory = XsValueImpl.DateValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.TimeValImpl.class)) {
                factory = XsValueImpl.TimeValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.AnyURIValImpl.class)) {
                factory = XsValueImpl.AnyURIValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.BooleanValImpl.class)) {
                factory = XsValueImpl.BooleanValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.DayTimeDurationValImpl.class)) {
                factory = XsValueImpl.DayTimeDurationValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.GDayValImpl.class)) {
                factory = XsValueImpl.GDayValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.GMonthValImpl.class)) {
                factory = XsValueImpl.GMonthValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.GMonthDayValImpl.class)) {
                factory = XsValueImpl.GMonthDayValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.GYearValImpl.class)) {
                factory = XsValueImpl.GYearValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.GYearMonthValImpl.class)) {
                factory = XsValueImpl.GYearMonthValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.StringValImpl.class)) {
                factory = XsValueImpl.StringValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.YearMonthDurationValImpl.class)) {
                factory = XsValueImpl.YearMonthDurationValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.QNameValImpl.class)) {
                factory = XsValueImpl.QNameValImpl::valueOf;
            }
            if (factory != null) {
                factories.put(as, factory);
            }
            return factory;
        }

        @Override
        public JsonNode getContainer(PlanExprCol col) {
            return this.getContainer(this.getNameForColumn(col));
        }

        @Override
        public JsonNode getContainer(String columnName) {
            return this.asJsonNode(columnName, this.get(columnName));
        }

        @Override
        public <T extends JSONReadHandle> T getContainer(PlanExprCol col, T containerHandle) {
            return this.getContainer(this.getNameForColumn(col), containerHandle);
        }

        @Override
        public <T extends JSONReadHandle> T getContainer(String columnName, T containerHandle) {
            Object value = this.get(columnName);
            if (value == null) {
                return null;
            }
            if (value instanceof JsonNode) {
                return NodeConverter.jsonNodeToHandle((JsonNode)value, containerHandle);
            }
            if (value instanceof RESTServices.RESTServiceResult) {
                return ((RESTServices.RESTServiceResult)value).getContent(containerHandle);
            }
            throw new IllegalStateException("column " + columnName + " does not have a container value");
        }

        @Override
        public <T> T getContainerAs(PlanExprCol col, Class<T> as) {
            return this.getContainerAs(this.getNameForColumn(col), as);
        }

        @Override
        public <T> T getContainerAs(String columnName, Class<T> as) {
            ContentHandle<T> handle = this.getHandle(as);
            if (!JSONReadHandle.class.isInstance(handle)) {
                throw new IllegalArgumentException("handle cannot read JSON: " + handle.getClass().getSimpleName());
            }
            this.getContainer(columnName, (JSONReadHandle)((Object)handle));
            return handle.get();
        }

        @Override
        public Format getContentFormat(PlanExprCol col) {
            return this.getContentFormat(this.getNameForColumn(col));
        }

        @Override
        public Format getContentFormat(String columnName) {
            String mimetype = this.getContentMimetype(columnName);
            if (mimetype == null) {
                return null;
            }
            switch (mimetype) {
                case "application/json": {
                    return Format.JSON;
                }
                case "text/plain": {
                    return Format.TEXT;
                }
                case "application/xml": 
                case "application/xml-external-parsed-entity": {
                    return Format.XML;
                }
            }
            return Format.BINARY;
        }

        @Override
        public String getContentMimetype(PlanExprCol col) {
            return this.getContentMimetype(this.getNameForColumn(col));
        }

        @Override
        public String getContentMimetype(String columnName) {
            if (columnName == null) {
                throw new IllegalArgumentException("cannot get column mime type with null name");
            }
            RESTServices.RESTServiceResult nodeResult = this.getServiceResult(columnName);
            if (nodeResult == null) {
                return null;
            }
            return nodeResult.getMimetype();
        }

        @Override
        public <T extends AbstractReadHandle> T getContent(PlanExprCol col, T contentHandle) {
            return this.getContent(this.getNameForColumn(col), contentHandle);
        }

        @Override
        public <T extends AbstractReadHandle> T getContent(String columnName, T contentHandle) {
            if (columnName == null) {
                throw new IllegalArgumentException("cannot get column node with null name");
            }
            RESTServices.RESTServiceResult nodeResult = this.getServiceResult(columnName);
            if (nodeResult == null) {
                return null;
            }
            return nodeResult.getContent(contentHandle);
        }

        @Override
        public <T> T getContentAs(PlanExprCol col, Class<T> as) {
            return this.getContentAs(this.getNameForColumn(col), as);
        }

        @Override
        public <T> T getContentAs(String columnName, Class<T> as) {
            ContentHandle<T> handle = this.getHandle(as);
            this.getContent(columnName, handle);
            return handle.get();
        }

        private <T> ContentHandle<T> getHandle(Class<T> as) {
            if (as == null) {
                throw new IllegalArgumentException("Must specify a class for content with a registered handle");
            }
            ContentHandle<T> handle = this.set.getHandleRegistry().makeHandle(as);
            if (handle == null) {
                throw new IllegalArgumentException("No handle registered for class: " + as.getName());
            }
            return handle;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("{");
            boolean isFirst = true;
            if (this.row != null) {
                for (String colName : this.row.keySet()) {
                    if (isFirst) {
                        buf.append("\n    ");
                        isFirst = false;
                    } else {
                        buf.append(",\n    ");
                    }
                    RowRecord.ColumnKind colKind = this.kinds.get(colName);
                    String colType = this.datatypes.get(colName);
                    buf.append(colName);
                    buf.append(":{kind: \"");
                    buf.append(colKind.name());
                    if (!"cid".equals(colType)) {
                        buf.append("\", type: \"");
                        buf.append(colType);
                    }
                    buf.append("\", ");
                    block0 : switch (colKind) {
                        case ATOMIC_VALUE: {
                            String atomicVal = this.getString(colName);
                            buf.append("value: ");
                            if (atomicVal == null) {
                                buf.append("null");
                                break;
                            }
                            switch (colType) {
                                case "xs:boolean": 
                                case "xs:byte": 
                                case "xs:decimal": 
                                case "xs:double": 
                                case "xs:float": 
                                case "xs:int": 
                                case "xs:integer": 
                                case "xs:long": 
                                case "xs:short": 
                                case "xs:unsignedByte": 
                                case "xs:unsignedInt": 
                                case "xs:unsignedLong": 
                                case "xs:unsignedShort": {
                                    buf.append(atomicVal);
                                    break block0;
                                }
                            }
                            buf.append("\"");
                            buf.append(atomicVal.replace("\"", "\\\""));
                            buf.append("\"");
                            break;
                        }
                        case CONTAINER_VALUE: {
                            String containerVal = this.getString(colName);
                            buf.append("value: ");
                            buf.append(containerVal == null ? "null" : containerVal);
                            break;
                        }
                        case CONTENT: {
                            buf.append("format: \"");
                            Format contentFormat = this.getContentFormat(colName);
                            buf.append(contentFormat == null ? "unknown" : contentFormat.name().toLowerCase());
                            buf.append("\", mimetype: \"");
                            buf.append(this.getContentMimetype(colName));
                            buf.append("\"");
                            break;
                        }
                        case NULL: {
                            buf.append("value: null");
                            break;
                        }
                        default: {
                            throw new InternalError("unknown value kind: " + (Object)((Object)colKind));
                        }
                    }
                    buf.append("}");
                }
            }
            if (!isFirst) {
                buf.append("\n    ");
            }
            buf.append("}\n");
            return buf.toString();
        }

        private String getNameForColumn(PlanExprCol col) {
            if (col == null) {
                throw new IllegalArgumentException("null column");
            }
            if (!(col instanceof PlanBuilderSubImpl.ColumnNamer)) {
                throw new IllegalArgumentException("invalid column class: " + col.getClass().getName());
            }
            return ((PlanBuilderSubImpl.ColumnNamer)((Object)col)).getColName();
        }
    }

    static class RowSetObject<T>
    extends RowSetHandleBase<T, ContentHandle<T>> {
        RowSetObject(String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, RESTServices.RESTServiceResultIterator results, ContentHandle<T> rowHandle) {
            super(rowFormat, datatypeStyle, rowStructureStyle, results, rowHandle);
        }

        @Override
        T makeNextResult(ContentHandle<T> currentHandle) {
            return currentHandle.get();
        }
    }

    static class RowSetHandle<T extends StructureReadHandle>
    extends RowSetHandleBase<T, T> {
        RowSetHandle(String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, RESTServices.RESTServiceResultIterator results, T rowHandle) {
            super(rowFormat, datatypeStyle, rowStructureStyle, results, rowHandle);
        }

        @Override
        T makeNextResult(T currentHandle) {
            return currentHandle;
        }
    }

    static abstract class RowSetHandleBase<T, R extends AbstractReadHandle>
    extends RowSetBase<T> {
        private R rowHandle = null;

        RowSetHandleBase(String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, RESTServices.RESTServiceResultIterator results, R rowHandle) {
            super(rowFormat, datatypeStyle, rowStructureStyle, results);
            this.rowHandle = rowHandle;
        }

        abstract T makeNextResult(R var1);

        @Override
        public T next() {
            RESTServices.RESTServiceResult currentRow = this.nextRow;
            if (currentRow == null) {
                throw new NoSuchElementException("no next row");
            }
            R currentHandle = this.rowHandle;
            boolean hasMoreRows = this.results.hasNext();
            if (hasMoreRows) {
                this.nextRow = this.results.next();
            } else {
                this.close();
            }
            return this.makeNextResult(currentRow.getContent(currentHandle));
        }
    }

    static class RowSetRecord
    extends RowSetBase<RowRecord> {
        private DatabaseClientFactory.HandleFactoryRegistry handleRegistry = null;
        private Map<String, RowRecord.ColumnKind> headerKinds = null;
        private Map<String, String> headerDatatypes = null;
        private Map<String, String> aliases = null;

        RowSetRecord(String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, RESTServices.RESTServiceResultIterator results, DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
            super(rowFormat, datatypeStyle, rowStructureStyle, results);
            this.handleRegistry = handleRegistry;
        }

        @Override
        void init() {
            super.init();
            if (this.datatypeStyle == RowManager.RowSetPart.HEADER) {
                this.headerKinds = new HashMap<String, RowRecord.ColumnKind>();
                this.headerDatatypes = new HashMap<String, String>();
                for (int i = 0; i < this.columnNames.length; ++i) {
                    String columnName = this.columnNames[i];
                    String columnType = this.columnTypes[i];
                    this.headerDatatypes.put(columnName, columnType);
                    RowRecord.ColumnKind columnKind = this.getColumnKind(columnType, RowRecord.ColumnKind.CONTENT);
                    this.headerKinds.put(columnName, columnKind);
                }
            }
        }

        DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
            return this.handleRegistry;
        }

        void initAliases(Map<String, ?> cols) {
            if (this.aliases != null) {
                return;
            }
            HashMap<String, String> candidates = new HashMap<String, String>();
            Set<String> noncandidates = cols.keySet();
            for (String col : noncandidates.toArray(new String[noncandidates.size()])) {
                String[] parts = col.split("\\.", 3);
                if (parts.length == 1) continue;
                for (int i = 1; i < parts.length; ++i) {
                    String candidate;
                    int next = i + 1;
                    String string = candidate = next == parts.length ? parts[i] : parts[i] + "." + parts[next];
                    if (noncandidates.contains(candidate)) continue;
                    if (candidates.containsKey(candidate)) {
                        candidates.remove(candidate);
                        noncandidates.add(candidate);
                        continue;
                    }
                    candidates.put(candidate, col);
                }
            }
            this.aliases = candidates;
        }

        <T> boolean hasAlias(Map<String, T> cols, Object colName) {
            if (colName == null) {
                return false;
            }
            this.initAliases(cols);
            String columnName = colName instanceof String ? (String)colName : colName.toString();
            String col = this.aliases.get(columnName);
            if (col == null) {
                return false;
            }
            cols.put(columnName, cols.get(col));
            return true;
        }

        @Override
        public RowRecord next() {
            RESTServices.RESTServiceResult currentRow = this.nextRow;
            if (currentRow == null) {
                throw new NoSuchElementException("no next row");
            }
            boolean hasMoreRows = this.results.hasNext();
            try {
                int n;
                String headerValue;
                Map<String, List<String>> headers;
                List<String> headerList;
                Map<String, String> datatypes = null;
                Map<Object, Object> kinds = null;
                HashMap<String, Object> row = new HashMap<String, Object>();
                InputStream rowStream = currentRow.getContent(new InputStreamHandle()).get();
                ObjectMapper rowMapper = new ObjectMapper();
                JsonNode rowNode = rowMapper.readTree(rowStream);
                block1 : switch (this.rowStructureStyle) {
                    case ARRAY: {
                        int i = 0;
                        switch (this.datatypeStyle) {
                            case HEADER: {
                                Object value;
                                datatypes = this.headerDatatypes;
                                for (JsonNode columnNode : rowNode) {
                                    RowRecord.ColumnKind columnKind;
                                    String string = this.columnNames[i];
                                    ++i;
                                    value = this.getColumnValue(string, columnNode);
                                    row.put(string, value);
                                    if (value != null || (columnKind = this.headerKinds.get(string)) == RowRecord.ColumnKind.NULL) continue;
                                    if (kinds == null) {
                                        kinds = new HashMap();
                                        kinds.putAll(this.headerKinds);
                                    }
                                    kinds.put(string, (Object)RowRecord.ColumnKind.NULL);
                                }
                                if (kinds != null) break;
                                kinds = this.headerKinds;
                                break;
                            }
                            case ROWS: {
                                Object value;
                                datatypes = new HashMap<String, String>();
                                kinds = new HashMap();
                                for (JsonNode columnBinding : rowNode) {
                                    String string = this.columnNames[i];
                                    value = this.getTypedRowValue(datatypes, kinds, string, columnBinding);
                                    row.put(string, value);
                                    ++i;
                                }
                                break;
                            }
                            default: {
                                throw new MarkLogicInternalException("Row record set with unknown datatype style: " + (Object)((Object)this.datatypeStyle));
                            }
                        }
                        while (i < this.columnNames.length) {
                            String columnName = this.columnNames[i];
                            kinds.put(columnName, (Object)RowRecord.ColumnKind.NULL);
                            row.put(columnName, null);
                            ++i;
                        }
                        break;
                    }
                    case OBJECT: {
                        Iterator fields = rowNode.properties().iterator();
                        switch (this.datatypeStyle) {
                            case HEADER: {
                                Object value;
                                Object field;
                                datatypes = this.headerDatatypes;
                                while (fields.hasNext()) {
                                    field = (Map.Entry)fields.next();
                                    String string = (String)field.getKey();
                                    JsonNode columnNode = (JsonNode)field.getValue();
                                    value = this.getColumnValue(string, columnNode);
                                    row.put(string, value);
                                }
                                for (Map.Entry entry : this.headerKinds.entrySet()) {
                                    RowRecord.ColumnKind columnKind;
                                    String columnName = (String)entry.getKey();
                                    value = row.get(columnName);
                                    if (value != null || (columnKind = (RowRecord.ColumnKind)((Object)entry.getValue())) == RowRecord.ColumnKind.NULL) continue;
                                    if (kinds == null) {
                                        kinds = new HashMap();
                                        kinds.putAll(this.headerKinds);
                                    }
                                    kinds.put(columnName, (Object)RowRecord.ColumnKind.NULL);
                                }
                                if (kinds != null) break block1;
                                kinds = this.headerKinds;
                                break block1;
                            }
                            case ROWS: {
                                Object value;
                                Object field;
                                datatypes = new HashMap<String, String>();
                                kinds = new HashMap();
                                while (fields.hasNext()) {
                                    field = (Map.Entry)fields.next();
                                    String string = (String)field.getKey();
                                    JsonNode columnBinding = (JsonNode)field.getValue();
                                    value = this.getTypedRowValue(datatypes, kinds, string, columnBinding);
                                    row.put(string, value);
                                }
                                break block1;
                            }
                            default: {
                                throw new MarkLogicInternalException("Row record set with unknown datatype style: " + (Object)((Object)this.datatypeStyle));
                            }
                        }
                    }
                    default: {
                        throw new MarkLogicInternalException("Row record set with unknown row structure style: " + (Object)((Object)this.rowStructureStyle));
                    }
                }
                while (hasMoreRows && (headerList = (headers = (currentRow = this.results.next()).getHeaders()).get("Content-Disposition")) != null && !headerList.isEmpty() && (headerValue = headerList.get(0)) != null && headerValue.startsWith("inline; kind=row-attachment") && (headerList = headers.get("Content-ID")) != null && !headerList.isEmpty() && (headerValue = headerList.get(0)) != null && headerValue.startsWith("<") && headerValue.endsWith(">") && (n = headerValue.indexOf("[", 1)) != -1) {
                    String colName = headerValue.substring(1, n);
                    row.put(colName, currentRow);
                    hasMoreRows = this.results.hasNext();
                }
                RowRecordImpl rowRecord = new RowRecordImpl(this);
                rowRecord.init(kinds, datatypes, row);
                if (hasMoreRows) {
                    this.nextRow = currentRow;
                } else {
                    this.close();
                }
                return rowRecord;
            }
            catch (JsonParseException e) {
                throw new MarkLogicIOException("could not part row record", e);
            }
            catch (JsonMappingException e) {
                throw new MarkLogicIOException("could not map row record", e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException("could not read row record", e);
            }
        }

        private Object getColumnValue(String columnName, JsonNode columnNode) {
            JsonNodeType nodeType = columnNode.getNodeType();
            switch (nodeType) {
                case NULL: {
                    return null;
                }
                case ARRAY: 
                case BOOLEAN: 
                case NUMBER: 
                case OBJECT: 
                case STRING: {
                    return columnNode;
                }
                case BINARY: 
                case MISSING: 
                case POJO: {
                    throw new MarkLogicIOException(columnName + " column with invalid node type: " + nodeType);
                }
            }
            throw new MarkLogicIOException(columnName + " column with unknown node type: " + nodeType);
        }

        private Object getTypedRowValue(Map<String, String> datatypes, Map<String, RowRecord.ColumnKind> kinds, String columnName, JsonNode binding) {
            RowRecord.ColumnKind columnKind = null;
            Object value = null;
            String datatype = binding.get("type").asText();
            if (datatype != null) {
                datatypes.put(columnName, datatype);
            }
            columnKind = this.getColumnKind(datatype, null);
            kinds.put(columnName, columnKind);
            value = columnKind == RowRecord.ColumnKind.NULL || datatype == null || "cid".equals(datatype) ? null : this.getColumnValue(columnName, binding.get("value"));
            return value;
        }

        private RowRecord.ColumnKind getColumnKind(String datatype, RowRecord.ColumnKind defaultKind) {
            if (datatype == null) {
                throw new MarkLogicInternalException("Column value with null datatype");
            }
            switch (datatype) {
                case "array": {
                    return RowRecord.ColumnKind.CONTAINER_VALUE;
                }
                case "cid": {
                    return RowRecord.ColumnKind.CONTENT;
                }
                case "null": {
                    return RowRecord.ColumnKind.NULL;
                }
                case "object": {
                    return RowRecord.ColumnKind.CONTAINER_VALUE;
                }
            }
            if (datatype.contains(":")) {
                return RowRecord.ColumnKind.ATOMIC_VALUE;
            }
            if (datatype != null && defaultKind != null) {
                return defaultKind;
            }
            throw new MarkLogicInternalException("Column value with unsupported datatype: " + datatype);
        }
    }

    static abstract class RowSetBase<T>
    implements RowSet<T>,
    Iterator<T>,
    Closeable {
        String rowFormat = null;
        RESTServices.RESTServiceResultIterator results = null;
        String[] columnNames = null;
        String[] columnTypes = null;
        RESTServices.RESTServiceResult nextRow = null;
        RowManager.RowSetPart datatypeStyle = null;
        RowManager.RowStructure rowStructureStyle = null;

        RowSetBase(String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, RESTServices.RESTServiceResultIterator results) {
            this.rowFormat = rowFormat;
            this.datatypeStyle = datatypeStyle;
            this.rowStructureStyle = rowStructureStyle;
            this.results = results;
        }

        void init() {
            this.parseColumns(this.datatypeStyle, this.rowStructureStyle);
            if (this.results.hasNext()) {
                this.nextRow = this.results.next();
            }
        }

        private void parseColumns(RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle) {
            if (!this.results.hasNext()) {
                return;
            }
            RESTServices.RESTServiceResult headerRow = this.results.next();
            switch (this.rowFormat) {
                case "json": {
                    try {
                        List cols = null;
                        switch (rowStructureStyle) {
                            case OBJECT: {
                                Map headerObj = (Map)new ObjectMapper().readValue(headerRow.getContent(new InputStreamHandle()).get(), Map.class);
                                if (headerObj == null) break;
                                cols = (List)headerObj.get("columns");
                                break;
                            }
                            case ARRAY: {
                                cols = (List)new ObjectMapper().readValue(headerRow.getContent(new InputStreamHandle()).get(), List.class);
                                break;
                            }
                            default: {
                                throw new InternalError("unknown row structure style: " + (Object)((Object)rowStructureStyle));
                            }
                        }
                        int colSize = cols == null ? 0 : cols.size();
                        this.columnNames = colSize > 0 ? new String[colSize] : new String[]{};
                        String[] stringArray = this.columnTypes = colSize > 0 && datatypeStyle == RowManager.RowSetPart.HEADER ? new String[colSize] : new String[]{};
                        if (colSize <= 0) break;
                        int i = 0;
                        for (Map col : cols) {
                            this.columnNames[i] = (String)col.get("name");
                            if (datatypeStyle == RowManager.RowSetPart.HEADER) {
                                this.columnTypes[i] = (String)col.get("type");
                            }
                            ++i;
                        }
                        break;
                    }
                    catch (JsonParseException e) {
                        throw new MarkLogicIOException("could not read JSON header part", e);
                    }
                    catch (JsonMappingException e) {
                        throw new MarkLogicIOException("could not read JSON header map", e);
                    }
                    catch (IOException e) {
                        throw new MarkLogicIOException("could not read JSON header", e);
                    }
                }
                case "xml": {
                    try {
                        ArrayList<String> cols = new ArrayList<String>();
                        ArrayList<String> types = datatypeStyle == RowManager.RowSetPart.HEADER ? new ArrayList<String>() : null;
                        XMLStreamReader headerReader = headerRow.getContent(new XMLStreamReaderHandle()).get();
                        while (headerReader.hasNext()) {
                            switch (headerReader.next()) {
                                case 1: {
                                    if (!"column".equals(headerReader.getLocalName())) break;
                                    cols.add(headerReader.getAttributeValue(null, "name"));
                                    if (datatypeStyle == RowManager.RowSetPart.HEADER) {
                                        types.add(headerReader.getAttributeValue(null, "type"));
                                    }
                                    headerReader.nextTag();
                                }
                            }
                        }
                        int colSize = cols.size();
                        this.columnNames = colSize > 0 ? cols.toArray(new String[colSize]) : new String[]{};
                        this.columnTypes = colSize > 0 && datatypeStyle == RowManager.RowSetPart.HEADER ? types.toArray(new String[colSize]) : new String[]{};
                        break;
                    }
                    catch (XMLStreamException e) {
                        throw new MarkLogicIOException("could not read XML header", e);
                    }
                }
                default: {
                    throw new IllegalArgumentException("Row format should be JSON or XML instead of " + this.rowFormat);
                }
            }
        }

        @Override
        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public String[] getColumnTypes() {
            return this.columnTypes;
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public Stream<T> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public boolean hasNext() {
            return this.nextRow != null;
        }

        @Override
        public void close() {
            if (this.results != null) {
                this.results.close();
                this.results = null;
                this.nextRow = null;
            }
        }
    }
}

