/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.InputStreamTee;
import com.marklogic.client.impl.ReaderTee;
import com.marklogic.client.util.RequestLogger;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestLoggerImpl
implements RequestLogger {
    private static final Logger logger = LoggerFactory.getLogger(RequestLoggerImpl.class);
    private PrintStream out;
    private boolean enabled = true;
    private long contentMax = 0L;

    RequestLoggerImpl(OutputStream out) {
        this.out = out == null ? System.out : (out instanceof PrintStream ? (PrintStream)out : new PrintStream(out));
    }

    @Override
    public long getContentMax() {
        return this.contentMax;
    }

    @Override
    public void setContentMax(long max) {
        this.contentMax = max;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.out == null && enabled) {
            throw new IllegalStateException("Cannot enable closed request logger");
        }
        this.enabled = enabled;
    }

    @Override
    public PrintStream getPrintStream() {
        return this.enabled ? this.out : null;
    }

    @Override
    public <T> T copyContent(T content) {
        if (content == null) {
            return content;
        }
        long max = this.getContentMax();
        if (max < 1L) {
            return content;
        }
        PrintStream out = this.getPrintStream();
        if (out == null) {
            return content;
        }
        if (content instanceof byte[]) {
            byte[] b = (byte[])content;
            out.write(b, 0, (int)Math.min((long)b.length, max));
            return content;
        }
        if (content instanceof File) {
            out.println("info: cannot copy content from " + ((File)content).getAbsolutePath());
            return content;
        }
        if (content instanceof InputStream) {
            return (T)new InputStreamTee((InputStream)content, out, max);
        }
        if (content instanceof Reader) {
            return (T)new ReaderTee((Reader)content, out, max);
        }
        if (content instanceof String) {
            String s = (String)content;
            int len = s.length();
            if ((long)len <= max) {
                out.print(s);
            } else {
                out.print(s.substring(0, (int)Math.min((long)len, max)));
            }
            return content;
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Unknown {} class for content", (Object)content.getClass().getName());
        }
        return content;
    }

    @Override
    public void flush() {
        if (this.out == null) {
            return;
        }
        this.out.flush();
    }

    @Override
    public void close() {
        if (this.out == null) {
            return;
        }
        this.out.close();
        this.out = null;
        this.enabled = false;
    }
}

