/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.expression.PlanBuilder;
import com.marklogic.client.expression.SchemaDefExpr;
import com.marklogic.client.expression.SemExpr;
import com.marklogic.client.expression.TransformDef;
import com.marklogic.client.impl.BaseTypeImpl;
import com.marklogic.client.impl.ContentParam;
import com.marklogic.client.impl.DocDescriptorUtil;
import com.marklogic.client.impl.PatchBuilderImpl;
import com.marklogic.client.impl.PlanBuilderBaseImpl;
import com.marklogic.client.impl.PlanBuilderImpl;
import com.marklogic.client.impl.PlanDocColsIdentifierImpl;
import com.marklogic.client.impl.PlanRowColTypesImpl;
import com.marklogic.client.impl.PlanRowColTypesSeqImpl;
import com.marklogic.client.impl.RdfValueImpl;
import com.marklogic.client.impl.SchemaDefImpl;
import com.marklogic.client.impl.SemValueImpl;
import com.marklogic.client.impl.TransformDefImpl;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.impl.XsValueImpl;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.type.CtsQueryExpr;
import com.marklogic.client.type.CtsReferenceExpr;
import com.marklogic.client.type.PatchBuilder;
import com.marklogic.client.type.PlanAggregateCol;
import com.marklogic.client.type.PlanAggregateColSeq;
import com.marklogic.client.type.PlanCase;
import com.marklogic.client.type.PlanColumn;
import com.marklogic.client.type.PlanCondition;
import com.marklogic.client.type.PlanDocColsIdentifier;
import com.marklogic.client.type.PlanDocDescriptor;
import com.marklogic.client.type.PlanDocDescriptorSeq;
import com.marklogic.client.type.PlanExprCol;
import com.marklogic.client.type.PlanExprColSeq;
import com.marklogic.client.type.PlanFunction;
import com.marklogic.client.type.PlanGroup;
import com.marklogic.client.type.PlanGroupConcatOptionSeq;
import com.marklogic.client.type.PlanGroupSeq;
import com.marklogic.client.type.PlanJsonProperty;
import com.marklogic.client.type.PlanNamedGroup;
import com.marklogic.client.type.PlanNamedGroupSeq;
import com.marklogic.client.type.PlanParamBindingVal;
import com.marklogic.client.type.PlanParamExpr;
import com.marklogic.client.type.PlanPrefixer;
import com.marklogic.client.type.PlanRowColTypes;
import com.marklogic.client.type.PlanRowColTypesSeq;
import com.marklogic.client.type.PlanSampleByOptions;
import com.marklogic.client.type.PlanSearchOptions;
import com.marklogic.client.type.PlanSparqlOptions;
import com.marklogic.client.type.PlanSystemColumn;
import com.marklogic.client.type.PlanTripleOption;
import com.marklogic.client.type.PlanTriplePatternSeq;
import com.marklogic.client.type.PlanValueOption;
import com.marklogic.client.type.SemIriVal;
import com.marklogic.client.type.SemStoreExpr;
import com.marklogic.client.type.ServerExpression;
import com.marklogic.client.type.XsBooleanVal;
import com.marklogic.client.type.XsIntVal;
import com.marklogic.client.type.XsLongVal;
import com.marklogic.client.type.XsQNameVal;
import com.marklogic.client.type.XsStringSeqVal;
import com.marklogic.client.type.XsStringVal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PlanBuilderSubImpl
extends PlanBuilderImpl {
    @Override
    public PatchBuilder patchBuilder(String contextPath) {
        return new PatchBuilderImpl(new XsValueImpl.StringValImpl(contextPath));
    }

    @Override
    public PatchBuilder patchBuilder(XsStringVal contextPath) {
        return new PatchBuilderImpl(contextPath);
    }

    @Override
    public PatchBuilder patchBuilder(String contextPath, Map<String, String> namespaces) {
        return new PatchBuilderImpl(new XsValueImpl.StringValImpl(contextPath), namespaces);
    }

    @Override
    public PatchBuilder patchBuilder(XsStringVal contextPath, Map<String, String> namespaces) {
        return new PatchBuilderImpl(contextPath, namespaces);
    }

    @Override
    public PlanBuilder.AccessPlan fromSearchDocs(CtsQueryExpr query) {
        return this.fromSearchDocs(query, null);
    }

    @Override
    public PlanBuilder.AccessPlan fromSearchDocs(CtsQueryExpr query, String qualifierName) {
        return this.fromSearchDocs(query, null, null);
    }

    @Override
    public PlanBuilder.AccessPlan fromSearchDocs(CtsQueryExpr query, String qualifierName, PlanSearchOptions options) {
        Object[] objectArray;
        XsStringVal qualifierValue;
        XsStringVal xsStringVal = qualifierValue = qualifierName == null ? null : this.xs.string(qualifierName);
        if (options == null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = query;
            objectArray = objectArray2;
            objectArray2[1] = qualifierValue;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = query;
            objectArray3[1] = qualifierValue;
            objectArray = objectArray3;
            objectArray3[2] = PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(options));
        }
        Object[] args = objectArray;
        return new AccessPlanSubImpl(this, "op", "from-search-docs", args);
    }

    @Override
    public PlanBuilder.AccessPlan fromSearch(CtsQueryExpr query) {
        return this.fromSearch(query, (PlanExprColSeq)null, (XsStringVal)null, (PlanSearchOptions)null);
    }

    @Override
    public PlanBuilder.AccessPlan fromSearch(CtsQueryExpr query, PlanExprCol ... columns) {
        return this.fromSearch(query, new PlanBuilderImpl.ExprColSeqListImpl(columns), null, null);
    }

    @Override
    public PlanBuilder.AccessPlan fromSearch(CtsQueryExpr query, PlanExprColSeq columns, String qualifierName) {
        return this.fromSearch(query, columns, qualifierName == null ? null : this.xs.string(qualifierName), null);
    }

    @Override
    public PlanBuilder.AccessPlan fromSearch(CtsQueryExpr query, PlanExprColSeq columns, XsStringVal qualifierName, PlanSearchOptions options) {
        return new AccessPlanSubImpl(this, "op", "from-search", new Object[]{query, columns, qualifierName, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(options))});
    }

    @Override
    public PlanBuilder.ModifyPlan fromSparql(String select, String qualifierName, PlanSparqlOptions option) {
        return this.fromSparql(select == null ? (XsStringVal)null : this.xs.string(select), qualifierName == null ? (XsStringVal)null : this.xs.string(qualifierName), option);
    }

    @Override
    public PlanBuilder.ModifyPlan fromSparql(XsStringVal select, XsStringVal qualifierName, PlanSparqlOptions option) {
        if (select == null) {
            throw new IllegalArgumentException("select parameter for fromSparql() cannot be null");
        }
        ModifyPlanSubImpl plan = new ModifyPlanSubImpl("op", "from-sparql", new Object[]{select, qualifierName, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(option))});
        plan.setHandleRegistry(this.getHandleRegistry());
        return plan;
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePatternSeq patterns, String qualifierName, String graphIris, PlanTripleOption option) {
        return this.fromTriples(patterns, qualifierName == null ? null : this.xs.string(qualifierName), graphIris == null ? null : this.xs.string(graphIris), option);
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePatternSeq patterns) {
        return new AccessPlanSubImpl(this, "op", "from-triples", new Object[]{patterns});
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePatternSeq patterns, XsStringVal qualifierName) {
        return new AccessPlanSubImpl(this, "op", "from-triples", new Object[]{patterns, qualifierName});
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePatternSeq patterns, XsStringVal qualifierName, XsStringSeqVal graphIris) {
        return new AccessPlanSubImpl(this, "op", "from-triples", new Object[]{patterns, qualifierName, graphIris});
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePatternSeq patterns, XsStringVal qualifierName, XsStringSeqVal graphIris, PlanTripleOption option) {
        return new AccessPlanSubImpl(this, "op", "from-triples", new Object[]{patterns, qualifierName, graphIris, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(option))});
    }

    @Override
    public PlanBuilder.AccessPlan fromLexicons(Map<String, CtsReferenceExpr> indexes) {
        return new AccessPlanSubImpl(this, "op", "from-lexicons", new Object[]{PlanBuilderSubImpl.literal(indexes)});
    }

    @Override
    public PlanBuilder.AccessPlan fromLexicons(Map<String, CtsReferenceExpr> indexes, String qualifierName) {
        return this.fromLexicons(indexes, qualifierName == null ? null : this.xs.string(qualifierName));
    }

    @Override
    public PlanBuilder.AccessPlan fromLexicons(Map<String, CtsReferenceExpr> indexes, XsStringVal qualifierName) {
        return new AccessPlanSubImpl(this, "op", "from-lexicons", new Object[]{PlanBuilderSubImpl.literal(indexes), qualifierName});
    }

    @Override
    public PlanBuilder.AccessPlan fromLexicons(Map<String, CtsReferenceExpr> indexes, String qualifierName, PlanSystemColumn sysCols) {
        return this.fromLexicons(indexes, qualifierName == null ? null : this.xs.string(qualifierName), sysCols);
    }

    @Override
    public PlanBuilder.AccessPlan fromLexicons(Map<String, CtsReferenceExpr> indexes, XsStringVal qualifierName, PlanSystemColumn sysCols) {
        return new AccessPlanSubImpl(this, "op", "from-lexicons", new Object[]{PlanBuilderSubImpl.literal(indexes), qualifierName, sysCols});
    }

    @Override
    @SafeVarargs
    public final PlanBuilder.AccessPlan fromLiterals(Map<String, Object> ... rows) {
        return new AccessPlanSubImpl(this, "op", "from-literals", new Object[]{PlanBuilderSubImpl.literal(rows)});
    }

    @Override
    public PlanBuilder.AccessPlan fromLiterals(Map<String, Object>[] rows, String qualifierName) {
        return this.fromLiterals(rows, qualifierName == null ? null : this.xs.string(qualifierName));
    }

    @Override
    public PlanBuilder.AccessPlan fromLiterals(Map<String, Object>[] rows, XsStringVal qualifierName) {
        return new AccessPlanSubImpl(this, "op", "from-literals", new Object[]{PlanBuilderSubImpl.literal(rows), qualifierName});
    }

    @Override
    public PlanBuilder.AccessPlan fromView(XsStringVal schema, XsStringVal view) {
        return new AccessPlanSubImpl(this, "op", "from-view", new Object[]{schema, view});
    }

    @Override
    public PlanBuilder.AccessPlan fromView(XsStringVal schema, XsStringVal view, XsStringVal qualifierName) {
        return new AccessPlanSubImpl(this, "op", "from-view", new Object[]{schema, view, qualifierName});
    }

    @Override
    public PlanBuilder.AccessPlan fromView(XsStringVal schema, XsStringVal view, XsStringVal qualifierName, PlanSystemColumn sysCols) {
        return new AccessPlanSubImpl(this, "op", "from-view", new Object[]{schema, view, qualifierName, sysCols});
    }

    @Override
    public PlanBuilder.AccessPlan fromParam(XsStringVal paramName, XsStringVal qualifier, PlanRowColTypesSeq colTypes) {
        if (paramName == null) {
            throw new IllegalArgumentException("paramName parameter for fromParam() cannot be null");
        }
        if (colTypes == null) {
            throw new IllegalArgumentException("colTypes parameter for fromParam() cannot be null");
        }
        return new AccessPlanSubImpl(this, "op", "from-param", new Object[]{paramName, qualifier, colTypes});
    }

    @Override
    public PlanBuilder.AccessPlan fromDocDescriptors(PlanDocDescriptorSeq docDescriptor) {
        if (docDescriptor == null) {
            throw new IllegalArgumentException("docDescriptor parameter for fromDocDescriptors() cannot be null");
        }
        return new AccessPlanSubImpl(this, "op", "from-doc-descriptors", new Object[]{docDescriptor});
    }

    @Override
    public PlanBuilder.AccessPlan fromDocDescriptors(PlanDocDescriptorSeq docDescriptor, XsStringVal qualifier) {
        if (docDescriptor == null) {
            throw new IllegalArgumentException("docDescriptor parameter for fromDocDescriptors() cannot be null");
        }
        return new AccessPlanSubImpl(this, "op", "from-doc-descriptors", new Object[]{docDescriptor, qualifier});
    }

    @Override
    public PlanBuilder.ModifyPlan fromSql(XsStringVal select) {
        if (select == null) {
            throw new IllegalArgumentException("select parameter for fromSql() cannot be null");
        }
        ModifyPlanSubImpl plan = new ModifyPlanSubImpl("op", "from-sql", new Object[]{select});
        plan.setHandleRegistry(this.getHandleRegistry());
        return plan;
    }

    @Override
    public PlanBuilder.AccessPlan fromDocUris(String ... uris) {
        return this.fromDocUris(this.cts.documentQuery(this.xs.stringSeq(uris)));
    }

    @Override
    public PlanBuilder.AccessPlan fromDocUris(CtsQueryExpr querydef) {
        return this.fromDocUris(querydef, null);
    }

    @Override
    public PlanBuilder.AccessPlan fromDocUris(CtsQueryExpr querydef, String qualifierName) {
        return new AccessPlanSubImpl(this, "op", "from-doc-uris", new Object[]{querydef, qualifierName == null ? null : this.xs.string(qualifierName)});
    }

    @Override
    public PlanDocColsIdentifier docCols(Map<String, PlanColumn> descriptorColumnMapping) {
        return new PlanDocColsIdentifierImpl(descriptorColumnMapping);
    }

    @Override
    public PlanDocDescriptor docDescriptor(DocumentWriteOperation writeOp) {
        return new PlanDocDescriptorImpl(writeOp);
    }

    @Override
    public PlanDocDescriptorSeq docDescriptors(DocumentWriteSet writeSet) {
        return new PlanDocDescriptorSeqImpl(writeSet);
    }

    @Override
    public PlanRowColTypesSeq colTypes(PlanRowColTypes ... colTypes) {
        return new PlanRowColTypesSeqImpl(colTypes);
    }

    @Override
    public PlanRowColTypes colType(String column) {
        return this.colType(column, null);
    }

    @Override
    public PlanRowColTypes colType(String column, String type) {
        return this.colType(column, type, null);
    }

    @Override
    public PlanRowColTypes colType(String column, String type, Boolean nullable) {
        return new PlanRowColTypesImpl(column, type, nullable);
    }

    @Override
    public TransformDef transformDef(String path) {
        return new TransformDefImpl(path);
    }

    @Override
    public SchemaDefExpr schemaDefinition(String kind) {
        return new SchemaDefImpl(kind);
    }

    @Override
    public ServerExpression permission(String roleName, String capability) {
        return this.jsonObject(this.prop(this.xs.string("roleName"), (ServerExpression)this.xs.string(roleName)), this.prop(this.xs.string("capability"), (ServerExpression)this.xs.string(capability)));
    }

    @Override
    public PlanAggregateCol avg(String name, String column, PlanValueOption option) {
        return this.avg(this.col(name), this.col(column), option);
    }

    @Override
    public PlanAggregateCol avg(PlanColumn name, PlanExprCol column, PlanValueOption option) {
        return new PlanBuilderImpl.AggregateColCallImpl("op", "avg", new Object[]{name, column, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(option))});
    }

    @Override
    public PlanAggregateCol arrayAggregate(String name, String column, PlanValueOption option) {
        return this.arrayAggregate(this.col(name), this.col(column), option);
    }

    @Override
    public PlanAggregateCol arrayAggregate(PlanColumn name, PlanExprCol column, PlanValueOption option) {
        return new PlanBuilderImpl.AggregateColCallImpl("op", "array-aggregate", new Object[]{name, column, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(option))});
    }

    @Override
    public PlanAggregateCol count(String name, String column, PlanValueOption option) {
        return this.count(this.col(name), this.exprCol(column), option);
    }

    @Override
    public PlanAggregateCol count(PlanColumn name, PlanExprCol column, PlanValueOption option) {
        return new PlanBuilderImpl.AggregateColCallImpl("op", "count", new Object[]{name, column, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(option))});
    }

    @Override
    public PlanAggregateCol max(String name, String column, PlanValueOption option) {
        return this.max(this.col(name), this.exprCol(column), option);
    }

    @Override
    public PlanAggregateCol max(PlanColumn name, PlanExprCol column, PlanValueOption option) {
        return new PlanBuilderImpl.AggregateColCallImpl("op", "max", new Object[]{name, column, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(option))});
    }

    @Override
    public PlanAggregateCol min(String name, String column, PlanValueOption option) {
        return this.min(this.col(name), this.exprCol(column), option);
    }

    @Override
    public PlanAggregateCol min(PlanColumn name, PlanExprCol column, PlanValueOption option) {
        return new PlanBuilderImpl.AggregateColCallImpl("op", "min", new Object[]{name, column, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(option))});
    }

    @Override
    public PlanAggregateCol sequenceAggregate(String name, String column, PlanValueOption option) {
        return this.sequenceAggregate(this.col(name), this.exprCol(column), option);
    }

    @Override
    public PlanAggregateCol sequenceAggregate(PlanColumn name, PlanExprCol column, PlanValueOption option) {
        return new PlanBuilderImpl.AggregateColCallImpl("op", "sequence-aggregate", new Object[]{name, column, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(option))});
    }

    @Override
    public PlanAggregateCol sum(String name, String column, PlanValueOption option) {
        return this.sum(this.col(name), this.exprCol(column), option);
    }

    @Override
    public PlanAggregateCol sum(PlanColumn name, PlanExprCol column, PlanValueOption option) {
        return new PlanBuilderImpl.AggregateColCallImpl("op", "sum", new Object[]{name, column, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(option))});
    }

    @Override
    public PlanAggregateCol groupConcat(String name, String column) {
        return this.groupConcat(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol groupConcat(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for groupConcat() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for groupConcat() cannot be null");
        }
        return new PlanBuilderImpl.AggregateColCallImpl("op", "group-concat", new Object[]{name, column});
    }

    @Override
    public PlanAggregateCol groupConcat(String name, String column, PlanGroupConcatOptionSeq options) {
        return this.groupConcat(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column), options);
    }

    @Override
    public PlanAggregateCol groupConcat(PlanColumn name, PlanExprCol column, PlanGroupConcatOptionSeq options) {
        return new PlanBuilderImpl.AggregateColCallImpl("op", "group-concat", new Object[]{name, column, PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(options))});
    }

    @Override
    public PlanGroupConcatOptionSeq groupConcatOptions(String separator) {
        return new PlanGroupConcatOptionSeqImpl(separator, null);
    }

    @Override
    public PlanGroupConcatOptionSeq groupConcatOptions(PlanValueOption option) {
        return new PlanGroupConcatOptionSeqImpl(null, option);
    }

    @Override
    public PlanGroupConcatOptionSeq groupConcatOptions(String separator, PlanValueOption option) {
        return new PlanGroupConcatOptionSeqImpl(separator, option);
    }

    @Override
    public PlanGroup group(String ... keys) {
        return this.group(this.colSeq(keys));
    }

    @Override
    public PlanGroupSeq rollup(String ... keys) {
        return this.rollup(this.colSeq(keys));
    }

    @Override
    public PlanGroupSeq cube(String ... keys) {
        return this.cube(this.colSeq(keys));
    }

    @Override
    public PlanNamedGroup namedGroup(String name) {
        return this.namedGroup(this.xs.string(name), null);
    }

    @Override
    public PlanNamedGroup namedGroup(String name, PlanExprColSeq keys) {
        return this.namedGroup(this.xs.string(name), keys);
    }

    @Override
    public PlanSampleByOptions sampleByOptions() {
        return new PlanSampleByOptionsImpl(this);
    }

    @Override
    public PlanSparqlOptions sparqlOptions() {
        return new PlanSparqlOptionsImpl(this);
    }

    @Override
    public ServerExpression caseExpr(PlanCase ... cases) {
        int lastPos = cases.length - 1;
        if (lastPos < 1) {
            throw new IllegalArgumentException("cannot specify caseExpr() without when() and elseExpr()");
        }
        BaseTypeImpl.BaseArgImpl[] whenList = new BaseTypeImpl.BaseArgImpl[lastPos];
        for (int i = 0; i < lastPos; ++i) {
            PlanCase currCase = cases[i];
            if (!(currCase instanceof CaseWhenCallImpl)) {
                throw new IllegalArgumentException("caseExpr() can only have when() cases and final elseExpr(): " + currCase.getClass().getName());
            }
            whenList[i] = (CaseWhenCallImpl)currCase;
        }
        PlanCase lastCase = cases[lastPos];
        if (!(lastCase instanceof CaseElseImpl)) {
            throw new IllegalArgumentException("caseExpr() must have a last case of elseExpr(): " + lastCase.getClass().getName());
        }
        return new CaseCallImpl(whenList, ((CaseElseImpl)lastCase).getArg());
    }

    @Override
    public PlanExprCol as(PlanColumn column, ServerExpression expression) {
        return new ExprColCallImpl("op", "as", new Object[]{column, expression});
    }

    @Override
    public PlanColumn col(XsStringVal column) {
        return new ColumnCallImpl("op", "col", new Object[]{column});
    }

    @Override
    public PlanColumn viewCol(XsStringVal view, XsStringVal column) {
        return new ColumnCallImpl("op", "view-col", new Object[]{view, column});
    }

    @Override
    public PlanColumn schemaCol(XsStringVal schema, XsStringVal view, XsStringVal column) {
        return new ColumnCallImpl("op", "schema-col", new Object[]{schema, view, column});
    }

    @Override
    public PlanSystemColumn fragmentIdCol(XsStringVal column) {
        return new SystemColumnCallImpl("op", "fragment-id-col", new Object[]{column});
    }

    @Override
    public PlanSystemColumn graphCol(XsStringVal column) {
        return new SystemColumnCallImpl("op", "graph-col", new Object[]{column});
    }

    @Override
    public PlanCase when(boolean condition, ServerExpression ... value) {
        return this.when(this.xs.booleanVal(condition), value);
    }

    @Override
    public PlanCase when(ServerExpression condition, ServerExpression ... value) {
        if (condition == null) {
            throw new IllegalArgumentException("condition parameter for when() cannot be null");
        }
        return new CaseWhenCallImpl(new Object[]{condition, new BaseTypeImpl.ItemSeqListImpl(value)});
    }

    @Override
    public PlanCase elseExpr(ServerExpression value) {
        if (!(value instanceof BaseTypeImpl.BaseArgImpl)) {
            throw new IllegalArgumentException("invalid value for elseExpr(): " + value.getClass().getName());
        }
        return new CaseElseImpl((BaseTypeImpl.BaseArgImpl)((Object)value));
    }

    @Override
    public ServerExpression jsonObject(PlanJsonProperty ... properties) {
        return new JsonObjectCallImpl(new Object[]{new JsonPropertySeqListImpl(properties)});
    }

    @Override
    public ServerExpression jsonArray(ServerExpression ... items) {
        return new JsonArrayCallImpl(new Object[]{new BaseTypeImpl.ItemSeqListImpl(items)});
    }

    @Override
    public PlanGroupSeq groupSeq(PlanGroup ... groups) {
        return new PlanBuilderImpl.GroupSeqListImpl(groups);
    }

    @Override
    public PlanNamedGroupSeq namedGroupSeq(PlanNamedGroup ... namedGroups) {
        return new PlanBuilderImpl.NamedGroupSeqListImpl(namedGroups);
    }

    @Override
    public PlanFunction resolveFunction(XsQNameVal functionName, String modulePath) {
        return this.resolveFunction(functionName, this.xs.string(modulePath));
    }

    @Override
    public ServerExpression seq(ServerExpression ... expr) {
        return new BaseTypeImpl.ServerExpressionListImpl(expr, true);
    }

    @Override
    public PlanPrefixer prefixer(XsStringVal base) {
        return this.prefixer(base.getString());
    }

    @Override
    public PlanPrefixer prefixer(String base) {
        if (base == null || base.length() == 0) {
            throw new IllegalArgumentException("cannot create prefixer with empty string");
        }
        String lastChar = base.substring(base.length() - 1);
        String prefix = "/".equals(lastChar) || "#".equals(lastChar) || "?".equals(lastChar) ? base : base + "/";
        return new PrefixerImpl(this.sem, prefix);
    }

    @Override
    public PlanParamExpr param(String name) {
        return new PlanBuilderBaseImpl.PlanParamBase(name);
    }

    @Override
    public PlanParamExpr param(XsStringVal name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for param() cannot be null");
        }
        return new ParamCallImpl("op", "param", new Object[]{name});
    }

    static Map<String, Object> makeMap(PlanSearchOptions options) {
        if (options == null) {
            return null;
        }
        if (!(options instanceof PlanBuilderBaseImpl.PlanSearchOptionsImpl)) {
            throw new IllegalArgumentException("invalid implementation of PlanSearchOptions");
        }
        return ((PlanBuilderBaseImpl.PlanSearchOptionsImpl)options).makeMap();
    }

    static Map<String, String> makeMap(PlanValueOption option) {
        if (option == null) {
            return null;
        }
        return option == PlanValueOption.DISTINCT ? PlanBuilderSubImpl.makeMap("values", "distinct") : null;
    }

    static Map<String, String> makeMap(PlanTripleOption option) {
        if (option == null) {
            return null;
        }
        return PlanBuilderSubImpl.makeMap("dedup", option == PlanTripleOption.DEDUPLICATED ? "on" : "off");
    }

    static Map<String, String> makeMap(PlanGroupConcatOptionSeq options) {
        if (options == null) {
            return null;
        }
        if (options instanceof PlanValueOption) {
            return PlanBuilderSubImpl.makeMap((PlanValueOption)options);
        }
        if (!(options instanceof PlanGroupConcatOptionSeqImpl)) {
            throw new IllegalArgumentException("invalid implementation of PlanGroupConcatOptionSeq");
        }
        PlanGroupConcatOptionSeqImpl optiondef = (PlanGroupConcatOptionSeqImpl)options;
        PlanValueOption option = optiondef.getOption();
        Map<String, String> mapdef = option == null ? null : PlanBuilderSubImpl.makeMap(option);
        String separator = optiondef.getSeparator();
        if (separator != null) {
            if (mapdef != null) {
                mapdef.put("separator", separator);
            } else {
                mapdef = PlanBuilderSubImpl.makeMap("separator", separator);
            }
        }
        return mapdef;
    }

    static Map<String, XsIntVal> makeMap(PlanSampleByOptions options) {
        if (options == null) {
            return null;
        }
        XsIntVal limit = options.getLimit();
        return limit == null ? null : PlanBuilderSubImpl.makeMap("limit", limit);
    }

    static Map<String, String> makeMap(PlanSparqlOptions options) {
        XsStringVal base;
        if (options == null) {
            return null;
        }
        Map<String, String> mapdef = null;
        XsBooleanVal dedup = options.getDeduplicated();
        if (dedup != null) {
            mapdef = PlanBuilderSubImpl.makeMap("dedup", dedup.getBoolean() ? "on" : "off");
        }
        if ((base = options.getBase()) != null) {
            if (mapdef == null) {
                mapdef = PlanBuilderSubImpl.makeMap("base", base.getString());
            } else {
                mapdef.put("base", base.getString());
            }
        }
        return mapdef;
    }

    static Map<String, String> makeMap(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (key != null) {
            map.put(key, value);
        }
        return map;
    }

    static Map<String, XsIntVal> makeMap(String key, XsIntVal value) {
        HashMap<String, XsIntVal> map = new HashMap<String, XsIntVal>();
        if (key != null) {
            map.put(key, value);
        }
        return map;
    }

    static BaseTypeImpl.BaseMapImpl asArg(Map<String, ?> arg) {
        if (arg == null) {
            return null;
        }
        return new BaseTypeImpl.BaseMapImpl(arg);
    }

    static class PrefixerImpl
    implements PlanPrefixer {
        private SemExpr sem;
        private String prefix;

        private PrefixerImpl(SemExpr sem, String prefix) {
            this.prefix = prefix;
            this.sem = sem;
        }

        @Override
        public SemIriVal iri(XsStringVal suffix) {
            return this.iri(suffix.getString());
        }

        @Override
        public SemIriVal iri(String suffix) {
            if (suffix == null || suffix.length() == 0) {
                throw new IllegalArgumentException("cannot create SemIriVal with empty string");
            }
            String firstChar = suffix.substring(0, 1);
            if ("/".equals(firstChar) || "#".equals(firstChar) || "?".equals(firstChar)) {
                if (suffix.length() == 1) {
                    throw new IllegalArgumentException("cannot create SemIriVal from: " + suffix);
                }
                suffix = suffix.substring(1);
            }
            return this.sem.iri(this.prefix + suffix);
        }
    }

    static class JsonArrayCallImpl
    extends BaseTypeImpl.ServerExpressionCallImpl
    implements JsonContentCallImpl {
        JsonArrayCallImpl(Object[] args) {
            super("op", "json-array", args);
        }
    }

    static class JsonPropertyCallImpl
    extends BaseTypeImpl.ServerExpressionCallImpl
    implements PlanJsonProperty {
        JsonPropertyCallImpl(Object[] args) {
            super("op", "prop", args);
        }
    }

    static class JsonObjectCallImpl
    extends BaseTypeImpl.ServerExpressionCallImpl
    implements JsonContentCallImpl {
        JsonObjectCallImpl(Object[] args) {
            super("op", "json-object", args);
        }
    }

    static class JsonPropertySeqListImpl
    extends BaseTypeImpl.ServerExpressionListImpl {
        JsonPropertySeqListImpl(PlanJsonProperty[] items) {
            super((Object[])Arrays.copyOf(items, items.length, BaseTypeImpl.BaseArgImpl[].class));
        }
    }

    static class JsonContentSeqListImpl
    extends BaseTypeImpl.ServerExpressionListImpl {
        JsonContentSeqListImpl(ServerExpression[] items) {
            super((Object[])Arrays.copyOf(items, items.length, BaseTypeImpl.BaseArgImpl[].class));
        }
    }

    static interface JsonContentCallImpl
    extends BaseTypeImpl.BaseArgImpl {
    }

    static class CaseElseImpl
    implements PlanCase {
        private BaseTypeImpl.BaseArgImpl arg = null;

        CaseElseImpl(BaseTypeImpl.BaseArgImpl arg) {
            this.arg = arg;
        }

        BaseTypeImpl.BaseArgImpl getArg() {
            return this.arg;
        }
    }

    static class CaseWhenCallImpl
    extends BaseTypeImpl.ServerExpressionCallImpl
    implements PlanCase {
        CaseWhenCallImpl(Object[] args) {
            super("op", "when", args);
        }
    }

    static class CaseCallImpl
    extends BaseTypeImpl.ServerExpressionCallImpl {
        CaseCallImpl(BaseTypeImpl.BaseArgImpl[] whenList, BaseTypeImpl.BaseArgImpl otherwise) {
            super("op", "case", new BaseTypeImpl.BaseArgImpl[]{new BaseTypeImpl.ServerExpressionListImpl(whenList), otherwise});
        }
    }

    static interface ColumnNamer {
        public String getColName();
    }

    static class SystemColumnCallImpl
    extends ColumnCallImpl
    implements PlanSystemColumn,
    ColumnNamer {
        private String name;

        SystemColumnCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
            this.name = fnArgs[0].toString();
        }

        @Override
        public String getColName() {
            return this.name;
        }
    }

    static class ColumnCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanColumn,
    ColumnNamer {
        private Object[] fnArgs = null;
        private String name = null;

        ColumnCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
            this.fnArgs = fnArgs;
        }

        @Override
        public String getColName() {
            if (this.name == null) {
                int stepCount = this.fnArgs.length;
                this.name = stepCount == 1 ? this.fnArgs[0].toString() : Arrays.stream(this.fnArgs).filter(step -> step != null).map(Object::toString).collect(Collectors.joining("."));
            }
            return this.name;
        }
    }

    static class ExprColCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanExprCol,
    ColumnNamer {
        private ColumnNamer namedCol;

        ExprColCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
            Object firstArg = fnArgs[0];
            if (!(firstArg instanceof ColumnNamer)) {
                throw new IllegalArgumentException("invalid column class: " + firstArg.getClass().getName());
            }
            this.namedCol = (ColumnNamer)firstArg;
        }

        @Override
        public String getColName() {
            return this.namedCol.getColName();
        }
    }

    static class AccessPlanSubImpl
    extends PlanBuilderImpl.AccessPlanImpl {
        XsStringVal schema = null;
        XsStringVal qualifier = null;

        AccessPlanSubImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            this((PlanBuilderBaseImpl)null, fnPrefix, fnName, fnArgs);
        }

        AccessPlanSubImpl(PlanBuilderBaseImpl builder, String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
            if (!"op".equals(fnPrefix)) {
                throw new IllegalArgumentException("unknown accessor constructor prefix: " + fnPrefix);
            }
            if (builder != null) {
                this.setHandleRegistry(builder.getHandleRegistry());
            }
            switch (fnName) {
                case "from-view": {
                    if (fnArgs.length < 2) {
                        throw new IllegalArgumentException("fromView() constructor missing view name parameter: " + fnArgs.length);
                    }
                    Object firstArg = fnArgs[0];
                    if (firstArg != null) {
                        this.schema = xs.string(firstArg.toString());
                    }
                    this.qualifier = xs.string(fnArgs[1].toString());
                    break;
                }
                case "from-lexicons": 
                case "from-literals": 
                case "from-search": 
                case "from-search-docs": 
                case "from-triples": 
                case "from-doc-uris": 
                case "from-param": 
                case "from-doc-descriptors": {
                    if (fnArgs.length < 1) {
                        throw new IllegalArgumentException("accessor constructor without parameters: " + fnArgs.length);
                    }
                    this.qualifier = xs.string(fnArgs[0].toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown accessor constructor name: " + fnName);
                }
            }
        }

        @Override
        public PlanColumn col(String name) {
            return this.col(xs.string(name));
        }

        @Override
        public PlanColumn col(XsStringVal name) {
            if (this.schema != null) {
                return pb.schemaCol(this.schema, this.qualifier, name);
            }
            if (this.qualifier != null) {
                return pb.viewCol(this.qualifier, name);
            }
            return pb.col(name);
        }

        @Override
        public PlanBuilder.ModifyPlan sampleBy(PlanSampleByOptions option) {
            return new ModifyPlanSubImpl(this, "op", "sample-by", new Object[]{PlanBuilderSubImpl.asArg(PlanBuilderSubImpl.makeMap(option))});
        }
    }

    static class ModifyPlanSubImpl
    extends PlanBuilderImpl.ModifyPlanImpl {
        ModifyPlanSubImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            this((PlanBuilderBaseImpl.PlanBaseImpl)null, fnPrefix, fnName, fnArgs);
        }

        ModifyPlanSubImpl(PlanBuilderBaseImpl.PlanBaseImpl prior, String fnPrefix, String fnName, Object[] fnArgs) {
            super(prior, fnPrefix, fnName, fnArgs);
        }

        @Override
        public PlanBuilder.ModifyPlan annTopK(int k, PlanColumn vectorColumn, ServerExpression queryVector, PlanColumn distanceColumn, Map<String, Object> options) {
            return new ModifyPlanSubImpl(this, "op", "annTopK", new Object[]{k, vectorColumn, queryVector, distanceColumn, new BaseTypeImpl.BaseMapImpl(options)});
        }

        @Override
        public PlanBuilder.ModifyPlan patch(String docColumn, PatchBuilder patchDef) {
            return new ModifyPlanSubImpl(this, "op", "patch", new Object[]{this.col(docColumn), patchDef});
        }

        @Override
        public PlanBuilder.ModifyPlan patch(PlanExprCol docColumn, PatchBuilder patchDef) {
            return new ModifyPlanSubImpl(this, "op", "patch", new Object[]{docColumn, patchDef});
        }

        @Override
        public PlanBuilder.ModifyPlan groupByUnion(PlanGroupSeq keys) {
            return this.groupByUnion(keys, null);
        }

        @Override
        public PlanBuilder.ModifyPlan groupByUnion(PlanGroupSeq keys, PlanAggregateColSeq aggregates) {
            return new ModifyPlanSubImpl(this, "op", "group-by-union", new Object[]{keys, aggregates});
        }

        @Override
        public PlanBuilder.ModifyPlan groupToArrays(PlanNamedGroupSeq keys) {
            return this.groupToArrays(keys, null);
        }

        @Override
        public PlanBuilder.ModifyPlan groupToArrays(PlanNamedGroupSeq keys, PlanAggregateColSeq aggregates) {
            return new ModifyPlanSubImpl(this, "op", "group-to-arrays", new Object[]{keys, aggregates});
        }

        @Override
        public PlanBuilder.ModifyPlan facetBy(PlanNamedGroupSeq keys) {
            if (keys == null) {
                throw new IllegalArgumentException("keys parameter for facetBy() cannot be null");
            }
            return new ModifyPlanSubImpl(this, "op", "facet-by", new Object[]{keys});
        }

        @Override
        public PlanBuilder.ModifyPlan facetBy(PlanNamedGroupSeq keys, String countCol) {
            return this.facetBy(keys, countCol == null ? null : this.exprCol(countCol));
        }

        @Override
        public PlanBuilder.ModifyPlan facetBy(PlanNamedGroupSeq keys, PlanExprCol countCol) {
            if (keys == null) {
                throw new IllegalArgumentException("keys parameter for facetBy() cannot be null");
            }
            return new ModifyPlanSubImpl(this, "op", "facet-by", new Object[]{keys, countCol});
        }

        @Override
        public PlanBuilder.ModifyPlan limit(long length) {
            return this.limit(xs.longVal(length));
        }

        @Override
        public PlanBuilder.ModifyPlan limit(XsLongVal length) {
            return new ModifyPlanSubImpl(this, "op", "limit", new Object[]{length});
        }

        @Override
        public PlanBuilder.ModifyPlan limit(PlanParamExpr length) {
            return new ModifyPlanSubImpl(this, "op", "limit", new Object[]{length});
        }

        @Override
        public PlanBuilder.ModifyPlan lockForUpdate() {
            return new ModifyPlanSubImpl(this, "op", "lockForUpdate", new Object[0]);
        }

        @Override
        public PlanBuilder.ModifyPlan lockForUpdate(PlanColumn uriColumn) {
            return new ModifyPlanSubImpl(this, "op", "lockForUpdate", new Object[]{uriColumn});
        }

        @Override
        public PlanBuilder.ModifyPlan offset(long start) {
            return this.offset(xs.longVal(start));
        }

        @Override
        public PlanBuilder.ModifyPlan offset(XsLongVal start) {
            return new ModifyPlanSubImpl(this, "op", "offset", new Object[]{start});
        }

        @Override
        public PlanBuilder.ModifyPlan offset(PlanParamExpr start) {
            return new ModifyPlanSubImpl(this, "op", "offset", new Object[]{start});
        }

        @Override
        public PlanBuilder.ModifyPlan offsetLimit(long start, long length) {
            return this.offsetLimit(xs.longVal(start), xs.longVal(length));
        }

        @Override
        public PlanBuilder.ModifyPlan offsetLimit(XsLongVal start, XsLongVal length) {
            return new ModifyPlanSubImpl(this, "op", "offset-limit", new Object[]{start, length});
        }

        @Override
        public PlanBuilder.ModifyPlan remove() {
            return new ModifyPlanSubImpl(this, "op", "remove", new Object[0]);
        }

        @Override
        public PlanBuilder.ModifyPlan remove(PlanColumn uriColumn) {
            return new ModifyPlanSubImpl(this, "op", "remove", new Object[]{uriColumn});
        }

        @Override
        public PlanBuilder.ModifyPlan remove(PlanColumn temporalCollection, PlanColumn uriColumn) {
            return new ModifyPlanSubImpl(this, "op", "remove", new Object[]{new TemporalRemoval(temporalCollection, uriColumn)});
        }

        @Override
        public PlanBuilder.ModifyPlan transformDoc(PlanColumn docColumn, TransformDef transformDef) {
            return new ModifyPlanSubImpl(this, "op", "transformDoc", new Object[]{docColumn, transformDef});
        }

        @Override
        public PlanBuilder.ModifyPlan where(ServerExpression condition) {
            return new ModifyPlanSubImpl(this, "op", "where", new Object[]{condition});
        }

        @Override
        public PlanBuilder.ModifyPlan where(CtsQueryExpr condition) {
            return new ModifyPlanSubImpl(this, "op", "where", new Object[]{condition});
        }

        @Override
        public PlanBuilder.ModifyPlan where(PlanCondition condition) {
            return new ModifyPlanSubImpl(this, "op", "where", new Object[]{condition});
        }

        @Override
        public PlanBuilder.ModifyPlan where(SemStoreExpr condition) {
            return new ModifyPlanSubImpl(this, "op", "where", new Object[]{condition});
        }

        static class TemporalRemoval
        implements BaseTypeImpl.BaseArgImpl {
            private final String template;

            public TemporalRemoval(PlanColumn temporalCollection, PlanColumn uriColumn) {
                this.template = String.format("{\"temporalCollection\":%s, \"uri\": %s}", ((BaseTypeImpl.BaseArgImpl)((Object)temporalCollection)).exportAst(new StringBuilder()), ((BaseTypeImpl.BaseArgImpl)((Object)uriColumn)).exportAst(new StringBuilder()));
            }

            @Override
            public StringBuilder exportAst(StringBuilder strb) {
                return strb.append(this.template);
            }
        }
    }

    static class PreparePlanSubImpl
    extends PlanBuilderImpl.PreparePlanImpl {
        PreparePlanSubImpl(PlanBuilderBaseImpl.PlanBaseImpl prior, String fnPrefix, String fnName, Object[] fnArgs) {
            super(prior, fnPrefix, fnName, fnArgs);
        }
    }

    static class ExportablePlanSubImpl
    extends PlanBuilderImpl.ExportablePlanImpl {
        ExportablePlanSubImpl(PlanBuilderBaseImpl.PlanBaseImpl prior, String fnPrefix, String fnName, Object[] fnArgs) {
            super(prior, fnPrefix, fnName, fnArgs);
        }

        @Override
        public <T extends JSONReadHandle> T export(T handle) {
            Utilities.setHandleToString(handle, this.getAst());
            return handle;
        }

        @Override
        public <T> T exportAs(Class<T> as) {
            if (as == null) {
                throw new IllegalArgumentException("Must specify a class to export content with a registered handle");
            }
            ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
            if (handle == null) {
                throw new IllegalArgumentException("No handle registered for class: " + as.getName());
            }
            if (!(handle instanceof JSONReadHandle)) {
                throw new IllegalArgumentException("Cannot parse JSON with handle registered for class: " + as.getName());
            }
            this.export((JSONReadHandle)((Object)handle));
            return handle.get();
        }
    }

    static class PlanSubImpl
    extends PlanBuilderImpl.PlanImpl {
        private PlanBuilderBaseImpl.PlanBaseImpl prior = null;
        private String fnPrefix = null;
        private String fnName = null;
        private Object[] fnArgs = null;
        private Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params = null;
        private List<ContentParam> contentParams;

        PlanSubImpl(PlanBuilderBaseImpl.PlanBaseImpl prior, String fnPrefix, String fnName, Object[] fnArgs) {
            super(prior, fnPrefix, fnName, fnArgs);
            this.prior = prior;
            this.fnPrefix = fnPrefix;
            this.fnName = fnName;
            this.fnArgs = fnArgs;
        }

        private PlanSubImpl(PlanBuilderBaseImpl.PlanBaseImpl prior, String fnPrefix, String fnName, Object[] fnArgs, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params, List<ContentParam> contentParams) {
            this(prior, fnPrefix, fnName, fnArgs);
            this.params = params;
            this.contentParams = contentParams;
        }

        @Override
        public Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> getParams() {
            return this.params;
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, boolean literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, boolean literal) {
            return this.bindParam(param, new XsValueImpl.BooleanValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, byte literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), new XsValueImpl.ByteValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, byte literal) {
            return this.bindParam(param, new XsValueImpl.ByteValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, double literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), new XsValueImpl.DoubleValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, double literal) {
            return this.bindParam(param, new XsValueImpl.DoubleValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, float literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), new XsValueImpl.FloatValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, float literal) {
            return this.bindParam(param, new XsValueImpl.FloatValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, int literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), new XsValueImpl.IntValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, int literal) {
            return this.bindParam(param, new XsValueImpl.IntValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, long literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), new XsValueImpl.LongValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, long literal) {
            return this.bindParam(param, new XsValueImpl.LongValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, short literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), new XsValueImpl.ShortValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, short literal) {
            return this.bindParam(param, new XsValueImpl.ShortValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, String literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), new XsValueImpl.StringValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, String literal) {
            return this.bindParam(param, new XsValueImpl.StringValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, PlanParamBindingVal literal) {
            if (!(param instanceof PlanBuilderBaseImpl.PlanParamBase)) {
                throw new IllegalArgumentException("param must be an instance of PlanParamBase");
            }
            HashMap<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> nextParams = new HashMap<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder>();
            if (this.params != null) {
                nextParams.putAll(this.params);
            }
            if (literal instanceof XsValueImpl.AnyAtomicTypeValImpl) {
                nextParams.put((PlanBuilderBaseImpl.PlanParamBase)param, (XsValueImpl.AnyAtomicTypeValImpl)((Object)literal));
            } else if (literal instanceof RdfValueImpl.RdfLangStringValImpl) {
                nextParams.put((PlanBuilderBaseImpl.PlanParamBase)param, (RdfValueImpl.RdfLangStringValImpl)literal);
            } else if (literal instanceof SemValueImpl.SemIriValImpl) {
                nextParams.put((PlanBuilderBaseImpl.PlanParamBase)param, (SemValueImpl.SemIriValImpl)literal);
            } else {
                throw new IllegalArgumentException("cannot set value with unknown implementation");
            }
            return new PlanSubImpl(this.prior, this.fnPrefix, this.fnName, this.fnArgs, nextParams, this.contentParams);
        }

        @Override
        public PlanBuilder.Plan bindParam(String param, DocumentWriteSet writeSet) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(param), writeSet);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, DocumentWriteSet writeSet) {
            if (!(param instanceof PlanBuilderBaseImpl.PlanParamBase)) {
                throw new IllegalArgumentException("param must be an instance of PlanParamBase");
            }
            ArrayList<ContentParam> nextContentParams = new ArrayList<ContentParam>();
            if (this.contentParams != null) {
                nextContentParams.addAll(this.contentParams);
            }
            nextContentParams.add(ContentParam.fromDocumentWriteSet((PlanBuilderBaseImpl.PlanParamBase)param, writeSet));
            return new PlanSubImpl(this.prior, this.fnPrefix, this.fnName, this.fnArgs, this.params, nextContentParams);
        }

        @Override
        public PlanBuilder.Plan bindParam(String param, AbstractWriteHandle content) {
            return this.bindParam(new PlanBuilderBaseImpl.PlanParamBase(param), content, null);
        }

        @Override
        public PlanBuilder.Plan bindParam(String param, AbstractWriteHandle content, Map<String, Map<String, AbstractWriteHandle>> columnAttachments) {
            return this.bindParam(new PlanBuilderBaseImpl.PlanParamBase(param), content, columnAttachments);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, AbstractWriteHandle content, Map<String, Map<String, AbstractWriteHandle>> columnAttachments) {
            if (!(param instanceof PlanBuilderBaseImpl.PlanParamBase)) {
                throw new IllegalArgumentException("param must be an instance of PlanParamBase");
            }
            PlanBuilderBaseImpl.PlanParamBase baseParam = (PlanBuilderBaseImpl.PlanParamBase)param;
            ArrayList<ContentParam> nextContentParams = new ArrayList<ContentParam>();
            if (this.contentParams != null) {
                nextContentParams.addAll(this.contentParams);
            }
            nextContentParams.add(new ContentParam(baseParam, content, columnAttachments));
            return new PlanSubImpl(this.prior, this.fnPrefix, this.fnName, this.fnArgs, this.params, nextContentParams);
        }

        @Override
        public List<ContentParam> getContentParams() {
            return this.contentParams;
        }
    }

    static class ParamCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanParamExpr {
        ParamCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class PlanSparqlOptionsImpl
    implements PlanSparqlOptions {
        private PlanBuilderBaseImpl pb;
        private XsBooleanVal deduplicate;
        private XsStringVal base;

        PlanSparqlOptionsImpl(PlanBuilderBaseImpl pb) {
            this.pb = pb;
        }

        PlanSparqlOptionsImpl(PlanBuilderBaseImpl pb, XsBooleanVal deduplicate, XsStringVal base) {
            this(pb);
            this.deduplicate = deduplicate;
            this.base = base;
        }

        @Override
        public XsStringVal getBase() {
            return this.base;
        }

        @Override
        public PlanSparqlOptions withBase(String base) {
            return this.withBase(this.pb.xs.string(base));
        }

        @Override
        public PlanSparqlOptions withBase(XsStringVal base) {
            return new PlanSparqlOptionsImpl(this.pb, this.deduplicate, base);
        }

        @Override
        public XsBooleanVal getDeduplicated() {
            return this.deduplicate;
        }

        @Override
        public PlanSparqlOptions withDeduplicated(boolean deduplicate) {
            return this.withDeduplicated(this.pb.xs.booleanVal(deduplicate));
        }

        @Override
        public PlanSparqlOptions withDeduplicated(XsBooleanVal deduplicate) {
            return new PlanSparqlOptionsImpl(this.pb, deduplicate, this.base);
        }
    }

    static class PlanSampleByOptionsImpl
    implements PlanSampleByOptions {
        private PlanBuilderBaseImpl pb;
        private XsIntVal limit;

        PlanSampleByOptionsImpl(PlanBuilderBaseImpl pb) {
            this.pb = pb;
        }

        PlanSampleByOptionsImpl(PlanBuilderBaseImpl pb, XsIntVal limit) {
            this(pb);
            this.limit = limit;
        }

        @Override
        public XsIntVal getLimit() {
            return this.limit;
        }

        @Override
        public PlanSampleByOptions withLimit(int limit) {
            return this.withLimit(this.pb.xs.intVal(limit));
        }

        @Override
        public PlanSampleByOptions withLimit(XsIntVal limit) {
            return new PlanSampleByOptionsImpl(this.pb, limit);
        }
    }

    static class PlanGroupConcatOptionSeqImpl
    implements PlanGroupConcatOptionSeq {
        private String separator;
        private PlanValueOption option;

        PlanGroupConcatOptionSeqImpl(String separator, PlanValueOption option) {
            this.separator = separator;
            this.option = option;
        }

        PlanValueOption getOption() {
            return this.option;
        }

        String getSeparator() {
            return this.separator;
        }
    }

    static class PlanDocDescriptorSeqImpl
    implements PlanDocDescriptorSeq,
    BaseTypeImpl.BaseArgImpl {
        private String template;

        public PlanDocDescriptorSeqImpl(DocumentWriteSet writeSet) {
            this.template = DocDescriptorUtil.buildDocDescriptors(writeSet).toString();
        }

        @Override
        public StringBuilder exportAst(StringBuilder strb) {
            return strb.append(this.template);
        }
    }

    public static class PlanDocDescriptorImpl
    implements PlanDocDescriptor,
    BaseTypeImpl.BaseArgImpl {
        private String template;
        private static ObjectMapper mapper = new ObjectMapper();

        public PlanDocDescriptorImpl(DocumentWriteOperation writeOp) {
            ObjectNode node = mapper.createObjectNode();
            DocDescriptorUtil.populateDocDescriptor(writeOp, node);
            this.template = node.toString();
        }

        @Override
        public StringBuilder exportAst(StringBuilder strb) {
            return strb.append(this.template);
        }
    }
}

