/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.XmlFactories;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.FileHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputSourceHandle;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.JacksonParserHandle;
import com.marklogic.client.io.OutputStreamHandle;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.ReaderHandle;
import com.marklogic.client.io.SourceHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.XMLEventReaderHandle;
import com.marklogic.client.io.XMLStreamReaderHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.BinaryWriteHandle;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NodeConverter {
    private static ObjectMapper mapper;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static XMLInputFactory xmlInputFactory;

    private NodeConverter() {
    }

    private static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (documentBuilderFactory == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            documentBuilderFactory = factory;
        }
        return documentBuilderFactory;
    }

    private static XMLInputFactory getXMLInputFactory() {
        if (xmlInputFactory == null) {
            xmlInputFactory = XmlFactories.makeNewInputFactory();
        }
        return xmlInputFactory;
    }

    public static BinaryWriteHandle BinaryWriter(BinaryWriteHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.BINARY);
    }

    public static Stream<BinaryWriteHandle> BinaryWriter(Stream<? extends BinaryWriteHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::BinaryWriter);
    }

    public static BinaryReadHandle BinaryReader(BinaryReadHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.BINARY);
    }

    public static Stream<BinaryReadHandle> BinaryReader(Stream<? extends BinaryReadHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::BinaryReader);
    }

    public static JSONWriteHandle JSONWriter(JSONWriteHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.JSON);
    }

    public static Stream<JSONWriteHandle> JSONWriter(Stream<? extends JSONWriteHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::JSONWriter);
    }

    public static JSONReadHandle JSONReader(JSONReadHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.JSON);
    }

    public static Stream<JSONReadHandle> JSONReader(Stream<? extends JSONReadHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::JSONReader);
    }

    public static TextWriteHandle TextWriter(TextWriteHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.TEXT);
    }

    public static Stream<TextWriteHandle> TextWriter(Stream<? extends TextWriteHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::TextWriter);
    }

    public static TextReadHandle TextReader(TextReadHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.TEXT);
    }

    public static Stream<TextReadHandle> TextReader(Stream<? extends TextReadHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::TextReader);
    }

    public static XMLWriteHandle XMLWriter(XMLWriteHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.XML);
    }

    public static Stream<XMLWriteHandle> XMLWriter(Stream<? extends XMLWriteHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::XMLWriter);
    }

    public static XMLReadHandle XMLReader(XMLReadHandle handle) {
        return handle == null ? null : NodeConverter.withFormat(handle, Format.XML);
    }

    public static Stream<XMLReadHandle> XMLReader(Stream<? extends XMLReadHandle> handles) {
        return handles == null ? null : handles.map(NodeConverter::XMLReader);
    }

    public static <T> T withFormat(T handle, Format format) {
        if (handle != null) {
            if (!(handle instanceof BaseHandle)) {
                throw new IllegalArgumentException("cannot set format on handle of " + handle.getClass().getName());
            }
            if (format != null) {
                ((BaseHandle)handle).setFormat(format);
            }
        }
        return handle;
    }

    public static <T extends AbstractWriteHandle> Stream<T> streamWithFormat(Stream<T> handles, Format format) {
        if (handles == null || format == null) {
            return handles;
        }
        Formatter formatter = new Formatter(format);
        return handles.map(formatter);
    }

    public static <T> T[] arrayWithFormat(T[] handles, Format format) {
        if (handles == null) {
            return handles;
        }
        for (T handle : handles) {
            NodeConverter.withFormat(handle, format);
        }
        return handles;
    }

    public static BytesHandle BytesToHandle(byte[] value) {
        return value == null ? null : new BytesHandle(value);
    }

    public static Stream<BytesHandle> BytesToHandle(Stream<? extends byte[]> values) {
        return values == null ? null : values.map(NodeConverter::BytesToHandle);
    }

    public static BytesHandle[] BytesToHandle(byte[][] values) {
        return values == null ? null : NodeConverter.convert(values, new BytesHandle[values.length], NodeConverter::BytesToHandle);
    }

    public static DOMHandle DocumentToHandle(Document value) {
        return value == null ? null : new DOMHandle(value);
    }

    public static Stream<DOMHandle> DocumentToHandle(Stream<? extends Document> values) {
        return values == null ? null : values.map(NodeConverter::DocumentToHandle);
    }

    public static DOMHandle[] DocumentToHandle(Document[] values) {
        return values == null ? null : NodeConverter.convert(values, new DOMHandle[values.length], NodeConverter::DocumentToHandle);
    }

    public static FileHandle FileToHandle(File value) {
        return value == null ? null : new FileHandle(value);
    }

    public static Stream<FileHandle> FileToHandle(Stream<? extends File> values) {
        return values == null ? null : values.map(NodeConverter::FileToHandle);
    }

    public static FileHandle[] FileToHandle(File[] values) {
        return values == null ? null : NodeConverter.convert(values, new FileHandle[values.length], NodeConverter::FileToHandle);
    }

    public static InputStreamHandle InputStreamToHandle(InputStream value) {
        return value == null ? null : new InputStreamHandle(value);
    }

    public static Stream<InputStreamHandle> InputStreamToHandle(Stream<? extends InputStream> values) {
        return values == null ? null : values.map(NodeConverter::InputStreamToHandle);
    }

    public static InputStreamHandle[] InputStreamToHandle(InputStream[] values) {
        return values == null ? null : NodeConverter.convert(values, new InputStreamHandle[values.length], NodeConverter::InputStreamToHandle);
    }

    public static InputSourceHandle InputSourceToHandle(InputSource value) {
        return value == null ? null : new InputSourceHandle(value);
    }

    public static Stream<InputSourceHandle> InputSourceToHandle(Stream<? extends InputSource> values) {
        return values == null ? null : values.map(NodeConverter::InputSourceToHandle);
    }

    public static InputSourceHandle[] InputSourceToHandle(InputSource[] values) {
        return values == null ? null : NodeConverter.convert(values, new InputSourceHandle[values.length], NodeConverter::InputSourceToHandle);
    }

    public static JacksonHandle JsonNodeToHandle(JsonNode value) {
        return value == null ? null : new JacksonHandle(value);
    }

    public static Stream<JacksonHandle> JsonNodeToHandle(Stream<? extends JsonNode> values) {
        return values == null ? null : values.map(NodeConverter::JsonNodeToHandle);
    }

    public static JacksonHandle[] JsonNodeToHandle(JsonNode[] values) {
        return values == null ? null : NodeConverter.convert(values, new JacksonHandle[values.length], NodeConverter::JsonNodeToHandle);
    }

    public static JacksonParserHandle JsonParserToHandle(JsonParser value) {
        if (value == null) {
            return null;
        }
        JacksonParserHandle handle = new JacksonParserHandle();
        handle.set(value);
        return handle;
    }

    public static Stream<JacksonParserHandle> JsonParserToHandle(Stream<? extends JsonParser> values) {
        return values == null ? null : values.map(NodeConverter::JsonParserToHandle);
    }

    public static JacksonParserHandle[] JsonParserToHandle(JsonParser[] values) {
        return values == null ? null : NodeConverter.convert(values, new JacksonParserHandle[values.length], NodeConverter::JsonParserToHandle);
    }

    public static ArrayNode ReaderToArrayNode(Reader value) {
        try {
            return value == null ? null : (ArrayNode)NodeConverter.getMapper().readValue(value, ArrayNode.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<ArrayNode> ReaderToArrayNode(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToArrayNode);
    }

    public static JsonNode ReaderToJsonNode(Reader value) {
        try {
            return value == null ? null : NodeConverter.getMapper().readTree(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<JsonNode> ReaderToJsonNode(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToJsonNode);
    }

    public static ObjectNode ReaderToObjectNode(Reader value) {
        try {
            return value == null ? null : (ObjectNode)NodeConverter.getMapper().readValue(value, ObjectNode.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<ObjectNode> ReaderToObjectNode(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToObjectNode);
    }

    public static JsonParser ReaderToJsonParser(Reader value) {
        try {
            return value == null ? null : NodeConverter.getMapper().getFactory().createParser(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<JsonParser> ReaderToJsonParser(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToJsonParser);
    }

    public static Document InputStreamToDocument(InputStream inputStream) {
        try {
            return inputStream == null ? null : NodeConverter.getDocumentBuilderFactory().newDocumentBuilder().parse(inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<Document> InputStreamToDocument(Stream<? extends InputStream> values) {
        return values == null ? null : values.map(NodeConverter::InputStreamToDocument);
    }

    public static File InputStreamToFile(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            Path tempFile = Files.createTempFile("tmp", null, new FileAttribute[0]);
            Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            return tempFile.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputSource ReaderToInputSource(Reader reader) {
        return reader == null ? null : new InputSource(reader);
    }

    public static Stream<InputSource> ReaderToInputSource(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToInputSource);
    }

    public static Source ReaderToSource(Reader reader) {
        return reader == null ? null : new StreamSource(reader);
    }

    public static Stream<Source> ReaderToSource(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToSource);
    }

    public static XMLEventReader ReaderToXMLEventReader(Reader reader) {
        try {
            return reader == null ? null : NodeConverter.getXMLInputFactory().createXMLEventReader(reader);
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<XMLEventReader> ReaderToXMLEventReader(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToXMLEventReader);
    }

    public static XMLStreamReader ReaderToXMLStreamReader(Reader reader) {
        try {
            return reader == null ? null : NodeConverter.getXMLInputFactory().createXMLStreamReader(reader);
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<XMLStreamReader> ReaderToXMLStreamReader(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToXMLStreamReader);
    }

    public static OutputStreamHandle OutputStreamSenderToHandle(OutputStreamSender value) {
        return value == null ? null : new OutputStreamHandle(value);
    }

    public static Stream<OutputStreamHandle> OutputStreamSenderToHandle(Stream<? extends OutputStreamSender> values) {
        return values == null ? null : values.map(NodeConverter::OutputStreamSenderToHandle);
    }

    public static OutputStreamHandle[] OutputStreamSenderToHandle(OutputStreamSender[] values) {
        return values == null ? null : NodeConverter.convert(values, new OutputStreamHandle[values.length], NodeConverter::OutputStreamSenderToHandle);
    }

    public static ReaderHandle ReaderToHandle(Reader value) {
        return value == null ? null : new ReaderHandle(value);
    }

    public static Stream<ReaderHandle> ReaderToHandle(Stream<? extends Reader> values) {
        return values == null ? null : values.map(NodeConverter::ReaderToHandle);
    }

    public static ReaderHandle[] ReaderToHandle(Reader[] values) {
        return values == null ? null : NodeConverter.convert(values, new ReaderHandle[values.length], NodeConverter::ReaderToHandle);
    }

    public static StringHandle StringToHandle(String value) {
        return value == null ? null : new StringHandle(value);
    }

    public static Stream<StringHandle> StringToHandle(Stream<? extends String> values) {
        return values == null ? null : values.map(NodeConverter::StringToHandle);
    }

    public static StringHandle[] StringToHandle(String[] values) {
        return values == null ? null : NodeConverter.convert(values, new StringHandle[values.length], NodeConverter::StringToHandle);
    }

    public static SourceHandle SourceToHandle(Source value) {
        return value == null ? null : new SourceHandle(value);
    }

    public static Stream<SourceHandle> SourceToHandle(Stream<? extends Source> values) {
        return values == null ? null : values.map(NodeConverter::SourceToHandle);
    }

    public static SourceHandle[] SourceToHandle(Source[] values) {
        return values == null ? null : NodeConverter.convert(values, new SourceHandle[values.length], NodeConverter::SourceToHandle);
    }

    public static XMLEventReaderHandle XMLEventReaderToHandle(XMLEventReader value) {
        return value == null ? null : new XMLEventReaderHandle(value);
    }

    public static Stream<XMLEventReaderHandle> XMLEventReaderToHandle(Stream<? extends XMLEventReader> values) {
        return values == null ? null : values.map(NodeConverter::XMLEventReaderToHandle);
    }

    public static XMLEventReaderHandle[] XMLEventReaderToHandle(XMLEventReader[] values) {
        return values == null ? null : NodeConverter.convert(values, new XMLEventReaderHandle[values.length], NodeConverter::XMLEventReaderToHandle);
    }

    public static XMLStreamReaderHandle XMLStreamReaderToHandle(XMLStreamReader value) {
        return value == null ? null : new XMLStreamReaderHandle(value);
    }

    public static Stream<XMLStreamReaderHandle> XMLStreamReaderToHandle(Stream<? extends XMLStreamReader> values) {
        return values == null ? null : values.map(NodeConverter::XMLStreamReaderToHandle);
    }

    public static XMLStreamReaderHandle[] XMLStreamReaderToHandle(XMLStreamReader[] values) {
        return values == null ? null : NodeConverter.convert(values, new XMLStreamReaderHandle[values.length], NodeConverter::XMLStreamReaderToHandle);
    }

    public static byte[] InputStreamToBytes(InputStream inputStream) {
        try {
            int byteCount;
            if (inputStream == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((byteCount = inputStream.read(buf)) != -1) {
                out.write(buf, 0, byteCount);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Reader InputStreamToReader(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return new InputStreamReader(inputStream, StandardCharsets.UTF_8);
    }

    public static String InputStreamToString(InputStream inputStream) {
        return NodeConverter.ReaderToString(NodeConverter.InputStreamToReader(inputStream));
    }

    public static String ReaderToString(Reader reader) {
        try {
            int charCount;
            if (reader == null) {
                return null;
            }
            StringBuilder bldr = new StringBuilder();
            char[] buf = new char[8192];
            while ((charCount = reader.read(buf)) != -1) {
                bldr.append(buf, 0, charCount);
            }
            return bldr.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends JSONReadHandle> T jsonNodeToHandle(JsonNode node, T handle) {
        if (node == null) {
            return null;
        }
        if (handle == null) {
            throw new IllegalArgumentException("cannot convert JSON node to null handle");
        }
        try {
            HandleImplementation handleImpl = HandleAccessor.checkHandle(handle, "json");
            Class as = handleImpl.receiveAs();
            if (as == null) {
                throw new IllegalArgumentException("handle does not specify class to receive content");
            }
            if (byte[].class.isAssignableFrom(as)) {
                handleImpl.receiveContent(NodeConverter.getMapper().writeValueAsBytes((Object)node));
            } else if (File.class.isAssignableFrom(as)) {
                Path tempFile = Files.createTempFile("tmp", ".json", new FileAttribute[0]);
                Files.copy(new ByteArrayInputStream(NodeConverter.getMapper().writeValueAsBytes((Object)node)), tempFile, StandardCopyOption.REPLACE_EXISTING);
                handleImpl.receiveContent(tempFile.toFile());
            } else if (InputStream.class.isAssignableFrom(as)) {
                handleImpl.receiveContent(new ByteArrayInputStream(NodeConverter.getMapper().writeValueAsBytes((Object)node)));
            } else if (Reader.class.isAssignableFrom(as)) {
                handleImpl.receiveContent(new StringReader(NodeConverter.getMapper().writeValueAsString((Object)node)));
            } else if (String.class.isAssignableFrom(as)) {
                handleImpl.receiveContent(NodeConverter.getMapper().writeValueAsString((Object)node));
            } else {
                throw new IllegalArgumentException("handle receives content with unsupported class: " + as.getSimpleName());
            }
            return handle;
        }
        catch (JsonProcessingException e) {
            throw new MarkLogicIOException("could not set handle to JsonNode", e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException("could not create file for JsonNode", e);
        }
    }

    public static JsonNode handleToJsonNode(JSONWriteHandle jsonHandle) {
        if (jsonHandle == null) {
            return null;
        }
        if (!(jsonHandle instanceof ContentHandle)) {
            throw new IllegalArgumentException("JSONWriteHandle must implement ContentHandle: " + jsonHandle.getClass().getCanonicalName());
        }
        Object jsonTree = ((ContentHandle)((Object)jsonHandle)).get();
        if (jsonTree == null || jsonTree instanceof JsonNode) {
            return (JsonNode)jsonTree;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            if (jsonTree instanceof byte[]) {
                return mapper.readTree((byte[])jsonTree);
            }
            if (jsonTree instanceof File) {
                return mapper.readTree((File)jsonTree);
            }
            if (jsonTree instanceof JsonParser) {
                return (JsonNode)mapper.readTree((JsonParser)jsonTree);
            }
            if (jsonTree instanceof InputStream) {
                return mapper.readTree((InputStream)jsonTree);
            }
            if (jsonTree instanceof Reader) {
                return mapper.readTree((Reader)jsonTree);
            }
            if (jsonTree instanceof String) {
                return mapper.readTree((String)jsonTree);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("Could not convert JSON of class: " + jsonTree.getClass().getCanonicalName() + "\n" + jsonTree);
    }

    public static BufferableHandle bufferAsBytes(BufferableHandle handle) {
        return handle == null ? null : new BytesHandle(handle);
    }

    public static BufferableHandle[] bufferAsBytes(BufferableHandle[] handles) {
        if (handles == null || handles.length == 0) {
            return null;
        }
        BufferableHandle[] bufferableBytesHandles = new BufferableHandle[handles.length];
        for (int i = 0; i < handles.length; ++i) {
            bufferableBytesHandles[i] = NodeConverter.bufferAsBytes(handles[i]);
        }
        return bufferableBytesHandles;
    }

    public static <I, O> O[] convert(I[] in, O[] out, Function<I, O> converter) {
        for (int i = 0; i < in.length; ++i) {
            out[i] = converter.apply(in[i]);
        }
        return out;
    }

    public static <I> BufferableHandle[] convert(I[] in, Function<I, BufferableHandle> converter) {
        if (in == null) {
            return null;
        }
        BufferableHandle[] out = new BufferableHandle[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = converter.apply(in[i]);
        }
        return out;
    }

    private static class Formatter<T extends AbstractWriteHandle>
    implements Function<T, T> {
        private final Format format;

        Formatter(Format format) {
            this.format = format;
        }

        @Override
        public T apply(T handle) {
            return (T)((AbstractWriteHandle)NodeConverter.withFormat(handle, this.format));
        }
    }
}

