/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HTTPSamlAuthInterceptor
implements Interceptor {
    private final DatabaseClientFactory.SAMLAuthContext.AuthorizerCallback authorizer;
    private final DatabaseClientFactory.SAMLAuthContext.RenewerCallback renewer;
    private String authorizationTokenValue;
    private DatabaseClientFactory.SAMLAuthContext.ExpiringSAMLAuth expiringSAMLAuth;
    private long threshold;
    private AtomicBoolean isCallbackExecuting;

    public HTTPSamlAuthInterceptor(String authToken) {
        this.authorizationTokenValue = authToken;
        this.authorizer = null;
        this.renewer = null;
    }

    public HTTPSamlAuthInterceptor(DatabaseClientFactory.SAMLAuthContext.AuthorizerCallback authorizer) {
        this.authorizer = authorizer;
        this.renewer = null;
    }

    public HTTPSamlAuthInterceptor(DatabaseClientFactory.SAMLAuthContext.ExpiringSAMLAuth authorization, DatabaseClientFactory.SAMLAuthContext.RenewerCallback renew) {
        this.expiringSAMLAuth = authorization;
        this.renewer = renew;
        this.isCallbackExecuting = new AtomicBoolean(false);
        this.authorizer = null;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (this.authorizer != null) {
            this.authorizeRequest();
        } else if (this.renewer != null && this.threshold <= Instant.now().getEpochSecond() && this.isCallbackExecuting.compareAndSet(false, true)) {
            this.startRenewalOfToken();
        }
        Request authenticatedRequest = chain.request().newBuilder().header("Authorization", this.buildSamlHeader()).build();
        return chain.proceed(authenticatedRequest);
    }

    private synchronized void startRenewalOfToken() {
        RenewCallbackWrapper renewCallbackWrapper = new RenewCallbackWrapper(this.expiringSAMLAuth);
        Executors.defaultThreadFactory().newThread(renewCallbackWrapper).start();
    }

    private synchronized void authorizeRequest() {
        if (this.expiringSAMLAuth == null) {
            this.authorizeCallbackWrapper(null);
        } else if (this.threshold <= Instant.now().getEpochSecond()) {
            this.authorizeCallbackWrapper(this.expiringSAMLAuth.getExpiry());
        }
    }

    private synchronized String buildSamlHeader() {
        return String.format("%s %s=%s", "SAML", "token", this.authorizationTokenValue);
    }

    private synchronized void authorizeCallbackWrapper(Instant expiry) {
        if (expiry == null && this.expiringSAMLAuth != null) {
            return;
        }
        if (expiry != null && expiry != this.expiringSAMLAuth.getExpiry()) {
            return;
        }
        this.expiringSAMLAuth = (DatabaseClientFactory.SAMLAuthContext.ExpiringSAMLAuth)this.authorizer.apply(this.expiringSAMLAuth);
        if (this.expiringSAMLAuth == null) {
            throw new IllegalArgumentException("SAML Authentication cannot be null");
        }
        if (this.expiringSAMLAuth.getAuthorizationToken() == null) {
            throw new IllegalArgumentException("SAML Authentication token cannot be null");
        }
        this.authorizationTokenValue = this.expiringSAMLAuth.getAuthorizationToken();
        this.setThreshold(this.expiringSAMLAuth.getExpiry());
    }

    private void setThreshold(Instant instant) {
        if (instant == null) {
            throw new IllegalArgumentException("SAML authentication does not have expiry value.");
        }
        if (instant.isBefore(Instant.now())) {
            throw new IllegalArgumentException("SAML authentication token has expired.");
        }
        long current = Instant.now().getEpochSecond();
        this.threshold = current + (instant.getEpochSecond() - current) / 2L;
    }

    private class RenewCallbackWrapper
    implements Runnable {
        private final DatabaseClientFactory.SAMLAuthContext.ExpiringSAMLAuth expiringAuth;

        public RenewCallbackWrapper(DatabaseClientFactory.SAMLAuthContext.ExpiringSAMLAuth expiringSamlAuth) {
            this.expiringAuth = expiringSamlAuth;
        }

        @Override
        public void run() {
            try {
                Instant newInstant = (Instant)HTTPSamlAuthInterceptor.this.renewer.apply(this.expiringAuth);
                HTTPSamlAuthInterceptor.this.setThreshold(newInstant);
            }
            finally {
                HTTPSamlAuthInterceptor.this.isCallbackExecuting.set(false);
            }
        }
    }
}

