/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.Page;
import java.util.Iterator;

public class BasicPage<T>
implements Page<T> {
    private Iterator<T> iterator;
    private long start;
    private Long size = null;
    private long pageSize;
    private long totalSize;

    protected BasicPage(Class<T> type) {
    }

    public BasicPage(Iterator<T> iterator, long start, long pageSize, long totalSize) {
        this.iterator = iterator;
        this.start = start;
        this.pageSize = pageSize;
        this.totalSize = totalSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public long getStart() {
        return this.start;
    }

    public BasicPage<T> setStart(long start) {
        this.start = start;
        return this;
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    public BasicPage<T> setPageSize(long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    public BasicPage<T> setTotalSize(long totalSize) {
        this.totalSize = totalSize;
        return this;
    }

    public BasicPage<T> setSize(long size) {
        this.size = size;
        return this;
    }

    @Override
    public long size() {
        if (this.size != null) {
            return this.size;
        }
        if (this.getPageSize() == 0L) {
            return 0L;
        }
        if (this.hasNextPage()) {
            return this.getPageSize();
        }
        if (this.getTotalSize() % this.getPageSize() == 0L) {
            return this.getPageSize();
        }
        return this.getTotalSize() % this.getPageSize();
    }

    @Override
    public long getTotalPages() {
        return this.ceilingDivision(this.getTotalSize(), this.getPageSize());
    }

    @Override
    public boolean hasContent() {
        return this.size() > 0L;
    }

    @Override
    public boolean hasNextPage() {
        return this.getPageNumber() < this.getTotalPages();
    }

    @Override
    public boolean hasPreviousPage() {
        return this.getPageNumber() > 1L;
    }

    @Override
    public long getPageNumber() {
        return this.ceilingDivision(this.getStart(), this.getPageSize());
    }

    private long ceilingDivision(long dividend, long divisor) {
        if (divisor == 0L) {
            return 0L;
        }
        long quotient = dividend / divisor;
        return dividend % divisor == 0L ? quotient : quotient + 1L;
    }

    @Override
    public boolean isFirstPage() {
        if (this.getPageSize() == 0L) {
            return true;
        }
        return this.getPageNumber() == 1L;
    }

    @Override
    public boolean isLastPage() {
        if (this.getPageSize() == 0L) {
            return true;
        }
        return this.getPageNumber() == this.getTotalPages();
    }
}

