/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.document;

import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;

public interface DocumentWriteOperation
extends Comparable<DocumentWriteOperation> {
    public OperationType getOperationType();

    public String getUri();

    public DocumentMetadataWriteHandle getMetadata();

    public AbstractWriteHandle getContent();

    public String getTemporalDocumentURI();

    public static Stream<DocumentWriteOperation> from(Stream<? extends AbstractWriteHandle> content, DocumentUriMaker uriMaker) {
        if (content == null || uriMaker == null) {
            throw new IllegalArgumentException("Content and/or Uri maker cannot be null");
        }
        return content.map(handle -> {
            String uri = (String)uriMaker.apply(handle);
            return new DocumentWriteOperationImpl(uri, (AbstractWriteHandle)handle);
        });
    }

    public static DocumentUriMaker uriMaker(String format) throws IllegalArgumentException {
        if (format == null || format.length() == 0) {
            throw new IllegalArgumentException("Format cannot be null or empty");
        }
        return content -> String.format(format, UUID.randomUUID());
    }

    @FunctionalInterface
    public static interface DocumentUriMaker
    extends Function<AbstractWriteHandle, String> {
    }

    public static enum OperationType {
        METADATA_DEFAULT,
        DISABLE_METADATA_DEFAULT,
        DOCUMENT_WRITE;

    }
}

