/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.dataservices.IOEndpoint;
import com.marklogic.client.dataservices.OutputCaller;
import com.marklogic.client.dataservices.impl.CallContextImpl;
import com.marklogic.client.dataservices.impl.HandleProvider;
import com.marklogic.client.dataservices.impl.IOEndpointImpl;
import com.marklogic.client.dataservices.impl.OutputCallerImpl;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputEndpointImpl<I, O>
extends IOEndpointImpl<I, O>
implements OutputCaller<O> {
    private static final Logger logger = LoggerFactory.getLogger(OutputEndpointImpl.class);
    private final OutputCallerImpl<I, O> caller;

    public OutputEndpointImpl(DatabaseClient client, JSONWriteHandle apiDecl, HandleProvider<I, O> handleProvider) {
        this(client, new OutputCallerImpl<I, O>(apiDecl, handleProvider));
    }

    private OutputEndpointImpl(DatabaseClient client, OutputCallerImpl<I, O> caller) {
        super(client, caller);
        this.caller = caller;
    }

    private OutputCallerImpl<I, O> getCaller() {
        return this.caller;
    }

    @Override
    public O[] call() {
        return this.getResponseData(this.newCallContext());
    }

    @Override
    public O[] call(IOEndpoint.CallContext callContext) {
        return this.getResponseData(callContext);
    }

    @Override
    public OutputCaller.BulkOutputCaller<O> bulkCaller() {
        return new BulkOutputCallerImpl(this);
    }

    @Override
    public OutputCaller.BulkOutputCaller<O> bulkCaller(IOEndpoint.CallContext callContext) {
        return new BulkOutputCallerImpl(this, this.checkAllowedArgs(callContext));
    }

    @Override
    public OutputCaller.BulkOutputCaller<O> bulkCaller(IOEndpoint.CallContext[] callContexts) {
        if (callContexts == null || callContexts.length == 0) {
            throw new IllegalArgumentException("CallContext cannot be null or empty");
        }
        return this.bulkCaller(callContexts, callContexts.length);
    }

    @Override
    public OutputCaller.BulkOutputCaller<O> bulkCaller(IOEndpoint.CallContext[] callContexts, int threadCount) {
        if (callContexts == null) {
            throw new IllegalArgumentException("CallContext cannot be null");
        }
        if (threadCount > callContexts.length) {
            throw new IllegalArgumentException("Thread count cannot be more than the callContext count.");
        }
        switch (callContexts.length) {
            case 0: {
                throw new IllegalArgumentException("CallContext cannot be empty");
            }
            case 1: {
                return new BulkOutputCallerImpl(this, this.checkAllowedArgs(callContexts[0]));
            }
        }
        return new BulkOutputCallerImpl(this, (CallContextImpl[])this.checkAllowedArgs(callContexts), threadCount);
    }

    private O[] getResponseData(IOEndpoint.CallContext callContext) {
        return this.getCaller().arrayCall(this.getClient(), this.checkAllowedArgs(callContext));
    }

    public static class BulkOutputCallerImpl<I, O>
    extends IOEndpointImpl.BulkIOEndpointCallerImpl<I, O>
    implements OutputCaller.BulkOutputCaller<O> {
        private final OutputEndpointImpl<I, O> endpoint;
        private Consumer<O> outputListener;
        private OutputCaller.BulkOutputCaller.ErrorListener errorListener;
        private AtomicInteger aliveCallContextCount;

        public BulkOutputCallerImpl(OutputEndpointImpl<I, O> endpoint) {
            this(endpoint, endpoint.checkAllowedArgs(endpoint.newCallContext()));
        }

        private BulkOutputCallerImpl(OutputEndpointImpl<I, O> endpoint, CallContextImpl<I, O> callContext) {
            super(endpoint, callContext);
            this.checkEndpoint(endpoint, "OutputEndpointImpl");
            this.endpoint = endpoint;
        }

        private BulkOutputCallerImpl(OutputEndpointImpl<I, O> endpoint, CallContextImpl<I, O>[] callContexts, int threadCount) {
            super(endpoint, callContexts, threadCount, threadCount);
            this.endpoint = endpoint;
            this.aliveCallContextCount = new AtomicInteger(threadCount);
        }

        private OutputEndpointImpl<I, O> getEndpoint() {
            return this.endpoint;
        }

        private Consumer<O> getOutputListener() {
            return this.outputListener;
        }

        @Override
        public void setOutputListener(Consumer<O> listener) {
            this.outputListener = listener;
        }

        @Override
        public O[] next() {
            if (this.getCallContext() == null) {
                throw new UnsupportedOperationException("Callcontext cannot be null.");
            }
            if (this.getOutputListener() != null) {
                throw new IllegalStateException("Cannot call next while current output consumer is not empty.");
            }
            return this.getOutputStream(this.getCallContext());
        }

        @Override
        public void setErrorListener(OutputCaller.BulkOutputCaller.ErrorListener errorListener) {
            this.errorListener = errorListener;
        }

        private OutputCaller.BulkOutputCaller.ErrorListener getErrorListener() {
            return this.errorListener;
        }

        @Override
        public void awaitCompletion() {
            if (this.getOutputListener() == null) {
                throw new IllegalStateException("Output consumer is null");
            }
            if (this.getPhase() != IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.INITIALIZING) {
                throw new IllegalStateException("Can only await completion when starting output and not while output is " + this.getPhase().name().toLowerCase());
            }
            this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.RUNNING);
            if (this.getCallContext() != null) {
                this.processOutput();
            } else if (this.getCallContextQueue() != null && !this.getCallContextQueue().isEmpty()) {
                try {
                    for (int i = 0; i < this.getThreadCount(); ++i) {
                        this.submitNewTask();
                    }
                    this.getCallerThreadPoolExecutor().awaitTermination();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Error occurred while awaiting termination ", throwable);
                }
            } else {
                throw new IllegalArgumentException("Cannot process output without Callcontext.");
            }
        }

        private void submitNewTask() {
            BulkCallableImpl bulkCallableImpl = new BulkCallableImpl(this);
            this.submitTask(bulkCallableImpl);
        }

        private O[] getOutputStream(CallContextImpl<I, O> callContext) {
            IOEndpoint.BulkIOEndpointCaller.ErrorDisposition error = IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.RETRY;
            O[] output = null;
            block9: for (int retryCount = 0; retryCount < 100 && error == IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.RETRY; ++retryCount) {
                Throwable throwable = null;
                try {
                    output = ((OutputEndpointImpl)this.getEndpoint()).getCaller().arrayCall(callContext.getClient(), callContext);
                    this.incrementCallCount();
                    return output;
                }
                catch (Throwable catchedThrowable) {
                    throwable = catchedThrowable;
                    if (throwable == null) continue;
                    if (this.getErrorListener() == null) {
                        logger.error("No error listener set. Stop all calls. " + this.getEndpoint().getEndpointPath(), throwable);
                        error = IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.STOP_ALL_CALLS;
                        continue;
                    }
                    try {
                        error = retryCount < 99 ? this.getErrorListener().processError(retryCount, throwable, callContext) : IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.SKIP_CALL;
                    }
                    catch (Throwable throwable1) {
                        logger.error("Error Listener failed with ", throwable1);
                        error = IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.STOP_ALL_CALLS;
                    }
                    switch (error) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP_CALL: {
                            if (callContext.getEndpoint().allowsEndpointState()) {
                                callContext.withEndpointState(null);
                            }
                            return ((OutputEndpointImpl)this.getEndpoint()).getCaller().newContentOutputArray(0);
                        }
                        case STOP_ALL_CALLS: {
                            if (this.getCallerThreadPoolExecutor() == null) continue block9;
                            this.getCallerThreadPoolExecutor().shutdown();
                        }
                    }
                    continue;
                }
            }
            return output == null ? ((OutputEndpointImpl)this.getEndpoint()).getCaller().newContentOutputArray(0) : output;
        }

        private void processOutput() {
            CallContextImpl callContext = this.getCallContext();
            if (callContext != null) {
                while (this.processOutput(callContext)) {
                }
            }
        }

        private boolean processOutput(CallContextImpl<I, O> callContext) {
            logger.trace("output endpoint={} count={} state={}", new Object[]{callContext.getEndpoint().getEndpointPath(), this.getCallCount(), callContext.getEndpointState()});
            O[] output = this.getOutputStream(callContext);
            this.processOutputBatch(output, this.getOutputListener());
            switch (this.getPhase()) {
                case INTERRUPTING: {
                    this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.INTERRUPTED);
                    logger.info("output interrupted endpoint={} count={} work={}", new Object[]{callContext.getEndpoint().getEndpointPath(), this.getCallCount(), callContext.getEndpointConstants()});
                    return false;
                }
                case RUNNING: {
                    if (output == null || output.length == 0) {
                        if (this.getCallerThreadPoolExecutor() == null || this.aliveCallContextCount.get() == 0) {
                            this.setPhase(IOEndpointImpl.BulkIOEndpointCallerImpl.WorkPhase.COMPLETED);
                        }
                        logger.info("output completed endpoint={} count={} work={}", new Object[]{callContext.getEndpoint().getEndpointPath(), this.getCallCount(), callContext.getEndpointConstants()});
                        return false;
                    }
                    return true;
                }
                case INTERRUPTED: 
                case COMPLETED: {
                    throw new IllegalStateException("cannot process more output as current phase is  " + this.getPhase().name());
                }
            }
            throw new MarkLogicInternalException("unexpected state for " + callContext.getEndpoint().getEndpointPath() + " during loop: " + this.getPhase().name());
        }

        private static class BulkCallableImpl<I, O>
        implements Callable<Boolean> {
            private final BulkOutputCallerImpl<I, O> bulkOutputCallerImpl;

            BulkCallableImpl(BulkOutputCallerImpl<I, O> bulkOutputCallerImpl) {
                this.bulkOutputCallerImpl = bulkOutputCallerImpl;
            }

            @Override
            public Boolean call() {
                try {
                    boolean continueCalling;
                    CallContextImpl callContext = this.bulkOutputCallerImpl.getCallContextQueue().poll();
                    boolean bl = continueCalling = callContext == null ? false : ((BulkOutputCallerImpl)this.bulkOutputCallerImpl).processOutput(callContext);
                    if (continueCalling) {
                        this.bulkOutputCallerImpl.getCallContextQueue().put(callContext);
                        this.bulkOutputCallerImpl.submitTask(this);
                    } else if (this.bulkOutputCallerImpl.getCallerThreadPoolExecutor() != null && ((BulkOutputCallerImpl)this.bulkOutputCallerImpl).aliveCallContextCount.decrementAndGet() == 0) {
                        this.bulkOutputCallerImpl.getCallerThreadPoolExecutor().shutdown();
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    throw new InternalError("Error occurred while processing CallContext - " + throwable.getMessage());
                }
            }
        }
    }
}

