/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.SessionState;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.io.Format;

abstract class BaseCallerImpl {
    private BaseProxy baseProxy = new BaseProxy();

    BaseCallerImpl() {
    }

    BaseProxy getBaseProxy() {
        return this.baseProxy;
    }

    public SessionState newSessionState() {
        return this.baseProxy.newSessionState();
    }

    static boolean getBoolean(JsonNode property, boolean defaultValue) {
        if (property == null) {
            return defaultValue;
        }
        return property.asBoolean(defaultValue);
    }

    static String getText(JsonNode property) {
        if (property == null) {
            return null;
        }
        return property.asText();
    }

    static class ParamdefImpl
    extends ValuedefImpl {
        private String name;

        ParamdefImpl(JsonNode paramDecl) {
            super(paramDecl);
            String paramName = BaseCallerImpl.getText(paramDecl.get("name"));
            if (paramName == null || paramName.length() == 0) {
                throw new IllegalArgumentException("no name in parameter declaration: " + paramDecl.toString());
            }
            this.name = paramName;
            if (!"session".equals(paramName) && this.getFormat() == null) {
                throw new IllegalArgumentException("parameter must accept a document data type: " + paramName);
            }
        }

        public String getParamName() {
            return this.name;
        }
    }

    static class ReturndefImpl
    extends ValuedefImpl {
        ReturndefImpl(JsonNode returnDecl) {
            super(returnDecl);
            if (this.getFormat() == null) {
                throw new IllegalArgumentException("must return a document data type: " + this.getDataType());
            }
        }
    }

    static abstract class ValuedefImpl {
        private String datatype = null;
        private boolean isNullable = false;
        private boolean isMultiple = false;
        private Format format = null;

        ValuedefImpl(JsonNode valueDecl) {
            String datatype = BaseCallerImpl.getText(valueDecl.get("datatype"));
            if (datatype == null || datatype.length() == 0) {
                throw new IllegalArgumentException("no datatype in parameter or return declaration: " + valueDecl.toString());
            }
            this.datatype = datatype;
            this.isNullable = BaseCallerImpl.getBoolean(valueDecl.get("nullable"), false);
            this.isMultiple = BaseCallerImpl.getBoolean(valueDecl.get("multiple"), false);
            if (!"session".equals(datatype)) {
                this.format = Format.getFromDataType(datatype);
                if (this.format == Format.UNKNOWN && !"anyDocument".equals(datatype)) {
                    throw new IllegalArgumentException("datatype must specify a document format: " + datatype);
                }
            }
        }

        public String getDataType() {
            return this.datatype;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        public boolean isMultiple() {
            return this.isMultiple;
        }

        public Format getFormat() {
            return this.format;
        }
    }
}

