/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.NodeOperation;
import com.marklogic.client.datamovement.Splitter;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.impl.XmlFactories;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;

public class XMLSplitter<T extends XMLWriteHandle>
implements Splitter<T> {
    private Visitor<T> visitor;
    private long count = 0L;
    private String splitFilename;
    private UriMaker uriMaker;

    public static XMLSplitter<StringHandle> makeSplitter(String nsUri, String localName) {
        BasicElementVisitor visitor = new BasicElementVisitor(nsUri, localName);
        return new XMLSplitter<StringHandle>(visitor);
    }

    public XMLSplitter(Visitor<T> visitor) {
        this.setVisitor(visitor);
    }

    public Visitor<T> getVisitor() {
        return this.visitor;
    }

    public void setVisitor(Visitor<T> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Visitor cannot be null");
        }
        this.visitor = visitor;
    }

    @Override
    public Stream<T> split(InputStream input) throws IOException, XMLStreamException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        XMLInputFactory factory = XmlFactories.makeNewInputFactory();
        XMLStreamReader reader = factory.createXMLStreamReader(input);
        return this.split(reader);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input) throws Exception {
        return this.splitWriteOperations(input, null);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input, String splitFilename) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        XMLStreamReader reader = XmlFactories.makeNewInputFactory().createXMLStreamReader(input);
        return this.splitWriteOperations(reader, splitFilename);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    public Stream<T> split(XMLStreamReader input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        this.count = 0L;
        HandleSpliterator handleSpliterator = new HandleSpliterator(this, input);
        return StreamSupport.stream(handleSpliterator, true);
    }

    public Stream<DocumentWriteOperation> splitWriteOperations(XMLStreamReader input, String splitFilename) {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        this.count = 0L;
        this.splitFilename = splitFilename;
        DocumentWriteOperationSpliterator documentWriteOperationSpliterator = new DocumentWriteOperationSpliterator(this, input);
        return StreamSupport.stream(documentWriteOperationSpliterator, true);
    }

    public UriMaker getUriMaker() {
        return this.uriMaker;
    }

    public void setUriMaker(UriMaker uriMaker) {
        this.uriMaker = uriMaker;
    }

    private static class UriMakerImpl
    extends com.marklogic.client.datamovement.impl.UriMakerImpl<XMLWriteHandle>
    implements UriMaker {
        private UriMakerImpl() {
        }
    }

    public static interface UriMaker
    extends Splitter.UriMaker {
        public String makeUri(long var1, XMLWriteHandle var3);
    }

    private static class XMLBranchStreamReader
    extends StreamReaderDelegate {
        private int depth = 1;

        XMLBranchStreamReader(XMLStreamReader reader) {
            super(reader);
        }

        @Override
        public boolean hasNext() {
            return this.depth > 0;
        }

        @Override
        public int next() throws XMLStreamException {
            if (this.depth < 1) {
                return 8;
            }
            int next = super.next();
            if (this.depth >= 1) {
                if (next == 1) {
                    ++this.depth;
                }
                if (next == 2) {
                    --this.depth;
                }
            }
            return next;
        }

        @Override
        public int nextTag() throws XMLStreamException {
            if (this.depth < 1) {
                return 8;
            }
            int next = super.nextTag();
            if (next == 1) {
                ++this.depth;
            }
            if (next == 2) {
                --this.depth;
            }
            return next;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException("Current XML branch cannot be closed.");
        }
    }

    private static class DocumentWriteOperationSpliterator<T extends XMLWriteHandle>
    extends XMLSpliterator<DocumentWriteOperation, T> {
        DocumentWriteOperationSpliterator(XMLSplitter<T> xmlSplitter, XMLStreamReader input) {
            super(xmlSplitter, input);
        }

        @Override
        public boolean tryAdvance(Consumer<? super DocumentWriteOperation> action) {
            Object handle = this.getNextHandle();
            if (handle == null) {
                return false;
            }
            XMLSplitter splitter = this.getSplitter();
            if (splitter.getUriMaker() == null) {
                UriMakerImpl uriMaker = new UriMakerImpl();
                uriMaker.setSplitFilename(splitter.splitFilename);
                uriMaker.setExtension("xml");
                splitter.setUriMaker(uriMaker);
            } else if (splitter.splitFilename != null) {
                splitter.getUriMaker().setSplitFilename(splitter.splitFilename);
            }
            splitter.count = splitter.getCount() + 1L;
            DocumentWriteOperation documentWriteOperation = splitter.getVisitor().makeDocumentWriteOperation(splitter.getUriMaker(), splitter.getCount(), handle);
            action.accept(documentWriteOperation);
            return true;
        }
    }

    private static class HandleSpliterator<T extends XMLWriteHandle>
    extends XMLSpliterator<T, T> {
        HandleSpliterator(XMLSplitter<T> xmlSplitter, XMLStreamReader input) {
            super(xmlSplitter, input);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Object handle = this.getNextHandle();
            if (handle == null) {
                return false;
            }
            this.getSplitter().count = this.getSplitter().getCount() + 1L;
            action.accept(handle);
            return true;
        }
    }

    private static abstract class XMLSpliterator<U, T extends XMLWriteHandle>
    extends Spliterators.AbstractSpliterator<U> {
        private XMLSplitter<T> splitter;
        private XMLStreamReader xmlStreamReader;
        private Visitor<T> visitor;

        private XMLStreamReader getXmlStreamReader() {
            return this.xmlStreamReader;
        }

        private void setXmlStreamReader(XMLStreamReader xmlStreamReader) {
            if (xmlStreamReader == null) {
                throw new IllegalArgumentException("XMLStreamReader cannot be null");
            }
            this.xmlStreamReader = xmlStreamReader;
        }

        private void setSplitter(XMLSplitter<T> xmlSplitter) {
            if (xmlSplitter == null) {
                throw new IllegalArgumentException("XMLSplitter cannot be null");
            }
            this.splitter = xmlSplitter;
        }

        XMLSplitter<T> getSplitter() {
            return this.splitter;
        }

        XMLSpliterator(XMLSplitter<T> xmlSplitter, XMLStreamReader input) {
            super(Long.MAX_VALUE, 1280);
            this.setSplitter(xmlSplitter);
            this.setXmlStreamReader(input);
            this.visitor = this.splitter.getVisitor();
        }

        T getNextHandle() {
            try {
                while (this.xmlStreamReader.hasNext()) {
                    int event = this.xmlStreamReader.next();
                    block1 : switch (event) {
                        case 1: {
                            StartElementReaderImpl startElementReader = new StartElementReaderImpl(this.xmlStreamReader);
                            NodeOperation nodeOperation = this.visitor.startElement(startElementReader);
                            if (nodeOperation == null) {
                                throw new IllegalStateException("No NodeOperation returned.");
                            }
                            switch (nodeOperation) {
                                case DESCEND: {
                                    break block1;
                                }
                                case PROCESS: {
                                    T handle = this.visitor.makeBufferedHandle(new XMLBranchStreamReader(this.xmlStreamReader));
                                    if (handle == null) break block1;
                                    return handle;
                                }
                                case SKIP: {
                                    int depth = 0;
                                    while (this.xmlStreamReader.hasNext()) {
                                        int next = this.xmlStreamReader.next();
                                        switch (next) {
                                            case 1: {
                                                ++depth;
                                                break;
                                            }
                                            case 2: {
                                                if (depth == 0) break block1;
                                                --depth;
                                                break;
                                            }
                                        }
                                    }
                                    break block1;
                                }
                                default: {
                                    throw new IllegalStateException("Unknown state");
                                }
                            }
                        }
                        case 2: {
                            this.visitor.endElement(this.xmlStreamReader.getNamespaceURI(), this.xmlStreamReader.getLocalName());
                            break;
                        }
                    }
                }
                return null;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Failed to traverse document", e);
            }
        }
    }

    private static class StartElementReaderImpl
    extends StreamReaderDelegate
    implements StartElementReader {
        private StartElementReaderImpl(XMLStreamReader reader) {
            super(reader);
        }
    }

    public static class BasicElementVisitor
    extends Visitor<StringHandle> {
        private String nsUri;
        private String localName;

        public BasicElementVisitor(String nsUri, String localName) {
            if (nsUri == null) {
                nsUri = "";
            }
            if (localName == null || localName.equals("")) {
                throw new IllegalArgumentException("LocalName cannot be null");
            }
            this.nsUri = nsUri;
            this.localName = localName;
        }

        @Override
        public NodeOperation startElement(StartElementReader startElementReader) {
            if (startElementReader == null) {
                throw new IllegalArgumentException("StartElementReader cannot be null");
            }
            String startNsUri = startElementReader.getNamespaceURI();
            String startLocalName = startElementReader.getLocalName();
            if ((startNsUri != null && startNsUri.equals(this.nsUri) || startNsUri == null && (this.nsUri == null || this.nsUri.length() == 0)) && (startLocalName != null && startLocalName.equals(this.localName) || startLocalName == null && (this.localName == null || this.localName.length() == 0))) {
                return NodeOperation.PROCESS;
            }
            return NodeOperation.DESCEND;
        }

        @Override
        public StringHandle makeBufferedHandle(XMLStreamReader xmlStreamReader) {
            if (xmlStreamReader == null) {
                throw new IllegalArgumentException("XMLStreamReader cannot be null");
            }
            String content = this.serialize(xmlStreamReader);
            return new StringHandle(content).withFormat(Format.XML);
        }
    }

    public static abstract class Visitor<T extends XMLWriteHandle> {
        private Transformer transformer;

        public abstract NodeOperation startElement(StartElementReader var1);

        public void endElement(String nsUri, String localName) {
        }

        public abstract T makeBufferedHandle(XMLStreamReader var1);

        public DocumentWriteOperation makeDocumentWriteOperation(UriMaker uriMaker, long count, T handle) {
            if (handle == null) {
                throw new IllegalArgumentException("Handle cannot be null");
            }
            String uri = uriMaker.makeUri(count, (XMLWriteHandle)handle);
            return new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, null, (AbstractWriteHandle)handle);
        }

        public String serialize(XMLStreamReader reader) {
            if (reader == null) {
                throw new IllegalArgumentException("XMLStreamReader cannot be null");
            }
            try {
                if (this.transformer == null) {
                    this.transformer = XmlFactories.makeNewTransformerFactory().newTransformer();
                }
                StAXSource stAXSrouce = new StAXSource(reader);
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                this.transformer.transform(stAXSrouce, streamResult);
                stringWriter.flush();
                this.transformer.reset();
                return stringWriter.toString();
            }
            catch (TransformerException e) {
                throw new RuntimeException("Could not serialize the document", e);
            }
        }
    }

    public static interface StartElementReader {
        public int getAttributeCount();

        public String getAttributeLocalName(int var1);

        public QName getAttributeName(int var1);

        public String getAttributeNamespace(int var1);

        public String getAttributePrefix(int var1);

        public String getAttributeType(int var1);

        public String getAttributeValue(int var1);

        public String getAttributeValue(String var1, String var2);

        public String getLocalName();

        public QName getName();

        public NamespaceContext getNamespaceContext();

        public int getNamespaceCount();

        public String getNamespacePrefix(int var1);

        public String getNamespaceURI();

        public String getNamespaceURI(int var1);

        public String getNamespaceURI(String var1);

        public String getPrefix();

        public boolean isAttributeSpecified(int var1);
    }
}

