/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressListener
implements QueryBatchListener {
    private static Logger logger = LoggerFactory.getLogger(ProgressListener.class);
    private List<Consumer<ProgressUpdate>> consumers = new ArrayList<Consumer<ProgressUpdate>>();
    private AtomicLong resultsSoFar = new AtomicLong(0L);
    private long startTime;
    private long totalResults;

    public ProgressListener() {
    }

    @SafeVarargs
    public ProgressListener(Consumer<ProgressUpdate> ... consumers) {
        this(0L, consumers);
    }

    @SafeVarargs
    public ProgressListener(long totalResults, Consumer<ProgressUpdate> ... consumers) {
        this.totalResults = totalResults;
        for (Consumer<ProgressUpdate> consumer : consumers) {
            this.consumers.add(consumer);
        }
    }

    public ProgressListener withTotalResults(long totalResults) {
        this.totalResults = totalResults;
        return this;
    }

    public ProgressListener onProgressUpdate(Consumer<ProgressUpdate> consumer) {
        this.consumers.add(consumer);
        return this;
    }

    @Override
    public void initializeListener(QueryBatcher queryBatcher) {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void processEvent(QueryBatch batch) {
        long newResultsSoFar;
        boolean resultsSoFarWasUpdated;
        long jobResultsSoFar = batch.getJobResultsSoFar();
        boolean bl = resultsSoFarWasUpdated = jobResultsSoFar == (newResultsSoFar = this.resultsSoFar.updateAndGet(operand -> jobResultsSoFar > operand ? jobResultsSoFar : operand));
        if (resultsSoFarWasUpdated && this.consumers != null) {
            double timeSoFar = ((double)System.currentTimeMillis() - (double)this.startTime) / 1000.0;
            long totalForThisUpdate = jobResultsSoFar > this.totalResults && this.totalResults > 0L ? jobResultsSoFar : this.totalResults;
            ProgressUpdate progressUpdate = this.newProgressUpdate(batch, this.startTime, totalForThisUpdate, timeSoFar);
            for (Consumer<ProgressUpdate> consumer : this.consumers) {
                this.invokeConsumer(consumer, progressUpdate);
            }
        }
    }

    protected ProgressUpdate newProgressUpdate(QueryBatch batch, long startTime, long totalForThisUpdate, double timeSoFar) {
        return new SimpleProgressUpdate(batch, startTime, totalForThisUpdate, timeSoFar);
    }

    protected void invokeConsumer(Consumer<ProgressUpdate> consumer, ProgressUpdate progressUpdate) {
        try {
            consumer.accept(progressUpdate);
        }
        catch (Throwable t) {
            logger.error("Exception thrown by a Consumer<ProgressUpdate> consumer: " + consumer + "; progressUpdate: " + progressUpdate, t);
        }
    }

    public static class SimpleProgressUpdate
    implements ProgressUpdate {
        private QueryBatch queryBatch;
        private long startTime;
        private long totalResults;
        private double timeSoFarInSeconds;

        public SimpleProgressUpdate(QueryBatch queryBatch, long startTime, long totalResults, double timeSoFarInSeconds) {
            this.queryBatch = queryBatch;
            this.startTime = startTime;
            this.timeSoFarInSeconds = timeSoFarInSeconds;
            this.totalResults = totalResults;
        }

        @Override
        public String getProgressAsString() {
            String text = this.totalResults > 0L ? String.format("Progress: %d of %d; time %fs", this.queryBatch.getJobResultsSoFar(), this.totalResults, this.timeSoFarInSeconds) : String.format("Progress: %d results so far; time %fs", this.queryBatch.getJobResultsSoFar(), this.timeSoFarInSeconds);
            if (this.timeSoFarInSeconds > 0.0) {
                double rate = (double)this.queryBatch.getJobResultsSoFar() / this.timeSoFarInSeconds;
                BigDecimal bd = new BigDecimal(rate);
                rate = bd.round(new MathContext(5)).doubleValue();
                return text + "; " + rate + " records/s";
            }
            return text;
        }

        @Override
        public boolean isComplete() {
            return this.totalResults > 0L ? this.queryBatch.getJobResultsSoFar() >= this.totalResults : false;
        }

        @Override
        public QueryBatch getQueryBatch() {
            return this.queryBatch;
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public long getTotalResults() {
            return this.totalResults;
        }

        @Override
        public double getTimeSoFarInSeconds() {
            return this.timeSoFarInSeconds;
        }
    }

    public static interface ProgressUpdate {
        public String getProgressAsString();

        public boolean isComplete();

        public QueryBatch getQueryBatch();

        public long getStartTime();

        public long getTotalResults();

        public double getTimeSoFarInSeconds();
    }
}

