/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.JacksonCSVSplitter;
import com.marklogic.client.datamovement.LineSplitter;
import com.marklogic.client.datamovement.Splitter;
import com.marklogic.client.datamovement.UnarySplitter;
import com.marklogic.client.datamovement.ZipSplitter;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class PathSplitter {
    public static final String DEFAULT_SPLITTER_KEY = "default";
    private Map<String, Splitter<? extends AbstractWriteHandle>> splitterMap;
    private Path documentUriAfter;
    private final Pattern extensionRegex = Pattern.compile("\\.([^.]+)$");

    public PathSplitter() {
        this.splitterMap = new HashMap<String, Splitter<? extends AbstractWriteHandle>>();
        this.splitterMap.put("csv", new JacksonCSVSplitter());
        this.splitterMap.put("jsonl", new LineSplitter());
        this.splitterMap.put("zip", new ZipSplitter());
        this.splitterMap.put(DEFAULT_SPLITTER_KEY, new UnarySplitter());
    }

    public Map<String, Splitter<? extends AbstractWriteHandle>> getSplitters() {
        return this.splitterMap;
    }

    public Path getDocumentUriAfter() {
        return this.documentUriAfter;
    }

    public PathSplitter withDocumentUriAfter(Path path) throws IOException {
        this.documentUriAfter = path;
        return this;
    }

    public Stream<? extends AbstractWriteHandle> splitHandles(Stream<Path> paths) throws Exception {
        if (paths == null) {
            throw new IllegalArgumentException("Stream<Path> cannot be null.");
        }
        return paths.flatMap(this::flatMapHandles);
    }

    public Stream<DocumentWriteOperation> splitDocumentWriteOperations(Stream<Path> paths) throws Exception {
        if (paths == null) {
            throw new IllegalArgumentException("Stream<Path> cannot be null.");
        }
        return paths.flatMap(this::flatMapDocumentWriteOperations);
    }

    private Stream<? extends AbstractWriteHandle> flatMapHandles(Path path) {
        String extension = this.getExtension(path);
        Splitter<? extends AbstractWriteHandle> splitter = this.lookupSplitter(extension);
        if (splitter == null) {
            return Stream.empty();
        }
        try {
            InputStream inputStream = this.openInputStream(path, extension);
            return splitter.split(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    private Stream<DocumentWriteOperation> flatMapDocumentWriteOperations(Path path) {
        String extension = this.getExtension(path);
        Splitter<? extends AbstractWriteHandle> splitter = this.lookupSplitter(extension);
        if (splitter == null) {
            return Stream.empty();
        }
        try {
            InputStream inputStream = this.openInputStream(path, extension);
            String filename = this.getFileName(path).toString();
            return splitter.splitWriteOperations(inputStream, filename);
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    private Path getFileName(Path path) {
        if (this.documentUriAfter == null) {
            return path;
        }
        Path relative = this.documentUriAfter.relativize(path);
        return path.toAbsolutePath().getRoot().resolve(relative);
    }

    private String getExtension(Path path) {
        Path fileName = this.getFileName(path);
        Matcher matcher = this.extensionRegex.matcher(fileName.toString());
        matcher.find();
        return matcher.group(1);
    }

    private Splitter<? extends AbstractWriteHandle> lookupSplitter(String extension) {
        Splitter<? extends AbstractWriteHandle> splitter = this.splitterMap.get(extension);
        if (splitter == null && this.splitterMap.get(DEFAULT_SPLITTER_KEY) != null) {
            return this.splitterMap.get(DEFAULT_SPLITTER_KEY);
        }
        return splitter;
    }

    private InputStream openInputStream(Path path, String extension) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null.");
        }
        BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        if ("zip".equals(extension)) {
            return new ZipInputStream(inputStream);
        }
        if ("gz".equals(extension)) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }
}

