/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.HostAvailabilityListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.QueryFailureListener;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.datamovement.WriteFailureListener;
import java.io.IOException;
import java.util.Set;

public class NoResponseListener
extends HostAvailabilityListener {
    public NoResponseListener(DataMovementManager moveMgr) {
        super(moveMgr);
    }

    @Override
    protected boolean isHostUnavailableException(Throwable throwable, Set<Throwable> path) {
        if (IOException.class.isInstance(throwable) && throwable.getMessage() != null && throwable.getMessage().contains("unexpected end of stream on")) {
            return true;
        }
        if (throwable.getCause() != null && !path.contains(throwable.getCause())) {
            path.add(throwable.getCause());
            boolean isCauseHostUnavailableException = this.isHostUnavailableException(throwable.getCause(), path);
            if (isCauseHostUnavailableException) {
                return true;
            }
        }
        return false;
    }

    public static NoResponseListener getInstance(Batcher batcher) {
        if (batcher instanceof WriteBatcher) {
            WriteFailureListener[] writeFailureListeners;
            for (WriteFailureListener writeFailureListener : writeFailureListeners = ((WriteBatcher)batcher).getBatchFailureListeners()) {
                if (!(writeFailureListener instanceof NoResponseListener)) continue;
                return (NoResponseListener)writeFailureListener;
            }
        } else if (batcher instanceof QueryBatcher) {
            QueryFailureListener[] queryFailureListeners;
            for (QueryFailureListener queryFailureListener : queryFailureListeners = ((QueryBatcher)batcher).getQueryFailureListeners()) {
                if (!(queryFailureListener instanceof NoResponseListener)) continue;
                return (NoResponseListener)queryFailureListener;
            }
        } else {
            throw new IllegalStateException("The Batcher should be either a QueryBatcher instance or a WriteBatcher instance");
        }
        return null;
    }
}

