/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Splitter;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.stream.Stream;

public class LineSplitter
implements Splitter<StringHandle> {
    private Format format = Format.JSON;
    private long count = 0L;
    private UriMaker uriMaker;

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        if (format == null) {
            throw new IllegalArgumentException("Format cannot be null.");
        }
        this.format = format;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public Stream<StringHandle> split(InputStream input) throws IOException {
        return this.split(input, null);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input) throws Exception {
        return this.splitWriteOperations(input, null);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input, String splitFilename) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("InputStream cannot be null.");
        }
        this.count = 0L;
        String extension = this.getFormat().getDefaultExtension();
        if (this.getUriMaker() == null) {
            UriMakerImpl uriMaker = new UriMakerImpl();
            uriMaker.setSplitFilename(splitFilename);
            uriMaker.setExtension(extension);
            this.setUriMaker(uriMaker);
        } else {
            if (splitFilename != null) {
                this.getUriMaker().setSplitFilename(splitFilename);
            }
            if (this.getUriMaker() instanceof UriMakerImpl) {
                ((UriMakerImpl)this.getUriMaker()).setExtension(extension);
            }
        }
        return new BufferedReader(new InputStreamReader(input)).lines().filter(line -> line.length() != 0).map(line -> {
            ++this.count;
            StringHandle handle = new StringHandle((String)line);
            String uri = this.getUriMaker().makeUri(this.count, handle);
            return new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, null, handle);
        });
    }

    public Stream<StringHandle> split(InputStream input, Charset charset) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("InputStream cannot be null.");
        }
        return this.split(charset == null ? new InputStreamReader(input) : new InputStreamReader(input, charset));
    }

    public Stream<StringHandle> split(Reader input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Reader cannot be null.");
        }
        this.count = 0L;
        return new BufferedReader(input).lines().filter(line -> line.length() != 0).map(line -> {
            ++this.count;
            return new StringHandle((String)line).withFormat(this.getFormat());
        });
    }

    public UriMaker getUriMaker() {
        return this.uriMaker;
    }

    public void setUriMaker(UriMaker uriMaker) {
        this.uriMaker = uriMaker;
    }

    private static class UriMakerImpl
    extends com.marklogic.client.datamovement.impl.UriMakerImpl<StringHandle>
    implements UriMaker {
        private UriMakerImpl() {
        }
    }

    public static interface UriMaker
    extends Splitter.UriMaker {
        public String makeUri(long var1, StringHandle var3);
    }
}

