/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.IoUtil;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.BinaryWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.GenericReadHandle;
import com.marklogic.client.io.marker.GenericWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.QuadsWriteHandle;
import com.marklogic.client.io.marker.SPARQLResultsReadHandle;
import com.marklogic.client.io.marker.StreamingContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.TriplesReadHandle;
import com.marklogic.client.io.marker.TriplesWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamHandle
extends BaseHandle<InputStream, InputStream>
implements StreamingContentHandle<InputStream, InputStream>,
BinaryReadHandle,
BinaryWriteHandle,
GenericReadHandle,
GenericWriteHandle,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
TriplesReadHandle,
TriplesWriteHandle,
QuadsWriteHandle,
SPARQLResultsReadHandle,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(InputStreamHandle.class);
    private byte[] contentBytes;
    private InputStream content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{InputStream.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return InputStream.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                InputStreamHandle handle = this.isHandled(type) ? new InputStreamHandle() : null;
                return handle;
            }
        };
    }

    public InputStreamHandle() {
        this.setResendable(false);
    }

    public InputStreamHandle(InputStream content) {
        this();
        this.set(content);
    }

    @Override
    public InputStream get() {
        if (this.contentBytes != null) {
            return new ByteArrayInputStream(this.contentBytes);
        }
        return this.content;
    }

    @Override
    public void set(InputStream content) {
        this.set(content, null);
    }

    private void set(InputStream content, byte[] contentBytes) {
        this.content = content;
        this.contentBytes = contentBytes;
    }

    public InputStreamHandle with(InputStream content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<InputStream> getContentClass() {
        return InputStream.class;
    }

    @Override
    public InputStreamHandle newHandle() {
        return new InputStreamHandle().withFormat(this.getFormat()).withMimetype(this.getMimetype());
    }

    public InputStreamHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new InputStreamHandle[length];
    }

    public InputStream[] newArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new InputStream[length];
    }

    public InputStreamHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public InputStreamHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        this.set(this.bytesToContent(buffer), buffer);
    }

    @Override
    public byte[] toBuffer() {
        if (this.contentBytes == null && this.content != null) {
            this.contentBytes = this.contentToBytes(this.get());
            this.content = null;
        }
        return this.contentBytes;
    }

    @Override
    public InputStream bytesToContent(byte[] buffer) {
        return buffer == null || buffer.length == 0 ? null : new ByteArrayInputStream(buffer);
    }

    @Override
    public byte[] contentToBytes(InputStream content) {
        try {
            if (content == null) {
                return null;
            }
            byte[] bytes = IoUtil.streamToBytes(content);
            content.close();
            return bytes;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public InputStream toContent(InputStream serialization) {
        return serialization;
    }

    public String toString() {
        byte[] buffer = this.toBuffer();
        return buffer == null ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        this.set(content, null);
    }

    @Override
    protected InputStream sendContent() {
        InputStream sendableContent = this.get();
        if (sendableContent == null) {
            throw new IllegalStateException("No stream to write");
        }
        return sendableContent;
    }

    @Override
    public void close() {
        if (this.contentBytes != null) {
            this.contentBytes = null;
        }
        if (this.content != null) {
            try {
                this.content.close();
            }
            catch (IOException e) {
                logger.error("Failed to close underlying InputStream", (Throwable)e);
                throw new MarkLogicIOException(e);
            }
            finally {
                this.content = null;
            }
        }
    }
}

