/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.Transaction;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.GraphPermissionsImpl;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.SPARQLQueryDefinitionImpl;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.SPARQLResultsReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.TriplesReadHandle;
import com.marklogic.client.semantics.Capability;
import com.marklogic.client.semantics.GraphPermissions;
import com.marklogic.client.semantics.SPARQLQueryDefinition;
import com.marklogic.client.semantics.SPARQLQueryManager;

public class SPARQLQueryManagerImpl
extends AbstractLoggingManager
implements SPARQLQueryManager {
    private RESTServices services;
    private long pageLength = -1L;

    public SPARQLQueryManagerImpl(RESTServices services) {
        this.services = services;
    }

    @Override
    public SPARQLQueryDefinition newQueryDefinition() {
        return new SPARQLQueryDefinitionImpl();
    }

    @Override
    public SPARQLQueryDefinition newQueryDefinition(String sparql) {
        return new SPARQLQueryDefinitionImpl(sparql);
    }

    @Override
    public SPARQLQueryDefinition newQueryDefinition(TextWriteHandle sparql) {
        return new SPARQLQueryDefinitionImpl(sparql);
    }

    @Override
    public <T extends SPARQLResultsReadHandle> T executeSelect(SPARQLQueryDefinition qdef, T handle) {
        return this.executeQueryImpl(qdef, handle, null, false);
    }

    @Override
    public <T extends SPARQLResultsReadHandle> T executeSelect(SPARQLQueryDefinition qdef, T handle, Transaction tx) {
        return this.executeQueryImpl(qdef, handle, tx, false);
    }

    @Override
    public <T extends SPARQLResultsReadHandle> T executeSelect(SPARQLQueryDefinition qdef, T handle, long start) {
        return this.executeSelect(qdef, handle, start, null);
    }

    @Override
    public <T extends SPARQLResultsReadHandle> T executeSelect(SPARQLQueryDefinition qdef, T handle, long start, Transaction tx) {
        if (start < 1L) {
            throw new IllegalArgumentException("start must be 1 or greater");
        }
        return this.executeQueryImpl(qdef, handle, start, tx, false);
    }

    @Override
    public long getPageLength() {
        return this.pageLength;
    }

    @Override
    public void setPageLength(long pageLength) {
        if (pageLength < 0L) {
            throw new IllegalArgumentException("pageLength must be 0 or greater");
        }
        this.pageLength = pageLength;
    }

    @Override
    public void clearPageLength() {
        this.pageLength = -1L;
    }

    private <T extends AbstractReadHandle> T executeQueryImpl(SPARQLQueryDefinition qdef, T handle, Transaction tx, boolean isUpdate) {
        return this.executeQueryImpl(qdef, handle, -1L, tx, isUpdate);
    }

    private <T extends AbstractReadHandle> T executeQueryImpl(SPARQLQueryDefinition qdef, T handle, long start, Transaction tx, boolean isUpdate) {
        if (qdef == null) {
            throw new IllegalArgumentException("qdef cannot be null");
        }
        if (handle == null) {
            throw new IllegalArgumentException("handle cannot be null");
        }
        return this.services.executeSparql(this.requestLogger, qdef, handle, start, this.getPageLength(), tx, isUpdate);
    }

    @Override
    public <T extends TriplesReadHandle> T executeConstruct(SPARQLQueryDefinition qdef, T triplesReadHandle) {
        this.setRdfXmlOrJsonMimetype(triplesReadHandle);
        return this.executeQueryImpl(qdef, triplesReadHandle, null, false);
    }

    @Override
    public <T extends TriplesReadHandle> T executeConstruct(SPARQLQueryDefinition qdef, T triplesReadHandle, Transaction tx) {
        this.setRdfXmlOrJsonMimetype(triplesReadHandle);
        return this.executeQueryImpl(qdef, triplesReadHandle, tx, false);
    }

    private void setRdfXmlOrJsonMimetype(TriplesReadHandle handle) {
        HandleImplementation baseHandle = HandleAccessor.as(handle);
        if (baseHandle.getFormat() == Format.JSON) {
            if (Format.JSON.getDefaultMimetype().equals(baseHandle.getMimetype())) {
                baseHandle.setMimetype("application/rdf+json");
            }
        } else if (baseHandle.getFormat() == Format.XML && Format.XML.getDefaultMimetype().equals(baseHandle.getMimetype())) {
            baseHandle.setMimetype("application/rdf+xml");
        }
    }

    @Override
    public <T extends TriplesReadHandle> T executeDescribe(SPARQLQueryDefinition qdef, T triplesReadHandle) {
        this.setRdfXmlOrJsonMimetype(triplesReadHandle);
        return this.executeQueryImpl(qdef, triplesReadHandle, null, false);
    }

    @Override
    public <T extends TriplesReadHandle> T executeDescribe(SPARQLQueryDefinition qdef, T triplesReadHandle, Transaction tx) {
        this.setRdfXmlOrJsonMimetype(triplesReadHandle);
        return this.executeQueryImpl(qdef, triplesReadHandle, tx, false);
    }

    @Override
    public Boolean executeAsk(SPARQLQueryDefinition qdef) {
        JsonNode result = this.executeQueryImpl(qdef, new JacksonHandle(), null, false).get();
        return result.get("boolean").asBoolean();
    }

    @Override
    public Boolean executeAsk(SPARQLQueryDefinition qdef, Transaction tx) {
        JsonNode result = this.executeQueryImpl(qdef, new JacksonHandle(), tx, false).get();
        return result.get("boolean").asBoolean();
    }

    @Override
    public void executeUpdate(SPARQLQueryDefinition qdef) {
        this.executeQueryImpl(qdef, new StringHandle().withFormat(Format.JSON), null, true);
    }

    @Override
    public void executeUpdate(SPARQLQueryDefinition qdef, Transaction tx) {
        this.executeQueryImpl(qdef, new StringHandle().withFormat(Format.JSON), tx, true);
    }

    @Override
    public GraphPermissions permission(String role, Capability ... capabilities) {
        return new GraphPermissionsImpl().permission(role, capabilities);
    }
}

