/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.ResourceNotFoundException;
import com.marklogic.client.alerting.RuleDefinition;
import com.marklogic.client.alerting.RuleManager;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.RuleListReadHandle;
import com.marklogic.client.io.marker.RuleReadHandle;
import com.marklogic.client.io.marker.RuleWriteHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.query.QueryDefinition;

public class RuleManagerImpl
extends AbstractLoggingManager
implements RuleManager {
    private static final String RULES_BASE = "/alert/rules";
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;

    public RuleManagerImpl(RESTServices services) {
        this.services = services;
    }

    public DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    public void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    @Override
    public boolean exists(String ruleName) {
        return this.services.exists("/alert/rules/" + ruleName);
    }

    @Override
    public <T> T readRuleAs(String ruleName, Class<T> as) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        ContentHandle<T> handle = this.getHandleRegistry().makeHandle(as);
        if (!RuleReadHandle.class.isAssignableFrom(handle.getClass())) {
            throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to read rule as " + as.getName());
        }
        this.readRule(ruleName, (RuleReadHandle)((Object)handle));
        return handle.get();
    }

    @Override
    public <T extends RuleReadHandle> T readRule(String ruleName, T ruleHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (ruleName == null) {
            throw new IllegalArgumentException("Cannot read null rule name");
        }
        HandleImplementation ruleBase = HandleAccessor.checkHandle(ruleHandle, "rule");
        Format ruleFormat = ruleBase.getFormat();
        switch (ruleFormat) {
            case UNKNOWN: {
                ruleFormat = Format.XML;
                break;
            }
            case JSON: 
            case XML: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only JSON and XML rules are possible.");
            }
        }
        String mimetype = ruleFormat.getDefaultMimetype();
        ruleBase.receiveContent(this.services.getValue(this.requestLogger, RULES_BASE, ruleName, false, mimetype, ruleBase.receiveAs()));
        return ruleHandle;
    }

    @Override
    public void writeRuleAs(String ruleName, Object ruleSource) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        if (ruleSource == null) {
            throw new IllegalArgumentException("no source to write");
        }
        Class<?> as = ruleSource.getClass();
        RuleWriteHandle sourceHandle = null;
        if (RuleWriteHandle.class.isAssignableFrom(as)) {
            sourceHandle = (RuleWriteHandle)ruleSource;
        } else {
            ContentHandle<?> handle = this.getHandleRegistry().makeHandle(as);
            if (!RuleWriteHandle.class.isAssignableFrom(handle.getClass())) {
                throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to write rule source as " + as.getName());
            }
            Utilities.setHandleContent(handle, ruleSource);
            sourceHandle = (RuleWriteHandle)((Object)handle);
        }
        if (sourceHandle instanceof RuleDefinition) {
            ((RuleDefinition)sourceHandle).setName(ruleName);
        }
        this.writeRule(ruleName, sourceHandle);
    }

    @Override
    public void writeRule(RuleDefinition ruleHandle) {
        String ruleName = ruleHandle.getName();
        this.writeRule(ruleName, ruleHandle);
    }

    @Override
    public void writeRule(String ruleName, RuleWriteHandle writeHandle) throws ResourceNotFoundException, ForbiddenUserException, FailedRequestException {
        HandleImplementation ruleBase;
        String name;
        if (writeHandle instanceof RuleDefinition && (name = ((RuleDefinition)writeHandle).getName()) != null) {
            ruleName = name;
        }
        if ((ruleBase = HandleAccessor.checkHandle(writeHandle, "rule")) == null) {
            throw new IllegalArgumentException("Could not write null rule: " + ruleName);
        }
        Format ruleFormat = ruleBase.getFormat();
        switch (ruleFormat) {
            case UNKNOWN: {
                ruleFormat = Format.XML;
                break;
            }
            case JSON: 
            case XML: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only JSON and XML rules are supported.");
            }
        }
        String mimetype = ruleFormat.getDefaultMimetype();
        this.services.putValue(this.requestLogger, RULES_BASE, ruleName, mimetype, ruleBase);
    }

    @Override
    public void delete(String ruleName) throws ForbiddenUserException, FailedRequestException {
        this.services.deleteValue(null, RULES_BASE, ruleName);
    }

    @Override
    public <T extends RuleListReadHandle> T match(QueryDefinition docQuery, T ruleListHandle) {
        return this.match(docQuery, 1L, -1L, new String[0], ruleListHandle);
    }

    @Override
    public <T extends RuleListReadHandle> T match(QueryDefinition docQuery, long start, long pageLength, String[] candidateRules, T ruleListHandle) {
        return this.match(docQuery, start, pageLength, candidateRules, ruleListHandle, null);
    }

    @Override
    public <T extends RuleListReadHandle> T match(QueryDefinition docQuery, long start, long pageLength, String[] candidateRules, T ruleListHandle, ServerTransform transform) {
        HandleAccessor.receiveContent(ruleListHandle, this.services.match(docQuery, start, pageLength, candidateRules, transform));
        return ruleListHandle;
    }

    @Override
    public <T extends RuleListReadHandle> T match(String[] docIds, T ruleListHandle) {
        return this.match(docIds, new String[0], ruleListHandle);
    }

    @Override
    public <T extends RuleListReadHandle> T match(String[] docIds, String[] candidateRules, T ruleListHandle) {
        return this.match(docIds, candidateRules, ruleListHandle, null);
    }

    @Override
    public <T extends RuleListReadHandle> T match(String[] docIds, String[] candidateRules, T ruleListHandle, ServerTransform transform) {
        HandleAccessor.receiveContent(ruleListHandle, this.services.match(docIds, candidateRules, transform));
        return ruleListHandle;
    }

    @Override
    public <T extends RuleListReadHandle> T matchAs(Object content, T ruleListHandle) {
        return this.matchAs(content, null, ruleListHandle, null);
    }

    @Override
    public <T extends RuleListReadHandle> T matchAs(Object content, String[] candidateRules, T ruleListHandle) {
        return this.matchAs(content, candidateRules, ruleListHandle, null);
    }

    @Override
    public <T extends RuleListReadHandle> T matchAs(Object content, String[] candidateRules, T ruleListHandle, ServerTransform transform) {
        if (content == null) {
            throw new IllegalArgumentException("no content for matching rules");
        }
        Class<?> as = content.getClass();
        StructureWriteHandle matchHandle = null;
        if (StructureWriteHandle.class.isAssignableFrom(as)) {
            matchHandle = (StructureWriteHandle)content;
        } else {
            ContentHandle<?> handle = this.getHandleRegistry().makeHandle(as);
            if (!StructureWriteHandle.class.isAssignableFrom(handle.getClass())) {
                throw new IllegalArgumentException("Handle " + handle.getClass().getName() + " cannot be used to match rules as " + as.getName());
            }
            Utilities.setHandleContent(handle, content);
            matchHandle = (StructureWriteHandle)((Object)handle);
        }
        return this.match(matchHandle, candidateRules, ruleListHandle, transform);
    }

    @Override
    public <T extends RuleListReadHandle> T match(StructureWriteHandle document, T ruleListHandle) {
        return this.match(document, new String[0], ruleListHandle);
    }

    @Override
    public <T extends RuleListReadHandle> T match(StructureWriteHandle document, String[] candidateRules, T ruleListHandle) {
        return this.match(document, candidateRules, ruleListHandle, null);
    }

    @Override
    public <T extends RuleListReadHandle> T match(StructureWriteHandle document, String[] candidateRules, T ruleListHandle, ServerTransform transform) {
        HandleImplementation searchBase = HandleAccessor.checkHandle(document, "match");
        Format searchFormat = searchBase.getFormat();
        switch (searchFormat) {
            case UNKNOWN: {
                searchFormat = Format.XML;
                break;
            }
            case JSON: 
            case XML: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only XML and JSON queries can filter for rule matches.");
            }
        }
        String mimeType = searchFormat.getDefaultMimetype();
        HandleAccessor.receiveContent(ruleListHandle, this.services.match(document, candidateRules, mimeType, transform));
        return ruleListHandle;
    }
}

