/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Splitter;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.InputStreamHandle;
import java.io.InputStream;
import java.util.UUID;
import java.util.stream.Stream;

public class UnarySplitter
implements Splitter<InputStreamHandle> {
    private UriMaker uriMaker;
    private long count = 0L;

    public UriMaker getUriMaker() {
        return this.uriMaker;
    }

    public void setUriMaker(UriMaker uriMaker) {
        if (uriMaker == null) {
            throw new IllegalArgumentException("uriMaker cannot be null.");
        }
        this.uriMaker = uriMaker;
    }

    @Override
    public Stream<InputStreamHandle> split(InputStream input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        this.count = 0L;
        InputStreamHandle handle = new InputStreamHandle(input);
        return Stream.of(handle);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input) throws Exception {
        return this.splitWriteOperations(input, null);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input, String splitFilename) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        this.count = 0L;
        InputStreamHandle handle = new InputStreamHandle(input);
        if (this.getUriMaker() == null) {
            UriMakerImpl uriMaker = new UriMakerImpl();
            this.setUriMaker(uriMaker);
        }
        if (splitFilename != null) {
            this.uriMaker.setSplitFilename(splitFilename);
        }
        String uri = this.uriMaker.makeUri(handle);
        DocumentWriteOperationImpl documentWriteOperation = new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, null, handle);
        this.count = this.getCount() + 1L;
        return Stream.of(documentWriteOperation);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    private static class UriMakerImpl
    extends com.marklogic.client.datamovement.impl.UriMakerImpl<BytesHandle>
    implements UriMaker {
        private UriMakerImpl() {
        }

        @Override
        public String makeUri(InputStreamHandle handle) {
            StringBuilder uri = new StringBuilder();
            if (this.getInputAfter() != null && this.getInputAfter().length() != 0) {
                uri.append(this.getInputAfter());
            }
            if (this.getSplitFilename() != null && this.getSplitFilename().length() != 0) {
                uri.append(this.getName());
            }
            uri.append("_").append(UUID.randomUUID()).append(".").append(this.getExtension());
            return uri.toString();
        }
    }

    public static interface UriMaker
    extends Splitter.UriMaker {
        public String makeUri(InputStreamHandle var1);
    }
}

