/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.gcs;

import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.comparator.VersionNumberComparator;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.gcs.configuration.GCSStoreConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.threeten.bp.Duration;

@Component(configurationPid={"com.liferay.portal.store.gcs.configuration.GCSStoreConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"store.type=com.liferay.portal.store.gcs.GCSStore"}, service={Store.class})
public class GCSStore
implements Store {
    private static final Log _log = LogFactoryUtil.getLog(GCSStore.class);
    private Blob.BlobSourceOption _blobDecryptSourceOption;
    private Storage.BlobWriteOption _blobEncryptWriteOption;
    private BucketInfo _bucketInfo;
    private Storage _gcsStore;
    private volatile GCSStoreConfiguration _gcsStoreConfiguration;
    private GoogleCredentials _googleCredentials;

    public void addFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream inputStream) throws PortalException {
        if (this.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            this.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
        String path = this._getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
        BlobInfo blobInfo = BlobInfo.newBuilder((BucketInfo)this._getBucketInfo(), (String)path).build();
        try (WriteChannel writeChannel = this._getWriteChannel(blobInfo);){
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)Channels.newOutputStream((WritableByteChannel)writeChannel));
        }
        catch (IOException ioException) {
            throw new PortalException("Unable to add file", (Throwable)ioException);
        }
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        String path = this._getDirectoryKey(companyId, repositoryId, dirName);
        Page blobPage = this._gcsStore.list(this._gcsStoreConfiguration.bucketName(), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)path)});
        Iterable blobs = blobPage.iterateAll();
        blobs.forEach(this::_deleteBlob);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        this._gcsStore.delete(BlobId.of((String)this._gcsStoreConfiguration.bucketName(), (String)this._getHeadVersionLabel(companyId, repositoryId, fileName, versionLabel)));
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        Blob blob = this._gcsStore.get(BlobId.of((String)this._gcsStoreConfiguration.bucketName(), (String)this._getHeadVersionLabel(companyId, repositoryId, fileName, versionLabel)));
        if (blob == null) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel);
        }
        return Channels.newInputStream((ReadableByteChannel)this._getReadChannel(blob));
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        Stream<String> stream = Arrays.stream(this._getFilePaths(companyId, repositoryId, dirName));
        String prefix = StringBundler.concat((Object[])new Object[]{companyId, "/", repositoryId, "/"});
        return (String[])stream.map(filePath -> filePath.substring(filePath.indexOf(prefix) + prefix.length(), filePath.lastIndexOf("/"))).toArray(String[]::new);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        String headVersionLabel = this._getHeadVersionLabel(companyId, repositoryId, fileName, versionLabel);
        Blob blob = this._gcsStore.get(BlobId.of((String)this._gcsStoreConfiguration.bucketName(), (String)headVersionLabel));
        if (blob == null) {
            throw new NoSuchFileException("No file exists for " + headVersionLabel);
        }
        return blob.getSize();
    }

    public String[] getFileVersions(long companyId, long repositoryId, String fileName) {
        Stream<String> stream = Arrays.stream(this._getFilePaths(companyId, repositoryId, fileName));
        return (String[])stream.map(path -> {
            String[] parts = StringUtil.split((String)path, (char)'/');
            return parts[parts.length - 1];
        }).toArray(String[]::new);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        String path = this._getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
        Page blobPage = this._gcsStore.list(this._gcsStoreConfiguration.bucketName(), new Storage.BlobListOption[]{Storage.BlobListOption.pageSize((long)1L), Storage.BlobListOption.prefix((String)path)});
        Iterable filesFoundIterable = blobPage.getValues();
        Iterator filesFoundIterator = filesFoundIterable.iterator();
        return filesFoundIterator.hasNext();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        try {
            this._gcsStoreConfiguration = (GCSStoreConfiguration)ConfigurableUtil.createConfigurable(GCSStoreConfiguration.class, properties);
            this._initEncryption();
            this._initGCSStore();
        }
        catch (PortalException portalException) {
            throw new IllegalStateException("Unable to initialize GCS store", portalException);
        }
    }

    private void _deleteBlob(Blob blob) {
        if (this._blobDecryptSourceOption == null) {
            blob.delete(new Blob.BlobSourceOption[0]);
        } else {
            blob.delete(new Blob.BlobSourceOption[]{this._blobDecryptSourceOption});
        }
    }

    private BucketInfo _getBucketInfo() {
        if (this._bucketInfo == null) {
            this._bucketInfo = BucketInfo.newBuilder((String)this._gcsStoreConfiguration.bucketName()).build();
        }
        return this._bucketInfo;
    }

    private String _getDirectoryKey(long companyId, long repositoryId, String folderName) {
        return this._getFileKey(companyId, repositoryId, folderName);
    }

    private String _getFileKey(long companyId, long repositoryId, String fileName) {
        return StringBundler.concat((Object[])new Object[]{companyId, "/", repositoryId, "/", fileName});
    }

    private String[] _getFilePaths(long companyId, long repositoryId, String dirName) {
        Bucket bucket = this._gcsStore.get(this._gcsStoreConfiguration.bucketName(), new Storage.BucketGetOption[0]);
        String path = null;
        path = Validator.isNull((String)dirName) || dirName.equals("/") ? this._getRepositoryKey(companyId, repositoryId) : this._getDirectoryKey(companyId, repositoryId, dirName);
        Page blobPage = bucket.list(new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)path)});
        Iterable blobs = blobPage.iterateAll();
        Stream<Blob> blobStream = StreamSupport.stream(blobs.spliterator(), false);
        return (String[])blobStream.map(BlobInfo::getName).toArray(String[]::new);
    }

    private String _getFileVersionKey(long companyId, long repositoryId, String fileName, String versionLabel) {
        return StringBundler.concat((Object[])new Object[]{companyId, "/", repositoryId, "/", fileName, "/", versionLabel});
    }

    private String _getHeadVersionLabel(long companyId, long repositoryId, String fileName, String versionLabel) {
        if (Validator.isNotNull((String)versionLabel)) {
            return this._getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
        }
        String path = this._getFileKey(companyId, repositoryId, fileName);
        String[] fileNames = this._getFilePaths(companyId, repositoryId, path);
        if (fileNames == null || fileNames.length == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using default version for " + path));
            }
            return this._getFileVersionKey(companyId, repositoryId, fileName, "1.0");
        }
        List<String> fileNamesList = Arrays.asList(fileNames);
        fileNamesList.sort((Comparator<String>)new VersionNumberComparator());
        return fileNamesList.get(fileNamesList.size() - 1);
    }

    private ReadChannel _getReadChannel(Blob blob) {
        if (this._blobDecryptSourceOption == null) {
            return blob.reader(new Blob.BlobSourceOption[0]);
        }
        return blob.reader(new Blob.BlobSourceOption[]{this._blobDecryptSourceOption});
    }

    private String _getRepositoryKey(long companyId, long repositoryId) {
        return companyId + "/" + repositoryId;
    }

    private WriteChannel _getWriteChannel(BlobInfo blobInfo) {
        if (this._blobEncryptWriteOption == null) {
            return this._gcsStore.writer(blobInfo, new Storage.BlobWriteOption[0]);
        }
        return this._gcsStore.writer(blobInfo, new Storage.BlobWriteOption[]{this._blobEncryptWriteOption});
    }

    private void _initEncryption() {
        String aes256Key = this._gcsStoreConfiguration.aes256Key();
        if (Validator.isNull((String)aes256Key)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Files are not encrypted because the portal property \"dl.store.gcs.aes256.key\" is not set");
            }
            this._blobDecryptSourceOption = null;
            this._blobEncryptWriteOption = null;
        } else {
            this._blobDecryptSourceOption = Blob.BlobSourceOption.decryptionKey((String)aes256Key);
            this._blobEncryptWriteOption = Storage.BlobWriteOption.encryptionKey((String)aes256Key);
        }
    }

    private void _initGCSStore() throws PortalException {
        String serviceAccountKey = this._gcsStoreConfiguration.serviceAccountKey();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(serviceAccountKey.getBytes());){
            this._googleCredentials = ServiceAccountCredentials.fromStream((InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new PortalException("Unable to authenticate with GCS", (Throwable)ioException);
        }
        StorageOptions storageOptions = ((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)this._googleCredentials)).setRetrySettings(RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)this._gcsStoreConfiguration.initialRetryDelay())).setInitialRpcTimeout(Duration.ofMillis((long)this._gcsStoreConfiguration.initialRPCTimeout())).setJittered(this._gcsStoreConfiguration.retryJitter()).setMaxAttempts(this._gcsStoreConfiguration.maxRetryAttempts()).setMaxRetryDelay(Duration.ofMillis((long)this._gcsStoreConfiguration.maxRetryDelay())).setMaxRpcTimeout(Duration.ofMillis((long)this._gcsStoreConfiguration.maxRPCTimeout())).setRetryDelayMultiplier(this._gcsStoreConfiguration.retryDelayMultiplier()).setRpcTimeoutMultiplier(this._gcsStoreConfiguration.rpcTimeoutMultiplier()).build())).build();
        this._gcsStore = (Storage)storageOptions.getService();
    }
}

