/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.DefaultObjectLayoutException;
import com.liferay.object.exception.NoSuchObjectDefinitionException;
import com.liferay.object.exception.ObjectLayoutBoxCategorizationTypeException;
import com.liferay.object.exception.ObjectLayoutColumnSizeException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectLayout;
import com.liferay.object.model.ObjectLayoutBox;
import com.liferay.object.model.ObjectLayoutColumn;
import com.liferay.object.model.ObjectLayoutRow;
import com.liferay.object.model.ObjectLayoutTab;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.base.ObjectLayoutLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectLayoutBoxPersistence;
import com.liferay.object.service.persistence.ObjectLayoutColumnPersistence;
import com.liferay.object.service.persistence.ObjectLayoutRowPersistence;
import com.liferay.object.service.persistence.ObjectLayoutTabPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectLayout"}, service={AopService.class})
public class ObjectLayoutLocalServiceImpl
extends ObjectLayoutLocalServiceBaseImpl {
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectLayoutBoxPersistence _objectLayoutBoxPersistence;
    @Reference
    private ObjectLayoutColumnPersistence _objectLayoutColumnPersistence;
    @Reference
    private ObjectLayoutRowPersistence _objectLayoutRowPersistence;
    @Reference
    private ObjectLayoutTabPersistence _objectLayoutTabPersistence;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectLayout addObjectLayout(long userId, long objectDefinitionId, boolean defaultObjectLayout, Map<Locale, String> nameMap, List<ObjectLayoutTab> objectLayoutTabs) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isSystem()) {
            throw new NoSuchObjectDefinitionException("Object layouts require a custom object definition");
        }
        this._validate(0L, objectDefinitionId, defaultObjectLayout, objectLayoutTabs);
        ObjectLayout objectLayout = this.objectLayoutPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectLayout.setCompanyId(user.getCompanyId());
        objectLayout.setUserId(user.getUserId());
        objectLayout.setUserName(user.getFullName());
        objectLayout.setObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        objectLayout.setDefaultObjectLayout(defaultObjectLayout);
        objectLayout.setNameMap(nameMap);
        objectLayout = (ObjectLayout)this.objectLayoutPersistence.update((BaseModel)objectLayout);
        objectLayout.setObjectLayoutTabs(this._addObjectLayoutTabs(user, objectDefinitionId, objectLayout.getObjectLayoutId(), objectLayoutTabs));
        return objectLayout;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectLayout deleteObjectLayout(long objectLayoutId) throws PortalException {
        ObjectLayout objectLayout = this.objectLayoutPersistence.findByPrimaryKey(objectLayoutId);
        return this.deleteObjectLayout(objectLayout);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectLayout deleteObjectLayout(ObjectLayout objectLayout) throws PortalException {
        objectLayout = (ObjectLayout)this.objectLayoutPersistence.remove((BaseModel)objectLayout);
        this._deleteObjectLayoutTabs(objectLayout.getObjectLayoutId());
        return objectLayout;
    }

    public void deleteObjectLayouts(long objectDefinitionId) throws PortalException {
        for (ObjectLayout objectLayout : this.objectLayoutPersistence.findByObjectDefinitionId(objectDefinitionId)) {
            this.objectLayoutLocalService.deleteObjectLayout(objectLayout);
        }
    }

    public ObjectLayout getDefaultObjectLayout(long objectDefinitionId) throws PortalException {
        ObjectLayout objectLayout = this.objectLayoutPersistence.findByODI_DOL_First(objectDefinitionId, true, null);
        objectLayout.setObjectLayoutTabs(this._getObjectLayoutTabs(objectLayout));
        return objectLayout;
    }

    @Override
    public ObjectLayout getObjectLayout(long objectLayoutId) throws PortalException {
        ObjectLayout objectLayout = this.objectLayoutPersistence.findByPrimaryKey(objectLayoutId);
        objectLayout.setObjectLayoutTabs(this._getObjectLayoutTabs(objectLayout));
        return objectLayout;
    }

    public List<ObjectLayout> getObjectLayouts(long objectDefinitionId) {
        List objectLayouts = this.objectLayoutPersistence.findByObjectDefinitionId(objectDefinitionId);
        for (ObjectLayout objectLayout : objectLayouts) {
            objectLayout.setObjectLayoutTabs(this._getObjectLayoutTabs(objectLayout));
        }
        return objectLayouts;
    }

    public List<ObjectLayout> getObjectLayouts(long objectDefinitionId, int start, int end) {
        return this.objectLayoutPersistence.findByObjectDefinitionId(objectDefinitionId, start, end);
    }

    public int getObjectLayoutsCount(long objectDefinitionId) {
        return this.objectLayoutPersistence.countByObjectDefinitionId(objectDefinitionId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectLayout updateObjectLayout(long objectLayoutId, boolean defaultObjectLayout, Map<Locale, String> nameMap, List<ObjectLayoutTab> objectLayoutTabs) throws PortalException {
        ObjectLayout objectLayout = this.objectLayoutPersistence.findByPrimaryKey(objectLayoutId);
        this._validate(objectLayoutId, objectLayout.getObjectDefinitionId(), defaultObjectLayout, objectLayoutTabs);
        this._deleteObjectLayoutTabs(objectLayoutId);
        objectLayout.setDefaultObjectLayout(defaultObjectLayout);
        objectLayout.setNameMap(nameMap);
        objectLayout = (ObjectLayout)this.objectLayoutPersistence.update((BaseModel)objectLayout);
        User user = this._userLocalService.getUser(objectLayout.getUserId());
        objectLayout.setObjectLayoutTabs(this._addObjectLayoutTabs(user, objectLayout.getObjectDefinitionId(), objectLayout.getObjectLayoutId(), objectLayoutTabs));
        return objectLayout;
    }

    private ObjectLayoutBox _addObjectLayoutBox(User user, long objectDefinitionId, long objectLayoutTabId, ObjectLayoutBox objectLayoutBox) throws PortalException {
        ObjectLayoutBox newObjectLayoutBox = this._objectLayoutBoxPersistence.create(this.counterLocalService.increment());
        newObjectLayoutBox.setCompanyId(user.getCompanyId());
        newObjectLayoutBox.setUserId(user.getUserId());
        newObjectLayoutBox.setUserName(user.getFullName());
        newObjectLayoutBox.setObjectLayoutTabId(objectLayoutTabId);
        newObjectLayoutBox.setCollapsable(objectLayoutBox.isCollapsable());
        newObjectLayoutBox.setNameMap(objectLayoutBox.getNameMap());
        newObjectLayoutBox.setObjectLayoutRows(objectLayoutBox.getObjectLayoutRows());
        newObjectLayoutBox.setPriority(objectLayoutBox.getPriority());
        newObjectLayoutBox.setType(objectLayoutBox.getType());
        newObjectLayoutBox = (ObjectLayoutBox)this._objectLayoutBoxPersistence.update((BaseModel)newObjectLayoutBox);
        newObjectLayoutBox.setObjectLayoutRows(this._addObjectLayoutRows(user, objectDefinitionId, newObjectLayoutBox.getObjectLayoutBoxId(), newObjectLayoutBox.getObjectLayoutRows()));
        return newObjectLayoutBox;
    }

    private List<ObjectLayoutBox> _addObjectLayoutBoxes(User user, long objectDefinitionId, long objectLayoutTabId, List<ObjectLayoutBox> objectLayoutBoxes) throws PortalException {
        return TransformUtil.unsafeTransform(objectLayoutBoxes, objectLayoutBox -> this._addObjectLayoutBox(user, objectDefinitionId, objectLayoutTabId, (ObjectLayoutBox)objectLayoutBox));
    }

    private ObjectLayoutColumn _addObjectLayoutColumn(User user, long objectDefinitionId, long objectFieldId, long objectLayoutRowId, int priority, int size) throws PortalException {
        ObjectField objectField = this._objectFieldPersistence.findByPrimaryKey(objectFieldId);
        if (objectField.getObjectDefinitionId() != objectDefinitionId) {
            throw new PortalException();
        }
        if (size < 0 || size > 12) {
            throw new ObjectLayoutColumnSizeException("Object layout column size must be more than 0 and less than 12");
        }
        ObjectLayoutColumn objectLayoutColumn = this._objectLayoutColumnPersistence.create(this.counterLocalService.increment());
        objectLayoutColumn.setCompanyId(user.getCompanyId());
        objectLayoutColumn.setUserId(user.getUserId());
        objectLayoutColumn.setUserName(user.getFullName());
        objectLayoutColumn.setObjectFieldId(objectField.getObjectFieldId());
        objectLayoutColumn.setObjectLayoutRowId(objectLayoutRowId);
        objectLayoutColumn.setPriority(priority);
        objectLayoutColumn.setSize(size);
        return (ObjectLayoutColumn)this._objectLayoutColumnPersistence.update((BaseModel)objectLayoutColumn);
    }

    private List<ObjectLayoutColumn> _addObjectLayoutColumns(User user, long objectDefinitionId, long objectLayoutRowId, List<ObjectLayoutColumn> objectLayoutColumns) throws PortalException {
        ArrayList<ObjectLayoutColumn> addObjectLayoutColumns = new ArrayList<ObjectLayoutColumn>();
        for (ObjectLayoutColumn objectLayoutColumn : objectLayoutColumns) {
            addObjectLayoutColumns.add(this._addObjectLayoutColumn(user, objectDefinitionId, objectLayoutColumn.getObjectFieldId(), objectLayoutRowId, objectLayoutColumn.getPriority(), objectLayoutColumn.getSize()));
        }
        return addObjectLayoutColumns;
    }

    private ObjectLayoutRow _addObjectLayoutRow(User user, long objectDefinitionId, long objectLayoutBoxId, int priority, List<ObjectLayoutColumn> objectLayoutColumns) throws PortalException {
        ObjectLayoutRow objectLayoutRow = this._objectLayoutRowPersistence.create(this.counterLocalService.increment());
        objectLayoutRow.setCompanyId(user.getCompanyId());
        objectLayoutRow.setUserId(user.getUserId());
        objectLayoutRow.setUserName(user.getFullName());
        objectLayoutRow.setObjectLayoutBoxId(objectLayoutBoxId);
        objectLayoutRow.setPriority(priority);
        objectLayoutRow = (ObjectLayoutRow)this._objectLayoutRowPersistence.update((BaseModel)objectLayoutRow);
        objectLayoutRow.setObjectLayoutColumns(this._addObjectLayoutColumns(user, objectDefinitionId, objectLayoutRow.getObjectLayoutRowId(), objectLayoutColumns));
        return objectLayoutRow;
    }

    private List<ObjectLayoutRow> _addObjectLayoutRows(User user, long objectDefinitionId, long objectLayoutBoxId, List<ObjectLayoutRow> objectLayoutRows) throws PortalException {
        return TransformUtil.unsafeTransform(objectLayoutRows, objectLayoutRow -> this._addObjectLayoutRow(user, objectDefinitionId, objectLayoutBoxId, objectLayoutRow.getPriority(), objectLayoutRow.getObjectLayoutColumns()));
    }

    private ObjectLayoutTab _addObjectLayoutTab(User user, long objectDefinitionId, long objectLayoutId, long objectRelationshipId, Map<Locale, String> nameMap, int priority, List<ObjectLayoutBox> objectLayoutBoxes) throws PortalException {
        ObjectLayoutTab objectLayoutTab = this._objectLayoutTabPersistence.create(this.counterLocalService.increment());
        objectLayoutTab.setCompanyId(user.getCompanyId());
        objectLayoutTab.setUserId(user.getUserId());
        objectLayoutTab.setUserName(user.getFullName());
        objectLayoutTab.setObjectLayoutId(objectLayoutId);
        objectLayoutTab.setObjectRelationshipId(objectRelationshipId);
        objectLayoutTab.setNameMap(nameMap);
        objectLayoutTab.setPriority(priority);
        objectLayoutTab = (ObjectLayoutTab)this._objectLayoutTabPersistence.update((BaseModel)objectLayoutTab);
        objectLayoutTab.setObjectLayoutBoxes(this._addObjectLayoutBoxes(user, objectDefinitionId, objectLayoutTab.getObjectLayoutTabId(), objectLayoutBoxes));
        return objectLayoutTab;
    }

    private List<ObjectLayoutTab> _addObjectLayoutTabs(User user, long objectDefinitionId, long objectLayoutId, List<ObjectLayoutTab> objectLayoutTabs) throws PortalException {
        return TransformUtil.unsafeTransform(objectLayoutTabs, objectLayoutTab -> this._addObjectLayoutTab(user, objectDefinitionId, objectLayoutId, objectLayoutTab.getObjectRelationshipId(), objectLayoutTab.getNameMap(), objectLayoutTab.getPriority(), objectLayoutTab.getObjectLayoutBoxes()));
    }

    private void _deleteObjectLayoutBoxes(List<ObjectLayoutTab> objectLayoutTabs) {
        for (ObjectLayoutTab objectLayoutTab : objectLayoutTabs) {
            List objectLayoutBoxes = this._objectLayoutBoxPersistence.findByObjectLayoutTabId(objectLayoutTab.getObjectLayoutTabId());
            this._objectLayoutBoxPersistence.removeByObjectLayoutTabId(objectLayoutTab.getObjectLayoutTabId());
            this._deleteObjectLayoutRows(objectLayoutBoxes);
        }
    }

    private void _deleteObjectLayoutColumns(List<ObjectLayoutRow> objectLayoutRows) {
        for (ObjectLayoutRow objectLayoutRow : objectLayoutRows) {
            this._objectLayoutColumnPersistence.removeByObjectLayoutRowId(objectLayoutRow.getObjectLayoutRowId());
        }
    }

    private void _deleteObjectLayoutRows(List<ObjectLayoutBox> objectLayoutBoxes) {
        for (ObjectLayoutBox objectLayoutBox : objectLayoutBoxes) {
            List objectLayoutRows = this._objectLayoutRowPersistence.findByObjectLayoutBoxId(objectLayoutBox.getObjectLayoutBoxId());
            this._objectLayoutRowPersistence.removeByObjectLayoutBoxId(objectLayoutBox.getObjectLayoutBoxId());
            this._deleteObjectLayoutColumns(objectLayoutRows);
        }
    }

    private void _deleteObjectLayoutTabs(long objectLayoutId) {
        List objectLayoutTabs = this._objectLayoutTabPersistence.findByObjectLayoutId(objectLayoutId);
        this._objectLayoutTabPersistence.removeByObjectLayoutId(objectLayoutId);
        this._deleteObjectLayoutBoxes(objectLayoutTabs);
    }

    private List<ObjectLayoutBox> _getObjectLayoutBoxes(ObjectLayoutTab objectLayoutTab) {
        List objectLayoutBoxes = this._objectLayoutBoxPersistence.findByObjectLayoutTabId(objectLayoutTab.getObjectLayoutTabId());
        for (ObjectLayoutBox objectLayoutBox : objectLayoutBoxes) {
            objectLayoutBox.setObjectLayoutRows(this._getObjectLayoutRows(objectLayoutBox));
        }
        return objectLayoutBoxes;
    }

    private List<ObjectLayoutRow> _getObjectLayoutRows(ObjectLayoutBox objectLayoutBox) {
        List objectLayoutRows = this._objectLayoutRowPersistence.findByObjectLayoutBoxId(objectLayoutBox.getObjectLayoutBoxId());
        for (ObjectLayoutRow objectLayoutRow : objectLayoutRows) {
            objectLayoutRow.setObjectLayoutColumns(this._objectLayoutColumnPersistence.findByObjectLayoutRowId(objectLayoutRow.getObjectLayoutRowId()));
        }
        return objectLayoutRows;
    }

    private List<ObjectLayoutTab> _getObjectLayoutTabs(ObjectLayout objectLayout) {
        List objectLayoutTabs = this._objectLayoutTabPersistence.findByObjectLayoutId(objectLayout.getObjectLayoutId());
        for (ObjectLayoutTab objectLayoutTab : objectLayoutTabs) {
            objectLayoutTab.setObjectLayoutBoxes(this._getObjectLayoutBoxes(objectLayoutTab));
        }
        return objectLayoutTabs;
    }

    private void _validate(long objectLayoutId, long objectDefinitionId, boolean defaultObjectLayout, List<ObjectLayoutTab> objectLayoutTabs) throws PortalException {
        if (defaultObjectLayout) {
            HashSet<Long> objectFieldIds = new HashSet<Long>();
            ObjectLayoutTab objectLayoutTab = objectLayoutTabs.get(0);
            List objectLayoutBoxes = objectLayoutTab.getObjectLayoutBoxes();
            for (Object objectLayoutBox : objectLayoutBoxes) {
                List objectLayoutRows = objectLayoutBox.getObjectLayoutRows();
                for (ObjectLayoutRow objectLayoutRow : objectLayoutRows) {
                    List objectLayoutColumns = objectLayoutRow.getObjectLayoutColumns();
                    for (ObjectLayoutColumn objectLayoutColumn : objectLayoutColumns) {
                        objectFieldIds.add(objectLayoutColumn.getObjectFieldId());
                    }
                }
            }
            List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinitionId);
            for (ObjectField objectField : objectFields) {
                if (!objectField.isRequired() || objectFieldIds.contains(objectField.getObjectFieldId())) continue;
                throw new DefaultObjectLayoutException("All required object fields must be associated to the first tab of a default object layout");
            }
            ObjectLayout objectLayout = this.objectLayoutPersistence.fetchByODI_DOL_First(objectDefinitionId, true, null);
            if (objectLayout != null && objectLayout.getObjectLayoutId() != objectLayoutId) {
                throw new DefaultObjectLayoutException("There can only be one default object layout");
            }
        }
        int countObjectLayoutBoxCategorizationType = 0;
        for (ObjectLayoutTab objectLayoutTab : objectLayoutTabs) {
            List objectLayoutBoxes = objectLayoutTab.getObjectLayoutBoxes();
            for (ObjectLayoutBox objectLayoutBox : objectLayoutBoxes) {
                if (Validator.isNull((String)objectLayoutBox.getType())) {
                    throw new ObjectLayoutBoxCategorizationTypeException("Object layout box must have a type");
                }
                if (!StringUtil.equals((String)objectLayoutBox.getType(), (String)"categorization")) continue;
                if (++countObjectLayoutBoxCategorizationType > 1) {
                    throw new ObjectLayoutBoxCategorizationTypeException("There can only be one categorization layout box per layout");
                }
                if (!ListUtil.isNotEmpty((List)objectLayoutBox.getObjectLayoutRows())) continue;
                throw new ObjectLayoutBoxCategorizationTypeException("Categorization layout box must not have layout rows");
            }
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (countObjectLayoutBoxCategorizationType == 1 && !StringUtil.equals((String)objectDefinition.getStorageType(), (String)"default")) {
            throw new ObjectLayoutBoxCategorizationTypeException("Categorization layout box only can be used in object definitions with default storage type");
        }
    }
}

