/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.object.exception.DuplicateObjectFieldExternalReferenceCodeException;
import com.liferay.object.exception.ObjectDefinitionStatusException;
import com.liferay.object.exception.ObjectFieldBusinessTypeException;
import com.liferay.object.exception.ObjectFieldDBTypeException;
import com.liferay.object.exception.ObjectFieldDefaultValueException;
import com.liferay.object.exception.ObjectFieldLabelException;
import com.liferay.object.exception.ObjectFieldNameException;
import com.liferay.object.exception.ObjectFieldRelationshipTypeException;
import com.liferay.object.exception.RequiredObjectFieldException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.business.type.ObjectFieldBusinessTypeServicesTracker;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectViewLocalService;
import com.liferay.object.service.base.ObjectFieldLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectEntryPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectFieldSettingPersistence;
import com.liferay.object.service.persistence.ObjectLayoutColumnPersistence;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectField"}, service={AopService.class})
public class ObjectFieldLocalServiceImpl
extends ObjectFieldLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectFieldLocalServiceImpl.class);
    private final Map<String, String> _businessTypes = HashMapBuilder.put((Object)"BigDecimal", (Object)"PrecisionDecimal").put((Object)"Blob", (Object)"LargeFile").put((Object)"Boolean", (Object)"Boolean").put((Object)"Clob", (Object)"LongText").put((Object)"Date", (Object)"Date").put((Object)"Double", (Object)"Decimal").put((Object)"Integer", (Object)"Integer").put((Object)"Long", (Object)"LongInteger").put((Object)"String", (Object)"Text").build();
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectEntryPersistence _objectEntryPersistence;
    @Reference
    private ObjectFieldBusinessTypeServicesTracker _objectFieldBusinessTypeServicesTracker;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectFieldSettingPersistence _objectFieldSettingPersistence;
    @Reference
    private ObjectLayoutColumnPersistence _objectLayoutColumnPersistence;
    @Reference
    private ObjectRelationshipPersistence _objectRelationshipPersistence;
    @Reference
    private ObjectViewLocalService _objectViewLocalService;
    private final Set<String> _reservedNames = SetUtil.fromArray((Object[])new String[]{"actions", "companyid", "createdate", "creator", "datecreated", "datemodified", "externalreferencecode", "groupid", "id", "lastpublishdate", "modifieddate", "statusbyuserid", "statusbyusername", "statusdate", "userid", "username"});
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addCustomObjectField(long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbType, String defaultValue, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        name = StringUtil.trim((String)name);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        String dbTableName = objectDefinition.getDBTableName();
        if (objectDefinition.isApproved()) {
            dbTableName = objectDefinition.getExtensionDBTableName();
        }
        ObjectField objectField = this._addObjectField(userId, listTypeDefinitionId, objectDefinitionId, businessType, name + "_", dbTableName, dbType, defaultValue, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required, false);
        if (objectDefinition.isApproved() && !Objects.equals(objectField.getBusinessType(), "Aggregation")) {
            this.runSQL(DynamicObjectDefinitionTable.getAlterTableAddColumnSQL(dbTableName, objectField.getDBColumnName(), dbType));
        }
        this._addOrUpdateObjectFieldSettings(objectField, objectFieldSettings);
        return objectField;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addOrUpdateSystemObjectField(long userId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, String defaultValue, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required) throws PortalException {
        ObjectField existingObjectField = this.objectFieldPersistence.fetchByODI_N(objectDefinitionId, name);
        if (existingObjectField == null) {
            return this.addSystemObjectField(userId, objectDefinitionId, businessType, dbColumnName, dbTableName, dbType, defaultValue, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required);
        }
        this._validateLabel(labelMap);
        existingObjectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        return (ObjectField)this.objectFieldPersistence.update((BaseModel)existingObjectField);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addSystemObjectField(long userId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, String defaultValue, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required) throws PortalException {
        name = StringUtil.trim((String)name);
        if (Validator.isNull((String)dbColumnName)) {
            dbColumnName = name;
        }
        return this._addObjectField(userId, 0L, objectDefinitionId, businessType, dbColumnName, dbTableName, dbType, defaultValue, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required, true);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectField deleteObjectField(long objectFieldId) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        return this.deleteObjectField(objectField);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectField deleteObjectField(ObjectField objectField) throws PortalException {
        if (Validator.isNotNull((String)objectField.getRelationshipType())) {
            throw new ObjectFieldRelationshipTypeException("Object field cannot be deleted because it has a relationship type");
        }
        return this._deleteObjectField(objectField);
    }

    public void deleteObjectFieldByObjectDefinitionId(Long objectDefinitionId) throws PortalException {
        for (ObjectField objectField : this._objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId.longValue())) {
            if (Validator.isNotNull((String)objectField.getRelationshipType())) continue;
            this.objectFieldPersistence.remove((BaseModel)objectField);
            this._objectFieldSettingPersistence.removeByObjectFieldId(objectField.getObjectFieldId());
        }
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectField deleteRelationshipTypeObjectField(long objectFieldId) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        if (Validator.isNull((String)objectField.getRelationshipType())) {
            throw new ObjectFieldRelationshipTypeException("Object field cannot be deleted because it does not have a relationship type");
        }
        return this._deleteObjectField(objectField);
    }

    public ObjectField fetchObjectField(long objectDefinitionId, String name) {
        return this.objectFieldPersistence.fetchByODI_N(objectDefinitionId, name);
    }

    public List<ObjectField> getActiveObjectFields(List<ObjectField> objectFields) throws PortalException {
        ArrayList<ObjectField> activeObjectFields = new ArrayList<ObjectField>();
        for (ObjectField objectField : objectFields) {
            objectField.setObjectFieldSettings(this._objectFieldSettingPersistence.findByObjectFieldId(objectField.getObjectFieldId()));
            if (Validator.isNotNull((String)objectField.getRelationshipType())) {
                ObjectRelationship objectRelationship = this._objectRelationshipPersistence.fetchByObjectFieldId2(objectField.getObjectFieldId());
                ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
                if (!objectDefinition.isActive()) continue;
                activeObjectFields.add(objectField);
                continue;
            }
            activeObjectFields.add(objectField);
        }
        return activeObjectFields;
    }

    public List<ObjectField> getCustomObjectFields(long objectFieldId) {
        List objectFields = this._objectFieldPersistence.findByODI_S(objectFieldId, false);
        for (ObjectField objectField : objectFields) {
            objectField.setObjectFieldSettings(this._objectFieldSettingPersistence.findByObjectFieldId(objectField.getObjectFieldId()));
        }
        return objectFields;
    }

    @Override
    public ObjectField getObjectField(long objectFieldId) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        objectField.setObjectFieldSettings(this._objectFieldSettingPersistence.findByObjectFieldId(objectFieldId));
        return objectField;
    }

    public ObjectField getObjectField(long objectDefinitionId, String name) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByODI_N(objectDefinitionId, name);
        objectField.setObjectFieldSettings(this._objectFieldSettingPersistence.findByObjectFieldId(objectField.getObjectFieldId()));
        return objectField;
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId) {
        List objectFields = this.objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId);
        for (ObjectField objectField : objectFields) {
            objectField.setObjectFieldSettings(this._objectFieldSettingPersistence.findByObjectFieldId(objectField.getObjectFieldId()));
        }
        return objectFields;
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId, String dbTableName) {
        List objectFields = this.objectFieldPersistence.findByODI_DTN(objectDefinitionId, dbTableName);
        for (ObjectField objectField : objectFields) {
            objectField.setObjectFieldSettings(this._objectFieldSettingPersistence.findByObjectFieldId(objectField.getObjectFieldId()));
        }
        return objectFields;
    }

    public int getObjectFieldsCount(long objectDefinitionId) {
        return this.objectFieldPersistence.countByObjectDefinitionId(objectDefinitionId);
    }

    public int getObjectFieldsCountByListTypeDefinitionId(long listTypeDefinitionId) {
        return this.objectFieldPersistence.countByListTypeDefinitionId(listTypeDefinitionId);
    }

    public Table getTable(long objectDefinitionId, String name) throws PortalException {
        ObjectField objectField = this.getObjectField(objectDefinitionId, name);
        if (Objects.equals(objectField.getDBTableName(), ObjectEntryTable.INSTANCE.getTableName())) {
            return ObjectEntryTable.INSTANCE;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (Objects.equals(objectField.getDBTableName(), objectDefinition.getDBTableName())) {
            return new DynamicObjectDefinitionTable(objectDefinition, this.objectFieldLocalService.getObjectFields(objectDefinitionId, objectDefinition.getDBTableName()), objectDefinition.getDBTableName());
        }
        return new DynamicObjectDefinitionTable(objectDefinition, this.objectFieldLocalService.getObjectFields(objectDefinitionId, objectDefinition.getExtensionDBTableName()), objectDefinition.getExtensionDBTableName());
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField updateCustomObjectField(long objectFieldId, String externalReferenceCode, long listTypeDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectField.getObjectDefinitionId());
        if (objectDefinition.isSystem()) {
            throw new ObjectDefinitionStatusException();
        }
        this._validateExternalReferenceCode(objectField.getObjectFieldId(), objectField.getCompanyId(), externalReferenceCode, objectField.getObjectDefinitionId());
        this._validateLabel(labelMap);
        objectField.setExternalReferenceCode(externalReferenceCode);
        objectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        if (objectDefinition.isApproved()) {
            objectField = (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
            this._addOrUpdateObjectFieldSettings(objectField, objectFieldSettings);
            return objectField;
        }
        this._validateIndexed(businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId);
        if (Validator.isNotNull((String)objectField.getRelationshipType())) {
            if (!Objects.equals(objectField.getDBType(), dbType) || !Objects.equals(objectField.getName(), name)) {
                throw new ObjectFieldRelationshipTypeException("Object field relationship name and DB type cannot be changed");
            }
        } else {
            this._validateName(objectFieldId, objectDefinition, name, false);
        }
        this._setBusinessTypeAndDBType(businessType, dbType, objectField);
        objectField.setListTypeDefinitionId(listTypeDefinitionId);
        objectField.setDBColumnName(name + "_");
        objectField.setIndexed(indexed);
        objectField.setIndexedAsKeyword(indexedAsKeyword);
        objectField.setIndexedLanguageId(indexedLanguageId);
        objectField.setName(name);
        objectField.setRequired(required);
        objectField = (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
        this._addOrUpdateObjectFieldSettings(objectField, objectFieldSettings);
        return objectField;
    }

    public ObjectField updateObjectField(long userId, long objectDefinitionId, long objectFieldId, String externalReferenceCode, long listTypeDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, String defaultValue, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required, boolean system, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        if (system) {
            return this.objectFieldLocalService.addOrUpdateSystemObjectField(userId, objectDefinitionId, businessType, dbColumnName, dbTableName, dbType, defaultValue, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required);
        }
        return this.objectFieldLocalService.updateCustomObjectField(objectFieldId, externalReferenceCode, listTypeDefinitionId, businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required, objectFieldSettings);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField updateRequired(long objectFieldId, boolean required) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        objectField.setRequired(required);
        return (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
    }

    private ObjectField _addObjectField(long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, String defaultValue, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required, boolean system) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._validateDefaultValue(businessType, defaultValue);
        this._validateIndexed(businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId);
        this._validateLabel(labelMap);
        this._validateName(0L, objectDefinition, name, system);
        ObjectField objectField = this.objectFieldPersistence.create(this.counterLocalService.increment());
        this._setBusinessTypeAndDBType(businessType, dbType, objectField);
        User user = this._userLocalService.getUser(userId);
        objectField.setCompanyId(user.getCompanyId());
        objectField.setUserId(user.getUserId());
        objectField.setUserName(user.getFullName());
        objectField.setListTypeDefinitionId(listTypeDefinitionId);
        objectField.setObjectDefinitionId(objectDefinitionId);
        objectField.setDBColumnName(dbColumnName);
        objectField.setDBTableName(dbTableName);
        objectField.setDefaultValue(defaultValue);
        objectField.setIndexed(indexed);
        objectField.setIndexedAsKeyword(indexedAsKeyword);
        objectField.setIndexedLanguageId(indexedLanguageId);
        objectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectField.setName(name);
        objectField.setRelationshipType(null);
        objectField.setRequired(required);
        objectField.setSystem(system);
        return (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
    }

    private void _addOrUpdateObjectFieldSettings(ObjectField objectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeServicesTracker.getObjectFieldBusinessType(objectField.getBusinessType());
        objectFieldBusinessType.validateObjectFieldSettings(objectField.getName(), objectFieldSettings);
        List oldObjectFieldSettings = this._objectFieldSettingPersistence.findByObjectFieldId(objectField.getObjectFieldId());
        for (ObjectFieldSetting oldObjectFieldSetting : oldObjectFieldSettings) {
            Stream stream = objectFieldSettings.stream();
            Optional<ObjectFieldSetting> objectFieldSettingOptional = stream.filter(newObjectFieldSetting -> Objects.equals(newObjectFieldSetting.getName(), oldObjectFieldSetting.getName())).findFirst();
            if (objectFieldSettingOptional.isPresent()) continue;
            this._objectFieldSettingPersistence.remove((BaseModel)oldObjectFieldSetting);
        }
        for (ObjectFieldSetting newObjectFieldSetting2 : objectFieldSettings) {
            ObjectFieldSetting oldObjectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectField.getObjectFieldId(), newObjectFieldSetting2.getName());
            if (oldObjectFieldSetting == null) {
                this._objectFieldSettingLocalService.addObjectFieldSetting(objectField.getUserId(), objectField.getObjectFieldId(), newObjectFieldSetting2.getName(), newObjectFieldSetting2.getValue());
                continue;
            }
            this._objectFieldSettingLocalService.updateObjectFieldSetting(oldObjectFieldSetting.getObjectFieldSettingId(), newObjectFieldSetting2.getValue());
        }
    }

    private void _deleteFileEntries(long objectDefinitionId, String name) {
        List objectEntries = this._objectEntryPersistence.findByObjectDefinitionId(objectDefinitionId);
        for (ObjectEntry objectEntry : objectEntries) {
            Map values = objectEntry.getValues();
            try {
                this._dlFileEntryLocalService.deleteFileEntry(GetterUtil.getLong(values.get(name)));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
    }

    private ObjectField _deleteObjectField(ObjectField objectField) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectField.getObjectDefinitionId());
        if ((objectDefinition.isApproved() || objectDefinition.isSystem()) && !Objects.equals(objectDefinition.getExtensionDBTableName(), objectField.getDBTableName()) && !Objects.equals(objectField.getBusinessType(), "Relationship")) {
            throw new RequiredObjectFieldException();
        }
        objectField = (ObjectField)this.objectFieldPersistence.remove((BaseModel)objectField);
        if (objectDefinition.getAccountEntryRestrictedObjectFieldId() == objectField.getObjectFieldId()) {
            objectDefinition.setAccountEntryRestrictedObjectFieldId(0L);
            objectDefinition.setAccountEntryRestricted(false);
            objectDefinition = (ObjectDefinition)this._objectDefinitionPersistence.update((BaseModel)objectDefinition);
        }
        String objectFieldSettingFileSource = "";
        if (Objects.equals(objectField.getBusinessType(), "Attachment")) {
            ObjectFieldSetting objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectField.getObjectFieldId(), "fileSource");
            objectFieldSettingFileSource = objectFieldSetting.getValue();
        }
        this._objectFieldSettingPersistence.removeByObjectFieldId(objectField.getObjectFieldId());
        this._objectLayoutColumnPersistence.removeByObjectFieldId(objectField.getObjectFieldId());
        this._objectViewLocalService.unassociateObjectField(objectField);
        if ((Objects.equals(objectDefinition.getExtensionDBTableName(), objectField.getDBTableName()) || objectDefinition.isApproved() && Objects.equals(objectField.getBusinessType(), "Relationship")) && !Objects.equals(objectField.getBusinessType(), "Aggregation")) {
            if (Objects.equals(objectFieldSettingFileSource, "userComputer")) {
                this._deleteFileEntries(objectField.getObjectDefinitionId(), objectField.getName());
            }
            this.runSQL(DynamicObjectDefinitionTable.getAlterTableDropColumnSQL(objectField.getDBTableName(), objectField.getDBColumnName()));
        }
        return objectField;
    }

    private void _setBusinessTypeAndDBType(String businessType, String dbType, ObjectField objectField) throws PortalException {
        ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeServicesTracker.getObjectFieldBusinessType(GetterUtil.getString((String)businessType));
        Set objectFieldDBTypes = this._objectFieldBusinessTypeServicesTracker.getObjectFieldDBTypes();
        if (objectFieldBusinessType != null) {
            objectField.setBusinessType(businessType);
            objectField.setDBType(objectFieldBusinessType.getDBType());
        } else if (objectFieldDBTypes.contains(dbType) && this._businessTypes.containsKey(dbType)) {
            objectField.setBusinessType(this._businessTypes.get(dbType));
            objectField.setDBType(dbType);
        } else {
            if (!businessType.isEmpty()) {
                throw new ObjectFieldBusinessTypeException("Invalid business type " + businessType);
            }
            throw new ObjectFieldDBTypeException("Invalid DB type " + dbType);
        }
    }

    private void _validateDefaultValue(String businessType, String defaultValue) throws PortalException {
        if (Validator.isNull((String)defaultValue)) {
            return;
        }
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-152677"))) {
            throw new UnsupportedOperationException();
        }
        if (!Objects.equals("Picklist", businessType)) {
            throw new ObjectFieldDefaultValueException(StringBundler.concat((String[])new String[]{"Object field can only have a default type when the ", "business type is \"", "Picklist", "\""}));
        }
    }

    private void _validateExternalReferenceCode(long objectFieldId, long companyId, String externalReferenceCode, long objectDefinitionId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        ObjectField objectField = this.objectFieldPersistence.fetchByC_ERC_ODI(companyId, externalReferenceCode, objectDefinitionId);
        if (objectField != null && objectField.getObjectFieldId() != objectFieldId) {
            throw new DuplicateObjectFieldExternalReferenceCodeException();
        }
    }

    private void _validateIndexed(String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId) throws PortalException {
        if (indexed && Objects.equals(dbType, "Blob")) {
            throw new ObjectFieldDBTypeException("Blob type is not indexable");
        }
        if (!((Objects.equals(businessType, "Attachment") || Objects.equals(dbType, "Clob") || Objects.equals(dbType, "String")) && !indexedAsKeyword || Validator.isBlank((String)indexedLanguageId))) {
            throw new ObjectFieldDBTypeException("Indexed language ID can only be applied with type \"Clob\" or \"String\" that is not indexed as a keyword");
        }
    }

    private void _validateLabel(Map<Locale, String> labelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (labelMap == null || Validator.isNull((String)labelMap.get(locale))) {
            throw new ObjectFieldLabelException("Label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateName(long objectFieldId, ObjectDefinition objectDefinition, String name, boolean system) throws PortalException {
        char[] nameCharArray;
        if (Validator.isNull((String)name)) {
            throw new ObjectFieldNameException.MustNotBeNull();
        }
        for (char c : nameCharArray = name.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c)) continue;
            throw new ObjectFieldNameException.MustOnlyContainLettersAndDigits();
        }
        if (!Character.isLowerCase(nameCharArray[0])) {
            throw new ObjectFieldNameException.MustBeginWithLowerCaseLetter();
        }
        if (nameCharArray.length > 41) {
            throw new ObjectFieldNameException.MustBeLessThan41Characters();
        }
        if (!system && this._reservedNames.contains(StringUtil.toLowerCase((String)name)) || StringUtil.equalsIgnoreCase((String)objectDefinition.getPKObjectFieldName(), (String)name)) {
            throw new ObjectFieldNameException.MustNotBeReserved(name);
        }
        ObjectField objectField = this.objectFieldPersistence.fetchByODI_N(objectDefinition.getObjectDefinitionId(), name);
        if (objectField != null && objectField.getObjectFieldId() != objectFieldId) {
            throw new ObjectFieldNameException.MustNotBeDuplicate(name);
        }
    }
}

