/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.executor;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.internal.action.util.ObjectActionVariablesUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectActionExecutor.class})
public class AddObjectEntryObjectActionExecutorImpl
implements ObjectActionExecutor {
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public void execute(long companyId, UnicodeProperties parametersUnicodeProperties, JSONObject payloadJSONObject, long userId) throws Exception {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-152180"))) {
            throw new UnsupportedOperationException();
        }
        ObjectDefinition targetObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(GetterUtil.getLong((String)((String)parametersUnicodeProperties.get((Object)"objectDefinitionId"))));
        if (targetObjectDefinition.isSystem()) {
            throw new UnsupportedOperationException();
        }
        long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
        ObjectDefinition sourceObjectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(payloadJSONObject.getLong("objectDefinitionId"));
        ObjectEntry objectEntry = this._objectEntryLocalService.addObjectEntry(defaultUserId, this._getGroupId(companyId, payloadJSONObject, sourceObjectDefinition, targetObjectDefinition), targetObjectDefinition.getObjectDefinitionId(), this._getValues(sourceObjectDefinition, parametersUnicodeProperties, payloadJSONObject), this._getServiceContext(companyId, defaultUserId));
        if (!GetterUtil.getBoolean((String)((String)parametersUnicodeProperties.get((Object)"relatedObjectEntries")))) {
            return;
        }
        for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationships(sourceObjectDefinition.getObjectDefinitionId())) {
            if (!Objects.equals(objectRelationship.getObjectDefinitionId2(), targetObjectDefinition.getObjectDefinitionId())) continue;
            this._objectRelationshipLocalService.addObjectRelationshipMappingTableValues(userId, objectRelationship.getObjectRelationshipId(), payloadJSONObject.getLong("classPK"), objectEntry.getObjectEntryId(), this._getServiceContext(companyId, userId));
        }
    }

    public String getKey() {
        return "add-object-entry";
    }

    private Serializable _evaluateExpression(String expression, Map<String, Object> variables) throws Exception {
        DDMExpression ddmExpression = this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)expression).build());
        ddmExpression.setVariables(variables);
        return (Serializable)ddmExpression.evaluate();
    }

    private long _getGroupId(long companyId, JSONObject payloadJSONObject, ObjectDefinition sourceObjectDefinition, ObjectDefinition targetObjectDefinition) throws Exception {
        ObjectScopeProvider targetObjectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(targetObjectDefinition.getScope());
        if (!targetObjectScopeProvider.isGroupAware()) {
            return 0L;
        }
        ObjectScopeProvider sourceObjectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(sourceObjectDefinition.getScope());
        if (!sourceObjectScopeProvider.isGroupAware()) {
            Group companyGroup = this._groupLocalService.fetchCompanyGroup(companyId);
            return companyGroup.getGroupId();
        }
        if (sourceObjectDefinition.isSystem()) {
            return MapUtil.getLong((Map)((Map)payloadJSONObject.get("model" + sourceObjectDefinition.getName())), (String)"groupId");
        }
        return MapUtil.getLong((Map)((Map)payloadJSONObject.get("objectEntry")), (String)"groupId");
    }

    private ServiceContext _getServiceContext(final long companyId, final long userId) {
        return new ServiceContext(){
            {
                this.setCompanyId(companyId);
                this.setUserId(userId);
            }
        };
    }

    private Map<String, Serializable> _getValues(ObjectDefinition objectDefinition, UnicodeProperties parametersUnicodeProperties, JSONObject payloadJSONObject) throws Exception {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        Map<String, Object> variables = ObjectActionVariablesUtil.toVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject);
        JSONArray jsonArray = this._jsonFactory.createJSONArray((String)parametersUnicodeProperties.get((Object)"predefinedValues"));
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Serializable value = (Serializable)jsonObject.get("value");
            if (!jsonObject.getBoolean("inputAsValue")) {
                value = this._evaluateExpression(value.toString(), variables);
            }
            values.put(jsonObject.getString("name"), value);
        }
        return values;
    }
}

