/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.resource.v1_0;

import com.liferay.object.exception.NoSuchObjectRelationshipException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.internal.resource.v1_0.BaseRelatedObjectEntryResourceImpl;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerTracker;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(factory="com.liferay.object.rest.internal.resource.v1_0.RelatedObjectEntryResource", property={"api.version=v1.0", "osgi.jaxrs.resource=true"}, service={RelatedObjectEntryResourceImpl.class})
public class RelatedObjectEntryResourceImpl
extends BaseRelatedObjectEntryResourceImpl {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryManagerTracker _objectEntryManagerTracker;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Context
    private UriInfo _uriInfo;

    @Override
    public Page<Object> getRelatedObjectEntriesPage(String previousPath, Long objectEntryId, String objectRelationshipName, Pagination pagination) throws Exception {
        ObjectRelationship objectRelationship = this._getObjectRelationship(objectRelationshipName);
        ObjectDefinition currentObjectDefinition = this._getCurrentObjectDefinition(objectEntryId, objectRelationship, this._uriInfo);
        ObjectDefinition relatedObjectDefinition = this._getRelatedObjectDefinition(currentObjectDefinition, objectRelationship);
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(currentObjectDefinition.getStorageType());
        if (relatedObjectDefinition.isSystem()) {
            return objectEntryManager.getRelatedSystemObjectEntries(currentObjectDefinition, objectEntryId, objectRelationshipName, pagination);
        }
        return objectEntryManager.getObjectEntryRelatedObjectEntries((DTOConverterContext)this._getDefaultDTOConverterContext(currentObjectDefinition, objectEntryId, this._uriInfo), currentObjectDefinition, objectEntryId, objectRelationshipName, pagination);
    }

    private ObjectDefinition _getCurrentObjectDefinition(long objectEntryId, ObjectRelationship objectRelationship, UriInfo uriInfo) throws Exception {
        ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry(objectEntryId);
        if (objectEntry != null) {
            return this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        URI uri = uriInfo.getBaseUri();
        String path = uri.getPath();
        if (!Objects.equals(objectDefinition.getRESTContextPath(), path.split("/")[2])) {
            objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        }
        return objectDefinition;
    }

    private DefaultDTOConverterContext _getDefaultDTOConverterContext(ObjectDefinition objectDefinition, Long objectEntryId, UriInfo uriInfo) {
        return new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)objectEntryId, LocaleUtil.fromLanguageId((String)objectDefinition.getDefaultLanguageId(), (boolean)true, (boolean)false), uriInfo, null);
    }

    private ObjectRelationship _getObjectRelationship(String objectRelationshipName) throws Exception {
        List objectRelationships = ListUtil.filter((List)this._objectRelationshipLocalService.getObjectRelationships(-1, -1), objectRelationship -> !objectRelationship.isReverse() && objectRelationship.getName().equals(objectRelationshipName));
        if (objectRelationships.isEmpty()) {
            throw new NoSuchObjectRelationshipException("No ObjectRelationship exists with the name " + objectRelationshipName);
        }
        return (ObjectRelationship)objectRelationships.get(0);
    }

    private ObjectDefinition _getRelatedObjectDefinition(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship) throws Exception {
        long objectDefinitionId1 = objectRelationship.getObjectDefinitionId1();
        if (objectDefinitionId1 != objectDefinition.getObjectDefinitionId()) {
            return this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        }
        return this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
    }
}

