/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.resource.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.internal.resource.v1_0.BaseObjectEntryResourceImpl;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerTracker;
import com.liferay.object.rest.odata.entity.v1_0.ObjectEntryEntityModel;
import com.liferay.object.rest.petra.sql.dsl.expression.FilterPredicateFactory;
import com.liferay.object.rest.resource.v1_0.ObjectEntryResource;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(factory="com.liferay.object.rest.internal.resource.v1_0.ObjectEntryResource", properties={"OSGI-INF/liferay/rest/v1_0/object-entry.properties"}, service={ObjectEntryResource.class})
public class ObjectEntryResourceImpl
extends BaseObjectEntryResourceImpl {
    @Reference
    private FilterPredicateFactory _filterPredicateFactory;
    @Context
    private ObjectDefinition _objectDefinition;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryManagerTracker _objectEntryManagerTracker;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipService _objectRelationshipService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;

    @Override
    public void create(Collection<ObjectEntry> objectEntries, Map<String, Serializable> parameters) throws Exception {
        this._loadObjectDefinition(parameters);
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(this._objectDefinition.getScope());
        if (objectScopeProvider.isGroupAware()) {
            UnsafeConsumer objectEntryUnsafeConsumer = null;
            String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
            if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"INSERT")) {
                objectEntryUnsafeConsumer = objectEntry -> this.postScopeScopeKey((String)parameters.get("scopeKey"), (ObjectEntry)objectEntry);
            }
            if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"UPSERT")) {
                objectEntryUnsafeConsumer = objectEntry -> this.putScopeScopeKeyByExternalReferenceCode((String)parameters.get("scopeKey"), objectEntry.getExternalReferenceCode(), (ObjectEntry)objectEntry);
            }
            if (objectEntryUnsafeConsumer == null) {
                throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for object entry");
            }
            this.contextBatchUnsafeConsumer.accept(objectEntries, (Object)objectEntryUnsafeConsumer);
        } else {
            super.create(objectEntries, parameters);
        }
    }

    @Override
    public void delete(Collection<ObjectEntry> objectEntries, Map<String, Serializable> parameters) throws Exception {
        this._loadObjectDefinition(parameters);
        super.delete(objectEntries, parameters);
    }

    @Override
    public void deleteByExternalReferenceCode(String externalReferenceCode) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        objectEntryManager.deleteObjectEntry(externalReferenceCode, this.contextCompany.getCompanyId(), this._objectDefinition, null);
    }

    @Override
    public void deleteObjectEntry(Long objectEntryId) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        objectEntryManager.deleteObjectEntry(this._objectDefinition, objectEntryId.longValue());
    }

    @Override
    public void deleteScopeScopeKeyByExternalReferenceCode(String scopeKey, String externalReferenceCode) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        objectEntryManager.deleteObjectEntry(externalReferenceCode, this.contextCompany.getCompanyId(), this._objectDefinition, scopeKey);
    }

    @Override
    public ObjectEntry getByExternalReferenceCode(String externalReferenceCode) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.getObjectEntry((DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this.contextCompany.getCompanyId(), this._objectDefinition, null);
    }

    @Override
    public Page<ObjectEntry> getCurrentObjectEntriesObjectRelationshipNamePage(Long currentObjectEntryId, String objectRelationshipName, Pagination pagination) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        Page page = objectEntryManager.getObjectEntryRelatedObjectEntries((DTOConverterContext)this._getDTOConverterContext(currentObjectEntryId), this._objectDefinition, currentObjectEntryId, objectRelationshipName, pagination);
        ObjectRelationship objectRelationship = this._objectRelationshipService.getObjectRelationship(this._objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition objectDefinition2 = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        return Page.of((Map)page.getActions(), (Collection)TransformUtil.transform((Collection)page.getItems(), objectEntry -> this._getRelatedObjectEntry(objectDefinition2, (ObjectEntry)objectEntry)));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new ObjectEntryEntityModel(this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId()));
    }

    @Override
    public Page<ObjectEntry> getObjectEntriesPage(Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.getObjectEntries(this.contextCompany.getCompanyId(), this._objectDefinition, null, aggregation, (DTOConverterContext)this._getDTOConverterContext(null), pagination, this._filterPredicateFactory.create(ParamUtil.getString((HttpServletRequest)this.contextHttpServletRequest, (String)"filter"), this._objectDefinition.getObjectDefinitionId()), search, sorts);
    }

    @Override
    public ObjectEntry getObjectEntry(Long objectEntryId) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.getObjectEntry((DTOConverterContext)this._getDTOConverterContext(objectEntryId), this._objectDefinition, objectEntryId.longValue());
    }

    @Override
    public ObjectEntry getScopeScopeKeyByExternalReferenceCode(String scopeKey, String externalReferenceCode) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.getObjectEntry((DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this.contextCompany.getCompanyId(), this._objectDefinition, scopeKey);
    }

    @Override
    public Page<ObjectEntry> getScopeScopeKeyPage(String scopeKey, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.getObjectEntries(this.contextCompany.getCompanyId(), this._objectDefinition, scopeKey, aggregation, (DTOConverterContext)this._getDTOConverterContext(null), pagination, this._filterPredicateFactory.create(ParamUtil.getString((HttpServletRequest)this.contextHttpServletRequest, (String)"filter"), this._objectDefinition.getObjectDefinitionId()), search, sorts);
    }

    @Override
    public ObjectEntry postObjectEntry(ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.addObjectEntry((DTOConverterContext)this._getDTOConverterContext(null), this._objectDefinition, objectEntry, null);
    }

    @Override
    public ObjectEntry postScopeScopeKey(String scopeKey, ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.addObjectEntry((DTOConverterContext)this._getDTOConverterContext(null), this._objectDefinition, objectEntry, scopeKey);
    }

    @Override
    public ObjectEntry putByExternalReferenceCode(String externalReferenceCode, ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.addOrUpdateObjectEntry(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this._objectDefinition, objectEntry, null);
    }

    @Override
    public ObjectEntry putCurrentObjectEntry(Long currentObjectEntryId, String objectRelationshipName, Long relatedObjectEntryId) throws Exception {
        ObjectRelationship objectRelationship = this._objectRelationshipService.getObjectRelationship(this._objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return this._getRelatedObjectEntry(this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2()), objectEntryManager.addObjectRelationshipMappingTableValues((DTOConverterContext)this._getDTOConverterContext(currentObjectEntryId), this._objectDefinition, objectRelationshipName, currentObjectEntryId.longValue(), relatedObjectEntryId.longValue()));
    }

    @Override
    public ObjectEntry putObjectEntry(Long objectEntryId, ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.updateObjectEntry((DTOConverterContext)this._getDTOConverterContext(objectEntryId), this._objectDefinition, objectEntryId.longValue(), objectEntry);
    }

    @Override
    public ObjectEntry putScopeScopeKeyByExternalReferenceCode(String scopeKey, String externalReferenceCode, ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.addOrUpdateObjectEntry(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this._objectDefinition, objectEntry, scopeKey);
    }

    @Override
    public Page<ObjectEntry> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        this._loadObjectDefinition(parameters);
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(this._objectDefinition.getScope());
        if (objectScopeProvider.isGroupAware()) {
            return this.getScopeScopeKeyPage((String)((Object)parameters.get("scopeKey")), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        return this.getObjectEntriesPage(Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
    }

    @Override
    public void update(Collection<ObjectEntry> objectEntries, Map<String, Serializable> parameters) throws Exception {
        this._loadObjectDefinition(parameters);
        super.update(objectEntries, parameters);
    }

    private DefaultDTOConverterContext _getDTOConverterContext(Long objectEntryId) {
        return new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, null, this.contextHttpServletRequest, (Object)objectEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
    }

    private ObjectEntry _getRelatedObjectEntry(ObjectDefinition objectDefinition, ObjectEntry objectEntry) {
        Map actions = objectEntry.getActions();
        for (Map.Entry entry : actions.entrySet()) {
            Map map = (Map)entry.getValue();
            String href = (String)map.get("href");
            map.put("href", StringUtil.replace((String)href, (String)StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getPluralLabel(this.contextAcceptLanguage.getPreferredLocale())), (String)StringUtil.lowerCaseFirstLetter((String)objectDefinition.getPluralLabel(this.contextAcceptLanguage.getPreferredLocale()))));
        }
        return objectEntry;
    }

    private void _loadObjectDefinition(Map<String, Serializable> parameters) throws Exception {
        String[] objectDefinitionIds;
        String parameterValue;
        String taskItemDelegateName = (String)((Object)parameters.get("taskItemDelegateName"));
        if (taskItemDelegateName != null) {
            this._objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(this.contextCompany.getCompanyId(), "C_" + taskItemDelegateName);
            if (this._objectDefinition != null) {
                return;
            }
        }
        if ((parameterValue = (String)((Object)parameters.get("objectDefinitionId"))) != null && parameterValue.length() > 2 && (objectDefinitionIds = StringUtil.split((String)parameterValue.substring(1, parameterValue.length() - 1), (String)",")).length > 0) {
            this._objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(GetterUtil.getLong((String)objectDefinitionIds[0]));
            return;
        }
        throw new NotFoundException("Missing parameter \"objectDefinitionId\"");
    }
}

