/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.openapi.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.FileEntry;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryResourceImpl;
import com.liferay.object.rest.internal.resource.v1_0.OpenAPIResourceImpl;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.batch.engine.Field;
import com.liferay.portal.vulcan.openapi.DTOProperty;
import com.liferay.portal.vulcan.openapi.OpenAPISchemaFilter;
import com.liferay.portal.vulcan.resource.OpenAPIResource;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectEntryOpenAPIResource.class})
public class ObjectEntryOpenAPIResourceImpl
implements ObjectEntryOpenAPIResource {
    private ObjectDefinition _objectDefinition;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private OpenAPIResource _openAPIResource;

    public Map<String, Field> getFields(long objectDefinitionId, UriInfo uriInfo) throws Exception {
        Response response = this.getOpenAPI(objectDefinitionId, "json", uriInfo);
        OpenAPI openAPI = (OpenAPI)response.getEntity();
        Components components = openAPI.getComponents();
        Map schemas = components.getSchemas();
        Schema schema = (Schema)schemas.get(this._objectDefinition.getShortName());
        if (schema == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        List<String> requiredPropertySchemaNames = this._getRequiredPropertySchemaNames(schema);
        Map properties = schema.getProperties();
        for (Map.Entry schemaEntry : properties.entrySet()) {
            String propertyName = (String)schemaEntry.getKey();
            Schema propertySchema = (Schema)schemaEntry.getValue();
            if (Optional.ofNullable(propertySchema.getReadOnly()).orElse(false).booleanValue() || Optional.ofNullable(propertySchema.getWriteOnly()).orElse(false).booleanValue() || propertyName.startsWith("x-")) continue;
            fields.put(propertyName, Field.of((String)propertySchema.getDescription(), (String)propertyName, (boolean)Optional.ofNullable(propertySchema.getReadOnly()).orElse(false), (boolean)requiredPropertySchemaNames.contains(propertyName), (String)propertySchema.getType(), (boolean)Optional.ofNullable(propertySchema.getWriteOnly()).orElse(false)));
        }
        return fields;
    }

    public Response getOpenAPI(long objectDefinitionId, String type, UriInfo uriInfo) throws Exception {
        this._objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
        Map<ObjectRelationship, ObjectDefinition> relatedObjectDefinitionsMap = this._getRelatedObjectDefinitionsMap();
        Response response = this._openAPIResource.getOpenAPI(this._getOpenAPISchemaFilter(this._objectDefinition.getRESTContextPath()), (Set)new HashSet<Class<?>>(){
            {
                this.add(ObjectEntryResourceImpl.class);
                this.add(OpenAPIResourceImpl.class);
            }
        }, type, uriInfo);
        OpenAPI openAPI = (OpenAPI)response.getEntity();
        Paths paths = openAPI.getPaths();
        for (String key : new ArrayList(paths.keySet())) {
            if (!key.contains("objectRelationshipName")) continue;
            for (Map.Entry<ObjectRelationship, ObjectDefinition> entry : relatedObjectDefinitionsMap.entrySet()) {
                final ObjectRelationship objectRelationship = entry.getKey();
                ObjectDefinition relatedObjectDefinition = entry.getValue();
                paths.addPathItem(StringUtil.replace((String)key, (String[])new String[]{"currentObjectEntry", "{objectRelationshipName}", "relatedObjectEntry"}, (String[])new String[]{StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getShortName()), objectRelationship.getName(), StringUtil.lowerCaseFirstLetter((String)relatedObjectDefinition.getShortName())}), this._createPathItem(objectRelationship, (PathItem)paths.get((Object)key), relatedObjectDefinition));
                ((Schema)openAPI.getComponents().getSchemas().get(this._objectDefinition.getShortName())).getProperties().put(objectRelationship.getName(), new Schema<Object>(){
                    {
                        this.setDescription(StringBundler.concat((String[])new String[]{"Information about the relationship ", objectRelationship.getName(), " can be embedded with \"nestedFields\"."}));
                    }
                });
            }
            paths.remove((Object)key);
        }
        return response;
    }

    private Operation _createOperation(final String httpMethod, final ObjectRelationship objectRelationship, final ObjectDefinition relatedObjectDefinition, final Operation operation) {
        final HashMap<String, 3> parameters = new HashMap<String, 3>();
        for (final Parameter parameter : operation.getParameters()) {
            String parameterName = parameter.getName();
            if (Objects.equals(parameterName, "objectRelationshipName")) continue;
            if (Objects.equals(parameterName, "currentObjectEntryId")) {
                parameterName = StringUtil.replace((String)parameterName, (String)"currentObjectEntry", (String)StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getShortName()));
            } else if (Objects.equals(parameterName, "relatedObjectEntryId")) {
                parameterName = StringUtil.replace((String)parameterName, (String)"relatedObjectEntry", (String)StringUtil.lowerCaseFirstLetter((String)relatedObjectDefinition.getShortName()));
            }
            final String finalParameterName = parameterName;
            parameters.put(parameter.getName(), new Parameter(){
                {
                    this.name(finalParameterName);
                    this.in(parameter.getIn());
                    this.required(parameter.getRequired());
                    this.schema(parameter.getSchema());
                }
            });
        }
        return new Operation(){
            {
                this.operationId(StringBundler.concat((String[])new String[]{httpMethod, ObjectEntryOpenAPIResourceImpl.this._objectDefinition.getShortName(), StringUtil.upperCaseFirstLetter((String)objectRelationship.getName()), relatedObjectDefinition.getShortName()}));
                this.parameters(new ArrayList(parameters.values()));
                this.responses(operation.getResponses());
                this.tags(operation.getTags());
            }
        };
    }

    private PathItem _createPathItem(final ObjectRelationship objectRelationship, final PathItem pathItem, final ObjectDefinition relatedObjectDefinition) {
        Map operations = pathItem.readOperationsMap();
        Operation operation = (Operation)operations.get(PathItem.HttpMethod.GET);
        if (operation != null) {
            return new PathItem(){
                {
                    this.get(ObjectEntryOpenAPIResourceImpl.this._createOperation("get", objectRelationship, relatedObjectDefinition, pathItem.getGet()));
                }
            };
        }
        operation = (Operation)operations.get(PathItem.HttpMethod.PUT);
        if (operation != null) {
            return new PathItem(){
                {
                    this.put(ObjectEntryOpenAPIResourceImpl.this._createOperation("put", objectRelationship, relatedObjectDefinition, pathItem.getPut()));
                }
            };
        }
        return new PathItem();
    }

    private DTOProperty _getDTOProperty(final ObjectField objectField) {
        if (Objects.equals(objectField.getBusinessType(), "Attachment")) {
            DTOProperty dtoProperty = new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectField.getName(), FileEntry.class.getSimpleName());
            dtoProperty.setDTOProperties(Arrays.asList(new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "id", Long.class.getSimpleName()), new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "name", String.class.getSimpleName())));
            dtoProperty.setRequired(objectField.isRequired());
            return dtoProperty;
        }
        if (objectField.getListTypeDefinitionId() != 0L) {
            DTOProperty dtoProperty = new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectField.getName(), ListEntry.class.getSimpleName());
            dtoProperty.setDTOProperties(Arrays.asList(new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "key", String.class.getSimpleName()), new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "name", String.class.getSimpleName())));
            dtoProperty.setRequired(objectField.isRequired());
            return dtoProperty;
        }
        return new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectField.getName(), objectField.getDBType()){
            {
                super(x0, x1, x2);
                this.setRequired(objectField.isRequired());
            }
        };
    }

    private OpenAPISchemaFilter _getOpenAPISchemaFilter(String applicationPath) {
        OpenAPISchemaFilter openAPISchemaFilter = new OpenAPISchemaFilter();
        openAPISchemaFilter.setApplicationPath(applicationPath);
        DTOProperty dtoProperty = new DTOProperty(new HashMap(), "ObjectEntry", "object");
        dtoProperty.setDTOProperties(TransformUtil.transform((Collection)this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId()), this::_getDTOProperty));
        openAPISchemaFilter.setDTOProperties(Arrays.asList(dtoProperty));
        openAPISchemaFilter.setSchemaMappings((Map)HashMapBuilder.put((Object)"ObjectEntry", (Object)this._objectDefinition.getShortName()).put((Object)"PageObjectEntry", (Object)("Page" + this._objectDefinition.getShortName())).build());
        return openAPISchemaFilter;
    }

    private Map<ObjectRelationship, ObjectDefinition> _getRelatedObjectDefinitionsMap() {
        HashMap<ObjectRelationship, ObjectDefinition> relatedObjectDefinitionsMap = new HashMap<ObjectRelationship, ObjectDefinition>();
        List objectRelationships = this._objectRelationshipLocalService.getObjectRelationships(this._objectDefinition.getObjectDefinitionId());
        for (ObjectRelationship objectRelationship : objectRelationships) {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectRelationship.getObjectDefinitionId2());
            relatedObjectDefinitionsMap.put(objectRelationship, objectDefinition);
        }
        return relatedObjectDefinitionsMap;
    }

    private List<String> _getRequiredPropertySchemaNames(Schema schema) {
        List<String> requiredPropertySchemaNames = schema.getRequired();
        if (requiredPropertySchemaNames == null) {
            requiredPropertySchemaNames = Collections.emptyList();
        }
        return requiredPropertySchemaNames;
    }
}

