/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.odata.filter.expression;

import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.CollectionPropertyExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.LambdaFunctionExpression;
import com.liferay.portal.odata.filter.expression.LambdaVariableExpression;
import com.liferay.portal.odata.filter.expression.ListExpression;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MemberExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.PrimitivePropertyExpression;
import com.liferay.portal.odata.filter.expression.UnaryExpression;
import java.text.DateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PredicateExpressionVisitorImpl
implements ExpressionVisitor<Object> {
    private Map<String, String> _lambdaVariableExpressionFieldNames;
    private final long _objectDefinitionId;
    private final ObjectFieldLocalService _objectFieldLocalService;

    public PredicateExpressionVisitorImpl(long objectDefinitionId, ObjectFieldLocalService objectFieldLocalService) {
        this(new HashMap<String, String>(), objectDefinitionId, objectFieldLocalService);
    }

    public Predicate visitBinaryExpressionOperation(BinaryExpression.Operation operation, Object left, Object right) {
        Optional<Predicate> predicateOptional = this._getPredicateOptional(operation, left, right);
        return predicateOptional.orElseThrow(() -> new UnsupportedOperationException("Unsupported method visitBinaryExpressionOperation with operation " + operation));
    }

    public Predicate visitCollectionPropertyExpression(CollectionPropertyExpression collectionPropertyExpression) throws ExpressionVisitException {
        LambdaFunctionExpression lambdaFunctionExpression = collectionPropertyExpression.getLambdaFunctionExpression();
        return (Predicate)lambdaFunctionExpression.accept((ExpressionVisitor)new PredicateExpressionVisitorImpl(Collections.singletonMap(lambdaFunctionExpression.getVariableName(), collectionPropertyExpression.getName()), this._objectDefinitionId, this._objectFieldLocalService));
    }

    public Object visitLambdaFunctionExpression(LambdaFunctionExpression.Type type, String variableName, Expression expression) throws ExpressionVisitException {
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitLambdaVariableExpression(LambdaVariableExpression lambdaVariableExpression) {
        return this._lambdaVariableExpressionFieldNames.get(lambdaVariableExpression.getVariableName());
    }

    public Predicate visitListExpressionOperation(ListExpression.Operation operation, Object left, List<Object> right) throws ExpressionVisitException {
        if (Objects.equals(ListExpression.Operation.IN, operation)) {
            Column column = this._objectFieldLocalService.getColumn(this._objectDefinitionId, GetterUtil.getString((Object)left));
            return column.in(right.toArray());
        }
        throw new UnsupportedOperationException("Unsupported method visitListExpressionOperation with operation " + operation);
    }

    public Object visitLiteralExpression(LiteralExpression literalExpression) {
        if (Objects.equals(LiteralExpression.Type.BOOLEAN, literalExpression.getType())) {
            return GetterUtil.getBoolean((String)literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.DATE, literalExpression.getType())) {
            return GetterUtil.getDate((String)literalExpression.getText(), (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd"));
        }
        if (Objects.equals(LiteralExpression.Type.DOUBLE, literalExpression.getType())) {
            return GetterUtil.getDouble((String)literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.INTEGER, literalExpression.getType())) {
            return GetterUtil.getInteger((String)literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.NULL, literalExpression.getType())) {
            return null;
        }
        if (Objects.equals(LiteralExpression.Type.STRING, literalExpression.getType())) {
            return StringUtil.unquote((String)literalExpression.getText());
        }
        return literalExpression.getText();
    }

    public Object visitMemberExpression(MemberExpression memberExpression) throws ExpressionVisitException {
        Expression expression = memberExpression.getExpression();
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitMethodExpression(List<Object> expressions, MethodExpression.Type type) {
        if (type == MethodExpression.Type.CONTAINS) {
            if (expressions.size() != 2) {
                throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported method visitMethodExpression with method ", "type ", type, " and ", expressions.size(), "params"}));
            }
            return this._contains(expressions.get(0), expressions.get(1));
        }
        if (type == MethodExpression.Type.STARTS_WITH) {
            if (expressions.size() != 2) {
                throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported method visitMethodExpression with method", "type ", type, " and ", expressions.size(), "params"}));
            }
            return this._startsWith(expressions.get(0), expressions.get(1));
        }
        throw new UnsupportedOperationException("Unsupported method visitMethodExpression with method type " + type);
    }

    public Object visitPrimitivePropertyExpression(PrimitivePropertyExpression primitivePropertyExpression) {
        return primitivePropertyExpression.getName();
    }

    public Predicate visitUnaryExpressionOperation(UnaryExpression.Operation operation, Object operand) {
        if (Objects.equals(UnaryExpression.Operation.NOT, operation)) {
            return Predicate.not((Predicate)((Predicate)operand));
        }
        throw new UnsupportedOperationException("Unsupported method visitUnaryExpressionOperation with operation " + operation);
    }

    private PredicateExpressionVisitorImpl(Map<String, String> lambdaVariableExpressionFieldNames, long objectDefinitionId, ObjectFieldLocalService objectFieldLocalService) {
        this._lambdaVariableExpressionFieldNames = lambdaVariableExpressionFieldNames;
        this._objectDefinitionId = objectDefinitionId;
        this._objectFieldLocalService = objectFieldLocalService;
    }

    private Predicate _contains(Object fieldName, Object fieldValue) {
        Column column = this._objectFieldLocalService.getColumn(this._objectDefinitionId, GetterUtil.getString((Object)fieldName));
        return column.like("%" + fieldValue + "%");
    }

    private Optional<Predicate> _getPredicateOptional(BinaryExpression.Operation operation, Object left, Object right) {
        Predicate predicate = null;
        if (Objects.equals(BinaryExpression.Operation.AND, operation)) {
            predicate = Predicate.and((Predicate)((Predicate)left), (Predicate)((Predicate)right));
        } else if (Objects.equals(BinaryExpression.Operation.OR, operation)) {
            predicate = Predicate.or((Predicate)((Predicate)left), (Predicate)((Predicate)right));
        }
        if (predicate != null) {
            return Optional.of(predicate);
        }
        Column column = this._objectFieldLocalService.getColumn(this._objectDefinitionId, GetterUtil.getString((Object)left));
        if (Objects.equals(BinaryExpression.Operation.EQ, operation)) {
            predicate = column.eq(right);
        } else if (Objects.equals(BinaryExpression.Operation.GE, operation)) {
            predicate = column.gte(right);
        } else if (Objects.equals(BinaryExpression.Operation.GT, operation)) {
            predicate = column.gt(right);
        } else if (Objects.equals(BinaryExpression.Operation.LE, operation)) {
            predicate = column.lte(right);
        } else if (Objects.equals(BinaryExpression.Operation.LT, operation)) {
            predicate = column.lt(right);
        } else if (Objects.equals(BinaryExpression.Operation.NE, operation)) {
            predicate = column.neq(right);
        } else {
            return Optional.empty();
        }
        return Optional.of(predicate);
    }

    private Predicate _startsWith(Object fieldName, Object fieldValue) {
        Column column = this._objectFieldLocalService.getColumn(this._objectDefinitionId, GetterUtil.getString((Object)fieldName));
        return column.like(fieldValue + "%");
    }
}

