/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.dto.v1_0.converter;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.FileEntry;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.dto.v1_0.Status;
import com.liferay.object.rest.dto.v1_0.util.CreatorUtil;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.util.ObjectEntryFieldValueUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.object.model.ObjectEntry"}, service={DTOConverter.class, ObjectEntryDTOConverter.class})
public class ObjectEntryDTOConverter
implements DTOConverter<ObjectEntry, com.liferay.object.rest.dto.v1_0.ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryDTOConverter.class);
    @Reference
    private DLFileEntryLocalService _dLFileEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return com.liferay.object.rest.dto.v1_0.ObjectEntry.class.getSimpleName();
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry toDTO(DTOConverterContext dtoConverterContext, ObjectEntry objectEntry) throws Exception {
        Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
        UriInfo uriInfo = uriInfoOptional.orElse(null);
        if (uriInfo == null) {
            return this._toDTO(dtoConverterContext, Math.min(1, PropsValues.OBJECT_NESTED_FIELDS_MAX_QUERY_DEPTH), objectEntry);
        }
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        return this._toDTO(dtoConverterContext, Math.min(GetterUtil.getInteger((String)((String)queryParameters.getFirst((Object)"nestedFieldsDepth")), (int)1), PropsValues.OBJECT_NESTED_FIELDS_MAX_QUERY_DEPTH), objectEntry);
    }

    private DTOConverterContext _getDTOConverterContext(DTOConverterContext dtoConverterContext, long objectEntryId) {
        Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
        UriInfo uriInfo = uriInfoOptional.orElse(null);
        return new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), null, dtoConverterContext.getDTOConverterRegistry(), dtoConverterContext.getHttpServletRequest(), (Object)objectEntryId, dtoConverterContext.getLocale(), uriInfo, dtoConverterContext.getUser());
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry[] _getManyToManyRelationshipObjectEntries(DTOConverterContext dtoConverterContext, int nestedFieldsDepth, ObjectEntry objectEntry, ObjectRelationship objectRelationship) {
        try {
            boolean reverse = objectRelationship.isReverse();
            if (reverse) {
                objectRelationship = this._objectRelationshipLocalService.fetchReverseObjectRelationship(objectRelationship, false);
            }
            return this._toObjectEntries(dtoConverterContext, nestedFieldsDepth, this._objectEntryLocalService.getManyToManyRelatedObjectEntries(objectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), objectEntry.getObjectEntryId(), reverse, -1, -1));
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return null;
        }
    }

    private ObjectDefinition _getObjectDefinition(DTOConverterContext dtoConverterContext, ObjectEntry objectEntry) throws Exception {
        ObjectDefinition objectDefinition = (ObjectDefinition)dtoConverterContext.getAttribute("objectDefinition");
        if (objectDefinition == null) {
            objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
        }
        return objectDefinition;
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry[] _getOneToManyRelationshipObjectEntries(DTOConverterContext dtoConverterContext, int nestedFieldsDepth, ObjectEntry objectEntry, ObjectRelationship objectRelationship) {
        try {
            return this._toObjectEntries(dtoConverterContext, nestedFieldsDepth, this._objectEntryLocalService.getOneToManyRelatedObjectEntries(objectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), objectEntry.getObjectEntryId(), -1, -1));
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return null;
        }
    }

    private String _getScopeKey(ObjectDefinition objectDefinition, ObjectEntry objectEntry) {
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        if (objectScopeProvider.isGroupAware()) {
            Group group = this._groupLocalService.fetchGroup(objectEntry.getGroupId());
            if (group == null) {
                return null;
            }
            return group.getGroupKey();
        }
        return null;
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry _toDTO(final DTOConverterContext dtoConverterContext, final int nestedFieldsDepth, final ObjectEntry objectEntry) throws Exception {
        final ObjectDefinition objectDefinition = this._getObjectDefinition(dtoConverterContext, objectEntry);
        return new com.liferay.object.rest.dto.v1_0.ObjectEntry(){
            {
                this.actions = dtoConverterContext.getActions();
                this.creator = CreatorUtil.toCreator((Portal)ObjectEntryDTOConverter.this._portal, (Optional)dtoConverterContext.getUriInfoOptional(), (User)ObjectEntryDTOConverter.this._userLocalService.fetchUser(objectEntry.getUserId()));
                this.dateCreated = objectEntry.getCreateDate();
                this.dateModified = objectEntry.getModifiedDate();
                this.externalReferenceCode = objectEntry.getExternalReferenceCode();
                this.id = objectEntry.getObjectEntryId();
                this.properties = ObjectEntryDTOConverter.this._toProperties(dtoConverterContext, nestedFieldsDepth, objectDefinition, objectEntry);
                this.scopeKey = ObjectEntryDTOConverter.this._getScopeKey(objectDefinition, objectEntry);
                this.status = new Status(){
                    {
                        this.code = objectEntry.getStatus();
                        this.label = WorkflowConstants.getStatusLabel((int)objectEntry.getStatus());
                        this.label_i18n = ObjectEntryDTOConverter.this._language.get(LanguageResources.getResourceBundle((Locale)dtoConverterContext.getLocale()), WorkflowConstants.getStatusLabel((int)objectEntry.getStatus()));
                    }
                };
            }
        };
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry[] _toObjectEntries(DTOConverterContext dtoConverterContext, int nestedFieldsDepth, List<ObjectEntry> objectEntries) {
        return (com.liferay.object.rest.dto.v1_0.ObjectEntry[])TransformUtil.transformToArray(objectEntries, objectEntry -> {
            try {
                return this._toDTO(this._getDTOConverterContext(dtoConverterContext, objectEntry.getObjectEntryId()), nestedFieldsDepth - 1, (ObjectEntry)objectEntry);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)exception);
                }
                return null;
            }
        }, com.liferay.object.rest.dto.v1_0.ObjectEntry.class);
    }

    private Map<String, Object> _toProperties(final DTOConverterContext dtoConverterContext, int nestedFieldsDepth, ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map values = objectEntry.getValues();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId(), false);
        for (ObjectField objectField : objectFields) {
            long listTypeDefinitionId = objectField.getListTypeDefinitionId();
            String objectFieldName = objectField.getName();
            Serializable serializable = (Serializable)values.get(objectFieldName);
            if (listTypeDefinitionId != 0L) {
                final ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(listTypeDefinitionId, (String)((Object)serializable));
                if (listTypeEntry == null) continue;
                map.put(objectFieldName, new ListEntry(){
                    {
                        this.key = listTypeEntry.getKey();
                        this.name = listTypeEntry.getName(dtoConverterContext.getLocale());
                        this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)listTypeEntry.getNameMap());
                    }
                });
                continue;
            }
            if (Objects.equals(objectField.getBusinessType(), "Attachment")) {
                Object value = values.get(objectField.getName());
                final DLFileEntry dlFileEntry = this._dLFileEntryLocalService.fetchDLFileEntry(GetterUtil.getLong(value));
                if (dlFileEntry == null) continue;
                map.put(objectFieldName, new FileEntry(){
                    {
                        this.id = dlFileEntry.getFileEntryId();
                        this.name = dlFileEntry.getFileName();
                    }
                });
                continue;
            }
            if (Objects.equals(objectField.getBusinessType(), "RichText")) {
                map.put(objectFieldName, ObjectEntryFieldValueUtil.getValueString((ObjectField)objectField, (Map)values));
                continue;
            }
            if (nestedFieldsDepth > 0 && Objects.equals(objectField.getRelationshipType(), "oneToMany")) {
                long objectEntryId = 0L;
                if (serializable != null) {
                    if (GetterUtil.getLong((Object)serializable) > 0L) {
                        objectEntryId = (Long)serializable;
                    }
                    Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
                    int underlineLastIndex = objectFieldName.lastIndexOf("_");
                    if (objectEntryId != 0L && uriInfoOptional.map(UriInfo::getQueryParameters).map(queryParameters -> (String)queryParameters.getFirst((Object)"nestedFields")).map(nestedFields -> nestedFields.contains(StringUtil.replaceLast((String)objectFieldName.substring(underlineLastIndex + 1), (String)"Id", (String)""))).orElse(false).booleanValue()) {
                        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
                        ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
                        if (relatedObjectDefinition.isSystem()) {
                            map.put(StringUtil.replaceLast((String)objectFieldName, (String)"Id", (String)""), this._objectEntryLocalService.getSystemModelAttributes(relatedObjectDefinition, objectEntryId));
                        } else {
                            map.put(StringUtil.replaceLast((String)objectFieldName, (String)"Id", (String)""), this._toDTO(this._getDTOConverterContext(dtoConverterContext, objectEntryId), nestedFieldsDepth - 1, this._objectEntryLocalService.getObjectEntry(objectEntryId)));
                        }
                    }
                }
                map.put(objectFieldName, objectEntryId);
                continue;
            }
            map.put(objectFieldName, serializable);
        }
        if (nestedFieldsDepth > 0) {
            List objectRelationships = this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId());
            Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
            for (ObjectRelationship objectRelationship : objectRelationships) {
                if (!uriInfoOptional.map(UriInfo::getQueryParameters).map(queryParameters -> (String)queryParameters.getFirst((Object)"nestedFields")).map(nestedFields -> {
                    List<String> strings = Arrays.asList(nestedFields.split(","));
                    return strings.contains(objectRelationship.getName());
                }).orElse(false).booleanValue()) continue;
                com.liferay.object.rest.dto.v1_0.ObjectEntry[] objectEntries = new com.liferay.object.rest.dto.v1_0.ObjectEntry[]{};
                if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
                    objectEntries = this._getManyToManyRelationshipObjectEntries(dtoConverterContext, nestedFieldsDepth, objectEntry, objectRelationship);
                } else if (Objects.equals(objectRelationship.getType(), "oneToMany")) {
                    objectEntries = this._getOneToManyRelationshipObjectEntries(dtoConverterContext, nestedFieldsDepth, objectEntry, objectRelationship);
                }
                map.put(objectRelationship.getName(), objectEntries);
            }
        }
        values.remove(objectDefinition.getPKObjectFieldName());
        return map;
    }
}

